/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.informix.jdbc.IfxDateTime;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.UDRMetaData;

public class UDTMetaData
extends UDRMetaData {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int SEND = 2;
    public static final int RECEIVE = 3;
    public static final int IMPORT = 4;
    public static final int EXPORT = 5;
    public static final int BINARYIMPORT = 6;
    public static final int BINARYEXPORT = 7;
    public static final int MAX_SUPPORT_FUNC_TYPE = 8;
    public static final int SINGLE_BYTE = 1;
    public static final int TWO_BYTE = 2;
    public static final int FOUR_BYTE = 4;
    public static final int EIGHT_BYTE = 8;
    String sqlname = null;
    int length = -1;
    int align = -1;
    String classname = null;
    int fieldCount = 0;
    fieldinfo[] fields = null;
    Hashtable supportudrs = null;
    Vector implCasts = null;
    Vector explCasts = null;
    boolean keepJavaFile = false;

    public void setSQLName(String name) throws SQLException {
        if (name == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.sqlname = name;
    }

    public String getSQLName() {
        return this.sqlname;
    }

    public void setLength(int length) throws SQLException {
        if (length <= 0) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setAlignment(int align) throws SQLException {
        if (align != 1 && align != 2 && align != 4 && align != 8) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        this.align = align;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setFieldCount(int fieldcount) throws SQLException {
        if (fieldcount <= 0) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        this.fieldCount = fieldcount;
        this.fields = new fieldinfo[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fields[i] = new fieldinfo();
        }
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setClassName(String name) throws SQLException {
        if (name == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.classname = name;
    }

    public String getClassName() {
        if (this.classname != null) {
            return this.classname;
        }
        return this.sqlname;
    }

    public void setSupportUDR(Method method, String sqlname, int type) throws SQLException {
        supportudrinfo udr;
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (type < 0 || type >= 8) {
            throw IfxErrMsg.getSQLException((int)-79857, (String)"", (Locale)this.locale);
        }
        if (this.supportudrs == null) {
            this.supportudrs = new Hashtable(10);
        }
        if (!this.supportudrs.contains(udr = new supportudrinfo(method, sqlname, type))) {
            this.supportudrs.put(new Integer(type), udr);
        }
    }

    public Method[] getSupportUDRs() {
        Method[] methods = null;
        int numUdrs = 0;
        if (this.supportudrs == null) {
            return null;
        }
        numUdrs = this.supportudrs.size();
        if (numUdrs == 0) {
            return null;
        }
        methods = new Method[numUdrs];
        int i = 0;
        Enumeration e = this.supportudrs.elements();
        while (e.hasMoreElements()) {
            methods[i] = ((supportudrinfo)e.nextElement()).method;
            ++i;
        }
        return methods;
    }

    public String getSupportUDRSQLName(Method method) throws SQLException {
        if (method == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.supportudrs == null) {
            return null;
        }
        supportudrinfo udr = null;
        Enumeration e = this.supportudrs.elements();
        while (e.hasMoreElements()) {
            udr = (supportudrinfo)e.nextElement();
            if (!udr.method.equals(method)) continue;
            return udr.sqlname;
        }
        return null;
    }

    public void setImplicitCast(int ifxtype, String methodsqlname) throws SQLException {
        if (!this.isValidCastType(ifxtype)) {
            throw IfxErrMsg.getSQLException((int)-79714, (String)"", (Locale)this.locale);
        }
        if (methodsqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.implCasts == null) {
            this.implCasts = new Vector(5);
        }
        castinfo cast = new castinfo(ifxtype, methodsqlname);
        this.implCasts.addElement(cast);
    }

    public void setExplicitCast(int ifxtype, String methodsqlname) throws SQLException {
        if (!this.isValidCastType(ifxtype)) {
            throw IfxErrMsg.getSQLException((int)-79714, (String)"", (Locale)this.locale);
        }
        if (methodsqlname == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        if (this.explCasts == null) {
            this.explCasts = new Vector(5);
        }
        castinfo cast = new castinfo(ifxtype, methodsqlname);
        this.explCasts.addElement(cast);
    }

    public void keepJavaFile(boolean value) {
        this.keepJavaFile = value;
    }

    public void setFieldName(int field, String name) throws SQLException {
        this.checkfield(field);
        if (name == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.fields[field - 1].name = name;
    }

    public String getFieldName(int field) throws SQLException {
        this.checkfield(field);
        return this.fields[field - 1].name;
    }

    public void setFieldType(int field, int ifxtype) throws SQLException {
        this.checkfield(field);
        this.checkFieldType(ifxtype);
        this.fields[field - 1].ifxtype = ifxtype;
    }

    public int getFieldType(int field) throws SQLException {
        this.checkfield(field);
        return this.fields[field - 1].ifxtype;
    }

    public void setFieldTypeName(int field, String sqltypename) throws SQLException {
        this.checkfield(field);
        if (sqltypename == null) {
            throw IfxErrMsg.getSQLException((int)-79708, (String)"", (Locale)this.locale);
        }
        this.fields[field - 1].sqltypename = sqltypename;
    }

    public String getFieldTypeName(int field) throws SQLException {
        this.checkfield(field);
        if (this.fields[field - 1].sqltypename != null) {
            return this.fields[field - 1].sqltypename;
        }
        if (this.fields[field - 1].ifxtype != -1) {
            return IfxTypes.IfxTypeToName((int)this.fields[field - 1].ifxtype);
        }
        return null;
    }

    public void setFieldLength(int field, int length) throws SQLException {
        this.checkfield(field);
        if (length <= 0) {
            throw IfxErrMsg.getSQLException((int)-79771, (String)"", (Locale)this.locale);
        }
        int ifxtype = this.fields[field - 1].ifxtype;
        if (IfxTypes.isString((int)ifxtype) || ifxtype == 14) {
            this.fields[field - 1].length = length;
        } else if (ifxtype == 10) {
            byte start = IfxDateTime.getStartCode((short)((short)length));
            byte end = IfxDateTime.getEndCode((short)((short)length));
            if (start == 6 && end == 10 || start == 0 && (end == 10 || end == 12 || end == 11 || end == 12 || end == 13 || end == 14 || end == 15)) {
                this.fields[field - 1].length = length;
            } else {
                throw IfxErrMsg.getSQLException((int)-79717, (String)"", (Locale)this.locale);
            }
        }
    }

    public int getFieldLength(int field) throws SQLException {
        this.checkfield(field);
        return this.fields[field - 1].length;
    }

    private void checkFieldType(int ifxtype) throws SQLException {
        switch (ifxtype) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 45: 
            case 101: 
            case 102: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 43: {
                throw IfxErrMsg.getSQLException((int)-79861, (String)"", (Locale)this.locale);
            }
            default: {
                throw IfxErrMsg.getSQLException((int)-79862, (String)"", (Locale)this.locale);
            }
        }
    }

    private boolean isValidCastType(int ifxtype) {
        return ifxtype >= 0 && ifxtype <= 8 || ifxtype >= 10 && ifxtype <= 18 || ifxtype == 43 || ifxtype == 45 || ifxtype == 101 || ifxtype == 102 || ifxtype == 44 || ifxtype == 46 || ifxtype == 47;
    }

    private void checkfield(int field) throws SQLException {
        if (field <= 0 || field > this.fieldCount) {
            throw IfxErrMsg.getSQLException((int)-79859, (String)"", (Locale)this.locale);
        }
    }

    class castinfo {
        int ifxtype = -1;
        String methodsqlname = null;

        castinfo(int ifxtype, String methodsqlname) {
            this.ifxtype = ifxtype;
            this.methodsqlname = methodsqlname;
        }
    }

    class supportudrinfo {
        Method method = null;
        String sqlname = null;
        int type = -1;

        supportudrinfo(Method method, String sqlname, int type) {
            this.method = method;
            this.sqlname = sqlname;
            this.type = type;
        }
    }

    class fieldinfo {
        String name = null;
        int ifxtype = -1;
        String sqltypename = null;
        int precision = -1;
        int scale = -1;
        int length = -1;

        fieldinfo() {
        }
    }
}

