/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.ChunkFlowStage;
import com.ibm.dltj.uima_annotator.flow.ConditionalFlowStage;
import com.ibm.dltj.uima_annotator.flow.FeatureFlowCondition;
import com.ibm.dltj.uima_annotator.flow.FixedFlowStage;
import com.ibm.dltj.uima_annotator.flow.IFlowStage;
import com.ibm.dltj.uima_annotator.flow.LrwFlow;
import com.ibm.dltj.uima_annotator.flow.SwitchFlowStage;
import com.ibm.dltj.uima_annotator.flow.TrueFlowCondition;
import com.ibm.langware.annotator.Copyright;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.resource.ResourceInitializationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LrwPearFlowController
extends CasFlowController_ImplBase {
    public void initialize(FlowControllerContext flowControllerContext) throws ResourceInitializationException {
        super.initialize(flowControllerContext);
    }

    public Flow computeFlow(CAS cAS) {
        LrwFlow lrwFlow = new LrwFlow(this.getContext().getLogger());
        lrwFlow.addFlowStages(this.getStages("0"));
        lrwFlow.computeFlow(cAS);
        return lrwFlow;
    }

    private List<IFlowStage> getStages(String string) {
        String[] stringArray = (String[])this.getContext().getConfigParameterValue(string, "RunIds");
        List<IFlowStage> list = this.getStages(stringArray);
        if (this.getContext().getConfigParameterValue(string, "ConditionType") == null) {
            return list;
        }
        ArrayList<IFlowStage> arrayList = new ArrayList<IFlowStage>(1);
        arrayList.add(this.getConditionStage(string, list));
        return arrayList;
    }

    private List<IFlowStage> getStages(String[] stringArray) {
        ArrayList<IFlowStage> arrayList = new ArrayList<IFlowStage>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.startsWith("*")) {
                LrwPearFlowController.handlePendingFixedIds(arrayList, arrayList2);
                arrayList.addAll(this.getStages(string.substring(1)));
                continue;
            }
            if (string.startsWith("!")) {
                LrwPearFlowController.handlePendingFixedIds(arrayList, arrayList2);
                arrayList.add(this.getSwitchStage(string.substring(1)));
                continue;
            }
            if (string.startsWith(">")) {
                LrwPearFlowController.handlePendingFixedIds(arrayList, arrayList2);
                arrayList.add(this.getChunkStage(string.substring(1)));
                continue;
            }
            arrayList2.add(string);
        }
        LrwPearFlowController.handlePendingFixedIds(arrayList, arrayList2);
        return arrayList;
    }

    private SwitchFlowStage getSwitchStage(String string) {
        Object object;
        Object object2;
        String[] stringArray = (String[])this.getContext().getConfigParameterValue(string, "RunIds");
        ArrayList<ConditionalFlowStage> arrayList = new ArrayList<ConditionalFlowStage>(stringArray.length - 1);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            object2 = stringArray[i];
            if (((String)object2).startsWith("*")) {
                object2 = ((String)object2).substring(1);
            }
            object = this.getStages((String)object2);
            arrayList.add((ConditionalFlowStage)object.get(0));
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.startsWith("*")) {
            string2 = string2.substring(1);
        }
        object2 = this.getStages(string2);
        object = new ConditionalFlowStage(new TrueFlowCondition(), (List<IFlowStage>)object2);
        return new SwitchFlowStage(arrayList, (ConditionalFlowStage)object);
    }

    private ChunkFlowStage getChunkStage(String string) {
        String[] stringArray = (String[])this.getContext().getConfigParameterValue(string, "RunIds");
        String[] stringArray2 = new String[stringArray.length - 2];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 2);
        List<IFlowStage> list = this.getStages(stringArray2);
        return new ChunkFlowStage(stringArray[0], list, stringArray[stringArray.length - 1]);
    }

    private static void handlePendingFixedIds(List<IFlowStage> list, List<String> list2) {
        if (!list2.isEmpty()) {
            list.add(new FixedFlowStage(list2));
            list2.clear();
        }
    }

    private ConditionalFlowStage getConditionStage(String string, List<IFlowStage> list) {
        String string2 = (String)this.getContext().getConfigParameterValue(string, "ConditionType");
        String string3 = (String)this.getContext().getConfigParameterValue(string, "ConditionFeature");
        String[] stringArray = (String[])this.getContext().getConfigParameterValue(string, "ConditionValues");
        FeatureFlowCondition featureFlowCondition = new FeatureFlowCondition(string2, string3, stringArray);
        return new ConditionalFlowStage(featureFlowCondition, list);
    }

    public void destroy() {
        super.destroy();
    }
}

