/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniMorphoSyntax;
import com.ibm.dltj.nondeterm.LookupResult;
import com.ibm.dltj.nondeterm.RuleBasedLookup;
import com.ibm.dltj.util.Guesser;
import com.ibm.dltj.util.GuesserUtil;
import java.text.CharacterIterator;

public class ApproximateGuesser
implements Guesser {
    private final UniMorphoSyntax morphoSyntax;
    private final RuleBasedLookup normalizer = RuleBasedLookup.getInstance();
    private LookupResult resultSet;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public ApproximateGuesser(UniLexAnalyzer uniLexAnalyzer) {
        this.morphoSyntax = uniLexAnalyzer.morphoSyntax;
    }

    @Override
    public String guess(String string) {
        String string2;
        if (!this.valid()) {
            return null;
        }
        try {
            this.resultSet = this.normalizer.lookup(string, this.morphoSyntax.dictionaries, this.morphoSyntax.tcr_dictionaries[0]);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        if (this.resultSet != null && (string2 = this.resultSet.getSurface()) != null && string2.length() != 0 && !string2.equals(string)) {
            return string2;
        }
        return null;
    }

    @Override
    public String guess(CharacterIterator characterIterator, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        UniLexAnalyzer.memcpy(stringBuilder, characterIterator, n, n2);
        return this.guess(stringBuilder.toString());
    }

    @Override
    public GlossCollection guessingLookup(CharacterIterator characterIterator, int n, int n2) {
        if (!this.valid()) {
            return null;
        }
        GlossCollection glossCollection = null;
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        UniLexAnalyzer.memcpy(stringBuilder, characterIterator, n, n2);
        try {
            this.resultSet = this.normalizer.lookup(stringBuilder.toString(), this.morphoSyntax.dictionaries, this.morphoSyntax.tcr_dictionaries[0]);
        }
        catch (DLTException dLTException) {
            return null;
        }
        if (this.resultSet != null) {
            glossCollection = GuesserUtil.adaptLemmaForGuess(this.resultSet.getSurface(), this.resultSet.getGloss());
        }
        return glossCollection;
    }

    @Override
    public int getType() {
        return 1;
    }

    public static boolean checkDicts(UniMorphoSyntax uniMorphoSyntax) {
        if (uniMorphoSyntax.tcr_dictionaries == null || uniMorphoSyntax.tcr_dictionaries.length == 0) {
            return false;
        }
        if (uniMorphoSyntax.tcr_dictionaries[0] == null) {
            return false;
        }
        return uniMorphoSyntax.dictionaries != null && uniMorphoSyntax.dictionaries.length != 0;
    }

    private boolean valid() {
        return ApproximateGuesser.checkDicts(this.morphoSyntax);
    }
}

