/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public final class AutoGlossSupport {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private AutoGlossSupport() {
    }

    public static int getHashCode(List<Object> list) {
        int n = 17;
        if (list == null) {
            return n;
        }
        for (Object object : list) {
            n = n * 37 + object.hashCode();
        }
        return n;
    }

    public static void readStringList(DataInputStream dataInputStream, List<String> list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(dataInputStream.readUTF());
        }
    }

    public static void writeStringList(DataOutputStream dataOutputStream, List<String> list) throws IOException {
        dataOutputStream.writeInt(list.size());
        for (String string : list) {
            dataOutputStream.writeUTF(string);
        }
    }

    public static void readBooleanList(DataInputStream dataInputStream, List<Boolean> list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(AutoGlossSupport.readBoolean(dataInputStream));
        }
    }

    public static void writeBooleanList(DataOutputStream dataOutputStream, List<Boolean> list) throws IOException {
        dataOutputStream.writeInt(list.size());
        for (Boolean bl : list) {
            dataOutputStream.writeBoolean(bl);
        }
    }

    public static void readByteList(DataInputStream dataInputStream, List<Byte> list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(dataInputStream.readByte());
        }
    }

    public static void writeByteList(DataOutputStream dataOutputStream, List<Byte> list) throws IOException {
        dataOutputStream.writeInt(list.size());
        for (Byte by : list) {
            dataOutputStream.writeByte(by.byteValue());
        }
    }

    public static void readIntegerList(DataInputStream dataInputStream, List<Integer> list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(dataInputStream.readInt());
        }
    }

    public static void writeIntegerList(DataOutputStream dataOutputStream, List<Integer> list) throws IOException {
        dataOutputStream.writeInt(list.size());
        for (Integer n : list) {
            dataOutputStream.writeInt(n);
        }
    }

    public static void readShortList(DataInputStream dataInputStream, List<Short> list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(dataInputStream.readShort());
        }
    }

    public static void writeShortList(DataOutputStream dataOutputStream, List<Short> list) throws IOException {
        dataOutputStream.writeInt(list.size());
        for (Short s : list) {
            dataOutputStream.writeShort(s.shortValue());
        }
    }

    public static <T extends Comparable<T>> int compareList(List<T> list, List<T> list2) {
        if (list.size() != list2.size()) {
            return list.size() - list2.size();
        }
        Iterator<T> iterator = list.iterator();
        Iterator<T> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)iterator.next();
            int n = comparable2.compareTo(comparable = (Comparable)iterator2.next());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public static int compareBoolean(Boolean bl, Boolean bl2) {
        if (bl.equals(bl2)) {
            return 0;
        }
        if (!bl.booleanValue()) {
            return -1;
        }
        return 1;
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUTF();
    }

    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeUTF(string);
    }

    public static Boolean readBoolean(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static void writeBoolean(DataOutputStream dataOutputStream, Boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
    }

    public static Byte readByte(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte();
    }

    public static void writeByte(DataOutputStream dataOutputStream, Byte by) throws IOException {
        dataOutputStream.writeByte(by.byteValue());
    }

    public static Integer readInteger(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readInt();
    }

    public static void writeInteger(DataOutputStream dataOutputStream, Integer n) throws IOException {
        dataOutputStream.writeInt(n);
    }

    public static Short readShort(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    public static void writeShort(DataOutputStream dataOutputStream, Short s) throws IOException {
        dataOutputStream.writeShort(s.shortValue());
    }

    public static Long readLong(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readLong();
    }

    public static void writeLong(DataOutputStream dataOutputStream, Long l) throws IOException {
        dataOutputStream.writeLong(l);
    }

    public static Float readFloat(DataInputStream dataInputStream) throws IOException {
        return new Float(dataInputStream.readFloat());
    }

    public static void writeFloat(DataOutputStream dataOutputStream, Float f) throws IOException {
        dataOutputStream.writeFloat(f.floatValue());
    }

    public static Double readDouble(DataInputStream dataInputStream) throws IOException {
        return new Double(dataInputStream.readDouble());
    }

    public static void writeDouble(DataOutputStream dataOutputStream, Double d) throws IOException {
        dataOutputStream.writeDouble(d);
    }
}

