/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.GlossReader;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.MapperGloss;

public class BackMapper
implements GlossProcessor {
    private final Gloss[] map;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public BackMapper(long l) {
        this.map = new Gloss[(int)l];
    }

    void recalcPointers() {
        for (int i = 0; i < this.map.length; ++i) {
            if (this.map[i] == null) continue;
            this.map[i].recalcPointers(this.map);
        }
    }

    public void setGloss(int n, Gloss gloss) throws DLTException {
        if (n < 0 || n >= this.map.length || this.map[n] != null) {
            throw new DLTException(Messages.getString("error.dict.read"));
        }
        this.map[n] = gloss;
    }

    @Override
    public void reset() {
    }

    @Override
    public Object process(Object object) throws DLTException {
        if (object instanceof GlossCollection) {
            GlossCollection glossCollection = (GlossCollection)object;
            for (int i = 0; i < glossCollection.size() && glossCollection.get(i) instanceof MapperGloss; ++i) {
                int n = ((MapperGloss)glossCollection.get((int)i)).map;
                n = GlossReader.decode_ordinal(n);
                glossCollection.set(i, this.map[n]);
            }
            return object;
        }
        throw new DLTException(Messages.getString("error.dict.load"));
    }
}

