/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Messages;
import com.ibm.dltj.PatternNameFilter;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class CapMatrix {
    private String _dataSpec = "";
    private final ArrayList<Entry> _entries = new ArrayList();
    private static final char PATH_SEPARATOR = '/';
    protected static final String EMPTY_STRING = "";
    protected static final Integer[] EMPTY_INT_ARRAY = new Integer[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final Entry[] EMPTY_ENTRY_ARRAY = new Entry[0];
    protected static final File[] EMPTY_FILE_ARRAY = new File[0];
    protected static final Dictionary[] EMPTY_DICT_ARRAY = new Dictionary[0];

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CapMatrix() throws DLTException {
        this(null);
    }

    public CapMatrix(String string) throws DLTException {
        this.setDataSpec(string);
    }

    public void setDataSpec(String string) {
        this.setDataSpec(string, true);
    }

    public synchronized void setDataSpec(String string, boolean bl) {
        this._dataSpec = string == null ? EMPTY_STRING : string;
        ArrayList<File> arrayList = CapMatrix.getRequestedFiles(this._dataSpec);
        this._entries.ensureCapacity(this._entries.size() + arrayList.size());
        for (File file : arrayList) {
            if (!file.isFile()) continue;
            URI uRI = file.toURI().normalize();
            Entry entry = null;
            for (Entry entry2 : this._entries) {
                if (!uRI.equals(entry2.getURI())) continue;
                entry = entry2;
                break;
            }
            try {
                if (entry == null) {
                    this._entries.add(new Entry(file));
                    continue;
                }
                if (!bl) continue;
                DictionaryInfo dictionaryInfo = new DictionaryInfo();
                Dictionary.readHeader(file, dictionaryInfo);
                entry.update(dictionaryInfo);
            }
            catch (DLTException dLTException) {
            }
            catch (IOException iOException) {}
        }
        this._entries.trimToSize();
    }

    public synchronized String getDataSpec() {
        return this._dataSpec;
    }

    public synchronized String[] getAvailableLangs() throws DLTException {
        HashSet<String> hashSet = new HashSet<String>(this._entries.size());
        for (Entry entry : this._entries) {
            for (String string : entry.getLangs()) {
                hashSet.add(string);
            }
        }
        if (hashSet.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public Integer[] getAvailableFuncs(String string) throws DLTException {
        return this.getAvailableFuncs(PatternNameFilter.parseLocale(string));
    }

    public Integer[] getAvailableFuncs(ULocale uLocale) throws DLTException {
        return this.getAvailableFuncs(PatternNameFilter.parseLocale(uLocale));
    }

    public synchronized Integer[] getAvailableFuncs(Locale locale) throws DLTException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Entry entry : this._entries) {
            for (Integer n : entry.getFuncs(locale)) {
                hashSet.add(n);
            }
        }
        if (hashSet.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        return hashSet.toArray(new Integer[hashSet.size()]);
    }

    public File[] getAvailableFiles(String string) throws DLTException {
        return this.getAvailableFiles(PatternNameFilter.parseLocale(string), 0);
    }

    public File[] getAvailableFiles(ULocale uLocale) throws DLTException {
        return this.getAvailableFiles(uLocale, 0);
    }

    public File[] getAvailableFiles(Locale locale) throws DLTException {
        return this.getAvailableFiles(locale, 0);
    }

    public File[] getAvailableFiles(String string, int n) throws DLTException {
        return this.getAvailableFiles(PatternNameFilter.parseLocale(string), n);
    }

    public synchronized File[] getAvailableFiles(ULocale uLocale, int n) throws DLTException {
        return this.getAvailableFiles(PatternNameFilter.parseLocale(uLocale), n);
    }

    public synchronized File[] getAvailableFiles(Locale locale, int n) throws DLTException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Entry entry : this._entries) {
            if (!entry.matches(locale, n)) continue;
            arrayList.add(entry.getFile());
        }
        if (arrayList.isEmpty()) {
            return EMPTY_FILE_ARRAY;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public Entry[] getAvailableEntries(String string) throws DLTException {
        return this.getAvailableEntries(PatternNameFilter.parseLocale(string), 0);
    }

    public Entry[] getAvailableEntries(ULocale uLocale) throws DLTException {
        return this.getAvailableEntries(PatternNameFilter.parseLocale(uLocale), 0);
    }

    public Entry[] getAvailableEntries(Locale locale) throws DLTException {
        return this.getAvailableEntries(locale, 0);
    }

    public Entry[] getAvailableEntries(String string, int n) throws DLTException {
        return this.getAvailableEntries(PatternNameFilter.parseLocale(string), n);
    }

    public synchronized Entry[] getAvailableEntries(ULocale uLocale, int n) throws DLTException {
        return this.getAvailableEntries(PatternNameFilter.parseLocale(uLocale), n);
    }

    public synchronized Entry[] getAvailableEntries(Locale locale, int n) throws DLTException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>(this._entries.size());
        for (Entry entry : this._entries) {
            if (!entry.matches(locale, n)) continue;
            arrayList.add(entry);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_ENTRY_ARRAY;
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    public Entry[] getAvailableEntries(String string, int[] nArray) throws DLTException {
        return this.getAvailableEntries(PatternNameFilter.parseLocale(string), nArray);
    }

    public synchronized Entry[] getAvailableEntries(ULocale uLocale, int[] nArray) throws DLTException {
        return this.getAvailableEntries(PatternNameFilter.parseLocale(uLocale), nArray);
    }

    public synchronized Entry[] getAvailableEntries(Locale locale, int[] nArray) throws DLTException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>(this._entries.size());
        for (Entry entry : this._entries) {
            if (!entry.matches(locale, nArray)) continue;
            arrayList.add(entry);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_ENTRY_ARRAY;
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    @Deprecated
    public Entry[] getEntries(Locale locale, int[] nArray) throws DLTException {
        return this.getAvailableEntries(locale, nArray);
    }

    public synchronized Entry[] getAllEntries() {
        if (this._entries.isEmpty()) {
            return EMPTY_ENTRY_ARRAY;
        }
        return this._entries.toArray(new Entry[this._entries.size()]);
    }

    public synchronized Dictionary[] getActivatedDicts() {
        ArrayList<Dictionary> arrayList = new ArrayList<Dictionary>(this._entries.size());
        for (Entry entry : this._entries) {
            if (!entry.isActivated()) continue;
            arrayList.add(entry.getDict());
        }
        if (arrayList.isEmpty()) {
            return EMPTY_DICT_ARRAY;
        }
        return arrayList.toArray(new Dictionary[arrayList.size()]);
    }

    public synchronized Entry getEntryByFilename(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = '/' + string.toLowerCase();
        for (Entry entry : this._entries) {
            URI uRI = entry.getURI();
            String string3 = uRI.toString();
            if (string3.length() < string2.length() || string3.charAt(string3.length() - string2.length()) != '/' || !(string3 = string3.substring(string3.length() - string2.length())).equalsIgnoreCase(string2)) continue;
            return entry;
        }
        return null;
    }

    public synchronized Entry getEntryByFile(File file) throws DLTException {
        if (file == null || !file.exists()) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        URI uRI = file.toURI().normalize();
        for (Entry entry : this._entries) {
            if (!uRI.equals(entry.getURI())) continue;
            return entry;
        }
        return this.registerEntry(new Entry(file));
    }

    public synchronized Entry[] activate(ULocale uLocale, int n) throws DLTException {
        return this.activate(PatternNameFilter.parseLocale(uLocale), n);
    }

    public synchronized Entry[] activate(Locale locale, int n) throws DLTException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>(this._entries.size());
        ArrayList<Dictionary> arrayList2 = new ArrayList<Dictionary>(this._entries.size());
        for (Entry entry : this._entries) {
            if (!entry.matches(locale, n)) continue;
            arrayList2.add(entry.activate());
            arrayList.add(entry);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_ENTRY_ARRAY;
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    @Deprecated
    public Entry[] activate(String string, int n) throws DLTException {
        return this.activate(PatternNameFilter.parseLocale(string), n);
    }

    public synchronized void deactivateAll() throws DLTException {
        for (Entry entry : this._entries) {
            entry.deactivate();
        }
    }

    public synchronized void deactivateFile(File file) {
        URI uRI = file.toURI().normalize();
        for (Entry entry : this._entries) {
            if (!uRI.equals(entry.getURI())) continue;
            entry.deactivate();
        }
    }

    public synchronized void deactivateFuzzy(int n) throws DLTException {
        if (n < 0) {
            return;
        }
        if (this._entries.size() <= n) {
            return;
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>(this._entries.size());
        for (Entry entry : this._entries) {
            if (!entry.isActivated() || entry.isNoDeactivateFuzzy()) continue;
            arrayList.add(entry);
        }
        if (arrayList.size() <= n) {
            return;
        }
        Collections.sort(arrayList, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                long l = entry.getActivatedTime() - entry2.getActivatedTime();
                if (l == 0L) {
                    return 0;
                }
                return l < 0L ? 1 : -1;
            }
        });
        for (int i = n; i < arrayList.size(); ++i) {
            Entry entry;
            entry = (Entry)arrayList.get(i);
            entry.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry registerDictionary(File file, Dictionary dictionary) throws DLTException {
        if (dictionary == null || !dictionary.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        Object object = dictionary.readLockObject;
        synchronized (object) {
            return this.registerEntry(new Entry(file, dictionary));
        }
    }

    public synchronized Entry registerEntry(Entry entry) throws DLTException {
        if (entry == null) {
            return null;
        }
        if (!this._entries.contains(entry)) {
            this._entries.add(entry);
        }
        return entry;
    }

    private static ArrayList<File> getRequestedFiles(String string) {
        String[] stringArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            File[] fileArray;
            File file = new File(string2);
            if (file.isFile() && !arrayList.contains(file)) {
                arrayList.add(file);
                continue;
            }
            if (file.isDirectory()) {
                fileArray = file.listFiles();
            } else {
                File[] fileArray2 = file.getAbsoluteFile();
                String string3 = fileArray2.getParent();
                if (string3 == null) {
                    fileArray = null;
                } else {
                    File file2 = new File(string3);
                    fileArray = file2.listFiles(new PatternNameFilter(fileArray2.getName()));
                }
            }
            if (fileArray == null) continue;
            for (File file3 : fileArray) {
                if (!file3.isFile() || arrayList.contains(file)) continue;
                arrayList.add(file3);
            }
        }
        return arrayList;
    }

    @Deprecated
    public void setDictCacheSize(int n) {
    }

    @Deprecated
    public int getDictCacheSize() {
        return 0;
    }

    public static class Entry {
        private final URI _uri;
        private SoftReference<File> _file;
        private SoftReference<Dictionary> _dictionary;
        private DictionaryInfo _info;
        private String _description;
        private volatile long _activatedTime;
        private boolean _noDeactivateFuzzy = false;

        Entry(File file) throws DLTException {
            this(file, null);
        }

        Entry(File file, Dictionary dictionary) throws DLTException {
            this._uri = file.toURI().normalize();
            this._file = new SoftReference<File>(file);
            this._dictionary = new SoftReference<Dictionary>(dictionary);
            if (dictionary == null) {
                this._info = new DictionaryInfo();
                try {
                    Dictionary.readHeader(file, this._info);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new DLTException(Messages.getString("file.notexist"));
                }
                catch (IOException iOException) {
                    throw new DLTException(Messages.getString("invalid.dict") + "\n" + iOException.getLocalizedMessage());
                }
            } else {
                this._info = dictionary.getSummary();
            }
        }

        synchronized void update(DictionaryInfo dictionaryInfo) {
            if (this._info == dictionaryInfo || this._info.equals(dictionaryInfo)) {
                return;
            }
            this._dictionary.clear();
            this._file.clear();
            this._description = null;
            this._info = dictionaryInfo;
        }

        public URI getURI() {
            return this._uri;
        }

        public synchronized File getFile() {
            File file = this._file.get();
            if (file == null) {
                file = new File(this._uri);
                this._file = new SoftReference<File>(file);
            }
            return file;
        }

        public synchronized Dictionary getDict() {
            try {
                return this.activate();
            }
            catch (DLTException dLTException) {
                return null;
            }
        }

        public synchronized DictionaryInfo getDictInfo() {
            return this._info;
        }

        public synchronized String getDescription() {
            if (this._description == null) {
                this._description = String.format("%s %s", this._uri, Arrays.toString(this.getLangs()));
            }
            return this._description;
        }

        synchronized String[] getLangs() {
            String[] stringArray = this._info.getLanguages();
            if (stringArray == null || stringArray.length == 0) {
                return EMPTY_STRING_ARRAY;
            }
            return stringArray;
        }

        synchronized Integer[] getFuncs(ULocale uLocale) {
            return this.getFuncs(PatternNameFilter.parseLocale(uLocale));
        }

        synchronized Integer[] getFuncs(Locale locale) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (String string : this.getLangs()) {
                Integer[] integerArray;
                Locale locale2 = PatternNameFilter.parseLocale(string);
                if (!PatternNameFilter.localeWildmatch(locale, locale2) || (integerArray = this._info.getFunctions(string)) == null || integerArray.length == 0) continue;
                for (Integer n : integerArray) {
                    hashSet.add(n);
                }
            }
            if (hashSet.isEmpty()) {
                return EMPTY_INT_ARRAY;
            }
            return hashSet.toArray(new Integer[hashSet.size()]);
        }

        public synchronized long getActivatedTime() {
            return this._activatedTime;
        }

        public synchronized void setNoDeactivateFuzzy(boolean bl) {
            this._noDeactivateFuzzy = bl;
        }

        public synchronized boolean isNoDeactivateFuzzy() {
            return this._noDeactivateFuzzy;
        }

        synchronized boolean matches(ULocale uLocale, int n) {
            return this.matches(PatternNameFilter.parseLocale(uLocale), n);
        }

        synchronized boolean matches(Locale locale, int n) {
            for (String string : this.getLangs()) {
                Integer[] integerArray;
                Locale locale2 = PatternNameFilter.parseLocale(string);
                if (!PatternNameFilter.localeWildmatch(locale, locale2)) continue;
                if (n == 0) {
                    return true;
                }
                for (Integer n2 : integerArray = this._info.getFunctions(string)) {
                    if (!n2.equals(n)) continue;
                    return true;
                }
            }
            return false;
        }

        synchronized boolean matches(ULocale uLocale, int[] nArray) {
            return this.matches(PatternNameFilter.parseLocale(uLocale), nArray);
        }

        synchronized boolean matches(Locale locale, int[] nArray) {
            for (String string : this.getLangs()) {
                Locale locale2 = PatternNameFilter.parseLocale(string);
                if (!PatternNameFilter.localeWildmatch(locale, locale2)) continue;
                if (nArray == null) {
                    return true;
                }
                List<Integer> list = Arrays.asList(this._info.getFunctions(string));
                boolean bl = true;
                for (int n : nArray) {
                    if (n > 0) {
                        if (list.contains(n)) continue;
                        bl = false;
                        break;
                    }
                    if (n >= 0 || !list.contains(n * -1)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }

        public Dictionary activate() throws DLTException {
            return this.activate(0);
        }

        @Deprecated
        public Dictionary activate(boolean bl) throws DLTException {
            return this.activate(bl ? 0 : 1);
        }

        @Deprecated
        public Dictionary activate(boolean bl, boolean bl2) throws DLTException {
            int n = 0;
            if (!bl) {
                n |= 1;
            }
            if (bl2) {
                n |= 2;
            }
            return this.activate(n);
        }

        public synchronized Dictionary activate(int n) throws DLTException {
            Dictionary dictionary = this._dictionary.get();
            if (dictionary == null || !dictionary.valid()) {
                dictionary = new Dictionary(this.getFile(), n);
                this._dictionary = new SoftReference<Dictionary>(dictionary);
                this._description = null;
                this._info = dictionary.getSummary();
            }
            this._activatedTime = System.nanoTime();
            return dictionary;
        }

        public synchronized void deactivate() {
            this._dictionary.clear();
            this._file.clear();
        }

        public synchronized boolean isActivated() {
            Dictionary dictionary = this._dictionary.get();
            return dictionary != null && dictionary.valid();
        }

        public String toString() {
            return this.getDescription();
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            return !(this._uri == null ? entry._uri != null : !this._uri.equals(entry._uri));
        }
    }
}

