/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.Buffer;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.Poolable;

public class CharacterBuffer
implements Buffer,
Poolable {
    public static final int DLTAID_MAX_STRLEN = 127;
    public int length;
    public char[] string;
    private String str;
    int id = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public boolean equals(CharacterBuffer characterBuffer) {
        if (characterBuffer.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (characterBuffer.string[i] == this.string[i]) continue;
            return false;
        }
        return true;
    }

    public CharacterBuffer() {
        this.init(127);
    }

    public CharacterBuffer(String string) {
        this.init(string.length());
        if (this.string != null) {
            System.arraycopy(string.toCharArray(), 0, this.string, 0, string.length());
            this.length = string.length();
            this.str = string;
        }
    }

    public CharacterBuffer(int n) {
        this.init(n);
    }

    protected void init(int n) {
        this.length = 0;
        this.string = (char[])(n > 127 ? null : new char[n]);
    }

    public String toString() {
        if (this.str == null) {
            this.str = new String(this.string, 0, this.length);
        }
        return this.str;
    }

    @Override
    public void addAll(Buffer buffer) {
        throw new IllegalArgumentException(Messages.getString("notimplement"));
    }

    @Override
    public void clear() {
        this.length = 0;
        this.str = null;
    }

    public void decLength() {
        --this.length;
        this.str = null;
    }

    @Override
    public int grow() {
        char[] cArray = new char[this.string.length * 2];
        System.arraycopy(this.string, 0, cArray, 0, this.string.length);
        this.string = cArray;
        return this.string.length;
    }

    @Override
    public int limit() {
        return this.string.length;
    }

    public void add(char c) {
        if (this.string.length == this.length) {
            this.grow();
        }
        this.string[this.length] = c;
        ++this.length;
        this.str = null;
    }

    @Override
    public int position() {
        return this.length;
    }

    @Override
    public int remaining() {
        return this.string.length - this.length;
    }

    void copyFrom(CharacterBuffer characterBuffer) {
        System.arraycopy(characterBuffer.string, 0, this.string, 0, characterBuffer.length);
        this.length = characterBuffer.length;
        this.str = characterBuffer.str;
    }

    void infix(CharacterBuffer characterBuffer, int n, CharacterBuffer characterBuffer2, char[] cArray, int n2) {
        System.arraycopy(characterBuffer.string, 0, this.string, 0, n);
        System.arraycopy(cArray, 0, this.string, n, cArray.length);
        System.arraycopy(characterBuffer2.string, n2, this.string, n + cArray.length, characterBuffer2.length - n2);
        this.length = n + cArray.length + characterBuffer2.length - n2;
        this.str = null;
    }

    @Override
    public void reg4pool(int n, Pool pool) {
        this.id = n;
    }

    public int indexOf(CharacterBuffer characterBuffer) {
        for (int i = 0; i < this.length; ++i) {
            int n;
            int n2 = i;
            if (this.length - n2 < characterBuffer.length) break;
            for (n = 0; n < characterBuffer.length && characterBuffer.string[n] == this.string[n2]; ++n) {
                ++n2;
            }
            if (n != characterBuffer.length) continue;
            return i;
        }
        return -1;
    }

    public CharacterBuffer toFirstTitleCase() {
        CharacterBuffer characterBuffer = new CharacterBuffer();
        characterBuffer.copyFrom(this);
        characterBuffer.string[0] = Character.toTitleCase(characterBuffer.string[0]);
        characterBuffer.str = null;
        return characterBuffer;
    }

    public CharacterBuffer toUpperCase() {
        String string = this.toString().toUpperCase();
        return new CharacterBuffer(string);
    }

    public CharacterBuffer toCrazyCase(int n) {
        CharacterBuffer characterBuffer = new CharacterBuffer();
        characterBuffer.copyFrom(this);
        characterBuffer.string[n] = Character.toTitleCase(characterBuffer.string[n]);
        characterBuffer.str = null;
        return characterBuffer;
    }

    public CharacterBuffer applyCase(CaseGloss caseGloss) {
        return new CharacterBuffer(caseGloss.getCase(this.toString()));
    }
}

