/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DictionariesJar {
    private final File _file;
    private final JarFile _jarFile;
    private final Map<String, Map<String, String[]>> _generic = new TreeMap<String, Map<String, String[]>>(NoCaseStringComparator.COMPARATOR);
    private final Map<String, String[]> _dictionaries = new TreeMap<String, String[]>(NoCaseStringComparator.COMPARATOR);
    private final Map<String, Object> _dictionaryCache;
    private final int _dictionaryCacheType;
    private final int _loadFlags;
    private static final boolean DEFAULT_VERIFY = false;
    private static final int DEFAULT_LOADFLAGS = 0;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_WEAK = 1;
    public static final int CACHE_SOFT = 2;
    public static final int CACHE_HARD = 3;
    public static final String LANGUAGEWARE_PREFIX = "LanguageWare-";
    private static final String LANGUAGEWARE_PREFIX_LOWER = "LanguageWare-".toLowerCase();
    public static final String LANGUAGEWARE_DICTIONARY_PREFIX = "LanguageWare-Dictionary-";
    private static final String LANGUAGEWARE_DICTIONARY_PREFIX_LOWER = "LanguageWare-Dictionary-".toLowerCase();
    public static final String STANDARD = "Std";
    private static final String PROPERTIES_TYPE = "properties";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DictionariesJar(File file) throws IOException, DLTException {
        this(file, false, 0, 0);
    }

    public DictionariesJar(File file, boolean bl, int n) throws IOException, DLTException {
        this(file, bl, n, 0);
    }

    public DictionariesJar(File file, boolean bl, int n, int n2) throws IOException, DLTException {
        this._file = file;
        this._loadFlags = n2;
        this._jarFile = new JarFile(file, bl, 1);
        Manifest manifest = this._jarFile.getManifest();
        if (manifest == null) {
            this.close();
            throw new DLTException(Messages.format("error.nomanifest", file.getPath()));
        }
        this.readManifest(manifest);
        this._dictionaryCacheType = n;
        if (n < 0 || n > 3) {
            throw new DLTException(Messages.getString("error.badcachetype"));
        }
        this._dictionaryCache = n == 0 ? null : new TreeMap();
    }

    private void readManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            Attributes.Name name = (Attributes.Name)entry.getKey();
            String string = name.toString();
            String string2 = string.toLowerCase();
            if (!string2.startsWith(LANGUAGEWARE_PREFIX_LOWER)) continue;
            this.readGenericAttr(string, (String)entry.getValue());
            if (!string2.startsWith(LANGUAGEWARE_DICTIONARY_PREFIX_LOWER)) continue;
            String string3 = string.substring(LANGUAGEWARE_DICTIONARY_PREFIX_LOWER.length());
            DictionariesJar.readAttrNames(string3, (String)entry.getValue(), this._dictionaries);
        }
    }

    private void readGenericAttr(String string, String string2) {
        String[] stringArray = string.split("-", 3);
        if (stringArray == null || stringArray.length != 3) {
            return;
        }
        String string3 = stringArray[1];
        Map<String, String[]> map = this._generic.get(string3);
        if (map == null) {
            map = new TreeMap<String, String[]>(NoCaseStringComparator.COMPARATOR);
            this._generic.put(string3, map);
        }
        String string4 = stringArray[2];
        DictionariesJar.readAttrNames(string4, string2, map);
    }

    private static void readAttrNames(String string, String string2, Map<String, String[]> map) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        String[] stringArray = string2.split(",");
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.length() <= 0) continue;
            arrayList.add(string3);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        map.put(string, stringArray2);
    }

    public void close() throws IOException {
        this._jarFile.close();
    }

    public void clearCache() {
        if (this._dictionaryCache != null) {
            this._dictionaryCache.clear();
        }
    }

    public String[] getGenericTypes() {
        Set<String> set = this._generic.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public String[] getGenericTypeEntryNames(String string) {
        Map<String, String[]> map = this._generic.get(string);
        if (map == null) {
            return null;
        }
        Set<String> set = map.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public InputStream[] getGenericTypeEntryInputStreams(String string, String string2) throws DLTException, IOException {
        Map<String, String[]> map = this._generic.get(string);
        if (map == null) {
            return null;
        }
        String[] stringArray = map.get(string2);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            JarEntry jarEntry = this._jarFile.getJarEntry(string3);
            if (jarEntry == null) {
                throw new DLTException(Messages.format("error.nojarentry", string3, this._jarFile.getName()));
            }
            inputStreamArray[i] = this._jarFile.getInputStream(jarEntry);
        }
        return inputStreamArray;
    }

    public Properties getProperties(String string) throws IOException, DLTException {
        InputStream[] inputStreamArray = this.getGenericTypeEntryInputStreams(PROPERTIES_TYPE, string);
        if (inputStreamArray == null) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < inputStreamArray.length; ++i) {
            InputStream inputStream = inputStreamArray[i];
            properties.load(inputStream);
            inputStream.close();
        }
        return properties;
    }

    public String[] getPropertiesTypes() {
        return this.getGenericTypeEntryNames(PROPERTIES_TYPE);
    }

    public String[] getDictionaryTypes() {
        Set<String> set = this._dictionaries.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public String[] getDictionaryNames(String string) {
        return this._dictionaries.get(string);
    }

    public Dictionary[] getDictionaries(String string) throws DLTException, IOException {
        String[] stringArray = this._dictionaries.get(string);
        return this.getDictionaries(stringArray);
    }

    private Dictionary[] getDictionaries(String[] stringArray) throws DLTException, IOException {
        if (stringArray == null) {
            return null;
        }
        Dictionary[] dictionaryArray = new Dictionary[stringArray.length];
        this.getDictionaries(stringArray, dictionaryArray);
        return dictionaryArray;
    }

    private void getDictionaries(String[] stringArray, Dictionary[] dictionaryArray) throws DLTException, IOException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            dictionaryArray[i] = this.getDictionary(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getDictionary(String string) throws IOException, DLTException {
        Dictionary dictionary = this.getDictionaryFromCache(string);
        if (dictionary != null) {
            return dictionary;
        }
        JarEntry jarEntry = this._jarFile.getJarEntry(string);
        if (jarEntry == null) {
            throw new DLTException(Messages.format("error.nojarentry", string, this._jarFile.getName()));
        }
        InputStream inputStream = null;
        try {
            inputStream = this._jarFile.getInputStream(jarEntry);
            dictionary = new Dictionary();
            ClassLoader classLoader = null;
            if ((this._loadFlags & 0x10) != 0) {
                classLoader = this.getJarClassLoader();
            }
            dictionary.load(inputStream, this._loadFlags, classLoader);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (this._dictionaryCache != null) {
            this._dictionaryCache.put(string, this.getValueToCache(dictionary));
        }
        return dictionary;
    }

    private ClassLoader getJarClassLoader() throws MalformedURLException {
        return new URLClassLoader(new URL[]{this._file.toURI().toURL()}, this.getClass().getClassLoader());
    }

    private Dictionary getDictionaryFromCache(String string) {
        if (this._dictionaryCache == null) {
            return null;
        }
        Object object = this._dictionaryCache.get(string);
        if (object == null) {
            return null;
        }
        if (this._dictionaryCacheType == 3) {
            return (Dictionary)object;
        }
        Reference reference = (Reference)object;
        Object t = reference.get();
        if (t == null) {
            this._dictionaryCache.remove(string);
            return null;
        }
        return (Dictionary)t;
    }

    private Object getValueToCache(Dictionary dictionary) {
        switch (this._dictionaryCacheType) {
            case 0: {
                return null;
            }
            case 1: {
                return new WeakReference<Dictionary>(dictionary);
            }
            case 2: {
                return new SoftReference<Dictionary>(dictionary);
            }
            case 3: {
                return dictionary;
            }
        }
        return null;
    }

    private static class NoCaseStringComparator
    implements Comparator<String> {
        static final Comparator<String> COMPARATOR = new NoCaseStringComparator();

        NoCaseStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

