/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.AppendTraverse;
import com.ibm.dltj.BackMapper;
import com.ibm.dltj.ChecksumException;
import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Entry;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.LockManager;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.fst.GenericToObjectConverter;
import com.ibm.dltj.fst.GlossCollectionHandler;
import com.ibm.dltj.fst.LowerCaseMultiNet;
import com.ibm.dltj.fst.MWUDictionary;
import com.ibm.dltj.fst.MWUDictionaryFactory;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.MultiNetImpl;
import com.ibm.dltj.fst.MultiNetIntegerImpl;
import com.ibm.dltj.fst.NDNet;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.fst.NetGenericDictionaryLowercase;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.NodeHashIndex;
import com.ibm.dltj.fst._NetIntegerImpl;
import com.ibm.dltj.gloss.BasicCutPasteGloss;
import com.ibm.dltj.gloss.BytesClassLoader;
import com.ibm.dltj.gloss.CatNameGloss;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossCollectionProcessor;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.GlossPool;
import com.ibm.dltj.gloss.GrammarGloss;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.JkomCollectionGloss;
import com.ibm.dltj.gloss.LangNameGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.PcodeGloss;
import com.ibm.dltj.gloss.PhoneticSpellingGloss;
import com.ibm.dltj.gloss.PosCollectionGloss;
import com.ibm.dltj.gloss.StemCutPasteGloss;
import com.ibm.dltj.gloss.StemGloss;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.SynonymGloss;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.gloss.TypedDoubleGloss;
import com.ibm.dltj.gloss.TypedIntGloss;
import com.ibm.dltj.gloss.TypedStringGloss;
import com.ibm.dltj.gloss.TypedVectorGloss;
import com.ibm.dltj.gloss.UserDefinedDefaultGloss;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.um.JKOM;
import com.ibm.dltj.util.ChecksumInputStream;
import com.ibm.dltj.util.ChecksumOutputStream;
import com.ibm.dltj.util.Traverse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Dictionary
extends LockManager {
    @Deprecated
    public static final int DLT3_DEFAULT_VERSION = 768;
    @Deprecated
    public static final int DLT3_DEFAULT_TYPE = 1;
    @Deprecated
    public static final int DLT3_TYPE_DEFAULT = 1;
    @Deprecated
    public static final int DLT3_TYPE_ENCHAINED = 0x10000000;
    public static final int DLT_DEFAULT_VERSION = 0x8000400;
    public static final int DLT_DEFAULT_TYPE = 1;
    public static final int DLT_TYPE_DEFAULT = 1;
    @Deprecated
    public static final int DLT_TYPE_ENCHAINED = 0x10000000;
    public static final int DLT_APPEND_DEST_LANG = 0;
    public static final int DLT_APPEND_SRC_LANG = 1;
    public static final int DLT_LOAD_OBJECT = 1;
    public static final int DLT_LOAD_CHECKSUM = 2;
    public static final int DLT_LOAD_DIRECTMEM = 4;
    public static final int DLT_LOAD_FORCE_NETCOMPACT = 8;
    public static final int DLT_LOAD_JAR_IN_CLASSPATH = 16;
    public static final int DLT_CREATE_MULTIWORD = 32;
    public static final int DLT_CREATE_STAGED_COMPACT_FSA = 64;
    public static final int DLT_CREATE_OBJECT_FORMAT = 128;
    public static final int DLT_HINT_OPTIMIZE_SIZE = 4096;
    public static final int DLT_HINT_OPTIMIZE_PERFORMANCE = 8192;
    public static final int DLT_HINT_RELAX_PRECISION = 65536;
    public static final String MWU_LanguageID = "MWU";
    MultiNet fsa = null;
    private DictionaryInfo summary = new DictionaryInfo();
    private File dictionaryFile = null;
    public GlossPool[] pools = new GlossPool[255];
    private BytesClassLoader loader = null;
    private GlossCollectionHandler glossHandler = null;
    private int overrideModifiable = 0;
    MWUDictionary mwuFsa = null;
    private static final int DLTGLS_POOL_HEXSIGNATURE_BYTE = 1347374924;
    private static final int DLTGLS_POOL_HEXSIGNATURE_CLASS = 1347374925;
    private static final int DLTGLS_POOL_HEXSIGNATURE_CLASSDATA = 1347374926;
    private static final int DLT_CHECKSUM_SIGNATURE = 1229081971;
    public final GlossProcessor atomic_gloss_registerer = new AtomicGlossRegisterer();
    public final GlossProcessor gloss_registerer = new GlossCollectionProcessor(this.atomic_gloss_registerer);

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\n5724-Z21 ASW16ZZ\n(C) Copyright IBM Corp. 2003, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    GlossPool getPoolByNumber(int n) {
        return this.pools[n];
    }

    GlossPool registerPool(int n) throws DLTException {
        if (this.pools[n] == null) {
            this.pools[n] = GlossPool.instantiate(n);
        }
        return this.pools[n];
    }

    GlossPool registerPool(String string, int n, ClassLoader classLoader) throws DLTException {
        if (this.pools[n] == null) {
            this.pools[n] = GlossPool.instantiate(string, classLoader);
        }
        return this.pools[n];
    }

    GlossPool registerPool(String string, byte[] byArray, int n) throws DLTException {
        if (this.pools[n] == null) {
            if (this.loader == null) {
                this.loader = new BytesClassLoader(Dictionary.class.getClassLoader());
            }
            this.pools[n] = GlossPool.instantiate(string, this.loader, byArray);
        }
        return this.pools[n];
    }

    GlossPool registerPool(Class<? extends Gloss> clazz, int n) throws DLTException {
        if (this.pools[n] == null) {
            this.pools[n] = new GlossPool(clazz);
        }
        return this.pools[n];
    }

    GlossPool registerPool(Class<? extends Gloss> clazz, byte[] byArray, int n) throws DLTException {
        if (this.pools[n] == null) {
            this.pools[n] = new GlossPool(clazz, byArray);
        }
        return this.pools[n];
    }

    public Dictionary() {
        this.fsa = new MultiNetImpl();
        this.setFSAOwnerDictionary();
    }

    private MultiNet makeLowercaseWrapper(MultiNet multiNet) {
        if (this.summary.isLowerCase()) {
            return new LowerCaseMultiNet(multiNet);
        }
        return multiNet;
    }

    private MultiNet createFST(int n) throws DLTException {
        if (!this.summary.isDeterministic()) {
            return new NDNet();
        }
        if ((n & 0x60) != 0 && (this.summary.getReleaseCompatibility() < 7000 || (n & 0x80) == 128)) {
            throw new DLTException(Messages.getString("error.relcompat.flag"));
        }
        if ((n & 0x80) == 128) {
            return this.makeLowercaseWrapper(new MultiNetImpl());
        }
        if (this.summary.getReleaseCompatibility() >= 7000) {
            this.glossHandler = new GlossCollectionHandler(this);
            NetGenericDictionary netGenericDictionary = this.createNetGenericFSA((n & 0x40) == 64 ? -2018189263 : 448061489);
            this.mwuFsa = (n & 0x10000) != 0 ? this.makeMwuFsa(813112591, netGenericDictionary.getCharacterMap()) : null;
            return netGenericDictionary;
        }
        return this.makeLowercaseWrapper(new MultiNetIntegerImpl());
    }

    private NetGenericDictionary createNetGenericFSA(int n) throws DLTException {
        CharacterMap characterMap = this.summary.isLowerCase() ? NetGenericDictionaryLowercase.createCharacterMap() : NetGenericDictionary.createCharacterMap();
        NetGenericDictionary netGenericDictionary = this.summary.isLowerCase() ? new NetGenericDictionaryLowercase(n, this.glossHandler, characterMap) : new NetGenericDictionary(n, this.glossHandler, characterMap);
        return netGenericDictionary;
    }

    private MWUDictionary makeMwuFsa(int n, CharacterMap characterMap) throws DLTException {
        if (!(this.fsa instanceof NetGenericDictionary)) {
            throw new DLTException(Messages.getString("error.dict.not.multiword"));
        }
        this.mwuFsa = MWUDictionaryFactory.createMWU(n, this.glossHandler, characterMap, this.atomic_gloss_registerer, this.summary.isLowerCase());
        if (this.pools[57] == null) {
            this.summary.addType(MWU_LanguageID, 57);
        }
        if (this.pools[58] == null) {
            this.summary.addType(MWU_LanguageID, 58);
        }
        return this.mwuFsa;
    }

    private MWUDictionary getOrMakeMwuFsa() throws DLTException {
        if (this.mwuFsa == null) {
            return this.makeMwuFsa(0, ((NetGenericDictionary)this.fsa.getMultiNet()).getCharacterMap());
        }
        return this.mwuFsa;
    }

    MWUDictionary getMwuFsa() {
        return this.mwuFsa;
    }

    @Deprecated
    public Dictionary(File file, String string, int n, int n2) throws DLTException {
        this(file, n, n2);
    }

    @Deprecated
    public Dictionary(File file, int n, int n2) throws DLTException {
        this.dictionaryFile = file;
        this.summary.version = n;
        this.fsa = this.createFST(n2);
        this.setFSAOwnerDictionary();
    }

    @Deprecated
    Dictionary(DictionaryInfo dictionaryInfo) throws DLTException {
        this(new File(""), dictionaryInfo, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    Dictionary(File file, DictionaryInfo dictionaryInfo, int n) throws DLTException {
        DictionaryInfo dictionaryInfo2 = dictionaryInfo;
        synchronized (dictionaryInfo2) {
            try {
                this.summary = (DictionaryInfo)dictionaryInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DLTException(Messages.getString("cannot.clone"));
            }
            this.dictionaryFile = file;
            this.fsa = this.createFST(n);
            this.setFSAOwnerDictionary();
        }
    }

    public static Dictionary createDictionary(DictionaryInfo dictionaryInfo) throws DLTException {
        return new Dictionary(new File(""), dictionaryInfo, 0);
    }

    public static Dictionary createDictionary(File file, DictionaryInfo dictionaryInfo) throws DLTException {
        return new Dictionary(file, dictionaryInfo, 0);
    }

    public static Dictionary createDictionary(int n, DictionaryInfo dictionaryInfo) throws DLTException {
        return new Dictionary(new File(""), dictionaryInfo, n);
    }

    public static Dictionary createDictionary(int n, File file, DictionaryInfo dictionaryInfo) throws DLTException {
        return new Dictionary(file, dictionaryInfo, n);
    }

    public static Dictionary createDictionary(DictionaryInfo dictionaryInfo, int n) throws DLTException {
        MultiNetIntegerImpl.setMinExtendSize(n);
        return new Dictionary(dictionaryInfo);
    }

    public static Dictionary createDictionary(File file, DictionaryInfo dictionaryInfo, int n) throws DLTException {
        MultiNetIntegerImpl.setMinExtendSize(n);
        return new Dictionary(file, dictionaryInfo, 0);
    }

    public Dictionary(File file, int n) throws DLTException {
        this(file, n, null);
    }

    public Dictionary(File file, int n, ClassLoader classLoader) throws DLTException {
        try {
            this.dictionaryFile = file;
            this.load(file, n, classLoader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        catch (IOException iOException) {
            throw new DLTException(iOException);
        }
    }

    public Dictionary(InputStream inputStream, int n) throws DLTException {
        this(inputStream, n, null);
    }

    public Dictionary(InputStream inputStream, int n, ClassLoader classLoader) throws DLTException {
        try {
            this.load(inputStream, n, classLoader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        catch (IOException iOException) {
            throw new DLTException(iOException);
        }
    }

    @Deprecated
    public Dictionary(File file, boolean bl, boolean bl2) throws DLTException {
        try {
            this.dictionaryFile = file;
            this.load(file, bl, bl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        catch (IOException iOException) {
            throw new DLTException(iOException);
        }
    }

    @Deprecated
    public Dictionary(File file, boolean bl) throws DLTException {
        this(file, bl, false);
    }

    public Dictionary(File file) throws DLTException {
        this(file, true, false);
    }

    public synchronized long getNumberOfEntries() throws DLTException {
        if (this.summary.getCopyrightStatement().indexOf("IBM") < 0 && !this.summary.isCyclic()) {
            return new CountTraverse().count();
        }
        throw new DLTException(Messages.getString("cannot.iteratedict"));
    }

    public boolean isMWUDictionary() {
        return this.mwuFsa != null && !this.mwuFsa.isEmpty();
    }

    public Iterator<Map.Entry<String, Object>> iterator() throws DLTException {
        if (this.summary.getCopyrightStatement().indexOf("IBM") < 0) {
            return this.fsa.iterator();
        }
        throw new DLTException(Messages.getString("cannot.iteratedict"));
    }

    @Deprecated
    public static File[] find(String string, int n) throws DLTException {
        if (DLT.getCapMatrix() == null) {
            throw new DLTException(Messages.getString("wrong.call.find"));
        }
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("invalid.langid"));
        }
        if (n < 0 || n > 255) {
            throw new DLTException(Messages.getString("invalid.option"));
        }
        return DLT.getCapMatrix().getAvailableFiles(string, n);
    }

    public MultiNet getNet() {
        return this.fsa;
    }

    public Node getMwuNodeInterface() {
        if (this.isMWUDictionary()) {
            return this.mwuFsa.getNodeInterface();
        }
        return null;
    }

    protected int getCheckSum() {
        return this.summary.getCheckSum();
    }

    public synchronized void load(File file) throws DLTException, FileNotFoundException, IOException {
        this.load(file, true, false);
    }

    @Deprecated
    public synchronized void load(File file, boolean bl) throws DLTException, FileNotFoundException, IOException {
        this.load(file, bl, false);
    }

    @Deprecated
    public void load(File file, boolean bl, boolean bl2) throws DLTException, FileNotFoundException, IOException {
        this.load((InputStream)new FileInputStream(file), bl, bl2);
    }

    public void load(File file, int n) throws DLTException, FileNotFoundException, IOException {
        this.load((InputStream)new FileInputStream(file), n, null);
    }

    public void load(File file, int n, ClassLoader classLoader) throws DLTException, FileNotFoundException, IOException {
        this.load((InputStream)new FileInputStream(file), n, classLoader);
    }

    @Deprecated
    public void load(InputStream inputStream, boolean bl, boolean bl2) throws DLTException, FileNotFoundException, IOException {
        int n = 0;
        if (!bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        this.load(inputStream, n);
    }

    public void load(InputStream inputStream, int n) throws DLTException, FileNotFoundException, IOException {
        this.load(inputStream, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream, int n, ClassLoader classLoader) throws DLTException, FileNotFoundException, IOException {
        FilterInputStream filterInputStream = null;
        try {
            FilterInputStream filterInputStream2 = new BufferedInputStream(inputStream, 4096);
            ChecksumInputStream checksumInputStream = null;
            if ((n & 2) != 0) {
                checksumInputStream = new ChecksumInputStream(filterInputStream2);
                filterInputStream2 = checksumInputStream;
            }
            filterInputStream = new DataInputStream(filterInputStream2);
            this.load((DataInputStream)filterInputStream, n, classLoader);
            if (checksumInputStream != null && filterInputStream.available() > 0) {
                long l = checksumInputStream.getCheckSum();
                int n2 = ((DataInputStream)filterInputStream).readInt();
                if (n2 != 1229081971) {
                    throw new DLTException(Messages.getString("bad.checksumsig"));
                }
                long l2 = ((DataInputStream)filterInputStream).readLong();
                if (l2 != l) {
                    throw new ChecksumException();
                }
            }
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    public void load(DataInputStream dataInputStream) throws DLTException, IOException {
        this.load(dataInputStream, 0, null);
    }

    public synchronized void load(DataInputStream dataInputStream, int n) throws DLTException, IOException {
        this.load(dataInputStream, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(DataInputStream dataInputStream, int n, ClassLoader classLoader) throws DLTException, IOException {
        DictionaryInfo dictionaryInfo = this.summary;
        synchronized (dictionaryInfo) {
            Initializer initializer;
            int n2;
            int n3 = this.summary.readHeader(dataInputStream);
            if (!this.summary.isDeterministic()) {
                this.fsa = new NDNet();
            } else {
                if (!dataInputStream.markSupported()) {
                    dataInputStream = new DataInputStream(new BufferedInputStream(dataInputStream));
                }
                if (NetGenericFactory.isNetCompact(n2 = NetGenericFactory.getFSTSignature(dataInputStream))) {
                    this.glossHandler = new GlossCollectionHandler(this);
                    this.fsa = this.createNetGenericFSA(n2);
                    this.mwuFsa = null;
                } else {
                    this.fsa = (n & 1) == 0 ? new MultiNetIntegerImpl() : new MultiNetImpl();
                    this.fsa = this.makeLowercaseWrapper(this.fsa);
                    this.glossHandler = null;
                }
            }
            this.setFSAOwnerDictionary();
            this.fsa.readContents(dataInputStream, n);
            this.summary.isMinimizable = !this.fsa.getChainPolicy();
            this.summary.isMinimized = this.fsa.isContracted();
            if (this.glossHandler != null) {
                this.glossHandler.readGlosses(dataInputStream);
                n2 = -1;
                while (n2 == -1) {
                    n2 = dataInputStream.readInt();
                }
                if (MWUDictionaryFactory.isMWUSignature(n2)) {
                    initializer = ((NetGenericDictionary)this.fsa).getCharacterMap();
                    this.makeMwuFsa(n2, (CharacterMap)initializer).readContents(dataInputStream);
                    n2 = dataInputStream.readInt();
                }
                if (n2 != -84230466) {
                    throw new DLTException(Messages.getString("error.marker"));
                }
            }
            this.loadGlosses(dataInputStream, classLoader);
            n2 = this.getCheckSum();
            if (n2 != n3) {
                throw new DLTException(Messages.getString("error.dict.checksum"));
            }
            this.summary.completeLoad();
            if (this.fsa instanceof NetGenericDictionary && (n & 1) != 0) {
                if (this.isMWUDictionary()) {
                    throw new DLTException(Messages.getString("invalid.option.object.mwu"));
                }
                this.fsa = new GenericToObjectConverter((NetGenericDictionary)this.fsa).convert();
                this.fsa = this.makeLowercaseWrapper(this.fsa);
                this.glossHandler = null;
            }
            if (!(this.fsa instanceof NetGenericDictionary) && (n & 8) != 0) {
                this.glossHandler = new GlossCollectionHandler(this);
                initializer = this.createNetGenericFSA(448061489);
                ((NetGenericDictionary)initializer).append(this.fsa.first(), GlossProcessor.Empty);
                this.fsa = initializer;
            }
        }
    }

    private void loadGlosses(DataInputStream dataInputStream, ClassLoader classLoader) throws DLTException, IOException {
        BackMapper backMapper = new BackMapper(this.summary.getNumberOfGlosses() + 1L);
        int n = 0;
        while ((long)n < this.summary.getNumberOfPools()) {
            int n2 = dataInputStream.readInt();
            this.loadGlossPool(dataInputStream, n2, backMapper, classLoader);
            ++n;
        }
        this.fsa.processGlosses(backMapper);
        backMapper.recalcPointers();
        Iterator<GlossPool> iterator = this.getPools();
        while (iterator.hasNext()) {
            GlossPool glossPool = iterator.next();
            if (glossPool == null) continue;
            glossPool.internGlosses();
        }
        this.fsa.endReading();
    }

    private void loadGlossPool(DataInputStream dataInputStream, int n, BackMapper backMapper, ClassLoader classLoader) throws IOException, DLTException {
        GlossPool glossPool;
        int n2;
        if (n == 1347374924) {
            n2 = dataInputStream.readByte() & 0xFF;
            if (this.getPoolByNumber(n2) != null) {
                throw new DLTException(Messages.getString("error.dict.pool"));
            }
            glossPool = this.registerPool(n2);
        } else if (n == 1347374925) {
            String string = dataInputStream.readUTF();
            n2 = dataInputStream.readInt();
            if (this.getPoolByNumber(n2) != null) {
                throw new DLTException(Messages.getString("error.dict.pool"));
            }
            glossPool = this.registerPool(string, n2, classLoader);
        } else if (n == 1347374926) {
            String string = dataInputStream.readUTF();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            dataInputStream.read(byArray);
            n2 = dataInputStream.readInt();
            if (this.getPoolByNumber(n2) != null) {
                throw new DLTException(Messages.getString("error.dict.pool"));
            }
            glossPool = this.registerPool(string, byArray, n2);
        } else {
            throw new DLTException(Messages.getString("error.dict.pool"));
        }
        if (glossPool == null) {
            throw new DLTException(Messages.getString("cannot.instantiatepool") + n2);
        }
        glossPool.read(dataInputStream, n2, backMapper);
    }

    public void save() throws DLTException, FileNotFoundException, IOException {
        this.internSave(this.dictionaryFile, false, null);
    }

    public void save(boolean bl) throws DLTException, FileNotFoundException, IOException {
        this.internSave(this.dictionaryFile, bl, null);
    }

    public void save(boolean bl, SaveInfo saveInfo) throws DLTException, FileNotFoundException, IOException {
        this.internSave(this.dictionaryFile, bl, saveInfo);
    }

    public void save(File file, boolean bl) throws DLTException, FileNotFoundException, IOException {
        this.internSave(file, bl, null);
    }

    public void save(File file) throws DLTException, FileNotFoundException, IOException {
        this.internSave(file, false, null);
    }

    public Object oovLookup(CharacterIterator characterIterator, int n) {
        return this.fsa.oovLookup(characterIterator, n);
    }

    public final boolean lookupLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverseLongest(characterIterator, matchBuffer);
    }

    public final boolean lookupLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.fsa.traverseLongest(characterIterator, matchBuffer, n, n2);
    }

    public final int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, int n, int n2) {
        return this.fsa.traverse(characterIterator, matchBuffer, n, n2);
    }

    public final boolean lookupLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverseLongestReversed(characterIterator, matchBuffer);
    }

    public final GlossCollection lookupWord(CharacterIterator characterIterator, int n) throws DLTException {
        return this.fsa.get(characterIterator, n);
    }

    public final int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverse(characterIterator, matchBuffer);
    }

    public final int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverseReversed(characterIterator, matchBuffer);
    }

    @Deprecated
    public final Entry lookupWord(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("wrong.string"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossCollection glossCollection = this.fsa.get(string);
        if (glossCollection != null) {
            return new Entry(glossCollection);
        }
        return new Entry();
    }

    @Deprecated
    public final void lookupWord(char[] cArray, int n, int n2, Entry entry) throws DLTException {
        this.lookupWordUnsafe(new String(cArray, n, n2 - n), entry);
    }

    @Deprecated
    public final void lookupWordUnsafe(String string, Entry entry) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossCollection glossCollection = this.get(string);
        entry.set(glossCollection);
    }

    public final GlossCollection get(String string) {
        return this.fsa.get(string);
    }

    public final GlossCollection get(CharacterIterator characterIterator, int n) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        return this.fsa.get(characterIterator, n);
    }

    @Deprecated
    public static void check(File file, DictionaryInfo dictionaryInfo) throws DLTException {
        try {
            Dictionary.readHeader(file, dictionaryInfo);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DLTException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readHeader(File file, DictionaryInfo dictionaryInfo) throws DLTException, FileNotFoundException, IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Dictionary.readHeader((DataInputStream)filterInputStream, dictionaryInfo);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    public static int readHeader(DataInputStream dataInputStream, DictionaryInfo dictionaryInfo) throws DLTException, IOException {
        return dictionaryInfo.readHeader(dataInputStream);
    }

    public DictionaryInfo getSummary() {
        return this.summary;
    }

    public synchronized void registerType(int n, String string) throws DLTException {
        if (n < 0 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.registergloss"));
        }
        this.verifyModifiable();
        if (this.summary == null) {
            throw new DLTException(Messages.getString("invalid.dictinfo"));
        }
        this.registerPool(n);
        this.summary.addType(string, n);
    }

    public synchronized void registerType(int n, String string, Class<? extends Gloss> clazz) throws DLTException {
        if (n < 128 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.registergloss"));
        }
        this.verifyModifiable();
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool != null && glossPool.getMainClass() != clazz) {
            throw new DLTException(Messages.getString("error.typeid"));
        }
        this.registerPool(clazz, n);
        this.summary.addType(string, n);
    }

    public synchronized void registerType(int n, String string, Class<? extends Gloss> clazz, byte[] byArray) throws DLTException {
        if (n < 128 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.registergloss"));
        }
        this.verifyModifiable();
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool != null && glossPool.getMainClass() != clazz) {
            throw new DLTException(Messages.getString("error.typeid"));
        }
        this.registerPool(clazz, byArray, n);
        this.summary.addType(string, n);
    }

    @Deprecated
    public Gloss addUserGloss(int n, byte[] byArray, int n2) throws DLTException {
        if (n < 128 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.addgloss"));
        }
        if (byArray == null) {
            throw new DLTException(Messages.getString("invalid.data"));
        }
        this.verifyModifiable();
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.notregister"));
        }
        return glossPool.checkIn(new UserDefinedDefaultGloss(n, byArray));
    }

    public Gloss addUserGloss(int n, Gloss gloss) throws DLTException {
        if (n < 1 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.addgloss"));
        }
        this.verifyModifiable();
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.notregister"));
        }
        return glossPool.checkIn(gloss);
    }

    public Gloss addGloss(int n, Gloss gloss) throws DLTException {
        return this.addUserGloss(n, gloss);
    }

    public final void addWord(String string, Gloss gloss) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("invalid.surface"));
        }
        this.verifyModifiable();
        this.fsa.add(new StringCharacterIterator(string), string.length(), gloss);
    }

    public final void addWord(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        if (characterIterator == null || n == 0) {
            throw new DLTException(Messages.getString("invalid.surface"));
        }
        this.verifyModifiable();
        this.fsa.add(characterIterator, n, gloss);
    }

    public final void addMWU(String[] stringArray, Gloss gloss) throws DLTException {
        this.addMWU(Arrays.asList(stringArray), gloss);
    }

    public final void addMWU(List<String> list, Gloss gloss) throws DLTException {
        if (list == null || list.isEmpty()) {
            throw new DLTException(Messages.getString("invalid.surface"));
        }
        this.verifyModifiable();
        this.getOrMakeMwuFsa().addSimple(list, gloss);
    }

    public final void addMWU(String[] stringArray, int n, Gloss gloss) throws DLTException {
        this.addMWU(Arrays.asList(stringArray), n, gloss);
    }

    public final void addMWU(List<String> list, int n, Gloss gloss) throws DLTException {
        if (list == null || list.isEmpty()) {
            throw new DLTException(Messages.getString("invalid.surface"));
        }
        this.verifyModifiable();
        this.getOrMakeMwuFsa().addMWU(list, n, gloss);
    }

    public final void addMWU(MWUElement[] mWUElementArray, int n, boolean bl, Gloss gloss) throws DLTException {
        this.addMWU(Arrays.asList(mWUElementArray), n, bl, gloss);
    }

    public final void addMWU(List<MWUElement> list, int n, boolean bl, Gloss gloss) throws DLTException {
        if (list == null || list.isEmpty()) {
            throw new DLTException(Messages.getString("invalid.surface"));
        }
        this.verifyModifiable();
        this.getOrMakeMwuFsa().addMWU(list, n, bl, gloss);
    }

    public final void addWord(String string, Gloss[] glossArray) throws DLTException {
        for (int i = 0; i < glossArray.length; ++i) {
            Gloss gloss = glossArray[i];
            this.addWord(string, gloss);
        }
    }

    public final void put(String string, Gloss gloss) throws DLTException {
        this.addWord(string, gloss);
    }

    public final void put(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        this.addWord(characterIterator, n, gloss);
    }

    public final Gloss addMorphGloss(Gloss[] glossArray, int n) throws DLTException {
        if (glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(1, new MidGloss(glossArray));
    }

    public final Gloss addMorphGloss(Gloss[] glossArray) throws DLTException {
        return this.addMorphGloss(glossArray, 0);
    }

    public final Gloss addLemmaGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(11, new LemmaGloss(string));
    }

    public final Gloss addLanguageGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(16, new LangNameGloss(string, n));
    }

    public final Gloss addIntegerGloss(int n) throws DLTException {
        return this.addUserGloss(18, new IntegerGloss(n));
    }

    @Deprecated
    public final Gloss addIntegerGloss(int n, int n2) throws DLTException {
        return this.addUserGloss(18, new IntegerGloss(n));
    }

    public final Gloss addLemmaGloss(String string) throws DLTException {
        return this.addLemmaGloss(string, 0);
    }

    @Deprecated
    public final Gloss addFeatureSetGloss(int n, int n2, int n3, int n4, int n5) throws DLTException {
        if ((n5 & 0xFFFFFF00) != 0 || (n & 0xFFFFFF00) != 0 || (n2 & 0xFFFFFF00) != 0 || (n3 & 0xFFFFFFFE) != 0 || (n4 & 0xFFFFFFFE) != 0) {
            throw new DLTException(Messages.getString("error.data"));
        }
        return this.addUserGloss(15, new FeatureSetGloss(n, n2, n3, n4, n5));
    }

    @Deprecated
    public final Gloss addFeatureSetGloss(int n, int n2, int n3, int n4) throws DLTException {
        return this.addFeatureSetGloss(n, n2, n3, n4, 0);
    }

    public final Gloss addFeatureSetGloss(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DLTException {
        if ((n & 0xFFFFFF00) != 0 || (n2 & 0xFFFFFF00) != 0) {
            throw new DLTException(Messages.getString("error.data"));
        }
        return this.addUserGloss(15, new FeatureSetGloss(n, n2, bl, bl2, bl3, bl4));
    }

    public Gloss addFeatureSetGloss(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DLTException {
        if ((n & 0xFFFFFF00) != 0 || (n2 & 0xFFFFFF00) != 0) {
            throw new DLTException(Messages.getString("error.data"));
        }
        return this.addUserGloss(15, new FeatureSetGloss(n, n2, bl, bl2, bl3, bl4, bl5));
    }

    @Deprecated
    public synchronized void dispose() throws DLTException {
        this.lockClose();
        this.fsa = null;
        this.summary = null;
        this.dictionaryFile = null;
        this.pools = null;
    }

    protected boolean valid() {
        return this.fsa != null && this.pools != null;
    }

    public final String[] getLanguages() throws DLTException {
        return this.getSummary().getLanguages();
    }

    public final Gloss addCatNameGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(19, new CatNameGloss(string));
    }

    public final Gloss addCutPasteGloss(String string, String string2, int n, int n2) throws DLTException {
        BasicCutPasteGloss basicCutPasteGloss;
        if (string == null || string2 == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        switch (n) {
            case 12: {
                basicCutPasteGloss = new CutPasteGloss(string, string2);
                break;
            }
            case 21: {
                basicCutPasteGloss = new StemCutPasteGloss(string, string2);
                break;
            }
            default: {
                throw new DLTException(Messages.getString("invalid.type"));
            }
        }
        return this.addUserGloss(basicCutPasteGloss.getType(), basicCutPasteGloss);
    }

    public final Gloss addGrammarGloss(int[] nArray, int n) throws DLTException {
        if (nArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(13, new GrammarGloss(nArray));
    }

    @Deprecated
    public Gloss addJAMorphGloss(int n, int n2, int n3, int n4) throws DLTException {
        if (n3 != 0 && n3 != 1) {
            throw new DLTException(Messages.getString("error.parameter"));
        }
        return this.addUserGloss(32, n2 == 0 ? new JaMorphGloss(n, JKOM.toJPOS(n), n3) : new JaMorphGloss(n, n2, n3));
    }

    public Gloss addJAMorphGloss(int n, int n2, boolean bl, boolean bl2) throws DLTException {
        return this.addUserGloss(32, n2 == 0 ? new JaMorphGloss(n, JKOM.toJPOS(n), bl, bl2) : new JaMorphGloss(n, n2, bl, bl2));
    }

    public final Gloss addJaGramSetGloss(long[] lArray) throws DLTException {
        if (lArray == null) {
            throw new DLTException(Messages.getString("invalid.data"));
        }
        return this.addUserGloss(34, new JaGramSetGloss(lArray));
    }

    public final Gloss addJkomBasedCollectionGls(int n, Gloss[] glossArray, int n2) throws DLTException {
        if (glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(4, new JkomCollectionGloss(n, glossArray, n2));
    }

    public final Gloss addPhoneticSpellingGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(23, new PhoneticSpellingGloss(string));
    }

    public final Gloss addPosBasedCollectionGls(int n, Gloss[] glossArray, int n2) throws DLTException {
        if (glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(2, new PosCollectionGloss(n, glossArray, n2));
    }

    public final Gloss addSynGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(22, new SynonymGloss(string));
    }

    public final Gloss addStemGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(20, new StemGloss(string));
    }

    public final Gloss addTCRGloss(int n, int n2, int n3, String string, int n4) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("invalid.rule"));
        }
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        return this.addUserGloss(17, new TCRGloss(n, n2, n3, string));
    }

    @Deprecated
    public final Gloss addPcodeGloss(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(14, new PcodeGloss(string));
    }

    public final Gloss addStringGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(60, new StringGloss(string, n));
    }

    public final Gloss addTypedStringGloss(StringGloss stringGloss, String string, int n) throws DLTException {
        if (string == null || stringGloss == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(66, new TypedStringGloss(stringGloss, string, n));
    }

    public final Gloss addTypedIntGloss(StringGloss stringGloss, int n, int n2) throws DLTException {
        if (stringGloss == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(67, new TypedIntGloss(stringGloss, n, n2));
    }

    public final Gloss addTypedDoubleGloss(StringGloss stringGloss, double d, int n) throws DLTException {
        if (stringGloss == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(68, new TypedDoubleGloss(stringGloss, d, n));
    }

    public final Gloss addTypedVectorGloss(StringGloss stringGloss, Gloss[] glossArray, int n) throws DLTException {
        if (stringGloss == null || glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        return this.addUserGloss(69, new TypedVectorGloss(stringGloss, glossArray, n));
    }

    public final void contract() throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        this.fsa.contract();
    }

    public void append(Dictionary dictionary) throws DLTException {
        this.append(dictionary, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Dictionary dictionary, int n) throws DLTException {
        Object object;
        if (n != 0 && n != 1) {
            throw new DLTException(Messages.getString("invalid.langopt"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        if (!this.fsa.isModifiable()) {
            throw new DLTException(Messages.getString("error.dict.not.modifiable"));
        }
        if (!dictionary.valid() || !dictionary.summary.isDeterministic()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        try {
            object = this;
            synchronized (object) {
                ++this.overrideModifiable;
            }
            object = dictionary.getSummary();
            if (n == 1) {
                this.summary.addAllTypes((DictionaryInfo)object);
            } else if (n == 0) {
                this.summary.addAllTypesIgnoreLang((DictionaryInfo)object);
            }
            if (this.fsa instanceof NetGenericDictionary) {
                NetGenericDictionary netGenericDictionary = (NetGenericDictionary)this.fsa;
                if (dictionary.fsa instanceof NetGenericDictionary) {
                    netGenericDictionary.append((NetGenericDictionary)dictionary.fsa, this.gloss_registerer);
                } else {
                    netGenericDictionary.append(dictionary.fsa.first(), this.gloss_registerer);
                }
                if (dictionary.isMWUDictionary()) {
                    this.getOrMakeMwuFsa().append(dictionary.getMwuFsa(), this.gloss_registerer);
                }
            } else {
                AppendTraverse appendTraverse = new AppendTraverse(this, this.gloss_registerer);
                appendTraverse.doTraverse(dictionary.fsa.first());
            }
        }
        finally {
            object = this;
            synchronized (object) {
                --this.overrideModifiable;
            }
        }
    }

    @Deprecated
    public final void removeEntry(String string, Entry entry) throws DLTException {
        if (entry == null) {
            throw new DLTException(Messages.getString("invalid.entry"));
        }
        Gloss gloss = entry.current;
        this.removeWord(string, gloss);
    }

    public final void removeWord(String string, Gloss gloss) throws DLTException {
        this.verifyModifiable();
        this.fsa.removeGloss(new StringCharacterIterator(string), string.length(), gloss);
    }

    public final void stampCopyright(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        if (this.summary == null) {
            throw new DLTException(Messages.getString("invalid.dictinfo"));
        }
        this.summary.setCopyrightStatement(string);
    }

    public void setVersion(int n) throws DLTException {
        this.summary.version = n;
    }

    private void setFSAOwnerDictionary() {
        this.fsa.setOwnerDictionary(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized Object[] getFunctionMasks() {
        DictionaryInfo dictionaryInfo = this.summary;
        synchronized (dictionaryInfo) {
            String[] stringArray = this.summary.getLanguages();
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Integer[] integerArray = this.summary.getFunctions(stringArray[i]);
                objectArray[i] = new int[integerArray.length];
                for (int j = 0; j < integerArray.length; ++j) {
                    Integer n = integerArray[j];
                    ((int[])objectArray[i])[j] = n;
                }
            }
            return objectArray;
        }
    }

    public synchronized int getPoolNum() {
        int n = 0;
        for (int i = 0; i < this.pools.length; ++i) {
            if (this.pools[i] == null) continue;
            ++n;
        }
        return n;
    }

    Iterator<GlossPool> getPools() {
        return Arrays.asList(this.pools).iterator();
    }

    synchronized int getPoolSizeSum() {
        int n = 0;
        Iterator<GlossPool> iterator = this.getPools();
        while (iterator.hasNext()) {
            GlossPool glossPool = iterator.next();
            if (glossPool == null) continue;
            n += glossPool.getSize();
        }
        return n;
    }

    private void writeFSAheaders(DataOutput dataOutput, int n, int n2, int n3) throws IOException {
        dataOutput.writeInt(-1161904401);
        dataOutput.writeInt(0);
        int n4 = n2;
        dataOutput.writeInt(n4);
        dataOutput.writeInt(n3);
        int n5 = n;
        dataOutput.writeInt(n5);
        dataOutput.writeInt(n4);
        int n6 = (this.fsa.isContracted() ? 2 : 0) | (this.fsa.getChainPolicy() ? 1 : 0);
        dataOutput.writeInt(n6);
    }

    private synchronized void writeGlosses(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws DLTException, IOException {
        Iterator<GlossPool> iterator = this.getPools();
        int n = 0;
        while (iterator.hasNext()) {
            GlossPool glossPool = iterator.next();
            if (glossPool != null) {
                if (n < 128) {
                    dataOutputStream.writeInt(1347374924);
                    dataOutputStream.writeByte(n);
                } else if (glossPool.getMainClassBytes() != null) {
                    dataOutputStream.writeInt(1347374926);
                    dataOutputStream.writeUTF(glossPool.getMainClass().getName());
                    byte[] byArray = glossPool.getMainClassBytes();
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                    dataOutputStream.writeInt(n);
                } else {
                    dataOutputStream.writeInt(1347374925);
                    dataOutputStream.writeUTF(glossPool.getMainClass().getName());
                    dataOutputStream.writeInt(n);
                }
                glossPool.write(dataOutputStream, glossMapper);
            }
            ++n;
        }
        glossMapper.reAssign();
    }

    private int internSave(DataOutputStream dataOutputStream, boolean bl, SaveInfo saveInfo) throws DLTException, IOException {
        int n;
        int n2 = dataOutputStream.size();
        GlossMapper glossMapper = new GlossMapper(this.pools);
        try {
            int n3;
            int n4;
            Object object;
            MultiNet multiNet = this.fsa.getMultiNet();
            if (multiNet instanceof NetGenericDictionary) {
                object = (NetGenericDictionary)multiNet;
                assert (this.glossHandler != null);
                ((NetGenericDictionary)object).ensureInitialized();
                this.summary.writeHeader(dataOutputStream, this, ((NetGenericDictionary)object).getSize());
                n4 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setHeaderSize(n4);
                }
                this.writeFSAheaders(dataOutputStream, ((NetGenericDictionary)object).getSize(), this.glossHandler.getGlossCollectionCount(), ((NetGenericDictionary)object).getSignature());
                int n5 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setFsaHeaderSize(n5 - n4);
                }
                ((NetGenericDictionary)object).writeNodes(dataOutputStream);
                n = dataOutputStream.size() - n2;
                n3 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setFsaSize(n3 - n5);
                }
                this.glossHandler.writeGlossCollections(dataOutputStream, glossMapper);
                if (this.isMWUDictionary()) {
                    dataOutputStream.writeInt(this.mwuFsa.getSignature());
                    this.mwuFsa.writeNodes(dataOutputStream);
                }
                dataOutputStream.writeInt(-84230466);
            } else if (multiNet instanceof MultiNetIntegerImpl && !bl) {
                object = (MultiNetIntegerImpl)multiNet;
                n4 = ((_NetIntegerImpl)object).getNodeCount();
                this.summary.writeHeader(dataOutputStream, this, n4);
                int n6 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setHeaderSize(n6);
                }
                this.writeFSAheaders(dataOutputStream, n4, ((MultiNetIntegerImpl)object).getGlossCollectionCount(), 1766224756);
                int n7 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setFsaHeaderSize(n7 - n6);
                }
                ((_NetIntegerImpl)object).writeNodes(dataOutputStream);
                n = dataOutputStream.size() - n2;
                n3 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setFsaSize(n3 - n7);
                }
                ((MultiNetIntegerImpl)object).writeGlossCollections(dataOutputStream, glossMapper);
            } else {
                object = new NodeHashIndex(multiNet.first());
                this.summary.writeHeader(dataOutputStream, this, ((NodeHashIndex)object).getNodeCount());
                n4 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setHeaderSize(n4);
                }
                this.writeFSAheaders(dataOutputStream, ((NodeHashIndex)object).getNodeCount(), ((NodeHashIndex)object).getGlossCollectionCount(), -1161904401);
                int n8 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setFsaHeaderSize(n8 - n4);
                }
                ((NodeHashIndex)object).write_nodes(dataOutputStream, 0);
                n = dataOutputStream.size() - n2;
                n3 = dataOutputStream.size();
                if (saveInfo != null) {
                    saveInfo.setFsaSize(n3 - n8);
                }
                ((NodeHashIndex)object).write_gloss_header(dataOutputStream, glossMapper);
            }
            int n9 = dataOutputStream.size();
            if (saveInfo != null) {
                saveInfo.setGlossCollectionSize(n9 - n3);
            }
            this.writeGlosses(dataOutputStream, glossMapper);
            n4 = dataOutputStream.size();
            if (saveInfo != null) {
                saveInfo.setGlossSize(n4 - n9);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (DLTException dLTException) {
            throw dLTException;
        }
        catch (Exception exception) {
            throw new DLTException(exception);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void internSave(File file, boolean bl, SaveInfo saveInfo) throws DLTException, FileNotFoundException, IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            ChecksumOutputStream checksumOutputStream = new ChecksumOutputStream(new BufferedOutputStream(new FileOutputStream(file), 4096));
            filterOutputStream = new DataOutputStream(checksumOutputStream);
            int n = this.internSave((DataOutputStream)filterOutputStream, bl, saveInfo);
            checksumOutputStream.updateInteger(n);
            long l = checksumOutputStream.getCheckSum();
            ((DataOutputStream)filterOutputStream).writeInt(1229081971);
            ((DataOutputStream)filterOutputStream).writeLong(l);
            ((DataOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            filterOutputStream = null;
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(26L);
                int n2 = randomAccessFile.readInt();
                randomAccessFile.seek(n2 + 4);
                randomAccessFile.writeInt(n);
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (DLTException dLTException) {
            throw dLTException;
        }
        catch (Exception exception) {
            throw new DLTException(exception.getClass().getName() + ":" + exception.getMessage());
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    private void verifyModifiable() throws DLTException {
        if (this.overrideModifiable > 0) {
            return;
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        if (!this.summary.isEditable()) {
            throw new DLTException(Messages.getString("error.dict.not.editable"));
        }
        if (!this.fsa.isModifiable()) {
            throw new DLTException(Messages.getString("error.dict.not.modifiable"));
        }
    }

    public boolean isModifiable() {
        return this.valid() && this.summary.isEditable() && this.fsa.isModifiable();
    }

    public File getFile() {
        return this.dictionaryFile;
    }

    public void setFile(File file) {
        this.dictionaryFile = file;
    }

    public String toString() {
        DictionaryInfo dictionaryInfo = this.getSummary();
        return this.dictionaryFile != null ? this.dictionaryFile.getAbsolutePath() : "(no file) " + (dictionaryInfo != null ? dictionaryInfo.toString() : "[no summary]");
    }

    public static class SaveInfo {
        private int _headerSize;
        private int _fsaHeaderSize;
        private int _fsaSize;
        private int _glossCollectionSize;
        private int _glossSize;
        private int _mwIndicesSize;

        public int getFsaHeaderSize() {
            return this._fsaHeaderSize;
        }

        void setFsaHeaderSize(int n) {
            this._fsaHeaderSize = n;
        }

        public int getFsaSize() {
            return this._fsaSize;
        }

        void setFsaSize(int n) {
            this._fsaSize = n;
        }

        public int getGlossCollectionSize() {
            return this._glossCollectionSize;
        }

        void setGlossCollectionSize(int n) {
            this._glossCollectionSize = n;
        }

        void setMwIndicesFstSize(int n) {
            this._mwIndicesSize = n;
        }

        public int getMwIndicesFstSize() {
            return this._mwIndicesSize;
        }

        public int getGlossSize() {
            return this._glossSize;
        }

        void setGlossSize(int n) {
            this._glossSize = n;
        }

        public int getHeaderSize() {
            return this._headerSize;
        }

        void setHeaderSize(int n) {
            this._headerSize = n;
        }
    }

    private class AtomicGlossRegisterer
    implements GlossProcessor {
        AtomicGlossRegisterer() {
        }

        @Override
        public Object process(Object object) throws DLTException {
            Gloss gloss = (Gloss)object;
            int n = gloss.getType();
            GlossPool glossPool = Dictionary.this.getPoolByNumber(n);
            if (glossPool == null) {
                if (n >= 128) {
                    Dictionary.this.registerType(n, null, gloss.getClass(), null);
                } else {
                    Dictionary.this.registerType(n, null);
                }
            }
            return Dictionary.this.addGloss(n, gloss);
        }

        @Override
        public void reset() {
        }
    }

    public static class MWUElement {
        public List<String> surfaceForms;
        public String lemma;
        public boolean optional;

        public MWUElement(String[] stringArray, String string, boolean bl) {
            this(Arrays.asList(stringArray), string, bl);
        }

        public MWUElement(List<String> list, String string, boolean bl) {
            this.surfaceForms = list;
            this.lemma = string != null && string.equals("") ? null : string;
            this.optional = bl;
        }

        public MWUElement(String[] stringArray) {
            this(Arrays.asList(stringArray));
        }

        public MWUElement(List<String> list) {
            this(list, null, false);
        }

        public String toString() {
            String string = this.lemma != null && this.lemma.length() <= 0 ? this.lemma : (this.surfaceForms.size() > 0 ? this.surfaceForms.get(0) : "***empty***");
            if (this.optional) {
                string = string + '?';
            }
            return string;
        }
    }

    private class CountTraverse
    extends Traverse {
        private long count;

        CountTraverse() {
        }

        @Override
        public void process(Node node) {
            ++this.count;
        }

        public long count() throws DLTException {
            this.count = 0L;
            this.doTraverse(Dictionary.this.fsa.first());
            return this.count;
        }
    }
}

