/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import com.ibm.dltj.PatternNameFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class DictionaryInfo
implements Cloneable {
    private String copyrightStatement = "";
    private String buildHistory = "";
    private int numberOfStates;
    private int headerLength;
    long version;
    private int last_modified;
    private int numberOfPools;
    private int numberOfGlosses;
    private boolean isEditable = true;
    public static final boolean VIEWABLE_DEFAULT = false;
    private boolean isViewable = false;
    boolean isMinimizable = true;
    boolean isMinimized = false;
    private boolean isDeterministic = true;
    boolean isReversed = false;
    public static final boolean PROPER_CASE_DEFAULT = false;
    private boolean isProperCase = false;
    public static final boolean LOWER_CASE_DEFAULT = false;
    private boolean isLowerCase = false;
    private String description;
    private TreeMap<String, ArrayList<Integer>> langToTypesMap = new TreeMap();
    private int releaseCompatibility = 7000;
    private boolean isCyclic = false;
    private int affectsTokenization = 0;
    public static final int AFFECTS_TOKENIZATION = 0;
    public static final int NOT_AFFECT_TOKENIZATION = -1;
    private static final int DLT_REL_COMPAT_UNKNOWN = -1;
    public static final int DLT_REL_COMPAT_V53 = 5300;
    public static final int DLT_REL_COMPAT_V60 = 6000;
    public static final int DLT_REL_COMPAT_V61 = 6100;
    public static final int DLT_REL_COMPAT_V70 = 7000;
    public static final int DLT_REL_COMPAT_V7113 = 7113;
    public static final int RELEASE_COMPAT_DEFAULT = 7000;
    private static final int DLT_DICTIONARY_SIGNATURE = 1229081924;
    private static final int DLT_DICTIONARY_HDR_EXT = 1229081957;
    private static final byte HDR_EXT_PROPER_CASE = 1;
    private static final byte HDR_EXT_LOWER_CASE = 2;
    private static final byte HDR_EXT_DESC = 3;
    private static final byte HDR_EXT_VIEWABLE = 4;
    private static final byte HDR_EXT_REL_COMPAT = 5;
    private static final byte HDR_EXT_CYCLIC = 6;
    private static final byte HDR_EXT_AFFECTS_TOKENIZATION = 7;
    private static final byte HDR_EXT_BUILD_HISTORY = 8;
    private static final int CONTENT_TYPE = 1718837599;
    private static final String UTF_8 = "UTF-8";
    public static final String LATIN1 = "Latin1";
    private static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Locale[] EMPTY_LOCALE_ARRAY = new Locale[0];

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public DictionaryInfo() {
        this(0x8000400L, true, true, false, true, false, "", false, false, false, 7000);
    }

    public DictionaryInfo(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        this(l, bl, bl2, bl3, bl4, bl5, string, false, false, false, 7000);
    }

    @Deprecated
    public DictionaryInfo(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, boolean bl6, boolean bl7, boolean bl8) {
        this(l, bl, bl2, bl3, bl4, bl5, string, bl6, bl7, bl8, Math.max(7000, bl6 || bl7 || bl8 ? 6000 : 0));
    }

    public DictionaryInfo(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, boolean bl6, boolean bl7, boolean bl8, int n) throws IllegalArgumentException {
        if (string != null) {
            this.copyrightStatement = string;
        }
        this.version = l;
        this.isEditable = bl;
        this.isMinimizable = bl2;
        this.isMinimized = bl3;
        this.isDeterministic = bl4;
        this.isReversed = bl5;
        this.isProperCase = bl6;
        this.isLowerCase = bl7;
        this.isViewable = bl8;
        this.releaseCompatibility = n;
        if (n == 5300 && (bl6 || bl7 || bl8)) {
            throw new IllegalArgumentException(Messages.getString("error.relcompat.flag"));
        }
    }

    public void clear() {
        this.langToTypesMap.clear();
    }

    public String[] getLanguages() {
        Set<String> set = this.langToTypesMap.keySet();
        if (set == null || set.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return set.toArray(new String[set.size()]);
    }

    public Set<String> getLanguagesSet() {
        return this.langToTypesMap.keySet();
    }

    public Locale[] getLocales() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        for (String string : this.getLanguages()) {
            hashSet.add(PatternNameFilter.parseLocale(string));
        }
        if (hashSet.isEmpty()) {
            return EMPTY_LOCALE_ARRAY;
        }
        return hashSet.toArray(new Locale[hashSet.size()]);
    }

    public Integer[] getFunctions(String string) {
        ArrayList<Integer> arrayList = this.langToTypesMap.get(string);
        if (arrayList == null || arrayList.isEmpty()) {
            return EMPTY_INTEGER_ARRAY;
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public boolean hasFunction(int n) {
        Integer n2 = n;
        for (ArrayList<Integer> arrayList : this.langToTypesMap.values()) {
            if (!arrayList.contains(n2)) continue;
            return true;
        }
        return false;
    }

    public String getCopyrightStatement() {
        return this.copyrightStatement;
    }

    public String getBuildHistory() {
        return this.buildHistory;
    }

    public void setCopyrightStatement(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        if (this.copyrightStatement.length() > 0) {
            throw new DLTException(Messages.getString("message.copyright"));
        }
        this.copyrightStatement = string;
    }

    private boolean appendBuildHistory(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (string2 == null) {
            return bl;
        }
        if (!bl) {
            int n;
            bl = true;
            int n2 = this.buildHistory.lastIndexOf(string + '=');
            if (n2 >= 0 && n2 < this.buildHistory.length() && (n = this.buildHistory.indexOf(10, n2)) >= 0 && string2.equals(this.buildHistory.substring(n2 + 1 + string.length(), n))) {
                bl = false;
            }
        }
        if (bl) {
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        return bl;
    }

    public void addBuildHistoryStep(String string, Collection<Map.Entry<String, String>> collection) throws DLTException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(this.buildHistory);
        boolean bl = this.appendBuildHistory(stringBuilder, "LanguageWare", DLT.getStrVersion(), false);
        Package package_ = DLT.class.getPackage();
        bl = this.appendBuildHistory(stringBuilder, "DLTBuildVersion", package_ == null ? "unknown" : package_.getSpecificationVersion() + '-' + package_.getImplementationVersion(), bl);
        if (string != null) {
            bl = this.appendBuildHistory(stringBuilder, "Builder", string, bl);
        }
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                bl = this.appendBuildHistory(stringBuilder, (String)entry.getKey(), (String)entry.getValue(), bl);
            }
        }
        if (bl = this.appendBuildHistory(stringBuilder, "Timestamp", (String)(object = new Date().toString()), bl)) {
            this.buildHistory = stringBuilder.toString();
        }
    }

    public void addBuildHistoryStep(String string, String string2) throws DLTException {
        if (string2 != null) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("CommandLine", string2);
            this.addBuildHistoryStep(string, treeMap.entrySet());
        } else {
            this.addBuildHistoryStep(string);
        }
    }

    public void addBuildHistoryStep(String string) throws DLTException {
        this.addBuildHistoryStep(string, (Collection<Map.Entry<String, String>>)null);
    }

    public long getHeaderLength() {
        return this.headerLength;
    }

    public boolean isBigEndian() {
        return true;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setNotEditable() {
        this.isEditable = false;
    }

    public void setNotViewable() {
        this.isViewable = false;
    }

    public boolean isMinimizable() {
        return this.isMinimizable;
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public TreeMap<String, ArrayList<Integer>> getLangToTypesMap() {
        return this.langToTypesMap;
    }

    public int getLast_modified() {
        return this.last_modified;
    }

    @Deprecated
    public long getNumberOfLanguages() {
        return 0L;
    }

    @Deprecated
    public long getNumberOfLinks() {
        return this.numberOfGlosses;
    }

    public long getNumberOfGlosses() {
        return this.numberOfGlosses;
    }

    public long getNumberOfPools() {
        return this.numberOfPools;
    }

    public long getNumberOfStates() {
        return this.numberOfStates;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public String getVersionStr() {
        return DLT.buildVersionString((int)this.version);
    }

    public int getReleaseCompatibility() {
        return this.releaseCompatibility;
    }

    public void setReleaseCompatibility(int n) {
        if (n == 5300 && (this.isProperCase || this.isLowerCase || this.isViewable)) {
            throw new IllegalArgumentException(Messages.getString("error.relcompat.flag"));
        }
        if (this.getGlossesCompatibilityLevel() > n) {
            throw new IllegalArgumentException(Messages.getString("error.relcompat.flag"));
        }
        this.releaseCompatibility = n;
    }

    public int getAffectsTokenization() {
        return this.affectsTokenization;
    }

    public void setAffectsTokenization(int n) {
        this.affectsTokenization = n;
    }

    public boolean isProperCase() {
        return this.isProperCase;
    }

    public boolean isLowerCase() {
        return this.isLowerCase;
    }

    public boolean isViewable() {
        return this.isViewable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws DLTException {
        this.description = string;
        if (this.releaseCompatibility == 5300 && this.description != null && this.description.length() > 0) {
            throw new DLTException(Messages.getString("error.relcompat.desc"));
        }
    }

    public void addType(String string, int n) throws DLTException {
        Integer n2;
        int n3;
        if (string == null) {
            return;
        }
        if (DictionaryInfo.getGlossCompatibilityLevel(n) > this.releaseCompatibility) {
            throw new DLTException(Messages.getString("error.relcompat.gloss"));
        }
        ArrayList<Integer> arrayList = this.langToTypesMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.langToTypesMap.put(string, arrayList);
        }
        if ((n3 = Collections.binarySearch(arrayList, n2 = Integer.valueOf(n))) < 0) {
            arrayList.add(-n3 - 1, n2);
        }
    }

    void appendType(String string, int n) {
        ArrayList<Integer> arrayList = this.langToTypesMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.langToTypesMap.put(string, arrayList);
        }
        arrayList.add(n);
    }

    void addAllTypes(DictionaryInfo dictionaryInfo) throws DLTException {
        if (dictionaryInfo == null) {
            throw new DLTException(Messages.getString("invalid.dictinfo"));
        }
        this.mergeCopyright(dictionaryInfo);
        this.mergeFlags(dictionaryInfo);
        String[] stringArray = dictionaryInfo.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Integer[] integerArray = dictionaryInfo.getFunctions(string);
            for (int j = 0; j < integerArray.length; ++j) {
                int n = integerArray[j];
                this.addType(string, n);
            }
        }
    }

    void addAllTypesIgnoreLang(DictionaryInfo dictionaryInfo) throws DLTException {
        if (dictionaryInfo == null) {
            throw new DLTException(Messages.getString("invalid.dictinfo"));
        }
        this.mergeCopyright(dictionaryInfo);
        this.mergeFlags(dictionaryInfo);
        String[] stringArray = this.getLanguages();
        if (stringArray.length == 0) {
            throw new DLTException(Messages.getString("no.lang"));
        }
        String[] stringArray2 = dictionaryInfo.getLanguages();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            Integer[] integerArray = dictionaryInfo.getFunctions(string);
            for (int j = 0; j < integerArray.length; ++j) {
                int n = integerArray[j];
                for (int k = 0; k < stringArray.length; ++k) {
                    this.addType(stringArray[k], n);
                }
            }
        }
    }

    private void mergeCopyright(DictionaryInfo dictionaryInfo) throws DLTException {
        this.mergeCopyright(dictionaryInfo.getCopyrightStatement());
    }

    public void mergeCopyright(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        if (this.copyrightStatement == null || this.copyrightStatement.length() == 0) {
            this.copyrightStatement = string;
        } else {
            if (this.copyrightStatement.equals(string)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(this.copyrightStatement.length() + 1 + string.length());
            stringBuilder.append(this.copyrightStatement);
            stringBuilder.append(' ');
            stringBuilder.append(string);
            this.copyrightStatement = stringBuilder.toString();
        }
    }

    private static String indent(String string) {
        return Pattern.compile("([^\n]*)\n").matcher(string).replaceAll(" $1\n");
    }

    private void mergeFlags(DictionaryInfo dictionaryInfo) {
        block9: {
            if (!dictionaryInfo.isEditable()) {
                this.setNotEditable();
            }
            if (!dictionaryInfo.isViewable()) {
                this.setNotViewable();
            }
            if (dictionaryInfo.isCyclic()) {
                this.setCyclic(true);
            }
            if (this.buildHistory.length() == 0) {
                this.buildHistory = dictionaryInfo.buildHistory;
            } else if (this.buildHistory.endsWith("Merge=end\n")) {
                this.buildHistory = this.buildHistory.substring(0, this.buildHistory.length() - "Merge=end\n".length()) + "Merge=source\n" + DictionaryInfo.indent(dictionaryInfo.buildHistory) + "Merge=end\n";
            } else {
                try {
                    this.buildHistory = "MergeVersion=" + DLT.getStrVersion() + '\n' + "Merge=source\n" + DictionaryInfo.indent(this.buildHistory) + "Merge=source\n" + DictionaryInfo.indent(dictionaryInfo.buildHistory) + "Merge=end\n";
                }
                catch (DLTException dLTException) {
                    dLTException.printStackTrace();
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
        }
    }

    private static int calcStringChecksum(int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = DictionaryInfo.DLTDICT_HASHFUN(string.charAt(i), n);
        }
        return n;
    }

    int getCheckSum() {
        int n = 0;
        n = DictionaryInfo.DLTDICT_HASHFUN(this.version, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.last_modified, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isEditable, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isMinimizable, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isMinimized, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isDeterministic, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.numberOfStates, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.headerLength, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.numberOfGlosses, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.numberOfPools, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(1718837599, n);
        for (Map.Entry<String, ArrayList<Integer>> entry : this.langToTypesMap.entrySet()) {
            String string = entry.getKey();
            ArrayList<Integer> arrayList = entry.getValue();
            for (Integer n2 : arrayList) {
                n = DictionaryInfo.DLTDICT_HASHFUN(n2, n);
            }
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                n = DictionaryInfo.DLTDICT_HASHFUN(string.charAt(i), n);
            }
        }
        n = DictionaryInfo.calcStringChecksum(n, this.copyrightStatement);
        return n;
    }

    long writeHeader(DataOutput dataOutput, Dictionary dictionary, int n) throws IOException {
        long l = -1L;
        this.numberOfStates = n;
        this.last_modified = (int)(System.currentTimeMillis() / 1000L);
        this.numberOfGlosses = dictionary.getPoolSizeSum();
        int n2 = this.calcHdrExtensionSize();
        this.headerLength = 43 + n2 + this.calcHeaderSize();
        l = this.headerLength;
        this.numberOfPools = dictionary.getPoolNum();
        this.isMinimizable = !dictionary.fsa.getChainPolicy();
        this.isMinimized = dictionary.fsa.isContracted();
        int n3 = this.getCheckSum();
        dataOutput.writeInt(n3);
        dataOutput.writeInt(1229081924);
        dataOutput.writeShort(0);
        dataOutput.writeInt(1718837599);
        dataOutput.writeInt((int)this.version);
        dataOutput.writeInt(this.last_modified);
        dataOutput.writeInt(this.numberOfStates);
        dataOutput.writeInt(this.headerLength);
        dataOutput.writeInt(this.numberOfGlosses);
        dataOutput.writeByte((byte)this.numberOfPools);
        dataOutput.writeByte(this.isEditable ? 1 : 0);
        dataOutput.writeByte(this.isMinimizable ? 1 : 0);
        dataOutput.writeByte(this.isMinimized ? 1 : 0);
        int n4 = (this.isDeterministic ? 1 : 0) + (this.isReversed ? 2 : 0);
        dataOutput.writeByte(n4);
        if (n2 > 0) {
            this.writeHdrExtension(dataOutput);
        }
        dataOutput.writeInt(1229081924);
        this.writeLanguages(dataOutput);
        if (this.copyrightStatement != null && this.copyrightStatement.length() > 0) {
            byte[] byArray = this.copyrightStatement.getBytes(LATIN1);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
        }
        return l;
    }

    private void writeLanguages(DataOutput dataOutput) throws IOException {
        String[] stringArray;
        int n = this.getLangToTypesMap().size();
        dataOutput.writeInt(n);
        for (String string : stringArray = this.getLanguages()) {
            byte[] byArray = string.getBytes(LATIN1);
            dataOutput.writeShort((short)byArray.length);
            dataOutput.write(byArray);
            Integer[] integerArray = this.getFunctions(string);
            int n2 = integerArray.length;
            dataOutput.writeShort((short)n2);
            for (int i = 0; i < n2; ++i) {
                dataOutput.writeByte(integerArray[i].byteValue());
            }
        }
    }

    private void writeHdrExtension(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(1229081957);
        if (this.isProperCase) {
            this.writeHdrExtensionBoolean(dataOutput, 1, this.isProperCase);
        }
        if (this.isLowerCase) {
            this.writeHdrExtensionBoolean(dataOutput, 2, this.isLowerCase);
        }
        this.writeHdrExtensionString(dataOutput, (byte)3, this.description);
        if (this.isViewable) {
            this.writeHdrExtensionBoolean(dataOutput, 4, this.isViewable);
        }
        if (this.isCyclic == this.isDeterministic) {
            this.writeHdrExtensionBoolean(dataOutput, 6, this.isCyclic);
        }
        if (this.affectsTokenization != 0) {
            this.writeHdrExtensionInteger(dataOutput, 7, this.affectsTokenization);
        }
        this.writeHdrExtensionInteger(dataOutput, 5, this.releaseCompatibility);
        this.writeHdrExtensionString(dataOutput, (byte)8, this.buildHistory);
        dataOutput.writeShort(-1);
    }

    private void writeHdrExtensionBoolean(DataOutput dataOutput, int n, boolean bl) throws IOException {
        dataOutput.writeShort(1);
        dataOutput.writeByte(n);
        dataOutput.writeByte(bl ? 1 : 0);
    }

    private void writeHdrExtensionString(DataOutput dataOutput, byte by, String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        byte[] byArray = string.getBytes(UTF_8);
        dataOutput.writeShort(byArray.length);
        dataOutput.writeByte(by);
        dataOutput.write(byArray);
    }

    private int calcHdrExtensionStringSize(String string) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return 0;
        }
        byte[] byArray = string.getBytes(UTF_8);
        return 3 + byArray.length;
    }

    private void writeHdrExtensionInteger(DataOutput dataOutput, int n, int n2) throws IOException {
        dataOutput.writeShort(4);
        dataOutput.writeByte(n);
        dataOutput.writeInt(n2);
    }

    private int calcHeaderSize() {
        String[] stringArray;
        int n = 4;
        for (String string : stringArray = this.getLanguages()) {
            n += 2;
            n += string.length();
            n += 2 + this.getLangToTypesMap().get(string).size();
        }
        return n += this.getCopyrightSize();
    }

    private int calcHdrExtensionSize() throws UnsupportedEncodingException {
        if (this.releaseCompatibility < 6000) {
            return 0;
        }
        int n = 4;
        if (this.isProperCase) {
            n += 4;
        }
        if (this.isLowerCase) {
            n += 4;
        }
        n += this.calcHdrExtensionStringSize(this.description);
        if (this.isViewable) {
            n += 4;
        }
        if (this.isCyclic == this.isDeterministic) {
            n += 4;
        }
        n += 7;
        if (this.affectsTokenization != 0) {
            n += 7;
        }
        n += this.calcHdrExtensionStringSize(this.buildHistory);
        return n += 2;
    }

    int readHeader(DataInput dataInput) throws IOException, DLTException {
        int n = 0;
        int n2 = dataInput.readInt();
        n += 4;
        int n3 = dataInput.readInt();
        n += 4;
        if (n3 != 1229081924) {
            throw new DLTException(Messages.getString("wrong.dictformat"));
        }
        this.releaseCompatibility = -1;
        dataInput.readShort();
        n += 2;
        dataInput.readInt();
        n += 4;
        this.version = dataInput.readInt();
        n += 4;
        this.last_modified = dataInput.readInt();
        n += 4;
        this.numberOfStates = dataInput.readInt();
        n += 4;
        this.headerLength = dataInput.readInt();
        n += 4;
        this.numberOfGlosses = dataInput.readInt();
        n += 4;
        this.numberOfPools = dataInput.readUnsignedByte();
        ++n;
        this.isEditable = dataInput.readByte() != 0;
        ++n;
        this.isMinimizable = dataInput.readByte() != 0;
        ++n;
        this.isMinimized = dataInput.readByte() != 0;
        ++n;
        byte by = dataInput.readByte();
        ++n;
        this.isDeterministic = (by & 1) != 0;
        boolean bl = this.isReversed = (by & 2) != 0;
        if (!this.isDeterministic) {
            this.isCyclic = true;
        }
        int n4 = dataInput.readInt();
        n += 4;
        boolean bl2 = false;
        if (n4 == 1229081957) {
            bl2 = true;
            n += this.readHdrExtension(dataInput);
            n4 = dataInput.readInt();
            n += 4;
        }
        if (n4 != 1229081924) {
            throw new DLTException(Messages.getString("wrong.dictformat"));
        }
        if (this.headerLength > (n += this.readLanguages(dataInput))) {
            int n5 = dataInput.readInt();
            n += 4;
            if (n5 < 0 || n5 > 10000) {
                throw new DLTException(Messages.getString("error.dict.format"));
            }
            byte[] byArray = new byte[n5];
            dataInput.readFully(byArray);
            n += n5;
            this.copyrightStatement = new String(byArray, LATIN1);
        }
        this.determineCompatibility(bl2);
        return n2;
    }

    private void determineCompatibility(boolean bl) {
        if (this.releaseCompatibility != -1) {
            return;
        }
        this.releaseCompatibility = this.getGlossesCompatibilityLevel();
        if (bl && this.releaseCompatibility < 6000) {
            this.releaseCompatibility = 6000;
        }
    }

    private int getGlossesCompatibilityLevel() {
        int n = 5300;
        for (ArrayList<Integer> arrayList : this.langToTypesMap.values()) {
            for (Integer n2 : arrayList) {
                int n3 = DictionaryInfo.getGlossCompatibilityLevel(n2);
                if (n3 <= n) continue;
                n = n3;
            }
        }
        return n;
    }

    public static int getGlossCompatibilityLevel(int n) {
        switch (n) {
            case 57: 
            case 58: 
            case 59: {
                return 7000;
            }
            case 35: 
            case 36: 
            case 37: 
            case 84: {
                return 6100;
            }
            case 27: 
            case 28: 
            case 83: {
                return 6000;
            }
        }
        return 5300;
    }

    private int readLanguages(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            short s = dataInput.readShort();
            n2 += 2;
            byte[] byArray = new byte[s];
            dataInput.readFully(byArray);
            n2 += s;
            String string = new String(byArray, LATIN1);
            int n3 = dataInput.readShort();
            n2 += 2;
            ArrayList<Integer> arrayList = this.langToTypesMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList(n3);
                this.langToTypesMap.put(string, arrayList);
            }
            for (int j = 0; j < n3; ++j) {
                int n4 = dataInput.readUnsignedByte();
                ++n2;
                arrayList.add(n4);
            }
        }
        return n2;
    }

    private int readHdrExtension(DataInput dataInput) throws IOException {
        int n = 0;
        while (true) {
            short s = dataInput.readShort();
            n += 2;
            if (s < 0) break;
            byte by = dataInput.readByte();
            byte[] byArray = new byte[s];
            dataInput.readFully(byArray);
            n += 1 + s;
            switch (by) {
                case 1: {
                    this.isProperCase = byArray[0] == 1;
                    break;
                }
                case 2: {
                    this.isLowerCase = byArray[0] == 1;
                    break;
                }
                case 3: {
                    this.description = new String(byArray, UTF_8);
                    break;
                }
                case 4: {
                    this.isViewable = byArray[0] == 1;
                    break;
                }
                case 5: {
                    this.releaseCompatibility = (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + ((byArray[3] & 0xFF) << 0);
                    break;
                }
                case 6: {
                    this.isCyclic = byArray[0] == 1;
                    break;
                }
                case 7: {
                    this.affectsTokenization = (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + ((byArray[3] & 0xFF) << 0);
                    break;
                }
                case 8: {
                    this.buildHistory = new String(byArray, UTF_8);
                    break;
                }
            }
        }
        return n;
    }

    void completeLoad() {
        for (Map.Entry<String, ArrayList<Integer>> entry : this.langToTypesMap.entrySet()) {
            ArrayList<Integer> arrayList = entry.getValue();
            Collections.sort(arrayList);
        }
    }

    static final int DLTDICT_HASHFUN(long l, int n) {
        return DictionaryInfo.DLTDICT_HASHFUN((int)l, n);
    }

    static final int DLTDICT_HASHFUN(boolean bl, int n) {
        return DictionaryInfo.DLTDICT_HASHFUN(bl ? 1 : 0, n);
    }

    static final int DLTDICT_HASHFUN(int n, int n2) {
        n2 = 31 * n2 + n + n2;
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        DictionaryInfo dictionaryInfo = (DictionaryInfo)super.clone();
        dictionaryInfo.version = this.version;
        dictionaryInfo.copyrightStatement = this.copyrightStatement;
        dictionaryInfo.headerLength = this.headerLength;
        dictionaryInfo.isDeterministic = this.isDeterministic;
        dictionaryInfo.isEditable = this.isEditable;
        dictionaryInfo.isMinimizable = this.isMinimizable;
        dictionaryInfo.isMinimized = this.isMinimized;
        dictionaryInfo.isReversed = this.isReversed;
        dictionaryInfo.isProperCase = this.isProperCase;
        dictionaryInfo.isLowerCase = this.isLowerCase;
        dictionaryInfo.isViewable = this.isViewable;
        dictionaryInfo.last_modified = this.last_modified;
        dictionaryInfo.langToTypesMap = (TreeMap)this.langToTypesMap.clone();
        dictionaryInfo.numberOfGlosses = this.numberOfGlosses;
        dictionaryInfo.numberOfPools = this.numberOfPools;
        dictionaryInfo.numberOfStates = this.numberOfStates;
        dictionaryInfo.description = this.description;
        dictionaryInfo.releaseCompatibility = this.releaseCompatibility;
        dictionaryInfo.affectsTokenization = this.affectsTokenization;
        return dictionaryInfo;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.affectsTokenization;
        n = 31 * n + (this.buildHistory == null ? 0 : this.buildHistory.hashCode());
        n = 31 * n + (this.copyrightStatement == null ? 0 : this.copyrightStatement.hashCode());
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + this.headerLength;
        n = 31 * n + (this.isCyclic ? 1231 : 1237);
        n = 31 * n + (this.isDeterministic ? 1231 : 1237);
        n = 31 * n + (this.isEditable ? 1231 : 1237);
        n = 31 * n + (this.isLowerCase ? 1231 : 1237);
        n = 31 * n + (this.isMinimizable ? 1231 : 1237);
        n = 31 * n + (this.isMinimized ? 1231 : 1237);
        n = 31 * n + (this.isProperCase ? 1231 : 1237);
        n = 31 * n + (this.isReversed ? 1231 : 1237);
        n = 31 * n + (this.isViewable ? 1231 : 1237);
        n = 31 * n + (this.langToTypesMap == null ? 0 : this.langToTypesMap.hashCode());
        n = 31 * n + this.last_modified;
        n = 31 * n + this.numberOfGlosses;
        n = 31 * n + this.numberOfPools;
        n = 31 * n + this.numberOfStates;
        n = 31 * n + this.releaseCompatibility;
        n = 31 * n + (int)(this.version ^ this.version >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DictionaryInfo dictionaryInfo = (DictionaryInfo)object;
        if (this.affectsTokenization != dictionaryInfo.affectsTokenization) {
            return false;
        }
        if (this.buildHistory == null ? dictionaryInfo.buildHistory != null : !this.buildHistory.equals(dictionaryInfo.buildHistory)) {
            return false;
        }
        if (this.copyrightStatement == null ? dictionaryInfo.copyrightStatement != null : !this.copyrightStatement.equals(dictionaryInfo.copyrightStatement)) {
            return false;
        }
        if (this.description == null ? dictionaryInfo.description != null : !this.description.equals(dictionaryInfo.description)) {
            return false;
        }
        if (this.headerLength != dictionaryInfo.headerLength) {
            return false;
        }
        if (this.isCyclic != dictionaryInfo.isCyclic) {
            return false;
        }
        if (this.isDeterministic != dictionaryInfo.isDeterministic) {
            return false;
        }
        if (this.isEditable != dictionaryInfo.isEditable) {
            return false;
        }
        if (this.isLowerCase != dictionaryInfo.isLowerCase) {
            return false;
        }
        if (this.isMinimizable != dictionaryInfo.isMinimizable) {
            return false;
        }
        if (this.isMinimized != dictionaryInfo.isMinimized) {
            return false;
        }
        if (this.isProperCase != dictionaryInfo.isProperCase) {
            return false;
        }
        if (this.isReversed != dictionaryInfo.isReversed) {
            return false;
        }
        if (this.isViewable != dictionaryInfo.isViewable) {
            return false;
        }
        if (this.langToTypesMap == null ? dictionaryInfo.langToTypesMap != null : !this.langToTypesMap.equals(dictionaryInfo.langToTypesMap)) {
            return false;
        }
        if (this.last_modified != dictionaryInfo.last_modified) {
            return false;
        }
        if (this.numberOfGlosses != dictionaryInfo.numberOfGlosses) {
            return false;
        }
        if (this.numberOfPools != dictionaryInfo.numberOfPools) {
            return false;
        }
        if (this.numberOfStates != dictionaryInfo.numberOfStates) {
            return false;
        }
        if (this.releaseCompatibility != dictionaryInfo.releaseCompatibility) {
            return false;
        }
        return this.version == dictionaryInfo.version;
    }

    int getCopyrightSize() {
        int n = this.copyrightStatement.length();
        if (n > 0) {
            return 4 + n;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("v.").append(DLT.buildVersionString((int)this.getVersion()));
        stringBuilder.append(" {");
        Iterator<Map.Entry<String, ArrayList<Integer>>> iterator = this.langToTypesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append('[');
            Map.Entry<String, ArrayList<Integer>> entry = iterator.next();
            String string = entry.getKey();
            stringBuilder.append('\"').append(string).append("\" ");
            ArrayList<Integer> arrayList = entry.getValue();
            Iterator<Integer> iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Integer n = iterator2.next();
                stringBuilder.append(n);
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(']');
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean bl) {
        this.isCyclic = bl;
    }
}

