/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.fst.NodeHashIndex;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.MorphRuleGloss;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class GlossCollection
extends ArrayList<Gloss> {
    private static final long serialVersionUID = 1L;
    Dictionary ownerDictionary = null;
    GlossListElement gle_representation = null;
    GlossCollection[] filtered;
    int filter_mask_method;
    int isGeneric = -1;

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public GlossCollection() {
    }

    public GlossCollection(GlossCollection glossCollection) {
        super(glossCollection != null ? glossCollection : Collections.EMPTY_LIST);
        this.ownerDictionary = glossCollection != null ? glossCollection.ownerDictionary : null;
    }

    public GlossCollection(Gloss gloss) {
        this(gloss, null);
    }

    public GlossCollection(Gloss gloss, Dictionary dictionary) {
        this.ownerDictionary = dictionary;
        this.add(gloss);
    }

    public GlossCollection(GlossCollection glossCollection, Dictionary dictionary) {
        super(glossCollection);
        this.ownerDictionary = dictionary;
    }

    public GlossCollection(Collection<Gloss> collection, Dictionary dictionary) {
        super(collection);
        this.ownerDictionary = dictionary;
    }

    public GlossCollection(GlossListElement glossListElement) {
        while (glossListElement != null) {
            this.add(glossListElement.gloss);
            glossListElement = glossListElement.next;
        }
    }

    public void setOwnerDictionary(Dictionary dictionary) {
        if (dictionary != this.ownerDictionary) {
            this.ownerDictionary = dictionary;
            this.markModification();
        }
    }

    public Dictionary getOwnerDictionary() {
        return this.ownerDictionary;
    }

    @Override
    public boolean add(Gloss gloss) {
        this.markModification();
        if (this.contains(gloss)) {
            return false;
        }
        return super.add(gloss);
    }

    @Deprecated
    public boolean add(Gloss gloss, Dictionary dictionary) {
        if (this.ownerDictionary == null) {
            this.ownerDictionary = dictionary;
        }
        return this.add(gloss);
    }

    @Deprecated
    private boolean addCheckOwner(Gloss gloss, Dictionary dictionary) {
        return this.add(gloss);
    }

    @Deprecated
    public boolean addAll(GlossListElement glossListElement) {
        if (glossListElement == null) {
            return false;
        }
        boolean bl = false;
        GlossListElement glossListElement2 = glossListElement;
        while (glossListElement2 != null) {
            bl |= this.addCheckOwner(glossListElement2.gloss, glossListElement2.getOwnerDictionary());
            glossListElement2 = glossListElement2.next;
        }
        if (bl) {
            this.markModification();
        }
        return bl;
    }

    @Deprecated
    public boolean addAll(GlossListElement glossListElement, Dictionary dictionary) {
        if (glossListElement == null) {
            return false;
        }
        boolean bl = false;
        GlossListElement glossListElement2 = glossListElement;
        while (glossListElement2 != null) {
            bl |= this.addCheckOwner(glossListElement2.gloss, dictionary);
            glossListElement2 = glossListElement2.next;
        }
        if (bl) {
            this.markModification();
        }
        return bl;
    }

    @Deprecated
    public boolean addAll(GlossCollection glossCollection, Dictionary dictionary) {
        if (this.ownerDictionary == null) {
            this.ownerDictionary = dictionary;
        }
        return this.addAll(glossCollection);
    }

    @Override
    public void clear() {
        super.clear();
        this.ownerDictionary = null;
        this.markModification();
    }

    public Gloss first() {
        return this.isEmpty() ? null : (Gloss)this.get(0);
    }

    @Override
    @Deprecated
    public GlossListElement getFirst() {
        if (this.gle_representation == null) {
            GlossListElement glossListElement = null;
            for (int i = this.size() - 1; i >= 0; --i) {
                glossListElement = new GlossListElement((Gloss)this.get(i), glossListElement, this.ownerDictionary);
            }
            this.gle_representation = glossListElement;
        }
        return this.gle_representation;
    }

    public Gloss getGloss(Class<?> clazz) {
        for (Gloss gloss : this) {
            if (gloss.getClass() != clazz) continue;
            return gloss;
        }
        return null;
    }

    @Override
    public void sort(Comparator<? super Gloss> comparator) {
        Collections.sort(this, comparator);
    }

    @Override
    public int hashCode() {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n += ((Gloss)this.get(i)).hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GlossCollection)) {
            return false;
        }
        GlossCollection glossCollection = (GlossCollection)object;
        int n = this.size();
        if (glossCollection.size() != n) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Gloss gloss;
            Gloss gloss2 = (Gloss)this.get(i);
            if (gloss2 == (gloss = (Gloss)glossCollection.get(i)) || gloss2.equals(gloss)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        if (n > 1) {
            if (!glossCollection.containsAll(this)) {
                return false;
            }
            return this.containsAll(glossCollection);
        }
        return false;
    }

    public int writeGlossCollectionDetails(DataOutput dataOutput, GlossMapper glossMapper) throws DLTException, IOException {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int n2 = glossMapper.getGlossIndex((Gloss)iterator.next());
            n2 = NodeHashIndex.newHash(n2);
            dataOutput.writeInt(n2);
            ++n;
        }
        dataOutput.writeInt(-1);
        return n;
    }

    public int readGlossCollectionDetails(DataInput dataInput, Dictionary dictionary) throws IOException {
        int n;
        if (this.ownerDictionary == null) {
            this.ownerDictionary = dictionary;
        }
        int n2 = 0;
        while ((n = dataInput.readInt()) != -1) {
            this.add(new MapperGloss(n));
            ++n2;
        }
        this.trimToSize();
        return n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Gloss gloss : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(gloss.toString());
        }
        return stringBuilder.toString();
    }

    protected void markModification() {
        this.filtered = null;
        this.gle_representation = null;
        this.isGeneric = -1;
    }

    public boolean isGeneric() {
        if (this.isGeneric == -1) {
            Gloss gloss;
            this.isGeneric = this.isEmpty() ? 0 : ((gloss = (Gloss)this.get(0)) instanceof MidGloss && ((MidGloss)gloss).getGloss(MorphRuleGloss.class) != null ? 1 : 0);
        }
        return this.isGeneric != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlossCollection filterByCase(int n, int n2, CharacterIterator characterIterator, int n3, int n4) {
        int n5 = CaseGloss.getFilterIndex(n);
        GlossCollection[] glossCollectionArray = this.filtered;
        if (glossCollectionArray == null || this.filter_mask_method != n2) {
            glossCollectionArray = new GlossCollection[32];
            GlossCollection glossCollection = this;
            synchronized (glossCollection) {
                this.filter_mask_method = n2;
                this.filtered = glossCollectionArray;
            }
        }
        if (glossCollectionArray[n5] == null) {
            glossCollectionArray[n5] = CaseGloss.prefilterByCase(this, n, n2);
        }
        return CaseGloss.refilterByCase(glossCollectionArray[n5], n, n2, characterIterator, n3, n4);
    }

    public GlossCollection filterByStringCase(int n, int n2, CharacterIterator characterIterator, int n3, int n4) {
        return this.filterByCase(CaseGloss.applyMethod(CaseGloss.CaseExtractor.getSubStringCase(characterIterator, n3, n4), n2), n, characterIterator, n3, n4);
    }

    public GlossCollection applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        ArrayList arrayList = null;
        for (Gloss gloss : this) {
            Gloss gloss2 = gloss.applyGlossProcessor(glossProcessor);
            if (gloss2 == gloss) {
                if (arrayList == null) continue;
                ((GlossCollection)arrayList).add(gloss);
                continue;
            }
            if (arrayList == null) {
                Gloss gloss3;
                arrayList = new GlossCollection();
                ((GlossCollection)arrayList).setOwnerDictionary(this.getOwnerDictionary());
                Iterator iterator = this.iterator();
                while (iterator.hasNext() && (gloss3 = (Gloss)iterator.next()) != gloss) {
                    ((GlossCollection)arrayList).add(gloss3);
                }
            }
            if (gloss2 == null) continue;
            ((GlossCollection)arrayList).add(gloss2);
        }
        if (arrayList == null) {
            return this;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public GlossCollection applyGlossProcessorShallow(GlossProcessor glossProcessor) throws DLTException {
        ArrayList arrayList = null;
        for (Gloss gloss : this) {
            Gloss gloss2 = (Gloss)glossProcessor.process(gloss);
            if (gloss2 == gloss) {
                if (arrayList == null) continue;
                ((GlossCollection)arrayList).add(gloss);
                continue;
            }
            if (arrayList == null) {
                Gloss gloss3;
                arrayList = new GlossCollection();
                ((GlossCollection)arrayList).setOwnerDictionary(this.getOwnerDictionary());
                Iterator iterator = this.iterator();
                while (iterator.hasNext() && (gloss3 = (Gloss)iterator.next()) != gloss) {
                    ((GlossCollection)arrayList).add(gloss3);
                }
            }
            if (gloss2 == null) continue;
            ((GlossCollection)arrayList).add(gloss2);
        }
        if (arrayList == null) {
            return this;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    @Override
    public void add(int n, Gloss gloss) {
        if (this.contains(gloss)) {
            return;
        }
        this.markModification();
        super.add(n, gloss);
    }

    @Override
    public boolean addAll(Collection<? extends Gloss> collection) {
        if (collection == null) {
            return false;
        }
        this.markModification();
        boolean bl = false;
        for (Gloss gloss : collection) {
            bl |= this.add(gloss);
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends Gloss> collection) {
        int n2 = this.size();
        for (Gloss gloss : collection) {
            this.add(n + this.size() - n2, gloss);
        }
        return this.size() > n2;
    }

    @Override
    public Gloss remove(int n) {
        this.markModification();
        return (Gloss)super.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        this.markModification();
        return super.remove(object);
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.markModification();
        super.removeRange(n, n2);
    }

    @Override
    public Gloss set(int n, Gloss gloss) {
        this.markModification();
        return super.set(n, gloss);
    }

    @Override
    public Object[] toArray() {
        return super.toArray(new Gloss[this.size()]);
    }
}

