/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.JaCategory;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.util.Utils;
import java.text.CharacterIterator;

final class InflectionParsingStreamJa
implements ParsingStream {
    private final ParsingStream stream;
    private CharacterIterator text;
    private final Awaiting awaiting = new Awaiting();
    static final ConjugationCharts[] conjugation_charts = new ConjugationCharts[]{new ConjugationCharts(1, null, "\u304f"), new ConjugationCharts(2, null, "\u304f"), new ConjugationCharts(3, null, "\u3050"), new ConjugationCharts(4, null, "\u3059"), new ConjugationCharts(5, null, "\u3064"), new ConjugationCharts(6, null, "\u306c"), new ConjugationCharts(7, null, "\u3076"), new ConjugationCharts(8, null, "\u3080"), new ConjugationCharts(9, null, "\u308b"), new ConjugationCharts(10, null, "\u3046"), new ConjugationCharts(11, null, "\u308b"), new ConjugationCharts(12, "\u3055", "\u3059\u308b"), new ConjugationCharts(12, "\u3057", "\u3059\u308b"), new ConjugationCharts(12, null, "\u308b"), new ConjugationCharts(13, null, "\u3059\u308b"), new ConjugationCharts(14, null, "\u3059\u308b"), new ConjugationCharts(15, null, "\u305a\u308b"), new ConjugationCharts(16, "\u304d", "\u304f\u308b"), new ConjugationCharts(16, "\u3053", "\u304f\u308b"), new ConjugationCharts(16, null, "\u308b"), new ConjugationCharts(17, null, "\u3044"), new ConjugationCharts(18, null, "\u3060"), new ConjugationCharts(35, "\u3055", "\u3059\u308b"), new ConjugationCharts(36, "\u305b", "\u3059\u308b"), new ConjugationCharts(37, "\u3057", "\u3059\u308b"), new ConjugationCharts(38, "\u3059", "\u3059\u308b"), new ConjugationCharts(38, "\u305a", "\u305a\u308b"), new ConjugationCharts(180, null, "\u3060"), new ConjugationCharts(181, null, "\u3060"), new ConjugationCharts(404, null, "\u3059"), new ConjugationCharts(412, null, "\u308b")};

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    InflectionParsingStreamJa(ParsingStream parsingStream) {
        this.stream = parsingStream;
    }

    @Override
    public void addToFork() {
        this.clearStd();
        this.stream.addToFork();
    }

    @Override
    public void close() {
        this.clearStd();
        this.stream.close();
    }

    @Override
    public void closeGroup(int n) {
        this.clearStd();
        this.stream.closeGroup(n);
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        this.clearStd();
        this.stream.createBreakpoint(n, n2, n3);
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.clearStd();
        this.stream.createPunctuation(n, n2, n3, n4);
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        this.storeStd(n, n2, n3, glossCollection);
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        this.clearStd();
        this.stream.createUnknown(n, n2, n3, n4);
    }

    @Override
    public void fork() {
        this.clearStd();
        this.stream.fork();
    }

    @Override
    public void mergeRoutes(int n) {
        this.clearStd();
        this.stream.mergeRoutes(n);
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.clearStd();
        this.stream.reset(uniLexAnalyzer);
        this.text = uniLexAnalyzer.getSourceText();
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        this.clearStd();
        return this.stream.startGroup(n, n2, n3);
    }

    private void storeStd(int n, int n2, int n3, GlossCollection glossCollection) {
        int n4 = 0;
        int n5 = 0;
        for (Gloss gloss : glossCollection) {
            JaMorphGloss jaMorphGloss = null;
            if (gloss instanceof MidGloss) {
                jaMorphGloss = (JaMorphGloss)((MidGloss)gloss).getGloss(JaMorphGloss.class);
            }
            if (jaMorphGloss == null) continue;
            n4 = jaMorphGloss.getJKOM();
            n5 = jaMorphGloss.getJPOS();
            break;
        }
        if (!this.awaiting.store(this.text, n, n2, n3, glossCollection, n4, n5)) {
            this.clearStd();
            this.awaiting.store(this.text, n, n2, n3, glossCollection, n4, n5);
        }
    }

    private void clearStd() {
        if (!this.awaiting.isEmpty()) {
            this.awaiting.settle();
            this.stream.createStd(this.awaiting.probability, this.awaiting.begin, this.awaiting.end, this.awaiting.gc);
        }
        this.awaiting.clear();
    }

    private static final class ConjugationCharts {
        final int jkom;
        final String word_stem;
        final String conjugation_ending;

        ConjugationCharts(int n, String string, String string2) {
            this.jkom = n;
            this.word_stem = string;
            this.conjugation_ending = string2;
        }
    }

    private static final class Awaiting {
        int probability;
        int begin;
        int end;
        GlossCollection gc;
        private int type;
        private int jkom;
        private int jpos;
        private int pos;
        private int stopward;
        private String lemma;
        private final StringBuilder buffer = new StringBuilder();

        Awaiting() {
        }

        boolean isEmpty() {
            return this.gc == null;
        }

        private boolean isModified() {
            return this.lemma != null || this.jkom >= 0 || this.jpos >= 0 || this.pos >= 0 || this.stopward >= 0;
        }

        void clear() {
            this.type = 0;
            this.end = 0;
            this.begin = 0;
            this.probability = 0;
            this.gc = null;
            this.stopward = -1;
            this.pos = -1;
            this.jpos = -1;
            this.jkom = -1;
            this.lemma = null;
        }

        boolean store(CharacterIterator characterIterator, int n, int n2, int n3, GlossCollection glossCollection, int n4, int n5) {
            int n6 = this.type;
            this.type = JaCategory.getType(n4, n5);
            if (this.isEmpty()) {
                this.probability = n;
                this.begin = n2;
                this.end = n3;
                this.gc = glossCollection;
                if ((this.type & 0x10024) != 0) {
                    this.lemma = this.getLemma(characterIterator, n2, n3, n4);
                }
                if ((this.type & 0x10) != 0) {
                    this.jkom = 19;
                    this.jpos = 4;
                    this.pos = 3;
                    this.stopward = 0;
                }
                if ((this.type & 0x20) != 0) {
                    this.jkom = 0;
                    this.jpos = 1;
                    this.pos = 2;
                    this.stopward = 0;
                }
                return true;
            }
            if ((n6 & 8) != 0 && (this.type & 8) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 4) != 0 && (this.type & 8) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x10) != 0) {
                return false;
            }
            if ((n6 & 0x20) != 0) {
                if ((this.type & 0xA88) != 0) {
                    this.end = n3;
                    return true;
                }
                return false;
            }
            if ((n6 & 0x1000) != 0 && (this.type & 0x2000) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x2000) != 0 && (this.type & 0x2000) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x4000) != 0 && (this.type & 0x8000) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x10000) != 0) {
                if ((this.type & 2) != 0) {
                    this.end = n3;
                    this.jkom = 0;
                    return true;
                }
                if ((this.type & 0x80000) != 0) {
                    this.end = n3;
                    this.jkom = 0;
                    this.jpos = 7;
                    return true;
                }
            }
            if ((n6 & 0x20000) != 0 && (this.type & 0x80000) != 0) {
                this.end = n3;
                this.jkom = 0;
                this.jpos = 7;
                return true;
            }
            if ((n6 & 0x40000) != 0 && (this.type & 0x80000) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x40) != 0 && (this.type & 0x80) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x100) != 0 && (this.type & 0x200) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if ((n6 & 0x400) != 0 && (this.type & 0x800) != 0) {
                this.end = n3;
                this.jkom = 0;
                return true;
            }
            if (n6 != 0 && (this.type & 0x100000) != 0) {
                this.end = n3;
                this.jkom = 19;
                this.jpos = 23;
                return true;
            }
            return false;
        }

        void settle() {
            if (this.isModified()) {
                GlossCollection glossCollection = new GlossCollection();
                glossCollection.setOwnerDictionary(this.gc.getOwnerDictionary());
                for (Gloss gloss : this.gc) {
                    if (gloss instanceof MidGloss) {
                        Gloss[] glossArray = ((MidGloss)gloss).element;
                        Gloss[] glossArray2 = new Gloss[glossArray.length];
                        System.arraycopy(glossArray, 0, glossArray2, 0, glossArray.length);
                        block8: for (int i = 0; i < glossArray2.length; ++i) {
                            switch (glossArray2[i].getType()) {
                                case 11: {
                                    if (this.lemma == null) continue block8;
                                    glossArray2[i] = new LemmaGloss(this.lemma);
                                    continue block8;
                                }
                                case 32: {
                                    if (this.jkom < 0 && this.jpos < 0) continue block8;
                                    Gloss gloss2 = (JaMorphGloss)glossArray2[i];
                                    int n = this.jkom >= 0 ? this.jkom : ((JaMorphGloss)gloss2).getJKOM();
                                    int n2 = this.jpos >= 0 ? this.jpos : ((JaMorphGloss)gloss2).getJPOS();
                                    glossArray2[i] = new JaMorphGloss(n, n2, ((JaMorphGloss)gloss2).getPhraseStart() == 1, false);
                                    continue block8;
                                }
                                case 15: {
                                    int n;
                                    if (this.pos < 0 && this.stopward < 0) continue block8;
                                    Gloss gloss2 = (FeatureSetGloss)glossArray2[i];
                                    int n3 = n = this.pos >= 0 ? this.pos : ((FeatureSetGloss)gloss2).getPOS();
                                    int n2 = this.stopward >= 0 ? this.stopward : (((FeatureSetGloss)gloss2).is(200) ? 1 : 0);
                                    glossArray2[i] = new FeatureSetGloss(n, ((FeatureSetGloss)gloss2).getBOFA(), ((FeatureSetGloss)gloss2).is(201) ? 1 : 0, n2, ((FeatureSetGloss)gloss2).getUser());
                                    continue block8;
                                }
                            }
                        }
                        try {
                            gloss = new MidGloss(glossArray2);
                        }
                        catch (DLTException dLTException) {
                            throw new Error(Messages.getString("error.internal"));
                        }
                    }
                    glossCollection.add(gloss);
                }
                this.gc = glossCollection;
            }
        }

        private String getLemma(CharacterIterator characterIterator, int n, int n2, int n3) {
            this.buffer.setLength(0);
            Utils.makeString(this.buffer, characterIterator, n, n2);
            String string = this.buffer.toString();
            for (int i = 0; i < conjugation_charts.length; ++i) {
                ConjugationCharts conjugationCharts = conjugation_charts[i];
                if (conjugationCharts.jkom != n3) continue;
                if (conjugationCharts.word_stem == null) {
                    this.buffer.append(conjugationCharts.conjugation_ending);
                    this.buffer.trimToSize();
                    return this.buffer.toString();
                }
                if (!conjugationCharts.word_stem.equals(string)) continue;
                return conjugationCharts.conjugation_ending;
            }
            return null;
        }
    }
}

