/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerKo;
import com.ibm.dltj.UniMorphoSyntax;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.gloss.FeatureStructureGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.KoMorphGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.dltj.um.KMorph;
import com.ibm.dltj.um.KPOS;
import com.ibm.dltj.util.DecomposingCharacterIterator;
import java.text.CharacterIterator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

final class InflectionParsingStreamKo
implements MWUParsingStream {
    private final ParsingStream stream;
    private final Awaiting awaiting;
    private DecomposingCharacterIterator text;
    private CharacterIterator origText;
    private UniMorphoSyntax morphoSyntax;
    private static final int KMORPH_WHITESPACE = KMorph._999.getCode();

    public InflectionParsingStreamKo(ParsingStream parsingStream) {
        this.stream = parsingStream;
        this.awaiting = new Awaiting();
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        int n4 = InflectionParsingStreamKo.getMorph(glossCollection);
        if (n4 == KMORPH_WHITESPACE) {
            this.flushAwaiting();
            return;
        }
        this.storeUnit(n, n2, n3, glossCollection, n4);
    }

    @Override
    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        int n4;
        int n5 = this.getPosition(n2);
        if (n5 < (n4 = this.getPosition(n3))) {
            ((MWUParsingStream)this.stream).createMWU(n, n5, n4, gloss);
        }
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        this.storeUnit(n, n2, n3, null, n4);
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.storeUnit(n, n2, n3, null, n4);
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        this.flushAwaiting();
        this.stream.createBreakpoint(n, this.getPosition(n2), n3);
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        this.flushAwaiting();
        int n4 = this.getPosition(n);
        int n5 = this.getPosition(n2);
        if (n4 < n5) {
            return this.stream.startGroup(n4, n5, n3);
        }
        return 0;
    }

    @Override
    public void fork() {
        this.flushAwaiting();
        this.stream.fork();
    }

    @Override
    public void addToFork() {
        this.flushAwaiting();
        this.stream.addToFork();
    }

    @Override
    public void mergeRoutes(int n) {
        this.flushAwaiting();
        this.stream.mergeRoutes(n);
    }

    @Override
    public void closeGroup(int n) {
        this.flushAwaiting();
        this.stream.closeGroup(n);
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.flushAwaiting();
        this.stream.reset(uniLexAnalyzer);
        this.text = ((UniLexAnalyzerKo)uniLexAnalyzer).getDecomposedSourceText();
        this.origText = ((UniLexAnalyzerKo)uniLexAnalyzer).getSourceText();
        this.morphoSyntax = uniLexAnalyzer.morphoSyntax;
    }

    @Override
    public void close() {
        this.flushAwaiting();
        this.stream.close();
    }

    private static final int getMorph(GlossCollection glossCollection) {
        for (Gloss gloss : glossCollection) {
            KoMorphGloss koMorphGloss;
            if (!(gloss instanceof MidGloss) || (koMorphGloss = (KoMorphGloss)((MidGloss)gloss).getGloss(KoMorphGloss.class)) == null) continue;
            return koMorphGloss.getMorph();
        }
        return 0;
    }

    private int getTokenClassCode(int n, int n2) {
        int n3 = this.origText.getIndex();
        TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.origText, n, n2);
        this.origText.setIndex(n3);
        return tokenClassGloss == null ? 0 : tokenClassGloss.getBestClass();
    }

    private void storeUnit(int n, int n2, int n3, GlossCollection glossCollection, int n4) {
        int n5;
        int n6;
        if (this.awaiting.isEmpty()) {
            this.awaiting.add(n, n2, n3, glossCollection, n4);
            return;
        }
        if (n4 > KMORPH_WHITESPACE && glossCollection != null) {
            this.awaiting.append(n3, glossCollection, n4);
            return;
        }
        if (this.awaiting.glist.size() == 1) {
            n6 = this.awaiting.flist.get(0);
            if (n6 == 54 && n4 == 641) {
                this.awaiting.append(n3, glossCollection, n4);
                this.awaiting.flist.set(0, KMorph._291.getCode());
                this.awaiting.prevEnd = n3;
                return;
            }
            if (n6 == 56 && n4 == 642) {
                this.awaiting.append(n3, glossCollection, n4);
                this.awaiting.flist.set(0, KMorph._292.getCode());
                this.awaiting.prevEnd = n3;
                return;
            }
            if (n6 == 624 && 641 <= n4 && n4 <= 647) {
                this.awaiting.append(n3, glossCollection, n4);
                switch (n4) {
                    case 641: 
                    case 644: {
                        this.awaiting.flist.set(0, KMorph._291.getCode());
                        break;
                    }
                    case 642: {
                        this.awaiting.flist.set(0, KMorph._292.getCode());
                        break;
                    }
                    case 643: 
                    case 645: 
                    case 646: {
                        this.awaiting.flist.set(0, KMorph._293.getCode());
                        break;
                    }
                    case 647: {
                        this.awaiting.flist.set(0, KMorph._294.getCode());
                    }
                }
                this.awaiting.prevEnd = n3;
                return;
            }
            if (n6 == 55 && n4 == 661) {
                this.awaiting.append(n3, glossCollection, n4);
                this.awaiting.flist.set(0, KMorph._295.getCode());
                this.awaiting.prevEnd = n3;
                return;
            }
            if (n6 == 57 && n4 == 662) {
                this.awaiting.append(n3, glossCollection, n4);
                this.awaiting.flist.set(0, KMorph._296.getCode());
                this.awaiting.prevEnd = n3;
                return;
            }
            if (n6 == 624 && 661 <= n4 && n4 <= 665) {
                this.awaiting.append(n3, glossCollection, n4);
                switch (n4) {
                    case 661: {
                        this.awaiting.flist.set(0, KMorph._295.getCode());
                        break;
                    }
                    case 662: 
                    case 664: 
                    case 665: {
                        this.awaiting.flist.set(0, KMorph._296.getCode());
                        break;
                    }
                    case 663: {
                        this.awaiting.flist.set(0, KMorph._297.getCode());
                    }
                }
                this.awaiting.prevEnd = n3;
                return;
            }
        }
        if (801 <= n4 && n4 <= 860 && (201 <= (n6 = this.awaiting.flist.get(0).intValue()) && n6 <= 261 || 76 <= n6 && n6 <= 79 || 273 == n6 || 275 == n6 || 276 <= n6 && n6 <= 279 || 401 <= n6 && n6 <= 461 || 641 <= n6 && n6 <= 647 || 291 <= n6 && n6 <= 297)) {
            this.awaiting.append(n3, glossCollection, n4);
            return;
        }
        n6 = this.getPosition(n2);
        if (n6 == (n5 = this.getPosition(n3))) {
            int n7 = this.getPosition(this.awaiting.begin);
            int n8 = this.getPosition(this.awaiting.end);
            if (n8 > n6 || n8 > n7) {
                this.flushAwaiting();
            }
            this.awaiting.add(n, n2, n3, glossCollection, n4);
            return;
        }
        int n9 = this.text.getIndex();
        char c = this.text.setIndex(n2);
        this.text.setIndex(n9);
        if (InflectionParsingStreamKo.isMedial(c) || InflectionParsingStreamKo.isFinal(c)) {
            this.awaiting.append(n3, glossCollection, n4);
            return;
        }
        this.flushAwaiting();
        this.awaiting.add(n, n2, n3, glossCollection, n4);
    }

    private void flushAwaiting() {
        if (!this.awaiting.isEmpty()) {
            int n = this.awaiting.glist.size();
            int n2 = this.getPosition(this.awaiting.begin);
            int n3 = this.getPosition(this.awaiting.end);
            GlossCollection glossCollection = this.awaiting.glist.get(0);
            int n4 = this.awaiting.flist.get(0);
            if (n == 1) {
                if (glossCollection == null) {
                    if (RBBICategory.isPunctuation(n4)) {
                        this.stream.createPunctuation(this.awaiting.probability, n2, n3, n4);
                    } else {
                        this.stream.createUnknown(this.awaiting.probability, n2, n3, n4);
                    }
                } else if (990 <= n4 && n4 <= 994) {
                    int n5 = this.getTokenClassCode(n2, n3);
                    if (RBBICategory.isPunctuation(n5)) {
                        this.stream.createPunctuation(this.awaiting.probability, n2, n3, n5);
                    } else {
                        this.stream.createUnknown(this.awaiting.probability, n2, n3, n5);
                    }
                } else {
                    this.stream.createStd(this.awaiting.probability, n2, n3, this.prepareGlossCollection(false, this.awaiting.begin, this.awaiting.end, n4, this.awaiting.glist));
                }
            } else if (this.awaiting.prevEnd > 0 && glossCollection != null) {
                this.stream.createStd(this.awaiting.probability, n2, n3, this.prepareGlossCollection(true, this.awaiting.begin, this.awaiting.prevEnd, n4, this.awaiting.glist));
            } else {
                this.stream.createUnknown(this.awaiting.probability, n2, n3, this.getTokenClassCode(n2, n3));
            }
        }
        this.awaiting.clear();
    }

    private GlossCollection prepareGlossCollection(boolean bl, int n, int n2, int n3, List<GlossCollection> list) {
        KMorph kMorph = KMorph.createFromIntegerCode(n3);
        KPOS kPOS = kMorph.getKpos();
        GlossCollection glossCollection = list.get(0);
        assert (glossCollection != null);
        GlossCollection glossCollection2 = new GlossCollection();
        glossCollection2.setOwnerDictionary(glossCollection.getOwnerDictionary());
        for (Gloss gloss : glossCollection) {
            if (gloss instanceof MidGloss) {
                Gloss[] glossArray = ((MidGloss)gloss).element;
                Gloss[] glossArray2 = new Gloss[glossArray.length];
                for (int i = 0; i < glossArray.length; ++i) {
                    Object object;
                    if (glossArray[i] instanceof LemmaGenerator) {
                        boolean bl2;
                        boolean bl3 = bl2 = !bl;
                        if (kMorph == KMorph._273 || kMorph == KMorph._275) {
                            bl2 = true;
                        }
                        if (!InflectionParsingStreamKo.useOriginalLemma(bl2, (LemmaGenerator)((Object)glossArray[i])) && (object = kMorph.getLemma(this.text, n, n2)) != null && !((String)object).isEmpty()) {
                            glossArray2[i] = new LemmaGloss((String)object);
                        }
                    } else if (glossArray[i] instanceof KoMorphGloss) {
                        KoMorphGloss koMorphGloss = new KoMorphGloss(n3, kPOS.getIntegerCode(), false, false);
                        if (kPOS.name().startsWith("V")) {
                            object = EnumSet.noneOf(KPOS.class);
                            for (int j = 1; j < list.size(); ++j) {
                                GlossCollection glossCollection3 = list.get(j);
                                if (glossCollection3 == null) continue;
                                for (Gloss gloss2 : glossCollection3) {
                                    KoMorphGloss koMorphGloss2;
                                    if (!(gloss2 instanceof MidGloss) || (koMorphGloss2 = (KoMorphGloss)((MidGloss)gloss2).getGloss(KoMorphGloss.class)) == null) continue;
                                    ((AbstractCollection)object).add(KMorph.createFromIntegerCode(koMorphGloss2.getMorph()).getKpos());
                                }
                            }
                            koMorphGloss.setInflectionFlags((EnumSet<KPOS>)object);
                            koMorphGloss.encodeShortMorphCode(n3);
                        }
                        glossArray2[i] = koMorphGloss;
                    } else if (glossArray[i] instanceof FeatureSetGloss && kMorph.getPos() != ((FeatureSetGloss)glossArray[i]).getPOS()) {
                        glossArray2[i] = new FeatureSetGloss(kMorph.getPos(), 0, false, false, false, false);
                    }
                    if (glossArray2[i] != null) continue;
                    glossArray2[i] = glossArray[i];
                }
                gloss = this.copyMidGloss((MidGloss)gloss);
                ((MidGloss)gloss).element = glossArray2;
            }
            glossCollection2.add(gloss);
        }
        return glossCollection2;
    }

    private static boolean useOriginalLemma(boolean bl, LemmaGenerator lemmaGenerator) {
        if (!bl) {
            return false;
        }
        return !(lemmaGenerator instanceof LemmaGloss) || !((LemmaGloss)lemmaGenerator).value.isEmpty();
    }

    private MidGloss copyMidGloss(MidGloss midGloss) {
        if (midGloss instanceof FeatureStructureGloss) {
            return new FeatureStructureGloss((FeatureStructureGloss)midGloss);
        }
        if (midGloss instanceof Annotate) {
            try {
                return (MidGloss)midGloss.getClass().newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return new MidGloss();
    }

    private int getPosition(int n) {
        return this.text.calculateOriginalPosition(n);
    }

    static boolean isJamo(char c) {
        return '\u1100' <= c && c <= '\u11ff';
    }

    static boolean isInitial(char c) {
        return '\u1100' <= c && c <= '\u115f';
    }

    static boolean isMedial(char c) {
        return '\u1160' <= c && c <= '\u11a7';
    }

    static boolean isFinal(char c) {
        return '\u11a8' <= c && c <= '\u11ff';
    }

    private final class Awaiting {
        int probability;
        int begin;
        int end;
        List<GlossCollection> glist = new ArrayList<GlossCollection>(4);
        List<Integer> flist = new ArrayList<Integer>(4);
        int prevEnd;

        Awaiting() {
        }

        boolean isEmpty() {
            return this.glist.isEmpty() && this.flist.isEmpty();
        }

        void add(int n, int n2, int n3, GlossCollection glossCollection, int n4) {
            if (this.isEmpty()) {
                this.probability = n;
                this.begin = n2;
                this.end = n3;
                this.glist.add(glossCollection);
                this.flist.add(n4);
            } else {
                this.append(n3, glossCollection, n4);
            }
            this.prevEnd = 0;
        }

        void append(int n, GlossCollection glossCollection, int n2) {
            if (this.glist.size() == 1) {
                this.prevEnd = this.end;
            }
            this.end = n;
            this.glist.add(glossCollection);
            this.flist.add(n2);
        }

        void clear() {
            this.prevEnd = 0;
            this.end = 0;
            this.begin = 0;
            this.probability = 0;
            this.glist.clear();
            this.flist.clear();
        }
    }
}

