/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

public final class LanguageGuess
implements Comparable<LanguageGuess> {
    private String language;
    private long score;
    private int confidence;
    private int confThres;
    private int normFactor;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public LanguageGuess(String string, int n, int n2) {
        this.language = string;
        this.score = n;
        this.confidence = n2;
        this.confThres = 1;
        this.normFactor = 100;
    }

    public int getConfidence() {
        return this.confidence;
    }

    void setConfidence(int n) {
        this.confidence = n;
    }

    public String getLanguage() {
        return this.language;
    }

    void setLanguage(String string) {
        this.language = string;
    }

    public long getScore() {
        return this.score;
    }

    void setScore(long l) {
        this.score = l;
    }

    int getConfThres() {
        return this.confThres;
    }

    void setConfThres(int n) {
        this.confThres = n;
    }

    int getNormFactor() {
        return this.normFactor;
    }

    void setNormFactor(int n) {
        this.normFactor = n;
    }

    long getNormalizedScore() {
        return this.score * (long)this.normFactor;
    }

    boolean isConfident4Tokens(int n) {
        if (n == 0 || this.score == 0L) {
            return false;
        }
        return this.score * (long)this.normFactor / (long)n > (long)(this.confThres * this.normFactor);
    }

    @Override
    public int compareTo(LanguageGuess languageGuess) {
        long l = this.getNormalizedScore();
        return l < languageGuess.getNormalizedScore() ? 1 : (l == languageGuess.getNormalizedScore() && this.language.equals(languageGuess.getLanguage()) ? 0 : -1);
    }

    public String toString() {
        return "LanguageGuess [language=" + this.language + ", confidence=" + this.confidence + " (" + this.confThres + "," + this.normFactor + "," + this.score + ")]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.language == null ? 0 : this.language.hashCode());
        n = 31 * n + this.confidence;
        n = 31 * n + this.confThres;
        n = 31 * n + this.normFactor;
        n = 31 * n + (int)(this.score ^ this.score >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LanguageGuess languageGuess = (LanguageGuess)object;
        if (this.confThres != languageGuess.confThres) {
            return false;
        }
        if (this.confidence != languageGuess.confidence) {
            return false;
        }
        if (this.language == null ? languageGuess.language != null : !this.language.equals(languageGuess.language)) {
            return false;
        }
        if (this.normFactor != languageGuess.normFactor) {
            return false;
        }
        return this.score == languageGuess.score;
    }
}

