/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MWElementGloss;
import com.ibm.dltj.gloss.MWUGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import com.ibm.dltj.util.Utils;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

public class MWDecorator
implements ParsingStream {
    CharacterIterator textIterator;
    Dictionary[] mwDictionaries;
    MWUParsingStream parsingStream;
    static boolean DEBUG = false;
    static Level DEBUG_LEVEL = Level.OFF;
    private ArrayList<MWUMatch> unfinishedMWUs = new ArrayList();
    private ArrayList<MWUMatch> upcomingMWUs = new ArrayList();
    private StringBuilder lemma = new StringBuilder();
    StringBuilder surface_form = new StringBuilder();
    private final StringBufferCharacterIterator bufferIterator = new StringBufferCharacterIterator(this.lemma);
    private final Set<String> visitedLemmas = new TreeSet<String>();
    private boolean match_created = false;

    private void swapLists() {
        ArrayList<MWUMatch> arrayList = this.unfinishedMWUs;
        arrayList.clear();
        this.unfinishedMWUs = this.upcomingMWUs;
        this.upcomingMWUs = arrayList;
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public MWDecorator(Dictionary[] dictionaryArray, ParsingStream parsingStream) throws DLTException {
        this.mwDictionaries = dictionaryArray;
        this.parsingStream = (MWUParsingStream)parsingStream;
        if (parsingStream == null) {
            throw new DLTException(Messages.getString("cannot.nullstream"));
        }
        if (dictionaryArray == null || dictionaryArray.length == 0) {
            throw new DLTException(Messages.getString("error.dict.multiword"));
        }
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.textIterator = uniLexAnalyzer.getSourceText();
        this.parsingStream.reset(uniLexAnalyzer);
    }

    @Override
    public void close() {
        this.parsingStream.close();
    }

    private void clearMWUs() {
        this.unfinishedMWUs.clear();
        this.upcomingMWUs.clear();
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        this.clearMWUs();
        this.parsingStream.createBreakpoint(n, n2, n3);
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        try {
            boolean bl = false;
            boolean bl2 = false;
            if (n == 0) {
                this.surface_form.setLength(0);
                Utils.makeString(this.surface_form, this.textIterator, n2, n3);
            }
            this.visitedLemmas.clear();
            LemmaGenerator lemmaGenerator = null;
            for (Gloss gloss : glossCollection) {
                if (!(gloss instanceof MidGloss)) continue;
                MidGloss midGloss = (MidGloss)gloss;
                LemmaGenerator lemmaGenerator2 = midGloss.getLemmaGloss();
                if (lemmaGenerator2 != null && lemmaGenerator2 != lemmaGenerator) {
                    this.lemma.setLength(0);
                    lemmaGenerator2.getLemma(this.textIterator, n2, n3, this.lemma);
                    bl2 = true;
                    if (!this.visitedLemmas.add(this.lemma.toString())) continue;
                    this.bufferIterator.setText(this.lemma);
                    if (DEBUG) {
                        this.debugPrint(Level.FINE, "\t\t\tLemma (");
                        this.debugPrint(Level.FINE, this.lemma.toString());
                        this.debugPrint(Level.FINE, ")\n");
                    }
                    this.processLemmaForMWU(n2, n3, this.bufferIterator, midGloss);
                    if (n == 0 && this.surface_form.toString().equals(this.lemma.toString())) {
                        bl = true;
                    }
                }
                lemmaGenerator = lemmaGenerator2;
            }
            if (n == 0 && !bl) {
                this.bufferIterator.setText(this.surface_form);
                this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
            }
            if (!bl2) {
                this.handleUnknown(n, n2, n3, 200);
            }
        }
        catch (DLTException dLTException) {
            // empty catch block
        }
        this.swapLists();
        this.parsingStream.createStd(n, n2, n3, glossCollection);
    }

    private void processLemmaForMWU(int n, int n2, StringBufferCharacterIterator stringBufferCharacterIterator, MidGloss midGloss) throws DLTException {
        int n3 = stringBufferCharacterIterator.getIndex();
        for (int i = 0; i < this.mwDictionaries.length; ++i) {
            stringBufferCharacterIterator.setIndex(n3);
            GlossCollection glossCollection = this.mwDictionaries[i].lookupWord(stringBufferCharacterIterator, stringBufferCharacterIterator.getEndIndex());
            if (glossCollection == null) continue;
            for (Gloss gloss : glossCollection) {
                if (!(gloss instanceof MWElementGloss)) continue;
                MWElementGloss mWElementGloss = (MWElementGloss)gloss;
                this.processSingleMWE(n, n2, mWElementGloss, midGloss);
            }
        }
    }

    private void processSingleMWE(int n, int n2, MWElementGloss mWElementGloss, MidGloss midGloss) {
        Iterator<MWUMatch> iterator = this.unfinishedMWUs.iterator();
        while (iterator.hasNext()) {
            MWUMatch mWUMatch = iterator.next();
            if (!mWUMatch.match(mWElementGloss)) continue;
            if (mWUMatch.done()) {
                this.createMWU(mWUMatch, n2);
            } else {
                this.upcomingMWUs.add(mWUMatch);
            }
            iterator.remove();
        }
        for (int i = 0; i < mWElementGloss.element.length; ++i) {
            if (!(mWElementGloss.element[i] instanceof MWUGloss)) continue;
            MWUGloss mWUGloss = (MWUGloss)mWElementGloss.element[i];
            this.startMWU(n, n2, mWUGloss, mWElementGloss);
            if (!DEBUG) continue;
            this.debugPrint(Level.FINEST, "\t\t\tstarting MWU", mWUGloss, mWElementGloss);
        }
    }

    private void startMWU(int n, int n2, MWUGloss mWUGloss, MWElementGloss mWElementGloss) {
        if (mWUGloss.element.length > 0 && mWUGloss.element[0].equals(mWElementGloss)) {
            MWUMatch mWUMatch = new MWUMatch(mWUGloss);
            this.match_created = true;
            mWUMatch.begin = n;
            if (mWUGloss.element.length == 1) {
                this.createMWU(mWUMatch, n2);
            } else {
                this.upcomingMWUs.add(mWUMatch);
                if (DEBUG) {
                    this.debugPrint(Level.FINEST, "upcomingMWUs.add()", mWUMatch);
                }
            }
        }
    }

    private void createMWU(MWUMatch mWUMatch, int n) {
        if (DEBUG) {
            this.debugPrint(Level.FINE, "+createMWU()", mWUMatch);
        }
        mWUMatch.end = n;
        this.parsingStream.createMWU(0, mWUMatch.begin, mWUMatch.end, mWUMatch.mwu.getDefinitionGloss());
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        this.handleUnknown(n, n2, n3, n4);
        this.swapLists();
        this.parsingStream.createUnknown(n, n2, n3, n4);
    }

    private void handleUnknown(int n, int n2, int n3, int n4) {
        this.lemma.setLength(0);
        Utils.makeString(this.lemma, this.textIterator, n2, n3);
        this.bufferIterator.setText(this.lemma);
        if (DEBUG) {
            this.debugPrint(Level.FINE, "\t\t\tUnknown (");
            this.debugPrint(Level.FINE, this.lemma.toString());
            this.debugPrint(Level.FINE, ")\n");
        }
        try {
            this.match_created = false;
            this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
            if (!this.match_created && RBBICategory.isWordLike(n4)) {
                this.lemma = new StringBuilder(this.lemma.toString().toLowerCase());
                this.bufferIterator.setText(this.lemma);
                this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
            }
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.lemma.setLength(0);
        Utils.makeString(this.lemma, this.textIterator, n2, n3);
        this.bufferIterator.setText(this.lemma);
        if (DEBUG) {
            this.debugPrint(Level.FINE, "\t\t\tPunctuation (");
            this.debugPrint(Level.FINE, this.lemma.toString());
            this.debugPrint(Level.FINE, ")\n");
        }
        try {
            this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        this.swapLists();
        this.parsingStream.createPunctuation(n, n2, n3, n4);
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        return this.parsingStream.startGroup(n, n2, n3);
    }

    @Override
    public void closeGroup(int n) {
        this.parsingStream.closeGroup(n);
    }

    @Override
    public void fork() {
        this.parsingStream.fork();
    }

    @Override
    public void addToFork() {
        this.parsingStream.addToFork();
    }

    @Override
    public void mergeRoutes(int n) {
        this.parsingStream.mergeRoutes(n);
    }

    void debugPrint(Level level, String string) {
    }

    void debugPrint(Level level, String string, MWUGloss mWUGloss, MWElementGloss mWElementGloss) {
    }

    void debugPrint(Level level, String string, MWUMatch mWUMatch) {
    }

    class MWUMatch {
        public MWUGloss mwu;
        int begin;
        int end;
        public LinkedList<Gloss> elementsToBeMatched = new LinkedList();

        MWUMatch() {
        }

        public boolean done() {
            return this.elementsToBeMatched.isEmpty();
        }

        public boolean match(MWElementGloss mWElementGloss) {
            if (this.elementsToBeMatched.getFirst().equals(mWElementGloss)) {
                this.elementsToBeMatched.remove(0);
                return true;
            }
            return false;
        }

        MWUMatch(int n) {
        }

        MWUMatch(MWUGloss mWUGloss) {
            for (int i = 1; i < mWUGloss.element.length; ++i) {
                this.elementsToBeMatched.add(mWUGloss.element[i]);
            }
            this.mwu = mWUGloss;
        }

        public int hashCode() {
            return this.mwu.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MWUGloss) {
                return this.mwu.equals(object);
            }
            if (object instanceof MWUMatch) {
                return this.mwu.equals(((MWUMatch)object).mwu);
            }
            return false;
        }
    }
}

