/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.Buffer;

public class ObjectBuffer
implements Buffer {
    protected int pos;
    protected Object[] element;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public ObjectBuffer() {
        this.init(16);
    }

    public ObjectBuffer(int n) {
        this.init(n);
    }

    protected void init(int n) {
        this.pos = 0;
        this.element = new Object[n];
    }

    public void add(Object object) {
        if (this.remaining() <= 0) {
            this.grow();
        }
        this.element[this.pos] = object;
        ++this.pos;
    }

    public void set(int n, Object object) {
        while (this.limit() <= n) {
            this.grow();
        }
        this.element[n] = object;
    }

    public Object get(int n) {
        return n < this.element.length ? this.element[n] : null;
    }

    public Object getFirst() {
        return this.pos > 0 ? this.element[0] : null;
    }

    public Object getLast() {
        return this.pos > 0 ? this.element[this.pos - 1] : null;
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    @Override
    public int limit() {
        return this.element.length;
    }

    @Override
    public int remaining() {
        return this.element.length - this.pos;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public int grow() {
        Object[] objectArray = new Object[this.element.length * 2];
        System.arraycopy(this.element, 0, objectArray, 0, this.element.length);
        this.element = objectArray;
        return this.element.length;
    }

    @Override
    public void addAll(Buffer buffer) {
        if (buffer instanceof ObjectBuffer) {
            int n = buffer.position();
            while (this.remaining() <= n) {
                this.grow();
            }
            System.arraycopy(((ObjectBuffer)buffer).element, 0, this.element, this.pos, n);
            this.pos += n;
        }
    }
}

