/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternNameFilter
implements FilenameFilter {
    private final String _pattern;
    private static final String REGEX = "[^_-]+";
    private static final String EMPTY_STRING = "";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public PatternNameFilter(String string) {
        this._pattern = string;
    }

    @Override
    public boolean accept(File file, String string) {
        return PatternNameFilter.wildmatch(this._pattern, string);
    }

    public static boolean wildmatch(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = string2.length();
        for (n = 0; n < n6 && n4 < n5 && string.charAt(n4) != '*'; ++n4, ++n) {
            if (string.charAt(n4) == string2.charAt(n) || string.charAt(n4) == '?') continue;
            return false;
        }
        while (n < n6 && n4 < n5) {
            if (string.charAt(n4) == '*') {
                if (++n4 >= n5) {
                    return true;
                }
                n3 = n4;
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n4) == string2.charAt(n) || string.charAt(n4) == '?') {
                ++n4;
                ++n;
                continue;
            }
            n4 = n3;
            n = n2++;
        }
        while (n4 < n5 && string.charAt(n4) == '*') {
            ++n4;
        }
        return n4 >= n5 && n >= n6;
    }

    public static boolean langNameWildmatch(String string, String string2) {
        return PatternNameFilter.localeWildmatch(PatternNameFilter.parseLocale(string), PatternNameFilter.parseLocale(string2));
    }

    public static boolean localeWildmatch(ULocale uLocale, ULocale uLocale2) {
        if (uLocale == uLocale2 || uLocale.equals((Object)uLocale2)) {
            return true;
        }
        return PatternNameFilter.localeWildmatch(PatternNameFilter.parseLocale(uLocale), PatternNameFilter.parseLocale(uLocale2));
    }

    public static boolean localeWildmatch(Locale locale, Locale locale2) {
        if (locale == locale2 || locale.equals(locale2)) {
            return true;
        }
        if (!PatternNameFilter.matches(locale.getLanguage(), locale2.getLanguage())) {
            return false;
        }
        if (!PatternNameFilter.matches(locale.getCountry(), locale2.getCountry())) {
            return false;
        }
        return PatternNameFilter.matches(locale.getVariant(), locale2.getVariant());
    }

    private static boolean matches(String string, String string2) {
        String string3;
        if (string.length() == 0 || string.equals("*")) {
            return true;
        }
        String string4 = string.toLowerCase();
        if (string4.equals(string3 = string2.toLowerCase())) {
            return true;
        }
        return PatternNameFilter.wildmatch(string4, string3);
    }

    static Locale parseLocale(ULocale uLocale) {
        return PatternNameFilter.parseLocale(uLocale.toString());
    }

    static Locale parseLocale(String string) {
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(string);
        String string2 = EMPTY_STRING;
        String string3 = EMPTY_STRING;
        String string4 = EMPTY_STRING;
        if (matcher.find()) {
            string2 = matcher.group();
            if (string2.length() == 3) {
                string2 = new ULocale(string2, EMPTY_STRING, EMPTY_STRING).getLanguage();
            }
            if (matcher.find()) {
                string3 = matcher.group();
                if (string3.length() == 3) {
                    string3 = new ULocale(EMPTY_STRING, string3, EMPTY_STRING).getCountry();
                }
                if (matcher.find()) {
                    string4 = string.substring(matcher.start());
                }
            }
        }
        return new Locale(string2, string3, string4);
    }
}

