/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.fst.MWUParser;
import com.ibm.dltj.parser.MWUParsingStream;
import java.text.CharacterIterator;

public class RepeatedWordsChecker
implements MWUParsingStream {
    private final MWUParsingStream parsingStream;
    CharacterIterator input;
    private int prev_token_begin = -1;
    private int prev_token_end = -1;
    private MWUParser.IBufferedInfo bufferedToken;
    private int compoundGroupOpened = 0;
    private int sequence_begin = -1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public RepeatedWordsChecker(MWUParsingStream mWUParsingStream) {
        this.parsingStream = mWUParsingStream;
    }

    @Override
    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        this.parsingStream.createMWU(n, n2, n3, gloss);
    }

    @Override
    public void createUnknown(int n, int n2, int n3, int n4) {
        if (this.compoundGroupOpened > 0) {
            if (this.sequence_begin < 0) {
                ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.CreateUnknownInfo(n, n2, n3, n4));
            }
        } else {
            boolean bl = this.processToken(n2, n3);
            if (bl) {
                this.bufferedToken = new MWUParser.CreateUnknownInfo(n, n2, n3, n4);
            }
        }
    }

    @Override
    public void addToFork() {
        if (this.compoundGroupOpened > 0) {
            if (this.sequence_begin < 0) {
                ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.AddToForkInfo());
            }
        } else {
            this.processEndOfSequence();
            this.parsingStream.addToFork();
        }
    }

    @Override
    public void close() {
        this.parsingStream.close();
        this.bufferedToken = null;
    }

    @Override
    public void closeGroup(int n) {
        if (this.compoundGroupOpened > 0) {
            --this.compoundGroupOpened;
            if (this.sequence_begin < 0) {
                ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.CloseGroupInfo(n));
            }
        } else {
            this.processEndOfSequence();
            this.parsingStream.closeGroup(n);
        }
    }

    @Override
    public void createBreakpoint(int n, int n2, int n3) {
        this.processEndOfSequence();
        this.parsingStream.createBreakpoint(n, n2, n3);
    }

    @Override
    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.processEndOfSequence();
        this.parsingStream.createPunctuation(n, n2, n3, n4);
    }

    @Override
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        if (this.compoundGroupOpened > 0) {
            if (this.sequence_begin < 0) {
                ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.CreateStdInfo(n, n2, n3, glossCollection));
            }
        } else {
            boolean bl = this.processToken(n2, n3);
            if (bl) {
                this.bufferedToken = new MWUParser.CreateStdInfo(n, n2, n3, glossCollection);
            }
        }
    }

    public void createDeletedToken(int n, int n2) {
        this.processToken(n, n2);
    }

    public void createDeletedBreak() {
        this.processEndOfSequence();
    }

    private boolean processToken(int n, int n2) {
        boolean bl = this.wordRepeats(n, n2);
        if (bl) {
            if (this.sequence_begin == -1) {
                this.sequence_begin = this.prev_token_begin;
                this.bufferedToken = null;
            }
        } else {
            this.processEndOfSequence();
            this.prev_token_begin = n;
            this.prev_token_end = n2;
            return true;
        }
        this.prev_token_begin = n;
        this.prev_token_end = n2;
        return false;
    }

    private void processEndOfSequence() {
        if (this.sequence_begin == -1) {
            if (this.bufferedToken != null) {
                this.bufferedToken.callFunction(this.parsingStream, -1);
            }
        } else {
            this.parsingStream.createUnknown(65535, this.sequence_begin, this.prev_token_end, 111);
        }
        this.bufferedToken = null;
        this.sequence_begin = -1;
        this.prev_token_begin = -1;
        this.prev_token_end = -1;
    }

    private boolean wordRepeats(int n, int n2) {
        if (this.prev_token_begin == -1) {
            return false;
        }
        int n3 = n2 - n;
        int n4 = this.prev_token_end - this.prev_token_begin;
        if (n3 != n4) {
            return false;
        }
        int n5 = this.input.getIndex();
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = this.input.setIndex(n + i);
            if (c2 == (c = this.input.setIndex(this.prev_token_begin + i))) continue;
            return false;
        }
        this.input.setIndex(n5);
        return true;
    }

    @Override
    public void fork() {
        if (this.compoundGroupOpened > 0) {
            if (this.sequence_begin < 0) {
                ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.ForkInfo());
            }
        } else {
            this.processEndOfSequence();
            this.parsingStream.fork();
        }
    }

    @Override
    public void mergeRoutes(int n) {
        if (this.compoundGroupOpened > 0) {
            if (this.sequence_begin < 0) {
                ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.MergeRoutesInfo(n));
            }
        } else {
            this.processEndOfSequence();
            this.parsingStream.mergeRoutes(n);
        }
    }

    @Override
    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.input = uniLexAnalyzer.characterIterator;
        this.parsingStream.reset(uniLexAnalyzer);
        this.prev_token_begin = -1;
        this.prev_token_end = -1;
        this.bufferedToken = null;
        this.sequence_begin = -1;
        this.compoundGroupOpened = 0;
    }

    @Override
    public int startGroup(int n, int n2, int n3) {
        if (this.compoundGroupOpened == 0) {
            boolean bl = this.processToken(n, n2);
            if (bl) {
                this.bufferedToken = new MWUParser.GroupInfo(new MWUParser.StartGroupInfo(n, n2, n3));
            }
        } else if (this.sequence_begin < 0) {
            ((MWUParser.GroupInfo)this.bufferedToken).addElement(new MWUParser.StartGroupInfo(n, n2, n3));
        }
        ++this.compoundGroupOpened;
        return 0;
    }
}

