/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.LPS;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.data.DecompositionRuleSetFactory;
import com.ibm.dltj.parser.ClassificationParsingStream;
import com.ibm.dltj.parser.LemmaParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.impl.ClassificationMWUParsingStreamImpl;
import com.ibm.dltj.parser.impl.DelayParsingStream;
import com.ibm.dltj.parser.impl.PreLemmatization;
import com.ibm.dltj.parser.impl.SimpleParsingStream;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;

public class Session
implements UniLexAnalyzerConstants {
    UniLexAnalyzer uan;
    public static final int DLTSESSION_LEX = 0;
    public static final int DLTSESSION_SPELL = 1;
    public int sessionType = 0;
    public static final int Delay_sentence = 2;
    public static final int Delay_paragraph = 2;
    public static final int PROCMODE_ALLCASE = 1;
    public static final int PROCMODE_LOWERCASE = 3;
    public static final int PROCMODE_MW_PROCESSING = 3;
    public static final int PROCMODE_MW_BUILDING = 4;
    public static final int MW_BOUNDARY_SENTENCE = 1;
    public static final int MW_BOUNDARY_PARAGRAPH = 2;
    public static final int MW_BOUNDARY_END = 3;
    public static final int MW_STYLE_AS_MET = 1;
    public static final int MW_STYLE_LONGEST_ONLY = 2;
    public static final int MW_STYLE_LOGICAL_ORDER = 3;
    public static final int MW_STYLE_LONGEST_MW_AND_TOKENS = 4;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected Session() {
    }

    public Session(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.language"));
        }
        this.uan = UniLexAnalyzer.getUniLexAnalyzer(new ULocale(string));
    }

    public Session(Locale locale) throws DLTException {
        if (locale == null) {
            throw new DLTException(Messages.getString("null.language"));
        }
        this.uan = UniLexAnalyzer.getUniLexAnalyzer(ULocale.forLocale((Locale)locale));
    }

    public Session(ULocale uLocale) throws DLTException {
        if (uLocale == null) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        this.uan = UniLexAnalyzer.getUniLexAnalyzer(uLocale);
    }

    public void setBreakIteratorByLocale(ULocale uLocale) throws DLTException {
        this.uan.setBreakIteratorByLocale(uLocale);
    }

    public void setBreakIteratorByLocaleString(String string) throws DLTException {
        this.setBreakIteratorByLocale(string == null || string.length() == 0 ? null : new ULocale(string));
    }

    public void setBreakIteratorByFilename(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        this.uan.setBreakIteratorByFilename(string);
    }

    public void setDecompositionRulesByFilename(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        this.uan.setDecompositionRules(DecompositionRuleSetFactory.getDecompositionRulesByFilename(string));
    }

    public void setProcessingMode(int n) {
        this.uan.setProcessingMode(n);
    }

    public void setCaseStrictMode(boolean bl) {
        this.uan.setCaseStrictMode(bl);
    }

    public void setGuessingMode(int n) {
        this.uan.setGuessingMode(n);
    }

    public void setTransliteratorRuleByFilename(String string) {
        this.uan.setTransliteratorRuleByFilename(string);
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3) throws DLTException {
        this.uan.setDictionaries(dictionaryArray, dictionaryArray2, dictionaryArray3);
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3, Dictionary[] dictionaryArray4) throws DLTException {
        this.uan.setDictionaries(dictionaryArray, dictionaryArray2, dictionaryArray3, dictionaryArray4);
    }

    public void open(Dictionary[] dictionaryArray, int n) throws DLTException {
        this.open(dictionaryArray, n, 1, 0, 0);
    }

    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        this.open(dictionaryArray, n, n2, n3, 0);
    }

    public synchronized void open(Dictionary[] dictionaryArray, int n, int n2, int n3, int n4) throws DLTException {
        this.sessionType = n4;
        this.uan.parentSession = this;
        this.uan.open(dictionaryArray, n, n2, n3);
    }

    public void open(int n, int n2, int n3) throws DLTException {
        this.sessionType = 0;
        this.uan.parentSession = this;
        this.uan.open(n, n2, n3);
    }

    @Deprecated
    public synchronized LPS processText(String string) throws DLTException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.processText(stringCharacterIterator);
    }

    @Deprecated
    public synchronized LPS processText(CharacterIterator characterIterator) throws DLTException {
        SimpleParsingStream simpleParsingStream = new SimpleParsingStream();
        this.uan.processText(characterIterator, simpleParsingStream);
        return new LPS(simpleParsingStream.getFirst().next);
    }

    public synchronized void processText(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        this.uan.processText(characterIterator, parsingStream);
    }

    public synchronized void delayProcessedText(CharacterIterator characterIterator, LemmaParsingStream lemmaParsingStream, int n) throws DLTException {
        DelayParsingStream delayParsingStream = new DelayParsingStream(lemmaParsingStream, n, characterIterator);
        this.uan.processText(characterIterator, delayParsingStream);
    }

    public synchronized void delayProcessedText(CharacterIterator characterIterator, LemmaParsingStream lemmaParsingStream) throws DLTException {
        this.delayProcessedText(characterIterator, lemmaParsingStream, 2);
    }

    public synchronized void processText(CharacterIterator characterIterator, LemmaParsingStream lemmaParsingStream) throws DLTException {
        PreLemmatization preLemmatization = new PreLemmatization(lemmaParsingStream, characterIterator);
        this.uan.processText(characterIterator, preLemmatization);
    }

    public synchronized void processText(CharacterIterator characterIterator, ClassificationParsingStream classificationParsingStream) throws DLTException {
        ClassificationMWUParsingStreamImpl classificationMWUParsingStreamImpl = new ClassificationMWUParsingStreamImpl(this.uan, classificationParsingStream);
        this.uan.processText(characterIterator, classificationMWUParsingStreamImpl);
    }

    public synchronized void processTextMW(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        this.uan.processTextMW(characterIterator, parsingStream);
    }

    public synchronized void processTextMW(CharacterIterator characterIterator, ClassificationParsingStream classificationParsingStream) throws DLTException {
        this.uan.processTextMW(characterIterator, classificationParsingStream);
    }

    public synchronized void processTextMW(CharacterIterator characterIterator, ParsingStream parsingStream, int n, int n2) throws DLTException {
        this.uan.processTextMW(characterIterator, parsingStream, n, n2);
    }

    public synchronized void processTextMW(CharacterIterator characterIterator, ClassificationParsingStream classificationParsingStream, int n, int n2) throws DLTException {
        this.uan.processTextMW(characterIterator, classificationParsingStream, n, n2);
    }

    public synchronized void close() {
        try {
            this.uan.close();
        }
        catch (DLTException dLTException) {
            throw new Error(dLTException.getMessage());
        }
    }

    public void dispose() {
    }

    public boolean valid() {
        return true;
    }

    @Deprecated
    public synchronized void processTextBuffered(char[] cArray, int n, int n2, ParsingStream parsingStream) throws DLTException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray), n, n2, n);
        this.uan.processText(stringCharacterIterator, parsingStream);
    }

    public int getCaseHandlingMethod() {
        return this.uan.getCaseHandlingMethod();
    }

    public void setCaseHandlingMethod(int n) {
        this.uan.setCaseHandlingMethod(n);
    }
}

