/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.UniMorphoSyntax;
import com.ibm.dltj.data.BreakIteratorManager;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.util.ArrayList;

public class SimpleWordTokenizer {
    private final Dictionary rbbiDict;
    private final MatchBuffer break_matches = new MatchBuffer();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public SimpleWordTokenizer() throws DLTException {
        this.rbbiDict = BreakIteratorManager.constructBreakIterator(null);
    }

    public SimpleWordTokenizer(String string) throws DLTException {
        this.rbbiDict = BreakIteratorManager.constructBreakIterator(new ULocale(string));
    }

    public ArrayList<Token> tokenize(CharacterIterator characterIterator) throws DLTException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        while (characterIterator.getIndex() < characterIterator.getEndIndex()) {
            int n = characterIterator.getIndex();
            TokenClassGloss tokenClassGloss = UniMorphoSyntax.evaluateBreakRules(characterIterator, this.break_matches, this.rbbiDict);
            if (!tokenClassGloss.is(452)) continue;
            arrayList.add(new Token(n, characterIterator.getIndex()));
        }
        return arrayList;
    }

    public ArrayList<TokenWithType> tokenizeWithType(CharacterIterator characterIterator) throws DLTException {
        ArrayList<TokenWithType> arrayList = new ArrayList<TokenWithType>();
        while (characterIterator.getIndex() < characterIterator.getEndIndex()) {
            int n = characterIterator.getIndex();
            TokenClassGloss tokenClassGloss = UniMorphoSyntax.evaluateBreakRules(characterIterator, this.break_matches, this.rbbiDict);
            if (!tokenClassGloss.is(452)) continue;
            arrayList.add(new TokenWithType(n, characterIterator.getIndex(), tokenClassGloss));
        }
        return arrayList;
    }

    public static class TokenWithType
    extends Token {
        private final TokenClassGloss typeGloss;

        public TokenClassGloss getTypeGloss() {
            return this.typeGloss;
        }

        public TokenWithType(int n, int n2, TokenClassGloss tokenClassGloss) {
            super(n, n2);
            this.typeGloss = tokenClassGloss;
        }
    }

    public static class Token {
        private final int begin;
        private final int end;

        public Token(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

