/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.MisspeltWord;
import com.ibm.dltj.RepeatedWordsChecker;
import com.ibm.dltj.Session;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.data.BreakIteratorManager;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.LangNameGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.icu.util.ULocale;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SpellCheckerSession
extends Session {
    public Dictionary[] dictionaries = new Dictionary[]{SpellCheckerSession.getRegexDictionary()};
    private Dictionary addenda;
    private Dictionary ignored;
    private boolean checkRepeatedWords = false;
    private static Gloss ignoreMset;
    private static Gloss addendaFeatureSetGloss;
    public static final String ignoredWordsTagPrefix = "ignored_";
    private static int minExtSize;
    private boolean checkStandaloneConstraint = true;
    private boolean checkFirstWordOfSentence = false;
    private static final ULocale SPELL_CHECK_LOCALE_REGEX;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private static Dictionary getRegexDictionary() throws DLTException {
        return BreakIteratorManager.constructBreakIterator(SPELL_CHECK_LOCALE_REGEX);
    }

    public SpellCheckerSession(String string) throws DLTException {
        super(string);
        this.checkLocale(this.uan._locale);
    }

    public SpellCheckerSession(ULocale uLocale) throws DLTException {
        super(uLocale);
        this.checkLocale(this.uan._locale);
    }

    public SpellCheckerSession(Dictionary[] dictionaryArray, String string) throws DLTException {
        this(string);
        if (dictionaryArray == null) {
            throw new DLTException(Messages.getString("null.array"));
        }
        Dictionary[] dictionaryArray2 = new Dictionary[dictionaryArray.length + 1];
        System.arraycopy(dictionaryArray, 0, dictionaryArray2, 0, dictionaryArray.length);
        dictionaryArray2[dictionaryArray2.length - 1] = this.dictionaries[0];
        this.dictionaries = dictionaryArray2;
        this.addenda = null;
        this.ignored = null;
    }

    public SpellCheckerSession(Dictionary[] dictionaryArray, int n, String string) throws DLTException {
        this(string);
        if (dictionaryArray == null) {
            throw new DLTException(Messages.getString("null.array"));
        }
        Dictionary[] dictionaryArray2 = new Dictionary[dictionaryArray.length + 2];
        System.arraycopy(dictionaryArray, 0, dictionaryArray2, 0, dictionaryArray.length);
        if (n != -1) {
            this.addenda = dictionaryArray2[n];
            addendaFeatureSetGloss = this.addenda.addFeatureSetGloss(0, 1, false, false, true, true);
        } else {
            this.addenda = null;
            addendaFeatureSetGloss = null;
        }
        dictionaryArray2[dictionaryArray2.length - 2] = this.dictionaries[0];
        String string2 = ignoredWordsTagPrefix + string + "_tokens";
        dictionaryArray2[dictionaryArray2.length - 1] = this.ignored = this.prepareIgnoredTokenDictionary(string2);
        this.dictionaries = dictionaryArray2;
    }

    private Dictionary prepareIgnoredTokenDictionary(String string) throws DLTException {
        Dictionary dictionary = Dictionary.createDictionary(new DictionaryInfo(), minExtSize);
        dictionary.registerType(15, string);
        dictionary.registerType(16, string);
        dictionary.registerType(1, string);
        dictionary.registerType(12, string);
        Gloss gloss = dictionary.addFeatureSetGloss(0, 1, false, false, true, false);
        Gloss gloss2 = dictionary.addLanguageGloss(string, 0);
        Gloss gloss3 = dictionary.addGloss(12, new CutPasteGloss("", 0, 0, 0));
        ignoreMset = dictionary.addMorphGloss(new Gloss[]{gloss, gloss3, gloss2});
        return dictionary;
    }

    public synchronized void open() throws DLTException {
        super.open(this.dictionaries, 0, 1 | (SpellCheckerSession.splitOnHyphenDefault(this.uan._locale) ? 0 : 2), 0, 1);
        this.uan.caseExpandFirstWord = this.checkFirstWordOfSentence ? 268700160 : 268700161;
    }

    @Override
    public void open(Dictionary[] dictionaryArray, int n) throws DLTException {
        super.open(dictionaryArray, n, 1, 0, 1);
        this.uan.caseExpandFirstWord = this.checkFirstWordOfSentence ? 268700160 : 268700161;
    }

    @Override
    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2, n3, 1);
        this.uan.caseExpandFirstWord = this.checkFirstWordOfSentence ? 268700160 : 268700161;
    }

    @Override
    public synchronized void open(Dictionary[] dictionaryArray, int n, int n2, int n3, int n4) throws DLTException {
        super.open(dictionaryArray, n, n2, n3, n4);
        this.uan.caseExpandFirstWord = this.checkFirstWordOfSentence ? 268700160 : 268700161;
    }

    @Override
    public void open(int n, int n2, int n3) throws DLTException {
        super.open(this.dictionaries, n, n2, n3, 1);
        this.uan.caseExpandFirstWord = this.checkFirstWordOfSentence ? 268700160 : 268700161;
    }

    public List<MisspeltWord> checkSpelling(String string) throws DLTException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.checkSpelling(stringCharacterIterator);
    }

    public synchronized List<MisspeltWord> checkSpelling(CharacterIterator characterIterator) throws DLTException {
        SpellParsingStream spellParsingStream = new SpellParsingStream();
        spellParsingStream.setCheckBOFA_FLAG_ALONE(this.checkStandaloneConstraint);
        if (this.checkRepeatedWords) {
            RepeatedWordsChecker repeatedWordsChecker = new RepeatedWordsChecker(spellParsingStream);
            super.processTextMW(characterIterator, repeatedWordsChecker, 1, 2);
        } else {
            super.processTextMW(characterIterator, spellParsingStream, 1, 2);
        }
        return spellParsingStream.retList;
    }

    public boolean getCheckRepeatedWords() {
        return this.checkRepeatedWords;
    }

    public void setCheckRepeatedWords(boolean bl) {
        this.checkRepeatedWords = bl;
    }

    public void saveAddenda() throws DLTException, FileNotFoundException, IOException {
        if (this.addenda == null) {
            return;
        }
        this.addenda.lockWrite();
        this.addenda.save();
        this.addenda.unlockWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWordToAddenda(String string) {
        if (this.addenda == null) {
            return;
        }
        try {
            this.addenda.lockWrite();
            this.addAddendaWord(string);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.addenda.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWordToAddendaWithError(String string) throws DLTException {
        if (this.addenda == null) {
            return;
        }
        this.addenda.lockWrite();
        try {
            this.addAddendaWord(string);
        }
        finally {
            this.addenda.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWordToAddenda(String[] stringArray) {
        if (this.addenda == null) {
            return;
        }
        try {
            this.addenda.lockWrite();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addAddendaWord(stringArray[i]);
            }
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.addenda.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    private void addAddendaWord(String string) throws DLTException {
        Gloss gloss = this.addenda.addGloss(28, new CaseGloss(string));
        Gloss gloss2 = this.addenda.addMorphGloss(new Gloss[]{addendaFeatureSetGloss, gloss});
        this.addenda.addWord(new StringCharacterIterator(string), string.length(), gloss2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreWord(String string) {
        if (this.ignored == null) {
            return;
        }
        try {
            this.ignored.lockWrite();
            this.ignored.addWord(new StringCharacterIterator(string), string.length(), ignoreMset);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.ignored.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWordFromAdenda(String string) {
        try {
            this.addenda.lockWrite();
            this.addenda.removeWord(string, null);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.addenda.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    @Override
    public void dispose() {
        this.dictionaries = null;
    }

    public static int getMinExtSize() {
        return minExtSize;
    }

    public static void setMinExtSize(int n) {
        minExtSize = n;
    }

    private void checkLocale(ULocale uLocale) {
        if (UniLexAnalyzer.isSameLanguage(uLocale, FINNISH)) {
            this.checkStandaloneConstraint = false;
        }
    }

    public static boolean splitOnHyphenDefault(ULocale uLocale) {
        return UniLexAnalyzer.isSameLanguage(uLocale, SPANISH) || UniLexAnalyzer.isSameLanguage(uLocale, ITALIAN) || UniLexAnalyzer.isSameLanguage(uLocale, GERMAN) || UniLexAnalyzer.isSameLanguage(uLocale, DUTCH) || UniLexAnalyzer.isSameLanguage(uLocale, BOKMAL) || UniLexAnalyzer.isSameLanguage(uLocale, NYNORSK) || UniLexAnalyzer.isSameLanguage(uLocale, SWEDISH) || UniLexAnalyzer.isSameLanguage(uLocale, DANISH) || UniLexAnalyzer.isSameLanguage(uLocale, FINNISH) || UniLexAnalyzer.isSameLanguage(uLocale, CATALAN) || UniLexAnalyzer.isSameLanguage(uLocale, AFRIKAANS);
    }

    public void setCheckFirstWordOfSentence(boolean bl) {
        this.checkFirstWordOfSentence = bl;
    }

    static {
        minExtSize = 65544;
        SPELL_CHECK_LOCALE_REGEX = new ULocale("clitics", "", "regex");
    }

    private static class SpellParsingStream
    implements MWUParsingStream {
        final List<MisspeltWord> retList = new LinkedList<MisspeltWord>();
        private UniLexAnalyzer analyzer;
        private boolean isCompoundGroup = false;
        private boolean checkBOFA_FLAG_ALONE = false;

        SpellParsingStream() {
        }

        @Override
        public void reset(UniLexAnalyzer uniLexAnalyzer) {
            this.analyzer = uniLexAnalyzer;
            this.isCompoundGroup = false;
            if (this.checkBOFA_FLAG_ALONE && this.analyzer instanceof UniLexAnalyzerEu) {
                this.analyzer.decompFlags |= 1;
            }
        }

        @Override
        public void close() {
            this.analyzer = null;
        }

        @Override
        public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
            Gloss gloss;
            if (glossCollection == null) {
                return;
            }
            Iterator iterator = glossCollection.iterator();
            boolean bl = false;
            boolean bl2 = false;
            while (iterator.hasNext()) {
                Gloss gloss2 = (Gloss)iterator.next();
                gloss = null;
                if (gloss2 instanceof MidGloss) {
                    MidGloss midGloss = (MidGloss)gloss2;
                    LangNameGloss langNameGloss = (LangNameGloss)midGloss.getGloss(16);
                    if (langNameGloss != null && langNameGloss.value.startsWith(SpellCheckerSession.ignoredWordsTagPrefix)) {
                        return;
                    }
                    gloss = midGloss.getFeatureGloss();
                } else if (gloss2.getType() == 15) {
                    gloss = (FeatureSetGloss)gloss2;
                }
                if (gloss == null || this.checkBOFA_FLAG_ALONE && !this.isCompoundGroup && !((FeatureSetGloss)gloss).is(101)) continue;
                if (((FeatureSetGloss)gloss).is(206)) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            if (bl2) {
                this.createUnknown(n, n2, n3, 200);
                return;
            }
            if (bl == bl2) {
                int n4;
                int n5 = this.analyzer.characterIterator.getIndex();
                gloss = this.analyzer.morphoSyntax.evaluateBreakRules(this.analyzer.characterIterator, n2, n3);
                int n6 = n4 = gloss == null ? 0 : ((TokenClassGloss)gloss).getBestClass();
                if (RBBICategory.isPunctuation(n4)) {
                    this.createPunctuation(n, n2, n3, n4);
                } else {
                    this.createUnknown(n, n2, n3, n4);
                }
                this.analyzer.characterIterator.setIndex(n5);
                return;
            }
        }

        @Override
        public void createBreakpoint(int n, int n2, int n3) {
        }

        @Override
        public void createPunctuation(int n, int n2, int n3, int n4) {
        }

        @Override
        public int startGroup(int n, int n2, int n3) {
            if (n3 == 1 || n3 == 4) {
                this.isCompoundGroup = true;
            }
            return 0;
        }

        @Override
        public void closeGroup(int n) {
            this.isCompoundGroup = false;
        }

        @Override
        public void fork() {
        }

        @Override
        public void addToFork() {
        }

        @Override
        public void mergeRoutes(int n) {
        }

        @Override
        public void createUnknown(int n, int n2, int n3, int n4) {
            this.retList.add(new MisspeltWord(n2, n3, n4));
        }

        public void setCheckBOFA_FLAG_ALONE(boolean bl) {
            this.checkBOFA_FLAG_ALONE = bl;
            if (this.checkBOFA_FLAG_ALONE && this.analyzer instanceof UniLexAnalyzerEu) {
                this.analyzer.decompFlags |= 1;
            }
        }

        @Override
        public void createMWU(int n, int n2, int n3, Gloss gloss) {
        }
    }
}

