/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.ISuggestionValidator;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.util.CharacterFilterSpecification;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;

public class SuggestionValidator
extends SpellCheckerSession
implements ISuggestionValidator {
    ValidatorParsingStream ps = new ValidatorParsingStream();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public SuggestionValidator(Dictionary[] dictionaryArray, String string) throws DLTException {
        super(dictionaryArray, string);
    }

    @Override
    public boolean isValidSuggestion(String string) throws DLTException {
        return this.isValidSuggestion(new StringCharacterIterator(string));
    }

    @Override
    public boolean isValidSuggestion(CharacterIterator characterIterator) throws DLTException {
        this.ps.validSuggestion = true;
        super.processText(characterIterator, this.ps);
        return this.ps.validSuggestion;
    }

    @Override
    public int getCaseHandlingMethod() {
        return this.uan.morphoSyntax.getCaseHandlingMethod();
    }

    @Override
    public CharacterFilterSpecification getCharacterFilter() {
        return this.uan;
    }

    private static class ValidatorParsingStream
    implements ParsingStream {
        public boolean validSuggestion = true;
        private UniLexAnalyzer analyzer;
        private boolean isCompoundGroup = false;
        private boolean checkBOFA_FLAG_ALONE = false;
        private boolean checkIsFirstWord = false;

        ValidatorParsingStream() {
        }

        @Override
        public void reset(UniLexAnalyzer uniLexAnalyzer) {
            this.analyzer = uniLexAnalyzer;
            this.isCompoundGroup = false;
            if (this.checkBOFA_FLAG_ALONE && this.analyzer instanceof UniLexAnalyzerEu) {
                this.analyzer.decompFlags |= 1;
            }
        }

        @Override
        public void close() {
            this.analyzer = null;
        }

        @Override
        public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
            if (!this.validSuggestion) {
                return;
            }
            if (glossCollection == null) {
                return;
            }
            Iterator iterator = glossCollection.iterator();
            FeatureSetGloss featureSetGloss = null;
            while (iterator.hasNext()) {
                Gloss gloss = (Gloss)iterator.next();
                if (gloss.getType() == 1) {
                    featureSetGloss = ((MidGloss)gloss).getFeatureGloss();
                } else if (gloss.getType() == 15) {
                    featureSetGloss = (FeatureSetGloss)gloss;
                } else if (gloss.getType() != 17) {
                    this.validSuggestion = false;
                    return;
                }
                if (featureSetGloss == null) continue;
                if (!featureSetGloss.is(206)) {
                    this.validSuggestion = false;
                    return;
                }
                if (featureSetGloss.is(207)) continue;
                this.validSuggestion = false;
                return;
            }
            this.validSuggestion = featureSetGloss != null;
        }

        @Override
        public void createBreakpoint(int n, int n2, int n3) {
        }

        @Override
        public void createPunctuation(int n, int n2, int n3, int n4) {
            this.createUnknown(n, n2, n3, 1);
        }

        @Override
        public int startGroup(int n, int n2, int n3) {
            if (n3 == 1) {
                this.isCompoundGroup = true;
            }
            return 0;
        }

        @Override
        public void closeGroup(int n) {
            this.isCompoundGroup = false;
        }

        @Override
        public void fork() {
        }

        @Override
        public void addToFork() {
        }

        @Override
        public void mergeRoutes(int n) {
        }

        @Override
        public void createUnknown(int n, int n2, int n3, int n4) {
            this.validSuggestion = false;
        }

        public void setCheckBOFA_FLAG_ALONE(boolean bl) {
            this.checkBOFA_FLAG_ALONE = bl;
            if (this.checkBOFA_FLAG_ALONE && this.analyzer instanceof UniLexAnalyzerEu) {
                this.analyzer.decompFlags |= 1;
            }
        }

        public void setCheckIsFirstWord(boolean bl) {
            this.checkIsFirstWord = bl;
        }
    }
}

