/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.data.ICUTransliteratorFactory;
import com.ibm.dltj.util.Guesser;
import com.ibm.dltj.util.GuesserUtil;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class TransliteratingGuesser
implements Guesser {
    private final UniLexAnalyzer analyzer;
    private final Transliterator translitetator;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public TransliteratingGuesser(UniLexAnalyzer uniLexAnalyzer, ULocale uLocale) throws DLTException {
        this.analyzer = uniLexAnalyzer;
        ICUTransliteratorFactory iCUTransliteratorFactory = new ICUTransliteratorFactory();
        this.translitetator = iCUTransliteratorFactory.getTransliterator(uLocale);
    }

    public TransliteratingGuesser(UniLexAnalyzer uniLexAnalyzer, ULocale uLocale, String string) throws DLTException {
        this.analyzer = uniLexAnalyzer;
        ICUTransliteratorFactory iCUTransliteratorFactory = new ICUTransliteratorFactory(string);
        this.translitetator = iCUTransliteratorFactory.getTransliterator(uLocale);
    }

    @Override
    public String guess(String string) {
        if (this.translitetator == null) {
            return null;
        }
        String string2 = this.translitetator.transliterate(string);
        if (!string.equals(string2)) {
            return string2;
        }
        return null;
    }

    @Override
    public String guess(CharacterIterator characterIterator, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        UniLexAnalyzer.memcpy(stringBuffer, characterIterator, n, n2);
        return this.guess(stringBuffer.toString());
    }

    @Override
    public GlossCollection guessingLookup(CharacterIterator characterIterator, int n, int n2) {
        String string = this.guess(characterIterator, n, n2);
        if (string == null) {
            return null;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        GlossCollection glossCollection = this.analyzer.dictLookupWord(stringCharacterIterator, string.length());
        if (glossCollection != null) {
            return GuesserUtil.adaptLemmaForGuess(string, glossCollection);
        }
        return null;
    }

    @Override
    public int getType() {
        return 2;
    }
}

