/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;

class UniDictionaryManager {
    private HashSet<Dictionary> allUsedDicts = new HashSet(17);
    static Dictionary[] EMPTY_DICT_ARRAY = new Dictionary[0];
    Dictionary[] dictionaries = EMPTY_DICT_ARRAY;
    Dictionary[] oov_dictionaries = EMPTY_DICT_ARRAY;
    Dictionary[] mw_dictionaries_old = EMPTY_DICT_ARRAY;
    Dictionary[] mw_dictionaries_new = EMPTY_DICT_ARRAY;
    Dictionary[] tcr_dictionaries = EMPTY_DICT_ARRAY;
    Dictionary[] nta_dictionaries = EMPTY_DICT_ARRAY;
    Dictionary break_rules = null;
    private int processingMode = 1;
    private int guessingMode = 0;
    private int case_handling_method = 0x17171717;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public void setProcessingMode(int n) {
        this.processingMode = n;
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public int getGuessingMode() {
        return this.guessingMode;
    }

    public void setGuessingMode(int n) {
        this.guessingMode = n;
    }

    private void processDictionaryList(Dictionary[] dictionaryArray, Collection<Dictionary> collection, Collection<Dictionary> collection2, Collection<Dictionary> collection3) throws DLTException {
        if (dictionaryArray != null) {
            LinkedHashSet<Dictionary> linkedHashSet = new LinkedHashSet<Dictionary>(dictionaryArray.length);
            linkedHashSet.addAll(Arrays.asList(this.dictionaries));
            boolean bl = false;
            for (int i = 0; i < dictionaryArray.length; ++i) {
                if (dictionaryArray[i] == null) {
                    throw new DLTException(Messages.format("dict.ref.null", i));
                }
                if (!dictionaryArray[i].valid()) {
                    throw new DLTException(Messages.format("invalid.dict1", dictionaryArray[i].getFile() != null ? dictionaryArray[i].getFile().getAbsolutePath() : null));
                }
                if (dictionaryArray[i].getSummary().hasFunction(85)) {
                    if (bl) {
                        throw new DLTException(Messages.getString("error.break.multiple"));
                    }
                    this.break_rules = dictionaryArray[i];
                    bl = true;
                    continue;
                }
                if (dictionaryArray[i].getSummary().hasFunction(26)) {
                    collection2.add(dictionaryArray[i]);
                    continue;
                }
                if (dictionaryArray[i].getSummary().getAffectsTokenization() == -1) {
                    collection3.add(dictionaryArray[i]);
                    continue;
                }
                if (dictionaryArray[i].fsa.first() != null) {
                    linkedHashSet.add(dictionaryArray[i]);
                }
                if (!dictionaryArray[i].isMWUDictionary()) continue;
                collection.add(dictionaryArray[i]);
            }
            this.dictionaries = linkedHashSet.toArray(this.dictionaries);
        }
    }

    public void setDictionaries(Dictionary[] dictionaryArray) throws DLTException {
        this.setDictionaries(dictionaryArray, null, null, null);
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3) throws DLTException {
        this.setDictionaries(dictionaryArray, dictionaryArray2, null, dictionaryArray3);
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3, Dictionary[] dictionaryArray4) throws DLTException {
        int n;
        LinkedHashSet<Dictionary> linkedHashSet = new LinkedHashSet<Dictionary>();
        LinkedHashSet<Dictionary> linkedHashSet2 = new LinkedHashSet<Dictionary>();
        LinkedHashSet linkedHashSet3 = new LinkedHashSet();
        LinkedHashSet<Dictionary> linkedHashSet4 = new LinkedHashSet<Dictionary>();
        linkedHashSet.addAll(Arrays.asList(this.mw_dictionaries_new));
        linkedHashSet2.addAll(Arrays.asList(this.oov_dictionaries));
        linkedHashSet4.addAll(Arrays.asList(this.nta_dictionaries));
        this.processDictionaryList(dictionaryArray, linkedHashSet, linkedHashSet2, linkedHashSet4);
        if (dictionaryArray2 != null) {
            for (n = 0; n < dictionaryArray2.length; ++n) {
                if (dictionaryArray2[n] == null || !dictionaryArray2[n].valid()) {
                    throw new DLTException(Messages.getString("invalid.OOVdict"));
                }
                if (!dictionaryArray2[n].getSummary().isLowerCase()) continue;
                this.setProcessingMode(3);
            }
            linkedHashSet2.addAll(Arrays.asList(dictionaryArray2));
        }
        this.oov_dictionaries = linkedHashSet2.toArray(this.oov_dictionaries);
        if (dictionaryArray4 != null && dictionaryArray4.length > 0) {
            LinkedHashSet<Dictionary> linkedHashSet5 = new LinkedHashSet<Dictionary>();
            linkedHashSet5.addAll(Arrays.asList(this.mw_dictionaries_old));
            for (int i = 0; i < dictionaryArray4.length; ++i) {
                if (!dictionaryArray4[i].isMWUDictionary()) {
                    linkedHashSet5.add(dictionaryArray4[i]);
                    continue;
                }
                linkedHashSet.add(dictionaryArray4[i]);
            }
            this.mw_dictionaries_old = linkedHashSet5.toArray(this.mw_dictionaries_old);
            if (!linkedHashSet5.isEmpty()) {
                this.setProcessingMode(3);
            }
        }
        this.mw_dictionaries_new = linkedHashSet.toArray(this.mw_dictionaries_new);
        if (dictionaryArray3 != null) {
            for (n = 0; n < dictionaryArray3.length; ++n) {
                if (dictionaryArray3[n] == null) {
                    throw new DLTException(Messages.format("dict.ref.null", n));
                }
                if (dictionaryArray3[n].valid()) continue;
                throw new DLTException(Messages.format("invalid.dict1", dictionaryArray3[n].getFile().getAbsolutePath()));
            }
            if (linkedHashSet3.isEmpty()) {
                this.tcr_dictionaries = (Dictionary[])dictionaryArray3.clone();
            } else {
                LinkedHashSet<Dictionary> linkedHashSet6 = new LinkedHashSet<Dictionary>();
                linkedHashSet6.addAll(Arrays.asList(this.tcr_dictionaries));
                linkedHashSet6.addAll(Arrays.asList(dictionaryArray3));
                this.tcr_dictionaries = linkedHashSet6.toArray(this.tcr_dictionaries);
            }
        }
        this.nta_dictionaries = linkedHashSet4.toArray(this.nta_dictionaries);
    }

    public void setBreakRules(Dictionary dictionary) {
        this.break_rules = dictionary;
    }

    public Dictionary getBreakRules() {
        return this.break_rules;
    }

    public void close() throws DLTException {
        this.unlockReadDictionaries();
        this.dictionaries = EMPTY_DICT_ARRAY;
        this.oov_dictionaries = EMPTY_DICT_ARRAY;
        this.mw_dictionaries_old = EMPTY_DICT_ARRAY;
        this.mw_dictionaries_new = EMPTY_DICT_ARRAY;
        this.tcr_dictionaries = EMPTY_DICT_ARRAY;
        this.nta_dictionaries = EMPTY_DICT_ARRAY;
        this.break_rules = null;
        this.allUsedDicts.clear();
    }

    private void lockReadDictionary(Dictionary dictionary) throws DLTException {
        if (dictionary == null) {
            return;
        }
        if (!this.allUsedDicts.contains(dictionary)) {
            this.allUsedDicts.add(dictionary);
            dictionary.lockRead();
        }
    }

    void lockReadDictionaries() throws DLTException {
        this.allUsedDicts.clear();
        this.lockReadDictionary(this.break_rules);
        for (Dictionary dictionary : this.dictionaries) {
            this.lockReadDictionary(dictionary);
        }
        for (Dictionary dictionary : this.oov_dictionaries) {
            this.lockReadDictionary(dictionary);
        }
        for (Dictionary dictionary : this.mw_dictionaries_new) {
            this.lockReadDictionary(dictionary);
        }
        for (Dictionary dictionary : this.mw_dictionaries_old) {
            this.lockReadDictionary(dictionary);
        }
        for (Dictionary dictionary : this.tcr_dictionaries) {
            this.lockReadDictionary(dictionary);
        }
        for (Dictionary dictionary : this.nta_dictionaries) {
            this.lockReadDictionary(dictionary);
        }
    }

    void unlockReadDictionaries() throws DLTException {
        for (Dictionary dictionary : this.allUsedDicts) {
            dictionary.unlockRead();
        }
    }

    public final int getCaseHandlingMethod() {
        return this.case_handling_method;
    }

    public final void setCaseHandlingMethod(int n) {
        this.case_handling_method = n;
    }
}

