/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.MWDecorator;
import com.ibm.dltj.Messages;
import com.ibm.dltj.Session;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.UniLexAnalyzerAr;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.UniLexAnalyzerFi;
import com.ibm.dltj.UniLexAnalyzerJa;
import com.ibm.dltj.UniLexAnalyzerKo;
import com.ibm.dltj.UniLexAnalyzerTh;
import com.ibm.dltj.UniLexAnalyzerZh;
import com.ibm.dltj.UniMorphoSyntax;
import com.ibm.dltj.data.BreakIteratorManager;
import com.ibm.dltj.decomposition.DecompositionRuleSet;
import com.ibm.dltj.fst.MWUDictionary;
import com.ibm.dltj.fst.MWUParser;
import com.ibm.dltj.fst.NTAParser;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.ClassificationMWUParsingStream;
import com.ibm.dltj.parser.ClassificationParsingStream;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.impl.ClassificationMWUParsingStreamImpl;
import com.ibm.dltj.util.CharacterFilterSpecification;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class UniLexAnalyzer
implements UniLexAnalyzerConstants,
CharacterFilterSpecification {
    protected boolean inSentence;
    protected boolean isFirstWord = true;
    UniMorphoSyntax morphoSyntax = null;
    int caseExpandFirstWord = 268700161;
    int caseExpandOtherWord = 268698113;
    CharacterIterator characterIterator = null;
    Session parentSession = null;
    ParsingStream m_pLPS;
    ULocale _locale = null;
    int _hints;
    int _flagSpec;
    public static final int OOV_SHORTWORD_THRESHOLD = 5;
    public static final int DECOMP_LIKE_GERMAN = 1;
    protected int decompFlags;
    private int decompGroupN;
    protected String transliteratorRuleFile = null;
    private static final ULocale SPELL_CHECK_LOCALE = new ULocale("clitics", "", "");
    private static final ULocale SPELL_CHECK_HYPHEN_LOCALE = new ULocale("clitics", "", "hyphen");
    private static final Map<ULocale, String> languageCache = new LinkedHashMap<ULocale, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<ULocale, String> entry) {
            return this.size() > 30;
        }
    };

    public CharacterIterator getSourceText() {
        return this.characterIterator != null ? (CharacterIterator)this.characterIterator.clone() : null;
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Deprecated
    protected UniLexAnalyzer(String string) {
        this(new ULocale(string));
    }

    protected UniLexAnalyzer(ULocale uLocale) {
        this.morphoSyntax = UniMorphoSyntax.getMorphoSyntax(uLocale);
        this._locale = uLocale;
        this.setCaseStrictMode(true);
    }

    public ParsingStream getParsingStream() {
        return this.m_pLPS;
    }

    public void setDecompFlag(int n) {
        this.decompFlags |= n;
    }

    public void setBreakIteratorByLocale(ULocale uLocale) throws DLTException {
        this.morphoSyntax.setBreakRules(BreakIteratorManager.constructBreakIterator(uLocale));
    }

    public void setBreakIteratorByInstance(Object object) throws DLTException {
        this.morphoSyntax.setBreakRules((Dictionary)object);
    }

    public void setBreakIteratorByFilename(String string) throws DLTException {
        this.morphoSyntax.setBreakRules(BreakIteratorManager.constructBreakIteratorByFile(string));
    }

    public void setProcessingMode(int n) {
        this.morphoSyntax.setProcessingMode(n);
    }

    public void setCaseStrictMode(boolean bl) {
        if (bl) {
            if (UniLexAnalyzer.isSameLanguage(this._locale, GERMAN)) {
                this.morphoSyntax.setCaseHandlingMethod(67372557);
            } else {
                this.morphoSyntax.setCaseHandlingMethod(67372551);
            }
        } else {
            this.morphoSyntax.setCaseHandlingMethod(0x17171717);
        }
    }

    public void setGuessingMode(int n) {
        this.morphoSyntax.setGuessingMode(n);
    }

    public void setTransliteratorRuleByFilename(String string) {
        this.transliteratorRuleFile = string;
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3) throws DLTException {
        this.morphoSyntax.setDictionaries(dictionaryArray, dictionaryArray2, dictionaryArray3);
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3, Dictionary[] dictionaryArray4) throws DLTException {
        this.morphoSyntax.setDictionaries(dictionaryArray, dictionaryArray2, dictionaryArray3, dictionaryArray4);
    }

    public final void open(Dictionary[] dictionaryArray) throws DLTException {
        this.open(dictionaryArray, 0, 1, 0);
    }

    public final void open(Dictionary[] dictionaryArray, int n) throws DLTException {
        this.open(dictionaryArray, n, 1, 0);
    }

    ULocale getBreakRulesLocale() throws DLTException {
        if (this.parentSession != null && this.parentSession instanceof SpellCheckerSession) {
            return (this._hints & 2) == 0 ? SPELL_CHECK_HYPHEN_LOCALE : SPELL_CHECK_LOCALE;
        }
        return this._locale;
    }

    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        this._hints = n2;
        this._flagSpec = n3;
        this.morphoSyntax.open(dictionaryArray, n, this);
    }

    public void open(int n, int n2, int n3) throws DLTException {
        this._hints = n2;
        this._flagSpec = n3;
        this.morphoSyntax.open(n, this);
    }

    @Override
    public String getEquivalentCharacters(int n) {
        return null;
    }

    public void close() throws DLTException {
        this.morphoSyntax.close();
        this.transliteratorRuleFile = null;
    }

    public final int getCasePromotion() {
        return this.isFirstWord ? this.caseExpandFirstWord : this.caseExpandOtherWord;
    }

    final boolean dictLookup(DictLookupPos dictLookupPos) {
        return this.morphoSyntax.dictLookup(this.characterIterator, dictLookupPos, this.getCasePromotion());
    }

    final boolean dictLookup(DictLookupPos dictLookupPos, CharacterIterator characterIterator) {
        return this.morphoSyntax.dictLookup(characterIterator, dictLookupPos, this.getCasePromotion());
    }

    final GlossCollection dictLookupWord(CharacterIterator characterIterator, int n) {
        return this.morphoSyntax.dictLookupWord(characterIterator, n, this.getCasePromotion());
    }

    Object oovdictLookup(CharacterIterator characterIterator, int n, int n2) {
        return this.morphoSyntax.oov_dictLookup(characterIterator, n, n2);
    }

    protected final void markSentence(int n, int n2) {
        if (this.inSentence) {
            this.m_pLPS.createBreakpoint(n2, n, 2);
            this.inSentence = false;
            this.isFirstWord = true;
        }
    }

    protected final void markParagraph(int n) {
        this.markSentence(n, 65535);
        this.m_pLPS.createBreakpoint(65535, n, 1);
        this.isFirstWord = true;
    }

    String text(int n, int n2) {
        int n3 = Math.max(n2 - n, 1);
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n4 = this.characterIterator.getIndex();
        this.characterIterator.setIndex(n);
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(this.characterIterator.current());
            this.characterIterator.next();
        }
        this.characterIterator.setIndex(n4);
        return stringBuffer.toString();
    }

    protected void insertParsedGloss(int n, int n2, GlossCollection glossCollection) {
        this.inSentence = true;
        this.m_pLPS.createStd(65535, n, n2, glossCollection);
        this.isFirstWord = false;
    }

    protected void insertTokenClassGloss(int n, int n2, TokenClassGloss tokenClassGloss) {
        if (tokenClassGloss.is(4)) {
            this.insertParsedGloss(n, n2, tokenClassGloss.getPostGloss());
        }
        if (tokenClassGloss.is(64)) {
            this.insertPunctuation(n, n2, 65535, tokenClassGloss.getBestClass());
        }
        if (tokenClassGloss.is(128)) {
            this.insertUnknown(n, n2, tokenClassGloss.getBestClass());
        }
        if (tokenClassGloss.is(256)) {
            this.insertUnknownWord(n, n2, tokenClassGloss.getBestClass());
        }
        if (tokenClassGloss.is(16)) {
            this.markSentence(n2, 65535);
        }
        if (tokenClassGloss.is(32)) {
            this.markParagraph(n2);
        }
    }

    protected void insertGlosses(int n) {
        int n2 = this.morphoSyntax.matches.getMaxIndex();
        this.insertParsedGloss(n, n2, this.collectGlosses());
    }

    protected GlossCollection collectGlosses() {
        return this.morphoSyntax.matches.collectMaxGlosses(this.morphoSyntax.cmPolicy == 1);
    }

    protected void insertPunctuation(int n, int n2, int n3) {
        this.m_pLPS.createPunctuation(n3, n, n2, 1);
    }

    protected void insertPunctuation(int n, int n2, int n3, int n4) {
        this.m_pLPS.createPunctuation(n3, n, n2, n4);
    }

    public boolean isFirstWordOfSentence() {
        return this.isFirstWord;
    }

    protected void insertUnknown(int n, int n2, int n3) {
        this.m_pLPS.createUnknown(65535, n, n2, n3);
        this.isFirstWord = false;
    }

    protected void insertUnknownWord(int n, int n2, int n3) {
        this.m_pLPS.createUnknown(65535, n, n2, n3);
        this.inSentence = true;
        this.isFirstWord = false;
    }

    protected void insertDecompElement(int n, int n2, GlossCollection glossCollection) {
        this.insertParsedGloss(n, n2, glossCollection);
    }

    protected void fork() {
        this.m_pLPS.fork();
    }

    protected void addToFork() {
        this.m_pLPS.addToFork();
    }

    protected void startDecompGroup(int n, int n2) {
        if ((1 & this.decompFlags) != 0 || (4 & this._hints) != 0) {
            this.decompGroupN = this.m_pLPS.startGroup(n, n2, 1);
        }
    }

    protected void closeDecompGroup(int n) {
        if (n > 1) {
            this.m_pLPS.mergeRoutes(n);
        }
        if ((1 & this.decompFlags) != 0 || (4 & this._hints) != 0) {
            this.m_pLPS.closeGroup(this.decompGroupN);
        }
    }

    abstract ParsingStream doProcessText(CharacterIterator var1) throws DLTException;

    public static UniLexAnalyzer getUniLexAnalyzer(ULocale uLocale) throws DLTException {
        if (uLocale == null) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        if (UniLexAnalyzer.isSameLanguage(uLocale, JAPANESE)) {
            return new UniLexAnalyzerJa(uLocale);
        }
        if (UniLexAnalyzer.isSameLanguage(uLocale, CHINESE)) {
            return new UniLexAnalyzerZh(uLocale);
        }
        if (UniLexAnalyzer.isSameLanguage(uLocale, KOREAN) && uLocale.getVariant().indexOf(KOREAN_LEGACY.getVariant()) < 0) {
            return new UniLexAnalyzerKo(uLocale);
        }
        if (UniLexAnalyzer.isSameLanguage(uLocale, THAI)) {
            return new UniLexAnalyzerTh(uLocale);
        }
        if (UniLexAnalyzer.isSameLanguage(uLocale, ARABIC)) {
            return new UniLexAnalyzerAr(uLocale);
        }
        if (UniLexAnalyzer.isSameLanguage(uLocale, FINNISH)) {
            return new UniLexAnalyzerFi(uLocale);
        }
        return new UniLexAnalyzerEu(uLocale);
    }

    @Deprecated
    public static UniLexAnalyzer getUniLexAnalyzer(Locale locale) throws DLTException {
        return UniLexAnalyzer.getUniLexAnalyzer(ULocale.forLocale((Locale)locale));
    }

    @Deprecated
    public static UniLexAnalyzer getUniLexAnalyzer(String string) throws DLTException {
        return UniLexAnalyzer.getUniLexAnalyzer(new ULocale(string));
    }

    public ParsingStream processTextMW(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        if (this.morphoSyntax.nta_dictionaries.length > 0) {
            parsingStream = new NTAParser(this.morphoSyntax.nta_dictionaries, parsingStream, this._hints, false);
        }
        if (parsingStream instanceof MWUParsingStream) {
            ArrayList<MWUDictionary> arrayList = new ArrayList<MWUDictionary>();
            for (int i = 0; i < this.morphoSyntax.mw_dictionaries_new.length; ++i) {
                if (!this.morphoSyntax.mw_dictionaries_new[i].isMWUDictionary()) continue;
                arrayList.add(this.morphoSyntax.mw_dictionaries_new[i].getMwuFsa());
            }
            if (arrayList.size() != 0) {
                parsingStream = new MWUParser(arrayList, (MWUParsingStream)parsingStream, this._locale);
            }
            if (this.morphoSyntax.mw_dictionaries_old != null && this.morphoSyntax.mw_dictionaries_old.length > 0) {
                parsingStream = new MWDecorator(this.morphoSyntax.mw_dictionaries_old, parsingStream);
            }
        }
        return this.doTextProcessing(characterIterator, parsingStream);
    }

    public ParsingStream processTextMW(CharacterIterator characterIterator, ClassificationParsingStream classificationParsingStream) throws DLTException {
        ClassificationMWUParsingStreamImpl classificationMWUParsingStreamImpl = new ClassificationMWUParsingStreamImpl(this, classificationParsingStream);
        if (classificationParsingStream instanceof ClassificationMWUParsingStream) {
            return this.processTextMW(characterIterator, classificationMWUParsingStreamImpl);
        }
        return this.processText(characterIterator, classificationMWUParsingStreamImpl);
    }

    public ParsingStream processTextMW(CharacterIterator characterIterator, ParsingStream parsingStream, int n, int n2) throws DLTException {
        if (this.morphoSyntax.nta_dictionaries.length > 0) {
            parsingStream = new NTAParser(this.morphoSyntax.nta_dictionaries, parsingStream, this._hints, n2 == 2);
            ((NTAParser)parsingStream).setSpanFlag(n);
        }
        if (parsingStream instanceof MWUParsingStream) {
            ArrayList<MWUDictionary> arrayList = new ArrayList<MWUDictionary>();
            for (int i = 0; i < this.morphoSyntax.mw_dictionaries_new.length; ++i) {
                if (!this.morphoSyntax.mw_dictionaries_new[i].isMWUDictionary()) continue;
                arrayList.add(this.morphoSyntax.mw_dictionaries_new[i].getMwuFsa());
            }
            if (arrayList.size() != 0) {
                parsingStream = new MWUParser(arrayList, (MWUParsingStream)parsingStream, this._locale);
                ((MWUParser)parsingStream).setSpanFlag(n);
                ((MWUParser)parsingStream).setMWOutputStyle(n2);
            }
            if (this.morphoSyntax.mw_dictionaries_old != null && this.morphoSyntax.mw_dictionaries_old.length > 0) {
                parsingStream = new MWDecorator(this.morphoSyntax.mw_dictionaries_old, parsingStream);
            }
        }
        return this.doTextProcessing(characterIterator, parsingStream);
    }

    public ParsingStream processTextMW(CharacterIterator characterIterator, ClassificationParsingStream classificationParsingStream, int n, int n2) throws DLTException {
        ClassificationMWUParsingStreamImpl classificationMWUParsingStreamImpl = new ClassificationMWUParsingStreamImpl(this, classificationParsingStream);
        if (classificationParsingStream instanceof ClassificationMWUParsingStream) {
            return this.processTextMW(characterIterator, classificationMWUParsingStreamImpl, n, n2);
        }
        return this.processText(characterIterator, classificationMWUParsingStreamImpl);
    }

    public ParsingStream processText(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        if (this.morphoSyntax.nta_dictionaries.length > 0) {
            parsingStream = new NTAParser(this.morphoSyntax.nta_dictionaries, parsingStream, this._hints, false);
        }
        return this.doTextProcessing(characterIterator, parsingStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsingStream doTextProcessing(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        this.characterIterator = this.morphoSyntax.prepareIterator(characterIterator);
        this.m_pLPS = parsingStream;
        try {
            if (this.m_pLPS != null) {
                this.m_pLPS.reset(this);
            }
            this.doProcessText(characterIterator);
            this.markParagraph(this.characterIterator.getIndex());
            ParsingStream parsingStream2 = parsingStream;
            return parsingStream2;
        }
        finally {
            if (this.m_pLPS != null) {
                this.m_pLPS.close();
            }
        }
    }

    public static final void memcpy(StringBuffer stringBuffer, CharacterIterator characterIterator, int n, int n2) {
        stringBuffer.setLength(0);
        int n3 = characterIterator.getIndex();
        int n4 = characterIterator.getEndIndex();
        if (n4 < n2) {
            n2 = n4;
        }
        characterIterator.setIndex(n);
        while (characterIterator.getIndex() != n2) {
            stringBuffer.append(characterIterator.current());
            characterIterator.next();
        }
        characterIterator.setIndex(n3);
    }

    public static final void memcpy(StringBuilder stringBuilder, CharacterIterator characterIterator, int n, int n2) {
        stringBuilder.setLength(0);
        int n3 = characterIterator.getIndex();
        int n4 = characterIterator.getEndIndex();
        if (n4 < n2) {
            n2 = n4;
        }
        characterIterator.setIndex(n);
        while (characterIterator.getIndex() != n2) {
            stringBuilder.append(characterIterator.current());
            characterIterator.next();
        }
        characterIterator.setIndex(n3);
    }

    public Dictionary getBreakIterator() {
        return this.morphoSyntax.getBreakRules();
    }

    public int getCaseHandlingMethod() {
        return this.morphoSyntax.getCaseHandlingMethod();
    }

    public void setCaseHandlingMethod(int n) {
        this.morphoSyntax.setCaseHandlingMethod(n);
    }

    public void setDecompositionRules(DecompositionRuleSet decompositionRuleSet) throws DLTException {
        throw new DLTException(Messages.format("invalid.decomposition.locale", this._locale.toString()));
    }

    public ULocale getLocale() {
        return this._locale;
    }

    public static final boolean isSameLanguage(ULocale uLocale, ULocale uLocale2) {
        String string;
        String string2 = languageCache.get(uLocale);
        if (string2 == null) {
            string2 = uLocale.getLanguage();
            languageCache.put(uLocale, string2);
        }
        if ((string = languageCache.get(uLocale2)) == null) {
            string = uLocale2.getLanguage();
            languageCache.put(uLocale2, string);
        }
        return string2.equals(string);
    }

    static class DictLookupPos {
        int dictIdx;

        DictLookupPos() {
        }
    }
}

