/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.LanguageGuess;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.gloss.CatNameGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossPool;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

final class UniLexAnalyzerC
extends UniLexAnalyzerEu {
    private static final String UNKNOWN_SIMPLE_TEXT_LANG = "STL";
    private static final String UNKNOWN_COMPLEX_TEXT_LANG = "CTL";
    private static final int CONF_THRES_TABLE = 1;
    private static final int NORM_FACTOR_TABLE = 2;
    private int matchCondition;
    private static final boolean DEBUG = "1".equals(System.getProperty("dlt.log.doOutput"));
    private boolean doUnk = true;
    private int tieDelta = -1;
    private TreeMap<String, LanguageGuess> lmap;
    private int unkCTLvotes;
    private int unkSTLvotes;
    private int tokenCount = 0;
    private int characterCount = 0;
    private int maxCharsToExamine = -1;
    private int upperLimit = 0;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    int getMaxCharsToExamine() {
        return this.maxCharsToExamine;
    }

    void setMaxCharsToExamine(int n) {
        this.maxCharsToExamine = n;
    }

    int getTieDelta() {
        return this.tieDelta;
    }

    void setTieDelta(int n) {
        this.tieDelta = n;
    }

    void doUnknown(boolean bl) {
        this.doUnk = bl;
    }

    int getConfidenceThreshold(String string) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = this.lmap.get(string);
            return languageGuess.getConfThres();
        }
        return -1;
    }

    int setConfidenceThreshold(String string, int n) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = this.lmap.get(string);
            int n2 = languageGuess.getConfThres();
            languageGuess.setConfThres(n);
            return n2;
        }
        return -1;
    }

    int getNormFactor(String string) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = this.lmap.get(string);
            return languageGuess.getNormFactor();
        }
        return -1;
    }

    int setNormFactor(String string, int n) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = this.lmap.get(string);
            int n2 = languageGuess.getNormFactor();
            languageGuess.setConfThres(n);
            return n2;
        }
        return -1;
    }

    UniLexAnalyzerC(ULocale uLocale) throws DLTException {
        super(uLocale);
    }

    @Deprecated
    UniLexAnalyzerC(String string) throws DLTException {
        super(string);
    }

    @Override
    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2, n3);
        this.lmap = new TreeMap();
        for (int i = 0; i < this.morphoSyntax.dictionaries.length; ++i) {
            Dictionary dictionary = this.morphoSyntax.dictionaries[i];
            GlossPool glossPool = dictionary.getPoolByNumber(19);
            if (glossPool == null) continue;
            Iterator<Gloss> iterator = glossPool.getGlossIterator();
            while (iterator.hasNext()) {
                CatNameGloss catNameGloss = (CatNameGloss)iterator.next();
                LanguageGuess languageGuess = new LanguageGuess(catNameGloss.value, 0, 0);
                this.lmap.put(languageGuess.getLanguage(), languageGuess);
            }
        }
        this.loadTable(1);
        this.loadTable(2);
    }

    private int loadTable(int n) {
        StringCharacterIterator stringCharacterIterator = null;
        switch (n) {
            case 1: {
                stringCharacterIterator = new StringCharacterIterator("jfrost_confThres4Lang");
                break;
            }
            case 2: {
                stringCharacterIterator = new StringCharacterIterator("jfrost_NormFactor4Lang");
                break;
            }
            default: {
                return -1;
            }
        }
        for (int i = 0; i < this.morphoSyntax.dictionaries.length; ++i) {
            this.morphoSyntax.matches.clear();
            this.morphoSyntax.dictionaries[i].lookupLongest(stringCharacterIterator, this.morphoSyntax.matches);
            GlossCollection[] glossCollectionArray = this.morphoSyntax.matches.gloss;
            if (this.morphoSyntax.matches.getMaxIndex() == stringCharacterIterator.getEndIndex()) {
                GlossCollection glossCollection = glossCollectionArray[this.morphoSyntax.matches.mpos - 1];
                for (Gloss gloss : glossCollection) {
                    if (!(gloss instanceof MidGloss)) continue;
                    CatNameGloss catNameGloss = (CatNameGloss)((MidGloss)gloss).getGloss(CatNameGloss.class);
                    IntegerGloss integerGloss = (IntegerGloss)((MidGloss)gloss).getGloss(IntegerGloss.class);
                    LanguageGuess languageGuess = this.lmap.get(catNameGloss.value);
                    if (n == 1) {
                        languageGuess.setConfThres(integerGloss.weight);
                        continue;
                    }
                    if (n != 2) continue;
                    languageGuess.setNormFactor(integerGloss.weight);
                }
                continue;
            }
            return 0;
        }
        this.morphoSyntax.matches.clear();
        return 1;
    }

    public void reset() {
        for (LanguageGuess languageGuess : this.lmap.values()) {
            languageGuess.setScore(0L);
        }
        this.tokenCount = 0;
        this.characterCount = 0;
        this.upperLimit = 0;
    }

    @Override
    public void close() throws DLTException {
        if (this.lmap != null) {
            this.lmap.clear();
        }
        super.close();
    }

    protected int reverseDictLookup(UniLexAnalyzer.DictLookupPos dictLookupPos) {
        int n = this.characterIterator.getIndex();
        while (dictLookupPos.dictIdx < this.morphoSyntax.dictionaries.length) {
            this.characterIterator.setIndex(n);
            this.morphoSyntax.dictionaries[dictLookupPos.dictIdx].lookupLongestReversed(this.characterIterator, this.morphoSyntax.matches);
            if (this.morphoSyntax.matches.getNumMatches() != 0 && this.morphoSyntax.cmPolicy == 1) {
                ++dictLookupPos.dictIdx;
                break;
            }
            ++dictLookupPos.dictIdx;
        }
        return this.morphoSyntax.matches.getNumMatches();
    }

    private void updateCounter(int n, int n2) {
        ++this.tokenCount;
        this.characterCount += n2 - n;
    }

    @Override
    public ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        this.reset();
        this.upperLimit = characterIterator.getEndIndex();
        if (this.maxCharsToExamine > 0 && this.maxCharsToExamine < this.upperLimit) {
            this.upperLimit = this.maxCharsToExamine;
        }
        return super.doProcessText(characterIterator);
    }

    @Override
    protected boolean doDictLookup() {
        boolean bl = super.doDictLookup();
        if (this.characterCount > this.upperLimit) {
            bl = false;
            this.startIndex = this.characterIterator.getEndIndex();
        }
        return bl;
    }

    @Override
    protected void decomposeAndPost() {
        this.updateCounter(this.startIndex, this.morphoSyntax.matches.getMaxIndex());
        super.decomposeAndPost();
    }

    @Override
    protected void insertTokenClassGloss(int n, int n2, TokenClassGloss tokenClassGloss) {
        if (tokenClassGloss.is(452)) {
            this.updateCounter(n, n2);
            if (this.isComplexText(tokenClassGloss)) {
                ++this.unkCTLvotes;
            } else {
                ++this.unkSTLvotes;
            }
        }
        super.insertTokenClassGloss(n, n2, tokenClassGloss);
    }

    private boolean isComplexText(TokenClassGloss tokenClassGloss) {
        int n = tokenClassGloss.getBestClass();
        return n >= 300 && n <= 330;
    }

    @Override
    protected final void insertUnknown(int n, int n2, int n3) {
        if (this.morphoSyntax.matches.mpos > 0) {
            this.matchCondition = 2;
            this.insertGlosses(n);
            this.matchCondition = 0;
        } else {
            this.dictPos.dictIdx = 0;
            this.morphoSyntax.matches.clear();
            this.morphoSyntax.matches.setMaxIndex(Integer.MAX_VALUE);
            this.characterIterator.setIndex(n2);
            if (this.reverseDictLookup(this.dictPos) > 0) {
                this.matchCondition = 8;
                if (this.startIndex < this.morphoSyntax.matches.index[this.morphoSyntax.matches.mpos - 1]) {
                    this.insertGlosses(this.startIndex);
                }
                this.matchCondition = 0;
            }
            this.characterIterator.setIndex(n2);
        }
    }

    @Override
    protected final void insertUnknownWord(int n, int n2, int n3) {
        if (this.morphoSyntax.matches.mpos > 0) {
            this.matchCondition = 2;
            this.insertGlosses(n);
            this.matchCondition = 0;
        } else {
            this.dictPos.dictIdx = 0;
            this.morphoSyntax.matches.clear();
            this.morphoSyntax.matches.setMaxIndex(Integer.MAX_VALUE);
            this.characterIterator.setIndex(n2);
            if (this.reverseDictLookup(this.dictPos) > 0) {
                this.matchCondition = 8;
                if (this.startIndex < this.morphoSyntax.matches.index[this.morphoSyntax.matches.mpos - 1]) {
                    this.insertGlosses(this.startIndex);
                }
                this.matchCondition = 0;
            }
            this.characterIterator.setIndex(n2);
        }
    }

    @Override
    protected final void insertParsedGloss(int n, int n2, GlossCollection glossCollection) {
        if (this.matchCondition == 0) {
            this.matchCondition = 1;
        }
        this.processMatches(n, n2, glossCollection);
        this.matchCondition = 0;
    }

    private final void processMatches(int n, int n2, GlossCollection glossCollection) {
        GlossCollection glossCollection2 = new GlossCollection();
        for (Gloss gloss : glossCollection) {
            FeatureSetGloss featureSetGloss;
            if (!(gloss instanceof MidGloss) || (featureSetGloss = ((MidGloss)gloss).getFeatureGloss()) == null) continue;
            int n3 = featureSetGloss.getBOFA();
            if (this.matchCondition == 0 || 0 == (n3 & this.matchCondition)) continue;
            CatNameGloss catNameGloss = (CatNameGloss)((MidGloss)gloss).getGloss(CatNameGloss.class);
            IntegerGloss integerGloss = (IntegerGloss)((MidGloss)gloss).getGloss(IntegerGloss.class);
            if (catNameGloss == null || integerGloss == null) continue;
            LanguageGuess languageGuess = this.lmap.get(catNameGloss.value);
            languageGuess.setScore(languageGuess.getScore() + (long)integerGloss.weight);
            if (!DEBUG) continue;
            String string = "unknown";
            if (0 != (this.matchCondition & 1)) {
                string = "exact";
            } else if (0 != (this.matchCondition & 2)) {
                string = "prefix";
            } else if (0 != (this.matchCondition & 8)) {
                string = "suffix";
            }
            try {
                glossCollection2.add(new MidGloss(new Gloss[]{catNameGloss, integerGloss, new StringGloss(string)}));
            }
            catch (DLTException dLTException) {}
        }
        if (DEBUG && !glossCollection2.isEmpty()) {
            this.m_pLPS.createStd(65535, n, n2, glossCollection2);
        }
    }

    LanguageGuess[] getClassificationResult() {
        int n;
        Object object;
        Iterator iterator;
        LanguageGuess[] languageGuessArray = null;
        Collection<LanguageGuess> collection = this.lmap.values();
        TreeSet<LanguageGuess> treeSet = new TreeSet<LanguageGuess>();
        TreeSet<Object> treeSet2 = new TreeSet<Object>();
        treeSet.addAll(collection);
        if (!this.doUnk) {
            iterator = treeSet.iterator();
            while (iterator.hasNext() && ((LanguageGuess)(object = (LanguageGuess)iterator.next())).getScore() != 0L) {
                treeSet2.add(object);
            }
            if (treeSet2.size() == 0) {
                languageGuessArray = new LanguageGuess[]{new LanguageGuess(UNKNOWN_SIMPLE_TEXT_LANG, 0, 1)};
                return languageGuessArray;
            }
        } else {
            iterator = treeSet.iterator();
            while (iterator.hasNext() && ((LanguageGuess)(object = (LanguageGuess)iterator.next())).getScore() != 0L) {
                if (!((LanguageGuess)object).isConfident4Tokens(this.tokenCount)) continue;
                treeSet2.add(object);
            }
            if (treeSet2.size() == 0) {
                languageGuessArray = new LanguageGuess[]{this.unkCTLvotes > this.unkSTLvotes ? new LanguageGuess(UNKNOWN_COMPLEX_TEXT_LANG, this.unkCTLvotes, 1) : new LanguageGuess(UNKNOWN_SIMPLE_TEXT_LANG, this.unkSTLvotes, 1)};
                return languageGuessArray;
            }
        }
        if ((n = treeSet2.size()) > 0) {
            long l;
            long l2;
            double d;
            object = treeSet2.iterator();
            languageGuessArray = new LanguageGuess[n];
            int n2 = 0;
            while (object.hasNext()) {
                languageGuessArray[n2] = (LanguageGuess)object.next();
                ++n2;
            }
            languageGuessArray[0].setConfidence(1);
            if (this.tieDelta != -1 && n > 1 && (d = (double)((l2 = languageGuessArray[0].getNormalizedScore()) - (l = languageGuessArray[1].getNormalizedScore())) / (double)l * 100.0) < (double)this.tieDelta) {
                languageGuessArray[1].setConfidence(1);
            }
        }
        return languageGuessArray;
    }
}

