/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.ApproximateGuesser;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.TransliteratingGuesser;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.data.DecompositionRuleSetFactory;
import com.ibm.dltj.decomposition.Decomposer;
import com.ibm.dltj.decomposition.DecompositionRuleSet;
import com.ibm.dltj.decomposition.FSAComponent;
import com.ibm.dltj.decomposition.FSADecomposer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.util.Guesser;
import com.ibm.dltj.util.PooledList;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;

class UniLexAnalyzerEu
extends UniLexAnalyzer
implements Decomposer.DecompositionTarget {
    protected Decomposer decomposer;
    protected Guesser ruleGuesser = null;
    protected int hint_modifier = 0;
    protected UniLexAnalyzer.DictLookupPos dictPos = new UniLexAnalyzer.DictLookupPos();
    protected int startIndex;
    protected int endIndex;
    protected int matchCase;
    PooledList<Decomposer.ProcessedComponent> savedDecomposition = new PooledList<Decomposer.ProcessedComponent>(new Decomposer.ProcessedComponent());

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    UniLexAnalyzerEu(ULocale uLocale) {
        super(uLocale);
        this.decompFlags = 0;
        this.decomposer = null;
        if (UniLexAnalyzerEu.isSameLanguage(uLocale, GERMAN) || UniLexAnalyzerEu.isSameLanguage(uLocale, DUTCH) || UniLexAnalyzerEu.isSameLanguage(uLocale, BOKMAL) || UniLexAnalyzerEu.isSameLanguage(uLocale, NYNORSK) || UniLexAnalyzerEu.isSameLanguage(uLocale, SWEDISH) || UniLexAnalyzerEu.isSameLanguage(uLocale, DANISH) || UniLexAnalyzerEu.isSameLanguage(uLocale, FINNISH) || UniLexAnalyzerEu.isSameLanguage(uLocale, KOREAN) || UniLexAnalyzerEu.isSameLanguage(uLocale, AFRIKAANS) || UniLexAnalyzerEu.isSameLanguage(uLocale, ARABIC) || UniLexAnalyzerEu.isSameLanguage(uLocale, HEBREW) || UniLexAnalyzerEu.isSameLanguage(uLocale, HEBREW_FORMER)) {
            this.decompFlags |= 1;
        } else if (UniLexAnalyzerEu.isSameLanguage(uLocale, ENGLISH)) {
            this.hint_modifier = 16;
        }
    }

    @Deprecated
    UniLexAnalyzerEu(String string) {
        this(new ULocale(string));
    }

    @Override
    public void open(int n, int n2, int n3) throws DLTException {
        super.open(n, n2 | this.hint_modifier, n3);
        this.initializeDecomposer();
    }

    private void initializeDecomposer() throws DLTException {
        if (this.decomposer != null) {
            return;
        }
        if (UniLexAnalyzerEu.isSameLanguage(this._locale, GERMAN) && this._locale.getVariant().indexOf(GERMAN_PREREFORM.getVariant()) >= 0) {
            this.setDecompositionRules(DecompositionRuleSetFactory.getDefaultDecompositionRules());
        } else if ((this._hints & 0x200) == 0) {
            this.setDecompositionRules(DecompositionRuleSetFactory.getDecompositionRules(this._locale, this.parentSession instanceof SpellCheckerSession ? "spell" : null));
        } else {
            this.setDecompositionRules(DecompositionRuleSetFactory.getDefaultDecompositionRules());
        }
    }

    @Override
    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2 | this.hint_modifier, n3);
        this.initializeDecomposer();
    }

    @Override
    public String getEquivalentCharacters(int n) {
        return n == 0 ? "'\u2019\u02bc" : null;
    }

    protected boolean doDictLookup() {
        this.characterIterator.setIndex(this.startIndex);
        this.dictPos.dictIdx = 0;
        this.morphoSyntax.matches.clear();
        if (!this.dictLookup(this.dictPos)) {
            this.endIndex = this.startIndex;
            return false;
        }
        int n = this.morphoSyntax.matches.getMaxIndex();
        this.characterIterator.setIndex(n);
        TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator);
        int n2 = this.characterIterator.getIndex();
        if (!tokenClassGloss.is(1)) {
            if (this.matchHasBreakFlag()) {
                this.decomposeAndPost();
                this.startIndex = n;
                return true;
            }
            this.endIndex = n;
            return false;
        }
        this.decomposeAndPost();
        this.startIndex = n;
        if (!tokenClassGloss.is(2) || !this.doDictLookup()) {
            this.insertTokenClassGloss(n, n2, tokenClassGloss);
            this.startIndex = n2;
        }
        return true;
    }

    protected void decomposeAndPost() {
        if (!this.decomposeStandalone()) {
            this.insertGlosses(this.startIndex);
        }
    }

    private boolean decomposeStandalone() {
        if ((this._hints & 0x10) == 0 && (this._hints & 0x40) == 0) {
            return false;
        }
        int n = this.morphoSyntax.matches.getMaxIndex();
        int[] nArray = this.morphoSyntax.matches.index;
        GlossCollection[] glossCollectionArray = this.morphoSyntax.matches.gloss;
        if ((this._hints & 0x40) == 0) {
            for (int i = this.morphoSyntax.matches.mpos - 1; i >= 0 && nArray[i] == n; --i) {
                if (this.checkComposabilityFlag(glossCollectionArray[i])) continue;
                return false;
            }
        }
        this.matchCase = this.morphoSyntax.matches.cases[this.morphoSyntax.matches.mpos - 1];
        return this.decompose(this.characterIterator, this.startIndex, n);
    }

    private void decomposeAndPost(GlossCollection glossCollection, int n, int n2) {
        if ((this._hints & 0x40) != 0 || (this._hints & 0x10) != 0 && this.checkComposabilityFlag(glossCollection)) {
            this.matchCase = -1;
            if (this.decompose(this.characterIterator, n, n2)) {
                return;
            }
        }
        this.insertParsedGloss(n, n2, glossCollection);
    }

    @Override
    public ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        this.ruleGuesser = this.getGuesser(this._locale, this.transliteratorRuleFile);
        this.startIndex = this.characterIterator.getBeginIndex();
        while (this.startIndex < this.characterIterator.getEndIndex()) {
            if (this.doDictLookup()) continue;
            this.characterIterator.setIndex(this.startIndex);
            TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator);
            int n = this.characterIterator.getIndex();
            int n2 = this.startIndex;
            if (tokenClassGloss.is(256)) {
                int n3 = this.matchCase = tokenClassGloss.getCaseGloss() != null ? tokenClassGloss.getCaseGloss().getCaseValue() : -1;
                if (n == this.endIndex) {
                    this.decomposeAndPost();
                    this.startIndex = n;
                    continue;
                }
                if (n < this.endIndex || this.morphoSyntax.cmPolicy == 1) {
                    this.characterIterator.setIndex(this.startIndex);
                    GlossCollection glossCollection = this.dictLookupWord(this.characterIterator, n - this.startIndex);
                    if (glossCollection != null) {
                        this.decomposeAndPost(glossCollection, this.startIndex, n);
                        this.startIndex = n;
                        continue;
                    }
                }
                this.endIndex = n;
                if (!tokenClassGloss.is(512) && this.decompose(this.characterIterator, n2, n) || this.guesser(tokenClassGloss, n2, n)) {
                    this.startIndex = n;
                    continue;
                }
            }
            this.insertTokenClassGloss(n2, n, tokenClassGloss);
            this.startIndex = n;
        }
        this.characterIterator.setIndex(this.startIndex);
        return this.m_pLPS;
    }

    protected boolean decompose(CharacterIterator characterIterator, int n, int n2) {
        if ((this._hints & 1) == 0) {
            return false;
        }
        if (this.matchCase == -1) {
            this.matchCase = CaseGloss.CaseExtractor.getSubStringCase(this.characterIterator, n, n2);
        }
        this.decomposer.reset();
        this.endIndex = n2;
        if ((this._hints & 0x20) != 0) {
            this.decomposer.decompose(n, n2, characterIterator, this.morphoSyntax.multinets);
        } else {
            for (MultiNet multiNet : this.morphoSyntax.multinets) {
                this.decomposer.decompose(n, n2, characterIterator, multiNet);
            }
        }
        return this.decomposer.close();
    }

    protected boolean guesser(TokenClassGloss tokenClassGloss, int n, int n2) {
        GlossCollection glossCollection = null;
        glossCollection = this.morphoSyntax.oov_dictLookup(this.characterIterator, n, n2);
        if (glossCollection != null) {
            this.insertParsedGloss(n, n2, glossCollection);
            return true;
        }
        if (this.ruleGuesser != null && (glossCollection = this.ruleGuesser.guessingLookup(this.characterIterator, n, n2)) != null) {
            this.insertParsedGloss(n, n2, glossCollection);
            return true;
        }
        return false;
    }

    private Guesser getGuesser(ULocale uLocale, String string) throws DLTException {
        int n = this.morphoSyntax.getGuessingMode();
        switch (n) {
            case 2: {
                if (string != null) {
                    return new TransliteratingGuesser(this, uLocale, string);
                }
                return new TransliteratingGuesser(this, uLocale);
            }
            case 1: {
                if (!ApproximateGuesser.checkDicts(this.morphoSyntax)) break;
                return new ApproximateGuesser(this);
            }
        }
        return null;
    }

    private boolean matchHasBreakFlag() {
        this.characterIterator.setIndex(this.startIndex);
        int n = this.morphoSyntax.matches.getMaxIndex();
        TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator);
        while (tokenClassGloss != null && this.characterIterator.getIndex() < n) {
            tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator);
        }
        if (tokenClassGloss != null) {
            return tokenClassGloss.is(1);
        }
        return false;
    }

    private boolean checkComposabilityFlag(GlossCollection glossCollection) {
        for (Gloss gloss : glossCollection) {
            FeatureSetGloss featureSetGloss = null;
            switch (gloss.getType()) {
                case 1: 
                case 88: {
                    featureSetGloss = ((MidGloss)gloss).getFeatureGloss();
                    break;
                }
                case 15: {
                    featureSetGloss = (FeatureSetGloss)gloss;
                }
            }
            if (featureSetGloss == null || !featureSetGloss.isCompositional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMatchCase() {
        return this.matchCase;
    }

    private void insertDecomposition(Iterable<? extends Decomposer.Component<?>> iterable) {
        for (Decomposer.Component<?> component : iterable) {
            this.insertDecompElement(component.start, component.end, component.filtered_glosses());
        }
    }

    private void saveDecomposition(Iterable<? extends Decomposer.Component<?>> iterable) {
        assert (this.savedDecomposition.isEmpty());
        for (Decomposer.Component<?> component : iterable) {
            Decomposer.Component component2 = (Decomposer.Component)this.savedDecomposition.getCurItem();
            component2.start = component.start;
            component2.end = component.end;
            component2.glosses = component.filtered_glosses();
            this.savedDecomposition.commitItem();
        }
    }

    @Override
    public boolean processDecomposition(Iterable<? extends Decomposer.Component<?>> iterable, int n) {
        if ((this._hints & 8) != 0) {
            this.startDecompGroup(this.startIndex, this.endIndex);
            this.insertDecomposition(iterable);
            this.closeDecompGroup(n);
            return false;
        }
        switch (n) {
            case 0: {
                this.saveDecomposition(iterable);
                return true;
            }
            case 1: {
                this.startDecompGroup(this.startIndex, this.endIndex);
                this.fork();
                this.insertDecomposition(this.savedDecomposition);
                this.savedDecomposition.clear();
            }
        }
        this.addToFork();
        this.insertDecomposition(iterable);
        return true;
    }

    @Override
    public void closeDecomposition(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.startDecompGroup(this.startIndex, this.endIndex);
                assert (!this.savedDecomposition.isEmpty());
                this.insertDecomposition(this.savedDecomposition);
                this.savedDecomposition.clear();
            }
            default: {
                this.closeDecompGroup(n);
            }
        }
    }

    @Override
    public boolean isDecompositionUnfiltered() {
        return (this._hints & 0x400) != 0;
    }

    @Override
    public void setDecompositionRules(DecompositionRuleSet decompositionRuleSet) {
        this.decomposer = new FSADecomposer<FSAComponent>(this, decompositionRuleSet.getComponentList());
    }
}

