/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.UniMorphoSyntaxFi;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.BasicCutPasteGloss;
import com.ibm.dltj.gloss.CaseGloss;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.util.LowercasingCharacterIterator;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

class UniLexAnalyzerFi
extends UniLexAnalyzerEu {
    private static final int INVALID_MATCH = 0;
    private static final int STANDALONE_MATCH = 1;
    private static final int COMPOUND_MATCH = 2;
    private static final int DETERMINISTIC_STANDALONE_MATCH = 3;
    private boolean isGuessing;
    private boolean hasSuggestion;
    private static final boolean grouping = true;
    private final GlossStore store = new GlossStore();
    private final Set<IntMatrix> positionSet = new TreeSet<IntMatrix>(intMatrixComparator);
    private LowercasingCharacterIterator lwrCseIterator;
    private static final Comparator<IntMatrix> intMatrixComparator = new Comparator<IntMatrix>(){

        @Override
        public int compare(IntMatrix intMatrix, IntMatrix intMatrix2) {
            for (int i = 0; i < intMatrix.len.length && i < intMatrix2.len.length; ++i) {
                if (intMatrix.len[i] == intMatrix2.len[i]) continue;
                return intMatrix2.len[i] - intMatrix.len[i];
            }
            return intMatrix2.len.length - intMatrix.len.length;
        }
    };

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    UniLexAnalyzerFi(ULocale uLocale) {
        super(uLocale);
    }

    @Deprecated
    UniLexAnalyzerFi(String string) {
        this(new ULocale(string));
    }

    @Override
    protected void insertGlosses(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.morphoSyntax.matches.getMaxIndex();
        int n7 = this.morphoSyntax.matches.getNumMatches();
        int[] nArray = new int[n7];
        this.store.setup(n6 - n);
        this.positionSet.clear();
        block5: for (n5 = 0; n5 < n7; ++n5) {
            n4 = this.morphoSyntax.matches.getMatchStart(n5);
            if (n4 == (n3 = this.morphoSyntax.matches.getMatchEnd(n5))) continue;
            if (n4 + 1 == n3 && this.morphoSyntax.matches.index[n3] == Integer.MIN_VALUE) {
                nArray[n5] = 3;
                continue;
            }
            if (this.morphoSyntax.matches.index[n3 - 1] < n6 || !UniMorphoSyntaxFi.isWordEnd(this.morphoSyntax.matches.gloss[n3 - 1])) continue;
            nArray[n5] = 1;
            for (n2 = n4; n2 < n3 - 2; ++n2) {
                if (this.morphoSyntax.matches.index[n2] == n6 || !UniMorphoSyntaxFi.isWordBoundary(this.morphoSyntax.matches.gloss[n2])) continue;
                nArray[n5] = 2;
                continue block5;
            }
        }
        block7: for (n5 = 0; n5 < n7; ++n5) {
            if (nArray[n5] == 0) continue;
            n4 = this.morphoSyntax.matches.getMatchStart(n5);
            n3 = this.morphoSyntax.matches.getMatchEnd(n5);
            switch (nArray[n5]) {
                case 1: {
                    this.gatherStandaloneWord(this.morphoSyntax.matches, n, n4, n3);
                    continue block7;
                }
                case 2: {
                    this.gatherDecompoundedWords(this.morphoSyntax.matches, n, n4, n3);
                    continue block7;
                }
                case 3: {
                    this.gatherDeterministicStandaloneWord(this.morphoSyntax.matches, n, n4, n3);
                    continue block7;
                }
            }
        }
        if (this.store.hasStandaloneWord()) {
            this.insertParsedGloss(n, n6, this.store.getStandaloneWord());
            return;
        }
        if (this.positionSet.isEmpty()) {
            this.unknownWord(n, n6);
            return;
        }
        this.startDecompGroup(n, n6);
        n5 = 0;
        Iterator<IntMatrix> iterator = this.positionSet.iterator();
        n3 = this.positionSet.size() > 1 ? 1 : 0;
        int n8 = n2 = (this._hints & 8) == 8 ? 1 : 0;
        while (iterator.hasNext()) {
            IntMatrix intMatrix = iterator.next();
            if (n3 != 0 && n2 == 0) {
                if (n5 == 0) {
                    this.fork();
                } else {
                    this.addToFork();
                }
            }
            int n9 = n;
            for (int i = 0; i < intMatrix.pos.length; ++i) {
                this.insertParsedGloss(n9, n + intMatrix.pos[i] + 1, this.store.getDecompoundedWord(intMatrix.pos[i], intMatrix.len[i]));
                n9 = n + intMatrix.pos[i] + 1;
            }
            ++n5;
            if (n2 == 0) continue;
            break;
        }
        this.closeDecompGroup(n5);
    }

    @Override
    protected boolean decompose(CharacterIterator characterIterator, int n, int n2) {
        return false;
    }

    @Override
    protected boolean guesser(TokenClassGloss tokenClassGloss, int n, int n2) {
        int n3 = this.dictPos.dictIdx;
        this.hasSuggestion = false;
        this.isGuessing = true;
        if (CaseGloss.isCase(this.matchCase, 8)) {
            if (this.lwrCseIterator == null) {
                this.lwrCseIterator = new LowercasingCharacterIterator(this.characterIterator);
            }
            this.lwrCseIterator.setIndex(n);
            this.dictPos.dictIdx = 0;
            this.dictLookup(this.dictPos, this.lwrCseIterator);
            if (n2 == this.morphoSyntax.matches.getMaxIndex()) {
                this.hasSuggestion = true;
                this.insertGlosses(n);
            }
        }
        this.dictPos.dictIdx = n3;
        this.morphoSyntax.matches.clear();
        this.isGuessing = false;
        return this.hasSuggestion;
    }

    protected void gatherDecompoundedWords(MatchBuffer matchBuffer, int n, int n2, int n3) {
        int n4 = 0;
        int[] nArray = new int[n3 - n2];
        int[] nArray2 = new int[n3 - n2];
        LemmaGenerator lemmaGenerator = null;
        FeatureSetGloss featureSetGloss = null;
        int n5 = n;
        for (int i = n2; i < n3; ++i) {
            if (!UniMorphoSyntaxFi.isWordBoundary(this.morphoSyntax.matches.gloss[i]) && (!UniMorphoSyntaxFi.isWordEnd(this.morphoSyntax.matches.gloss[i]) || i != n3 - 1)) continue;
            int n6 = matchBuffer.index[i];
            block3: for (int j = i; j >= n2 && n5 != n6; --j) {
                GlossCollection glossCollection = matchBuffer.gloss[j];
                for (Gloss gloss : glossCollection) {
                    if (!(gloss instanceof MidGloss)) continue;
                    featureSetGloss = ((MidGloss)gloss).getFeatureGloss();
                    lemmaGenerator = ((MidGloss)gloss).getLemmaGloss();
                    if (featureSetGloss == null || lemmaGenerator == null || featureSetGloss.getPOS() == 0 || !(lemmaGenerator instanceof BasicCutPasteGloss)) continue;
                    BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)lemmaGenerator;
                    if (basicCutPasteGloss.getMinSourceLength() > n6 - n5) {
                        lemmaGenerator = null;
                    }
                    if (lemmaGenerator != null) {
                        lemmaGenerator = new CutPasteGloss(basicCutPasteGloss.getValue(), n6 - matchBuffer.index[j] + basicCutPasteGloss.getCut(), basicCutPasteGloss.getConv(), basicCutPasteGloss.getOptions());
                    }
                    MidGloss midGloss = null;
                    try {
                        Gloss[] glossArray;
                        if (lemmaGenerator == null) {
                            Gloss[] glossArray2 = new Gloss[1];
                            glossArray = glossArray2;
                            glossArray2[0] = featureSetGloss;
                        } else {
                            Gloss[] glossArray3 = new Gloss[2];
                            glossArray3[0] = (Gloss)((Object)lemmaGenerator);
                            glossArray = glossArray3;
                            glossArray3[1] = featureSetGloss;
                        }
                        midGloss = new MidGloss(glossArray);
                    }
                    catch (DLTException dLTException) {
                        // empty catch block
                    }
                    featureSetGloss = null;
                    lemmaGenerator = null;
                    if (n5 > n6) {
                        throw new IllegalArgumentException();
                    }
                    this.store.addDecompoundedWord(n6 - n - 1, n6 - n5 - 1, midGloss, glossCollection.getOwnerDictionary());
                    nArray[n4] = n6 - n - 1;
                    nArray2[n4] = n6 - n5 - 1;
                    ++n4;
                    n5 = n6;
                    continue block3;
                }
            }
        }
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        System.arraycopy(nArray, 0, nArray3, 0, n4);
        System.arraycopy(nArray2, 0, nArray4, 0, n4);
        this.positionSet.add(new IntMatrix(nArray3, nArray4));
    }

    protected void gatherStandaloneWord(MatchBuffer matchBuffer, int n, int n2, int n3) {
        LemmaGenerator lemmaGenerator = null;
        FeatureSetGloss featureSetGloss = null;
        int n4 = matchBuffer.index[n3 - 1];
        for (int i = n3 - 1; i >= n2; --i) {
            GlossCollection glossCollection = matchBuffer.gloss[i];
            for (Gloss gloss : glossCollection) {
                if (!(gloss instanceof MidGloss)) continue;
                featureSetGloss = ((MidGloss)gloss).getFeatureGloss();
                lemmaGenerator = ((MidGloss)gloss).getLemmaGloss();
                if (featureSetGloss == null || lemmaGenerator == null || !(lemmaGenerator instanceof BasicCutPasteGloss)) continue;
                BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)lemmaGenerator;
                if (basicCutPasteGloss.getMinSourceLength() > n4 - n) {
                    lemmaGenerator = null;
                }
                if (lemmaGenerator != null) {
                    lemmaGenerator = new CutPasteGloss(basicCutPasteGloss.getValue(), n4 - matchBuffer.index[i] + basicCutPasteGloss.getCut(), basicCutPasteGloss.getConv(), basicCutPasteGloss.getOptions());
                }
                MidGloss midGloss = null;
                try {
                    Gloss[] glossArray;
                    if (lemmaGenerator == null) {
                        Gloss[] glossArray2 = new Gloss[1];
                        glossArray = glossArray2;
                        glossArray2[0] = featureSetGloss;
                    } else {
                        Gloss[] glossArray3 = new Gloss[2];
                        glossArray3[0] = (Gloss)((Object)lemmaGenerator);
                        glossArray = glossArray3;
                        glossArray3[1] = featureSetGloss;
                    }
                    midGloss = new MidGloss(glossArray);
                }
                catch (DLTException dLTException) {
                    // empty catch block
                }
                if (n > n4) {
                    throw new IllegalArgumentException();
                }
                this.store.addStandaloneWord(midGloss, glossCollection.getOwnerDictionary());
                return;
            }
        }
    }

    protected void gatherDeterministicStandaloneWord(MatchBuffer matchBuffer, int n, int n2, int n3) {
        if (n2 + 1 != n3) {
            return;
        }
        GlossCollection glossCollection = matchBuffer.gloss[n3 - 1];
        for (Gloss gloss : glossCollection) {
            this.store.addStandaloneWord(gloss, glossCollection.getOwnerDictionary());
        }
    }

    private void unknownWord(int n, int n2) {
        if (this.isGuessing) {
            this.hasSuggestion = false;
        } else {
            TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator, n, n2);
            if (tokenClassGloss != null) {
                this.insertUnknown(n, n2, tokenClassGloss.getBestClass());
            } else {
                this.insertUnknown(n, n2, 0);
            }
        }
    }

    private final class IntMatrix {
        int[] pos;
        int[] len;

        public IntMatrix(int[] nArray, int[] nArray2) {
            this.pos = nArray;
            this.len = nArray2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IntMatrix)) {
                return false;
            }
            if (this.pos.length != this.len.length) {
                return false;
            }
            if (!Arrays.equals(this.pos, ((IntMatrix)object).pos)) {
                return false;
            }
            return Arrays.equals(this.len, ((IntMatrix)object).len);
        }

        public int hashCode() {
            int n;
            int n2 = 1;
            for (n = 0; n < this.pos.length; ++n) {
                n2 = 17 * n2 + this.pos[n];
            }
            for (n = 0; n < this.len.length; ++n) {
                n2 = 31 * n2 + this.len[n];
            }
            return n2;
        }
    }

    private final class GlossStore {
        GlossCollection standaloneCollection;
        GlossCollection[][] compoundedCollection;

        GlossStore() {
        }

        public void setup(int n) {
            this.standaloneCollection = null;
            this.compoundedCollection = new GlossCollection[n][n];
        }

        public boolean addDecompoundedWord(int n, int n2, MidGloss midGloss, Dictionary dictionary) {
            if (this.compoundedCollection[n][n2] == null) {
                this.compoundedCollection[n][n2] = new GlossCollection();
            }
            return this.addMidGloss(this.compoundedCollection[n][n2], midGloss, dictionary);
        }

        public boolean addStandaloneWord(MidGloss midGloss, Dictionary dictionary) {
            if (this.standaloneCollection == null) {
                this.standaloneCollection = new GlossCollection();
            }
            return this.addMidGloss(this.standaloneCollection, midGloss, dictionary);
        }

        public boolean addStandaloneWord(Gloss gloss, Dictionary dictionary) {
            if (this.standaloneCollection == null) {
                this.standaloneCollection = new GlossCollection();
            }
            return this.standaloneCollection.add(gloss, dictionary);
        }

        public boolean hasStandaloneWord() {
            if (this.standaloneCollection == null) {
                return false;
            }
            return !this.standaloneCollection.isEmpty();
        }

        public GlossCollection getStandaloneWord() {
            return this.standaloneCollection;
        }

        public GlossCollection getDecompoundedWord(int n, int n2) {
            return this.compoundedCollection[n][n2];
        }

        private boolean addMidGloss(GlossCollection glossCollection, MidGloss midGloss, Dictionary dictionary) {
            if (glossCollection == null) {
                return false;
            }
            if (this.acceptMidGloss(glossCollection, midGloss)) {
                return glossCollection.add(midGloss, dictionary);
            }
            return false;
        }

        private boolean acceptMidGloss(GlossCollection glossCollection, MidGloss midGloss) {
            if (midGloss == null) {
                return false;
            }
            if (glossCollection.isEmpty()) {
                return true;
            }
            for (MidGloss midGloss2 : glossCollection) {
                if (!midGloss2.equals(midGloss)) continue;
                return false;
            }
            return true;
        }
    }
}

