/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.InflectionParsingStreamJa;
import com.ibm.dltj.Messages;
import com.ibm.dltj.SimpleDecomposer;
import com.ibm.dltj.UniLexAnalyzerTrellis;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.GlossPool;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.StateMatrix;
import com.ibm.dltj.trellis.StateTrellis;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.dltj.trellis.TrellisPayload;
import com.ibm.dltj.util.HanNormalizer;
import com.ibm.dltj.util.Utils;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class UniLexAnalyzerJa
extends UniLexAnalyzerTrellis {
    protected final Map<TrellisPayload, Utils.ObjectPair<GlossCollection, Boolean>[]> reserved = new EnumMap<TrellisPayload, Utils.ObjectPair<GlossCollection, Boolean>[]>(TrellisPayload.class);
    private static final char[] MIDDLE_DOTS = new char[]{'\u30fb', '\uff65'};
    private final SimpleDecomposer katakanaDecomposer = new SimpleDecomposer(MIDDLE_DOTS){

        @Override
        protected void processElement(int n, int n2) throws DLTException {
            UniLexAnalyzerJa.this.insertDecompElement(n, n2);
        }

        @Override
        protected void processBreak(int n, int n2) throws DLTException {
            UniLexAnalyzerJa.this.insertPunctuation(n, n2, 65535);
        }
    };
    private final Trellis decomposer;
    private Set<Dictionary> annoDictSet;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Deprecated
    UniLexAnalyzerJa(String string) throws DLTException {
        this(new ULocale(string));
    }

    UniLexAnalyzerJa(ULocale uLocale) throws DLTException {
        super(uLocale, HanNormalizer.createNormalizerJa());
        this.trellis = new StateTrellisImpl();
        this.decomposer = new StateTrellisImpl(new GlossFilter(){

            @Override
            public boolean accept(Object object) {
                return UniLexAnalyzerJa.isDecompoundedPiece(object);
            }
        });
        this.annoDictSet = new HashSet<Dictionary>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2, n3);
        this.morphoSyntax.cmPolicy = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("");
        for (TrellisPayload trellisPayload : TrellisPayload.values()) {
            void var10_13;
            stringCharacterIterator.setText(trellisPayload.toReservedWord());
            GlossCollection glossCollection = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getBeginIndex(), stringCharacterIterator.getEndIndex(), 1);
            if (glossCollection == null) {
                stringCharacterIterator.setText(trellisPayload.toAlternative());
                GlossCollection glossCollection2 = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getBeginIndex(), stringCharacterIterator.getEndIndex(), 1);
                if (glossCollection2 == null) {
                    if (!trellisPayload.isOptional()) {
                        throw new DLTException(Messages.getString("invalid.dict.ja"));
                    }
                    GlossCollection glossCollection3 = trellisPayload.getFallbackGloss();
                }
            }
            this.reserved.put(trellisPayload, this.prepareReservedGloss((GlossCollection)var10_13));
        }
        for (Dictionary dictionary : dictionaryArray) {
            for (GlossPool glossPool : dictionary.pools) {
                if (glossPool == null || !Annotate.class.isAssignableFrom(glossPool.getMainClass())) continue;
                this.annoDictSet.add(dictionary);
            }
        }
    }

    @Override
    public void close() throws DLTException {
        super.close();
        this.annoDictSet.clear();
    }

    @Override
    protected int rawLookup(CharacterIterator characterIterator, MultiNet multiNet, MatchBuffer matchBuffer) {
        return multiNet.normalizingTraverse(characterIterator, matchBuffer, Normalizer.NFKD);
    }

    @Override
    protected ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        if (this.reserved.isEmpty()) {
            throw new DLTException(Messages.getString("invalid.dict.trellis"));
        }
        if (!this.hasDwbreakFlag() && !(this.m_pLPS instanceof InflectionParsingStreamJa)) {
            this.m_pLPS = new InflectionParsingStreamJa(this.m_pLPS);
            this.m_pLPS.reset(this);
        }
        return super.doProcessText(characterIterator);
    }

    @Override
    protected void processGloss(int n, int n2, Gloss gloss) throws DLTException {
        if (this.hasDecompositionFlag() && UniLexAnalyzerJa.isCompoundWord(gloss)) {
            int n3 = 0;
            this.startDecompGroup(n, n2);
            this.fork();
            this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, gloss, true));
            ++n3;
            this.addToFork();
            if (this.decomposeWord(n, n2) == 0) {
                this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, gloss, true));
            }
            this.closeDecompGroup(++n3);
            return;
        }
        this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, gloss, true));
    }

    @Override
    protected void processGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) throws DLTException {
        int n3 = tokenClassGloss.getBestClass();
        if (n3 == 304 && this.hasDecompositionFlag(tokenClassGloss) && this.katakanaDecomposer.isCompoundWord(this.characterIterator, n, n2)) {
            int n4 = 0;
            this.startDecompGroup(n, n2);
            this.fork();
            this.insertTokenClassGloss(n, n2, tokenClassGloss);
            ++n4;
            this.addToFork();
            this.katakanaDecomposer.decompose(this.characterIterator, n, n2);
            this.closeDecompGroup(++n4);
            return;
        }
        super.processGloss(n, n2, tokenClassGloss, object);
    }

    @Override
    protected void processGlossCollection(int n, int n2, GlossCollection glossCollection) {
        GlossCollection[] glossCollectionArray = this.trellis.getElement(n, n2);
        if (glossCollectionArray.length <= 1) {
            this.insertParsedGloss(n, n2, glossCollection);
            return;
        }
        this.insertParsedGloss(n, n2, UniLexAnalyzerJa.concatGlossCollection(glossCollectionArray));
    }

    @Override
    public void insertTokenClassGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) {
        if (tokenClassGloss.is(384)) {
            int n3 = Boolean.TRUE == object ? 65535 : 32768;
            this.m_pLPS.createUnknown(n3, n, n2, tokenClassGloss.getBestClass());
            this.inSentence = true;
            this.isFirstWord = false;
            return;
        }
        super.insertTokenClassGloss(n, n2, tokenClassGloss);
    }

    @Override
    protected boolean hasDecompositionFlag(Gloss gloss) {
        int n;
        if (this.hasDecompositionFlag()) {
            return true;
        }
        return gloss instanceof TokenClassGloss && (n = ((TokenClassGloss)gloss).getBestClass()) == 304 && this.reserved.get((Object)TrellisPayload.DECOMP_KATAKANA) != null;
    }

    private static boolean isCompoundWord(Gloss gloss) {
        if (gloss instanceof MidGloss) {
            JaMorphGloss jaMorphGloss = (JaMorphGloss)((MidGloss)gloss).getGloss(JaMorphGloss.class);
            return jaMorphGloss != null && jaMorphGloss.isDividable();
        }
        return false;
    }

    private static boolean isDecompoundedPiece(Object object) {
        if (object instanceof MidGloss) {
            JaMorphGloss jaMorphGloss = (JaMorphGloss)((MidGloss)object).getGloss(JaMorphGloss.class);
            return jaMorphGloss != null && !jaMorphGloss.isDividable();
        }
        return object instanceof TokenClassGloss;
    }

    protected static boolean isNounWord(Gloss gloss) {
        if (gloss instanceof MidGloss) {
            JaMorphGloss jaMorphGloss = (JaMorphGloss)((MidGloss)gloss).getGloss(JaMorphGloss.class);
            return jaMorphGloss != null && jaMorphGloss.isNoun();
        }
        return false;
    }

    private Utils.ObjectPair<GlossCollection, Boolean>[] prepareReservedGloss(GlossCollection glossCollection) {
        if (glossCollection == null) {
            return null;
        }
        GlossCollection glossCollection2 = new GlossCollection();
        GlossCollection glossCollection3 = new GlossCollection();
        for (Gloss gloss : glossCollection) {
            if (gloss instanceof MidGloss) {
                JaMorphGloss jaMorphGloss = (JaMorphGloss)((MidGloss)gloss).getGloss(JaMorphGloss.class);
                if (jaMorphGloss == null) {
                    Utils.ObjectPair<GlossCollection, Boolean> objectPair = new Utils.ObjectPair<GlossCollection, Boolean>(glossCollection, Boolean.FALSE);
                    return new Utils.ObjectPair[]{objectPair};
                }
                if (jaMorphGloss.getPhraseStart() == 1) {
                    glossCollection3.add(gloss);
                    continue;
                }
            }
            glossCollection2.add(gloss);
        }
        return new Utils.ObjectPair[]{new Utils.ObjectPair<GlossCollection, Boolean>(glossCollection2, Boolean.FALSE), new Utils.ObjectPair<GlossCollection, Boolean>(glossCollection3, Boolean.TRUE)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decomposeWord(int n, int n2) throws DLTException {
        int n3 = this.characterIterator.getIndex();
        try {
            int n4;
            this.decomposer.init(n);
            this.decomposer.append(this.trellis, n, n2, true);
            if (this.decomposer.isEmpty()) {
                int n5 = 0;
                return n5;
            }
            EdgeListElement edgeListElement = this.decomposer.process();
            if (edgeListElement == null) {
                if (this.katakanaDecomposer.isCompoundWord(this.characterIterator, n, n2)) {
                    int n6 = this.katakanaDecomposer.decompose(this.characterIterator, n, n2);
                    return n6;
                }
                for (n4 = n; n4 < n2; ++n4) {
                    TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator, n4, n2);
                    if (tokenClassGloss == null) continue;
                    this.decomposer.addElement(n4, n2, new GlossCollection(tokenClassGloss));
                }
                this.characterIterator.setIndex(n3);
                edgeListElement = this.decomposer.process();
            }
            if (edgeListElement == null) {
                n4 = 0;
                return n4;
            }
            for (EdgeListElement edgeListElement2 = edgeListElement; edgeListElement2 != null; edgeListElement2 = edgeListElement2.getNext()) {
                int n7 = edgeListElement2.getStartIndex();
                int n8 = edgeListElement2.getEndIndex();
                Object object = edgeListElement2.getGloss();
                if (n7 == n8) continue;
                if (object instanceof Gloss) {
                    if (object instanceof TokenClassGloss) {
                        this.processDecompGloss(n7, n8, (TokenClassGloss)object);
                        continue;
                    }
                    this.processDecompGloss(n7, n8, (Gloss)object);
                    continue;
                }
                if (object instanceof GlossCollection) {
                    this.processGlossCollection(n7, n8, (GlossCollection)object);
                    continue;
                }
                assert (false);
            }
            int n9 = 1;
            return n9;
        }
        finally {
            if (!this.decomposer.isEmpty()) {
                this.decomposer.clear();
            }
            this.characterIterator.setIndex(n3);
        }
    }

    private void processDecompGloss(int n, int n2, Gloss gloss) {
        this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, gloss, false));
    }

    private void processDecompGloss(int n, int n2, TokenClassGloss tokenClassGloss) throws DLTException {
        switch (tokenClassGloss.getBestClass()) {
            case 1: 
            case 2: 
            case 8: {
                this.insertPunctuation(n, n2, 65535, tokenClassGloss.getBestClass());
                return;
            }
            case 304: {
                this.katakanaDecomposer.decompose(this.characterIterator, n, n2);
                return;
            }
        }
        this.insertTokenClassGloss(n, n2, tokenClassGloss);
    }

    private GlossCollection collectGlossCollection(int n, int n2, Gloss gloss, boolean bl) {
        if (!UniLexAnalyzerJa.isNounWord(gloss) || this.annoDictSet.isEmpty()) {
            return (GlossCollection)this.gFactory.getInstance(gloss);
        }
        if (bl) {
            GlossCollection[] glossCollectionArray;
            for (GlossCollection glossCollection : glossCollectionArray = this.trellis.getElement(n, n2)) {
                if (!this.annoDictSet.contains(glossCollection.getOwnerDictionary())) continue;
                GlossCollection glossCollection2 = new GlossCollection(gloss);
                return this.annotationGlossProcessor.process(glossCollection2, glossCollectionArray);
            }
        }
        return (GlossCollection)this.gFactory.getInstance(gloss);
    }

    private final class StateTrellisImpl
    extends StateTrellis {
        private final GlossProcessor extractor;

        protected StateTrellisImpl() {
            this.extractor = new StateMatrixGlossExtractor();
        }

        protected StateTrellisImpl(GlossFilter glossFilter) {
            super(glossFilter);
            this.extractor = new StateMatrixGlossExtractor();
        }

        @Override
        protected void extract() throws DLTException {
            block0: for (int i = this.elementList.head(); i < this.elementList.tail(); ++i) {
                GlossCollection glossCollection = this.elementList.gloss(i);
                if (glossCollection == null) continue;
                for (Gloss gloss : glossCollection) {
                    Object object;
                    if (gloss instanceof MidGloss && this.assign(i, gloss, (JaGramSetGloss)(object = (JaGramSetGloss)this.extractor.process(gloss)), null)) continue;
                    if (gloss instanceof TokenClassGloss) {
                        object = ((TokenClassGloss)gloss).getTrellisPayload();
                        this.assign(i, gloss, (TrellisPayload)((Object)object));
                        continue;
                    }
                    object = gloss instanceof Annotate ? TrellisPayload.PROPER_NOUN : TrellisPayload.UNKNOWN;
                    this.assign(i, glossCollection, (TrellisPayload)((Object)object));
                    continue block0;
                }
            }
        }

        private void assign(int n, Object object, TrellisPayload trellisPayload) throws DLTException {
            Utils.ObjectPair<GlossCollection, Boolean>[] objectPairArray = UniLexAnalyzerJa.this.reserved.get((Object)trellisPayload);
            if (objectPairArray == null) {
                return;
            }
            for (Utils.ObjectPair<GlossCollection, Boolean> objectPair : objectPairArray) {
                for (Gloss gloss : (GlossCollection)objectPair.l) {
                    JaGramSetGloss jaGramSetGloss = (JaGramSetGloss)this.extractor.process(gloss);
                    this.assign(n, object, jaGramSetGloss, (Boolean)objectPair.r);
                }
            }
        }

        private boolean assign(int n, Object object, JaGramSetGloss jaGramSetGloss, Boolean bl) {
            if (jaGramSetGloss == null) {
                return false;
            }
            StateMatrix stateMatrix = jaGramSetGloss.getData();
            if (stateMatrix == null) {
                return false;
            }
            int n2 = this.elementList.length(n);
            int n3 = (n2 == 1 ? 2 : n2) * jaGramSetGloss.getExt();
            this.matrixList.chainUp(n, this.matrixList.addElement(stateMatrix, object, n3, bl));
            return true;
        }

        @Override
        protected void terminate() {
            int n = this.getEndIndex();
            this.addElement(n, n, (GlossCollection)UniLexAnalyzerJa.this.reserved.get((Object)((Object)TrellisPayload.LAST_EPSILON))[0].l);
            this.addElement(n, n, (GlossCollection)UniLexAnalyzerJa.this.reserved.get((Object)((Object)TrellisPayload.LAST_EPSILON))[1].l);
        }
    }

    static final class StateMatrixGlossExtractor
    implements GlossProcessor {
        StateMatrixGlossExtractor() {
        }

        @Override
        public Object process(Object object) throws DLTException {
            if (object == null) {
                return null;
            }
            if (object instanceof MidGloss) {
                MidGloss midGloss = (MidGloss)object;
                return midGloss.getGloss(JaGramSetGloss.class);
            }
            return null;
        }

        @Override
        public void reset() {
        }
    }
}

