/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.InflectionParsingStreamKo;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzerTrellis;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.GlossPool;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.KoMorphGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.trellis.StateMatrix;
import com.ibm.dltj.trellis.StateTrellis;
import com.ibm.dltj.trellis.TrellisPayload;
import com.ibm.dltj.util.DecomposingCharacterIterator;
import com.ibm.dltj.util.HanNormalizer;
import com.ibm.dltj.util.Utils;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class UniLexAnalyzerKo
extends UniLexAnalyzerTrellis {
    protected final Map<TrellisPayload, Utils.ObjectPair<GlossCollection, Boolean>[]> reserved = new EnumMap<TrellisPayload, Utils.ObjectPair<GlossCollection, Boolean>[]>(TrellisPayload.class);
    private final Set<Dictionary> annoDictSet;
    private CharacterIterator originalIterator;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Deprecated
    UniLexAnalyzerKo(String string) throws DLTException {
        this(new ULocale(string));
    }

    UniLexAnalyzerKo(ULocale uLocale) throws DLTException {
        super(uLocale, HanNormalizer.createNormalizerJa());
        this.trellis = new StateTrellisImpl();
        this.annoDictSet = new HashSet<Dictionary>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2, n3);
        this.morphoSyntax.cmPolicy = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("");
        for (TrellisPayload trellisPayload : TrellisPayload.values()) {
            void var10_13;
            stringCharacterIterator.setText(trellisPayload.toReservedWord());
            GlossCollection glossCollection = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getBeginIndex(), stringCharacterIterator.getEndIndex(), 1);
            if (glossCollection == null) {
                stringCharacterIterator.setText(trellisPayload.toAlternative());
                GlossCollection glossCollection2 = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getBeginIndex(), stringCharacterIterator.getEndIndex(), 1);
                if (glossCollection2 == null) {
                    if (!trellisPayload.isOptional()) {
                        throw new DLTException(Messages.getString("invalid.dict.trellis"));
                    }
                    GlossCollection glossCollection3 = trellisPayload.getFallbackGloss();
                }
            }
            this.reserved.put(trellisPayload, this.prepareReservedGloss((GlossCollection)var10_13));
        }
        for (Dictionary dictionary : dictionaryArray) {
            for (GlossPool glossPool : dictionary.pools) {
                if (glossPool == null || !Annotate.class.isAssignableFrom(glossPool.getMainClass())) continue;
                this.annoDictSet.add(dictionary);
            }
        }
    }

    @Override
    public void close() throws DLTException {
        super.close();
        this.annoDictSet.clear();
    }

    @Override
    public CharacterIterator getSourceText() {
        return this.originalIterator == null ? null : (CharacterIterator)this.originalIterator.clone();
    }

    DecomposingCharacterIterator getDecomposedSourceText() {
        return this.characterIterator == null ? null : (DecomposingCharacterIterator)this.characterIterator.clone();
    }

    @Override
    protected int rawLookup(CharacterIterator characterIterator, MultiNet multiNet, MatchBuffer matchBuffer) {
        return multiNet.traverse(characterIterator, matchBuffer);
    }

    @Override
    protected ParsingStream doTextProcessing(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        this.originalIterator = characterIterator;
        return super.doTextProcessing(characterIterator, parsingStream);
    }

    @Override
    protected ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        if (this.reserved.isEmpty()) {
            throw new DLTException(Messages.getString("invalid.dict.trellis"));
        }
        if (!(this.m_pLPS instanceof InflectionParsingStreamKo) && !this.hasDwbreakFlag()) {
            if (!(characterIterator instanceof DecomposingCharacterIterator)) {
                this.characterIterator = new DecomposingCharacterIterator(characterIterator, DecomposingCharacterIterator.Form.NFKD);
            }
            this.m_pLPS = new InflectionParsingStreamKo(this.m_pLPS);
            this.m_pLPS.reset(this);
        }
        return super.doProcessText(characterIterator);
    }

    @Override
    protected void addRegExpEntry(int n, int n2) {
        GlossCollection glossCollection = this.morphoSyntax.getBreakRulesCollection();
        if (this.trellis.isEmpty()) {
            TokenClassGloss tokenClassGloss = (TokenClassGloss)glossCollection.first();
            if (tokenClassGloss != null && tokenClassGloss.getTrellisPayload() == TrellisPayload.PADDING) {
                return;
            }
            this.trellis.init(n);
        }
        this.trellis.addElement(n, n2, glossCollection);
    }

    @Override
    protected int stepForward(int n, int n2, TokenClassGloss tokenClassGloss) {
        int n3 = n + 1;
        if (n >= n2) {
            return n3;
        }
        switch (tokenClassGloss.getBestClass()) {
            case 303: 
            case 400: {
                return n3;
            }
        }
        return n2;
    }

    @Override
    protected void processGloss(int n, int n2, Gloss gloss) {
        this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, gloss, true));
    }

    @Override
    protected void processGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) {
        this.insertTokenClassGloss(n, n2, tokenClassGloss, object);
    }

    @Override
    protected void processGlossCollection(int n, int n2, GlossCollection glossCollection) {
        GlossCollection[] glossCollectionArray = this.trellis.getElement(n, n2);
        if (glossCollectionArray.length <= 1) {
            this.insertParsedGloss(n, n2, glossCollection);
            return;
        }
        this.insertParsedGloss(n, n2, UniLexAnalyzerKo.concatGlossCollection(glossCollectionArray));
    }

    @Override
    public void insertTokenClassGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) {
        if (tokenClassGloss.is(384)) {
            int n3 = Boolean.TRUE == object ? 65535 : 32768;
            this.m_pLPS.createUnknown(n3, n, n2, tokenClassGloss.getBestClass());
            this.inSentence = true;
            this.isFirstWord = false;
            return;
        }
        super.insertTokenClassGloss(n, n2, tokenClassGloss);
    }

    protected static boolean isCompoundWord(Gloss gloss) {
        if (gloss instanceof MidGloss) {
            KoMorphGloss koMorphGloss = (KoMorphGloss)((MidGloss)gloss).getGloss(KoMorphGloss.class);
            return koMorphGloss != null && koMorphGloss.isDividable();
        }
        return false;
    }

    protected static boolean isDecompoundedPiece(Object object) {
        if (object instanceof MidGloss) {
            KoMorphGloss koMorphGloss = (KoMorphGloss)((MidGloss)object).getGloss(KoMorphGloss.class);
            return koMorphGloss != null && !koMorphGloss.isDividable();
        }
        return object instanceof TokenClassGloss;
    }

    protected static boolean isNounWord(Gloss gloss) {
        if (gloss instanceof MidGloss) {
            KoMorphGloss koMorphGloss = (KoMorphGloss)((MidGloss)gloss).getGloss(KoMorphGloss.class);
            return koMorphGloss != null && koMorphGloss.isNoun();
        }
        return false;
    }

    private Utils.ObjectPair<GlossCollection, Boolean>[] prepareReservedGloss(GlossCollection glossCollection) {
        if (glossCollection == null) {
            return null;
        }
        GlossCollection glossCollection2 = new GlossCollection();
        GlossCollection glossCollection3 = new GlossCollection();
        for (Gloss gloss : glossCollection) {
            if (gloss instanceof MidGloss) {
                KoMorphGloss koMorphGloss = (KoMorphGloss)((MidGloss)gloss).getGloss(KoMorphGloss.class);
                if (koMorphGloss == null) {
                    Utils.ObjectPair<GlossCollection, Boolean> objectPair = new Utils.ObjectPair<GlossCollection, Boolean>(glossCollection, Boolean.FALSE);
                    return new Utils.ObjectPair[]{objectPair};
                }
                if (koMorphGloss.getPhraseStart() == 1) {
                    glossCollection3.add(gloss);
                    continue;
                }
            }
            glossCollection2.add(gloss);
        }
        return new Utils.ObjectPair[]{new Utils.ObjectPair<GlossCollection, Boolean>(glossCollection2, Boolean.FALSE), new Utils.ObjectPair<GlossCollection, Boolean>(glossCollection3, Boolean.TRUE)};
    }

    private GlossCollection collectGlossCollection(int n, int n2, Gloss gloss, boolean bl) {
        if (!UniLexAnalyzerKo.isNounWord(gloss) || this.annoDictSet.isEmpty()) {
            return (GlossCollection)this.gFactory.getInstance(gloss);
        }
        if (bl) {
            GlossCollection[] glossCollectionArray;
            for (GlossCollection glossCollection : glossCollectionArray = this.trellis.getElement(n, n2)) {
                if (!this.annoDictSet.contains(glossCollection.getOwnerDictionary())) continue;
                GlossCollection glossCollection2 = new GlossCollection(gloss);
                return this.annotationGlossProcessor.process(glossCollection2, glossCollectionArray);
            }
        }
        return (GlossCollection)this.gFactory.getInstance(gloss);
    }

    private final class StateTrellisImpl
    extends StateTrellis {
        private final GlossProcessor extractor = new StateMatrixGlossExtractor();

        protected StateTrellisImpl() {
        }

        @Override
        protected void extract() throws DLTException {
            block0: for (int i = this.elementList.head(); i < this.elementList.tail(); ++i) {
                GlossCollection glossCollection = this.elementList.gloss(i);
                if (glossCollection == null) continue;
                for (Gloss gloss : glossCollection) {
                    Object object;
                    if (gloss instanceof MidGloss && this.assign(i, gloss, (JaGramSetGloss)(object = (JaGramSetGloss)this.extractor.process(gloss)), null)) continue;
                    if (gloss instanceof TokenClassGloss) {
                        object = ((TokenClassGloss)gloss).getTrellisPayload();
                        this.assign(i, gloss, (TrellisPayload)((Object)object));
                        continue;
                    }
                    object = gloss instanceof Annotate ? TrellisPayload.PROPER_NOUN : TrellisPayload.UNKNOWN;
                    this.assign(i, glossCollection, (TrellisPayload)((Object)object));
                    continue block0;
                }
            }
        }

        private void assign(int n, Object object, TrellisPayload trellisPayload) throws DLTException {
            Utils.ObjectPair<GlossCollection, Boolean>[] objectPairArray = UniLexAnalyzerKo.this.reserved.get((Object)trellisPayload);
            if (objectPairArray == null) {
                return;
            }
            for (Utils.ObjectPair<GlossCollection, Boolean> objectPair : objectPairArray) {
                for (Gloss gloss : (GlossCollection)objectPair.l) {
                    JaGramSetGloss jaGramSetGloss = (JaGramSetGloss)this.extractor.process(gloss);
                    this.assign(n, object, jaGramSetGloss, (Boolean)objectPair.r);
                }
            }
        }

        private boolean assign(int n, Object object, JaGramSetGloss jaGramSetGloss, Boolean bl) {
            if (jaGramSetGloss == null) {
                return false;
            }
            StateMatrix stateMatrix = jaGramSetGloss.getData();
            if (stateMatrix == null) {
                return false;
            }
            int n2 = this.elementList.length(n);
            int n3 = (n2 == 1 ? 2 : n2) * jaGramSetGloss.getExt();
            this.matrixList.chainUp(n, this.matrixList.addElement(stateMatrix, object, n3, bl));
            return true;
        }

        @Override
        protected void terminate() {
            int n = this.getEndIndex();
            this.addElement(n, n, (GlossCollection)UniLexAnalyzerKo.this.reserved.get((Object)((Object)TrellisPayload.LAST_EPSILON))[0].l);
            this.addElement(n, n, (GlossCollection)UniLexAnalyzerKo.this.reserved.get((Object)((Object)TrellisPayload.LAST_EPSILON))[1].l);
        }
    }

    static final class StateMatrixGlossExtractor
    implements GlossProcessor {
        StateMatrixGlossExtractor() {
        }

        @Override
        public Object process(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof MidGloss) {
                MidGloss midGloss = (MidGloss)object;
                return midGloss.getGloss(JaGramSetGloss.class);
            }
            return null;
        }

        @Override
        public void reset() {
        }
    }
}

