/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.ThWordForm;
import com.ibm.dltj.UniLexAnalyzerTrellis;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.trellis.WeightTrellis;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.util.ArrayList;

final class UniLexAnalyzerTh
extends UniLexAnalyzerTrellis {
    static final int TH_WORD_UNIT_COMPLETE = 1001;
    static final int TH_WORD_UNIT_MINIMAL = 1002;
    static final int TH_WORD_UNIT_PARTIAL = 1003;
    static final int TH_WORD_UNIT_SWAP = 1004;
    static final int TH_WORD_UNIT_INVALID = 1005;
    private final ThWordForm thRule;
    private final TokenClassGloss defaultTkg;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Deprecated
    UniLexAnalyzerTh(String string) throws DLTException {
        this(new ULocale(string));
    }

    public UniLexAnalyzerTh(ULocale uLocale) throws DLTException {
        super(uLocale, null);
        this.trellis = new ThWeightTrellisImpl();
        this.thRule = new ThWordForm();
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(320);
        arrayList.add("word");
        this.defaultTkg = TokenClassGloss.fromSpec(arrayList);
    }

    @Override
    protected void processGlossCollection(int n, int n2, GlossCollection glossCollection) {
        Gloss gloss = glossCollection.first();
        if (gloss instanceof TokenClassGloss) {
            this.processGloss(n, n2, (TokenClassGloss)gloss, null);
            return;
        }
        if (gloss instanceof MapperGloss) {
            this.processGloss(n, n2, this.defaultTkg, null);
            return;
        }
        this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, glossCollection));
    }

    @Override
    protected void processGloss(int n, int n2, Gloss gloss) {
        this.processGlossCollection(n, n2, (GlossCollection)this.gFactory.getInstance(gloss));
    }

    @Override
    protected void processGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) {
        TokenClassGloss tokenClassGloss2 = tokenClassGloss;
        int n3 = tokenClassGloss2.getBestClass();
        if (1001 <= n3 && n3 <= 1005) {
            tokenClassGloss2 = this.defaultTkg;
        }
        this.insertTokenClassGloss(n, n2, tokenClassGloss2, null);
    }

    @Override
    protected int rawLookup(CharacterIterator characterIterator, MultiNet multiNet, MatchBuffer matchBuffer) {
        int n = characterIterator.getIndex();
        int n2 = multiNet.traverse(characterIterator, matchBuffer);
        characterIterator.setIndex(n);
        return n2 + this.ruleMatch(characterIterator, matchBuffer);
    }

    private int ruleMatch(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.thRule.matchWF(characterIterator, matchBuffer);
    }

    private GlossCollection collectGlossCollection(int n, int n2, GlossCollection glossCollection) {
        GlossCollection[] glossCollectionArray = this.trellis.getElement(n, n2);
        if (glossCollectionArray.length <= 1) {
            return glossCollection;
        }
        return this.annotationGlossProcessor.process(glossCollection, glossCollectionArray);
    }

    protected static final class ThWeightTrellisImpl
    extends WeightTrellis {
        protected ThWeightTrellisImpl() {
        }

        @Override
        protected void extract() {
            for (int i = this.elementList.head(); i < this.elementList.tail(); ++i) {
                GlossCollection glossCollection = this.elementList.gloss(i);
                if (glossCollection == null) continue;
                Gloss gloss = glossCollection.first();
                int n = 1000;
                int n2 = this.elementList.endIndex(i) - this.elementList.startIndex(i);
                if (gloss instanceof MidGloss) {
                    n = n / 2 - n2 * n2 * n2;
                } else if (gloss instanceof MapperGloss) {
                    n = n / 2 - n2 * n2;
                } else if (gloss instanceof TokenClassGloss) {
                    int n3 = ((TokenClassGloss)gloss).getBestClass();
                    switch (n3) {
                        case 1001: {
                            n = n / 2 - n2 * 2;
                            break;
                        }
                        case 1002: {
                            n = n / 2 - n2;
                            break;
                        }
                        case 1003: {
                            n -= n2 * 2;
                            break;
                        }
                        case 1004: {
                            n -= n2;
                            break;
                        }
                        case 1005: {
                            n += n2;
                            break;
                        }
                        default: {
                            n += n2 * n2;
                        }
                    }
                }
                this.assign(i, glossCollection, n);
            }
        }

        private void assign(int n, GlossCollection glossCollection, int n2) {
            this.weightList.chainUp(n, this.weightList.addElement(n2, glossCollection));
        }
    }
}

