/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.SimpleDecomposer;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.gloss.FeatureStructureGloss;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.gloss.ZhFreqGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.dltj.util.HanNormalizer;
import com.ibm.dltj.util.factory.ObjectFactory;
import com.ibm.dltj.util.factory.WeakRefCachedObjectFactory;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.CharacterIterator;
import java.util.ArrayList;

abstract class UniLexAnalyzerTrellis
extends UniLexAnalyzer {
    protected Trellis trellis;
    private final HanNormalizer normalizer;
    protected final ObjectFactory<Gloss, GlossCollection> gFactory = new WeakRefCachedObjectFactory<Gloss, GlossCollection>(){

        @Override
        protected GlossCollection create(Gloss gloss) {
            return new GlossCollection(new GlossListElement(gloss, null));
        }
    };
    protected final AnnotationGlossProcessor annotationGlossProcessor = new AnnotationGlossProcessor();
    private static final char SEPARATOR_HYPHEN = '-';
    private final SimpleDecomposer hyphenDecomposer = new SimpleDecomposer(new char[]{'-'}){

        @Override
        protected void processElement(int n, int n2) throws DLTException {
            UniLexAnalyzerTrellis.this.insertDecompElement(n, n2);
        }

        @Override
        protected void processBreak(int n, int n2) {
            UniLexAnalyzerTrellis.this.insertPunctuation(n, n2, 65535);
        }
    };

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected UniLexAnalyzerTrellis(ULocale uLocale, HanNormalizer hanNormalizer) throws DLTException {
        super(uLocale);
        this.normalizer = hanNormalizer;
        this.decompFlags |= 1;
    }

    @Override
    public void open(int n, int n2, int n3) throws DLTException {
        this.open(this.morphoSyntax.dictionaries, n, n2, n3);
    }

    @Override
    public void close() throws DLTException {
        super.close();
        if (this.trellis != null) {
            this.trellis.clear();
        }
        this.gFactory.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlossCollection dictLookup(CharacterIterator characterIterator, int n, int n2, int n3) throws DLTException {
        this.morphoSyntax.matches.clear();
        int n4 = characterIterator.getIndex();
        try {
            GlossCollection glossCollection = null;
            for (Dictionary dictionary : this.morphoSyntax.dictionaries) {
                characterIterator.setIndex(n);
                int n5 = this.rawLookup(characterIterator, dictionary.fsa, this.morphoSyntax.matches);
                if (n5 <= 0) continue;
                for (int i = 0; i < this.morphoSyntax.matches.mpos; ++i) {
                    int n6 = this.morphoSyntax.matches.index[i];
                    GlossCollection glossCollection2 = this.morphoSyntax.matches.gloss[i];
                    if (n6 != n2) continue;
                    if (n3 == 1) {
                        GlossCollection glossCollection3 = glossCollection2;
                        return glossCollection3;
                    }
                    if (glossCollection == null) {
                        glossCollection = new GlossCollection();
                    }
                    glossCollection.addAll(glossCollection2);
                }
            }
            Dictionary[] dictionaryArray = glossCollection;
            return dictionaryArray;
        }
        finally {
            characterIterator.setIndex(n4);
        }
    }

    private boolean doDictLookup() {
        int n;
        this.morphoSyntax.matches.clear();
        int n2 = this.characterIterator.getIndex();
        for (Dictionary dictionary : this.morphoSyntax.dictionaries) {
            int n3 = this.rawLookup(this.characterIterator, dictionary.fsa, this.morphoSyntax.matches);
            this.characterIterator.setIndex(n2);
            if (n3 > 0 && this.morphoSyntax.cmPolicy == 1) break;
        }
        return (n = this.morphoSyntax.matches.mpos) != 0;
    }

    protected abstract int rawLookup(CharacterIterator var1, MultiNet var2, MatchBuffer var3);

    private void addDictEntry(int n) {
        if (this.trellis.isEmpty()) {
            this.trellis.init(n);
        }
        for (int i = 0; i < this.morphoSyntax.matches.mpos; ++i) {
            int n2 = this.morphoSyntax.matches.index[i];
            GlossCollection glossCollection = this.morphoSyntax.matches.gloss[i];
            this.trellis.addElement(n, n2, glossCollection);
        }
    }

    protected void addRegExpEntry(int n, int n2) {
        if (this.trellis.isEmpty()) {
            this.trellis.init(n);
        }
        GlossCollection glossCollection = this.morphoSyntax.getBreakRulesCollection();
        this.trellis.addElement(n, n2, glossCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        try {
            Object object;
            int n = this.characterIterator.getBeginIndex();
            while (n < this.characterIterator.getEndIndex()) {
                this.characterIterator.setIndex(n);
                if (this.doDictLookup()) {
                    this.addDictEntry(n);
                }
                this.characterIterator.setIndex(n);
                object = this.morphoSyntax.evaluateBreakRules(this.characterIterator);
                int n2 = this.characterIterator.getIndex();
                if (((TokenClassGloss)object).is(1) && !this.trellis.isAmbiguous(n)) {
                    this.doProcessTrellis();
                    this.insertTokenClassGloss(n, n2, (TokenClassGloss)object);
                    n = n2;
                    continue;
                }
                this.addRegExpEntry(n, n2);
                n = this.stepForward(n, n2, (TokenClassGloss)object);
            }
            if (!this.trellis.isEmpty()) {
                this.doProcessTrellis();
            }
            object = this.m_pLPS;
            return object;
        }
        finally {
            if (!this.trellis.isEmpty()) {
                this.trellis.clear();
            }
        }
    }

    protected int stepForward(int n, int n2, TokenClassGloss tokenClassGloss) {
        int n3 = n + 1;
        if (n >= n2) {
            return n3;
        }
        switch (tokenClassGloss.getBestClass()) {
            case 301: {
                return n3;
            }
            case 304: {
                return this.hasDecompositionFlag(tokenClassGloss) ? n3 : n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doProcessTrellis() throws DLTException {
        if (this.trellis.isEmpty()) {
            return;
        }
        try {
            EdgeListElement edgeListElement = this.trellis.process();
            if (edgeListElement == null) {
                int n;
                int n2 = this.trellis.getStartIndex();
                if (n2 < (n = this.trellis.getEndIndex())) {
                    this.insertUnknown(n2, n, 0);
                }
                return;
            }
            for (EdgeListElement edgeListElement2 = edgeListElement; edgeListElement2 != null; edgeListElement2 = edgeListElement2.getNext()) {
                int n = edgeListElement2.getStartIndex();
                int n3 = edgeListElement2.getEndIndex();
                Object object = edgeListElement2.getGloss();
                if (n == n3) continue;
                if (object instanceof Gloss) {
                    if (object instanceof TokenClassGloss) {
                        this.processGloss(n, n3, (TokenClassGloss)object, edgeListElement2.getPayload());
                        continue;
                    }
                    this.processGloss(n, n3, (Gloss)object);
                    continue;
                }
                if (object instanceof GlossCollection) {
                    this.processGlossCollection(n, n3, (GlossCollection)object);
                    continue;
                }
                assert (false);
            }
        }
        finally {
            if (!this.trellis.isEmpty()) {
                this.trellis.clear();
            }
        }
    }

    protected abstract void processGloss(int var1, int var2, Gloss var3) throws DLTException;

    protected void processGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) throws DLTException {
        String string;
        String string2 = string = this.normalizer == null ? null : tokenClassGloss.getTrellisPayload().normalizeWithPrefix(this.normalizer, this.characterIterator, n, n2);
        if (string != null) {
            int n3 = 0;
            this.startDecompGroup(n, n2);
            this.fork();
            this.insertTokenClassGloss(n, n2, tokenClassGloss, object);
            ++n3;
            this.addToFork();
            MidGloss midGloss = new MidGloss(new Gloss[]{new LemmaGloss(string)});
            this.insertDecompElement(n, n2, new GlossCollection(new GlossListElement(midGloss, null)));
            this.closeDecompGroup(++n3);
            return;
        }
        if (!this.hasDecompHyphenOffFlag() && this.isHyphenWord(n, n2, tokenClassGloss)) {
            this.m_pLPS.startGroup(n, n2, 4);
            this.hyphenDecomposer.decompose(this.characterIterator, n, n2);
            this.m_pLPS.closeGroup(1);
            return;
        }
        this.insertTokenClassGloss(n, n2, tokenClassGloss, object);
    }

    protected void insertTokenClassGloss(int n, int n2, TokenClassGloss tokenClassGloss, Object object) {
        super.insertTokenClassGloss(n, n2, tokenClassGloss);
    }

    protected abstract void processGlossCollection(int var1, int var2, GlossCollection var3) throws DLTException;

    protected void insertDecompElement(int n, int n2) throws DLTException {
        GlossCollection glossCollection = this.dictLookup(this.characterIterator, n, n2, 0);
        if (glossCollection != null && !glossCollection.isEmpty()) {
            this.insertParsedGloss(n, n2, glossCollection);
            return;
        }
        TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator, n, n2);
        this.insertUnknownWord(n, n2, tokenClassGloss == null ? 0 : tokenClassGloss.getBestClass());
    }

    protected static GlossCollection concatGlossCollection(GlossCollection[] glossCollectionArray) {
        if (glossCollectionArray.length == 1) {
            return glossCollectionArray[0];
        }
        GlossCollection glossCollection = new GlossCollection();
        for (GlossCollection glossCollection2 : glossCollectionArray) {
            glossCollection.addAll(glossCollection2);
        }
        return glossCollection;
    }

    protected final boolean hasDwbreakFlag() {
        return (this._flagSpec & 1) != 0;
    }

    protected final boolean hasDecompositionFlag() {
        return (this._hints & 1) != 0;
    }

    protected boolean hasDecompositionFlag(Gloss gloss) {
        return this.hasDecompositionFlag();
    }

    protected final boolean hasDecompHyphenOffFlag() {
        return (this._hints & 2) != 0;
    }

    protected boolean isHyphenWord(int n, int n2, TokenClassGloss tokenClassGloss) {
        switch (tokenClassGloss.getBestClass()) {
            case 201: 
            case 202: 
            case 203: {
                return this.hyphenDecomposer.isCompoundWord(this.characterIterator, n, n2);
            }
        }
        return false;
    }

    protected static final class AnnotationGlossProcessor {
        private final ArrayList<String> types = new ArrayList();
        private final ArrayList<Gloss> list = new ArrayList();

        protected AnnotationGlossProcessor() {
        }

        public GlossCollection process(GlossCollection glossCollection, GlossCollection[] glossCollectionArray) {
            this.types.clear();
            GlossCollection glossCollection2 = glossCollection;
            Gloss gloss = glossCollection.first();
            this.types.add(AnnotationGlossProcessor.type(gloss));
            for (GlossCollection glossCollection3 : glossCollectionArray) {
                for (Gloss gloss2 : glossCollection3) {
                    if (!(gloss2 instanceof Annotate)) continue;
                    if (gloss2 instanceof MidGloss) {
                        String string = AnnotationGlossProcessor.type(gloss2);
                        if (string == null || this.types.contains(string)) continue;
                        gloss2 = this.edit((MidGloss)gloss2);
                    }
                    if (glossCollection2 == glossCollection) {
                        glossCollection2 = new GlossCollection(glossCollection);
                    }
                    glossCollection2.add(gloss2);
                    this.types.add(AnnotationGlossProcessor.type(gloss2));
                }
            }
            return glossCollection2;
        }

        private MidGloss edit(MidGloss midGloss) {
            try {
                MidGloss midGloss2 = midGloss instanceof FeatureStructureGloss ? new FeatureStructureGloss((FeatureStructureGloss)midGloss) : (MidGloss)midGloss.getClass().newInstance();
                midGloss2.element = this.filter(midGloss.element);
                return midGloss2;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return midGloss;
        }

        private Gloss[] filter(Gloss[] glossArray) {
            if (glossArray == null) {
                return glossArray;
            }
            this.list.clear();
            this.list.ensureCapacity(glossArray.length);
            for (Gloss gloss : glossArray) {
                if (gloss instanceof JaGramSetGloss || gloss instanceof ZhFreqGloss) continue;
                this.list.add(gloss);
            }
            return this.list.toArray(new Gloss[this.list.size()]);
        }

        private static String type(Gloss gloss) {
            if (gloss instanceof FeatureStructureGloss) {
                return ((FeatureStructureGloss)gloss).toFeaturesString();
            }
            try {
                Method method = gloss.getClass().getMethod("getUimaType", new Class[0]);
                return (String)method.invoke((Object)gloss, new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }
}

