/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzerTrellis;
import com.ibm.dltj.annotate.gloss.FeatureStructureGloss;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.gloss.ZhDecompGloss;
import com.ibm.dltj.gloss.ZhFreqGloss;
import com.ibm.dltj.gloss.ZhMorphGloss;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.WeightTrellis;
import com.ibm.dltj.util.HanNormalizer;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;

final class UniLexAnalyzerZh
extends UniLexAnalyzerTrellis {
    private static final int UNKNOWN_FREQUENCY = 70000;
    private final ChineseDecomposer decomposer = new ChineseDecomposer();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    @Deprecated
    UniLexAnalyzerZh(String string) throws DLTException {
        this(new ULocale(string));
    }

    UniLexAnalyzerZh(ULocale uLocale) throws DLTException {
        super(uLocale, HanNormalizer.createNormalizerZh());
        this.trellis = new WeightTrellisImpl();
    }

    @Override
    protected int rawLookup(CharacterIterator characterIterator, MultiNet multiNet, MatchBuffer matchBuffer) {
        return multiNet.whitespaceIgnoringTraverse(characterIterator, matchBuffer);
    }

    @Override
    protected void processGloss(int n, int n2, Gloss gloss) throws DLTException {
        this.processGlossCollection(n, n2, (GlossCollection)this.gFactory.getInstance(gloss));
    }

    @Override
    protected void processGlossCollection(int n, int n2, GlossCollection glossCollection) throws DLTException {
        if (glossCollection.first() instanceof TokenClassGloss) {
            this.processGloss(n, n2, (TokenClassGloss)glossCollection.first(), null);
            return;
        }
        if (this.hasDecompositionFlag() && UniLexAnalyzerZh.isCompoundWord(n, n2)) {
            this.decomposeWord(n, n2, glossCollection);
            return;
        }
        this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, glossCollection));
    }

    private GlossCollection collectGlossCollection(int n, int n2, GlossCollection glossCollection) {
        GlossCollection[] glossCollectionArray = this.trellis.getElement(n, n2);
        if (glossCollectionArray.length <= 1) {
            return glossCollection;
        }
        return this.annotationGlossProcessor.process(glossCollection, glossCollectionArray);
    }

    private static boolean isCompoundWord(int n, int n2) {
        return n2 - n > 2;
    }

    private void decomposeWord(int n, int n2, GlossCollection glossCollection) {
        MidGloss midGloss = (MidGloss)glossCollection.getGloss(MidGloss.class);
        if (midGloss == null) {
            midGloss = (MidGloss)glossCollection.getGloss(FeatureStructureGloss.class);
        }
        if (midGloss == null) {
            this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, glossCollection));
            return;
        }
        ZhDecompGloss zhDecompGloss = (ZhDecompGloss)midGloss.getGloss(ZhDecompGloss.class);
        if (zhDecompGloss == null) {
            this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, glossCollection));
            return;
        }
        assert (zhDecompGloss.value.length % 2 == 0);
        int n3 = 0;
        this.startDecompGroup(n, n2);
        this.fork();
        this.insertDecompElement(n, n2, glossCollection);
        ++n3;
        this.addToFork();
        if ((this._hints & 8) != 0) {
            this.decomposer.decomposeNoOverlap(this.characterIterator, n, n2, zhDecompGloss.value);
        } else {
            this.decomposer.decompose(this.characterIterator, n, n2, zhDecompGloss.value);
        }
        this.closeDecompGroup(++n3);
    }

    protected void processUnknownDecompElement(int n, int n2) {
        TokenClassGloss tokenClassGloss = this.morphoSyntax.evaluateBreakRules(this.characterIterator, n, n2);
        this.insertUnknownWord(n, n2, tokenClassGloss == null ? 0 : tokenClassGloss.getBestClass());
    }

    protected void processDecompElement(int n, int n2) {
        GlossCollection glossCollection;
        Gloss gloss;
        GlossCollection[] glossCollectionArray = this.trellis.getElement(n, n2);
        if (glossCollectionArray.length == 0) {
            this.processUnknownDecompElement(n, n2);
            return;
        }
        if (glossCollectionArray.length == 1 && (gloss = (glossCollection = glossCollectionArray[0]).first()) instanceof TokenClassGloss) {
            this.insertUnknownWord(n, n2, ((TokenClassGloss)gloss).getBestClass());
            return;
        }
        this.insertParsedGloss(n, n2, this.collectGlossCollection(n, n2, glossCollectionArray[0]));
    }

    protected static final class WeightTrellisImpl
    extends WeightTrellis {
        protected WeightTrellisImpl() {
        }

        protected WeightTrellisImpl(GlossFilter glossFilter) {
            super(glossFilter);
        }

        @Override
        protected void extract() throws DLTException {
            for (int i = this.elementList.head(); i < this.elementList.tail(); ++i) {
                GlossCollection glossCollection = this.elementList.gloss(i);
                if (glossCollection == null) continue;
                Gloss gloss = glossCollection.first();
                int n = 70000;
                if (gloss instanceof MidGloss) {
                    MidGloss midGloss = (MidGloss)gloss;
                    ZhFreqGloss zhFreqGloss = (ZhFreqGloss)midGloss.getGloss(ZhFreqGloss.class);
                    if (zhFreqGloss != null) {
                        n = zhFreqGloss.getFreq();
                    } else {
                        zhFreqGloss = (ZhMorphGloss)midGloss.getGloss(ZhMorphGloss.class);
                        if (zhFreqGloss != null) {
                            n = zhFreqGloss.getFreq();
                        }
                    }
                }
                this.assign(i, glossCollection, n);
            }
        }

        private void assign(int n, GlossCollection glossCollection, int n2) {
            this.weightList.chainUp(n, this.weightList.addElement(n2, glossCollection));
        }
    }

    protected final class ChineseDecomposer {
        private CharacterIterator ci;
        private int startIndex;
        private int endIndex;

        protected ChineseDecomposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decompose(CharacterIterator characterIterator, int n, int n2, byte[] byArray) {
            this.ci = characterIterator;
            this.startIndex = n;
            this.endIndex = n2;
            int n3 = this.ci.getIndex();
            try {
                int n4 = this.startIndex;
                int n5 = this.startIndex;
                if (0 < byArray[0]) {
                    n4 = this.startIndex;
                    n5 = this.backward(byArray[0]);
                    UniLexAnalyzerZh.this.processDecompElement(n4, n5);
                }
                for (int i = 0; i < byArray.length; i += 2) {
                    n4 = this.forward(byArray[i]);
                    n5 = this.backward(byArray[i + 1]);
                    UniLexAnalyzerZh.this.processDecompElement(n4, n5);
                }
                if (n5 < this.endIndex) {
                    n4 = this.forward(byArray[byArray.length - 1]);
                    n5 = this.endIndex;
                    UniLexAnalyzerZh.this.processDecompElement(n4, n5);
                }
            }
            finally {
                this.ci.setIndex(n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decomposeNoOverlap(CharacterIterator characterIterator, int n, int n2, byte[] byArray) {
            this.ci = characterIterator;
            this.startIndex = n;
            this.endIndex = n2;
            int n3 = this.ci.getIndex();
            try {
                int n4;
                byte by = 0;
                byte by2 = byArray[0];
                for (n4 = 0; n4 < byArray.length; n4 += 2) {
                    byte by3 = byArray[n4];
                    byte by4 = byArray[n4 + 1];
                    if (by == by3 && by4 > by2) {
                        by2 = by4;
                        continue;
                    }
                    if (by4 <= by2 || by2 > by3) continue;
                    UniLexAnalyzerZh.this.processDecompElement(this.forward(by), this.backward(by2));
                    if (by2 < by3) {
                        UniLexAnalyzerZh.this.processUnknownDecompElement(this.forward(by2), this.backward(by3));
                    }
                    by = by3;
                    by2 = by4;
                }
                n4 = this.backward(by2);
                if (n4 < this.endIndex) {
                    UniLexAnalyzerZh.this.processDecompElement(this.forward(by), n4);
                    by = by2;
                }
                UniLexAnalyzerZh.this.processDecompElement(this.forward(by), this.endIndex);
            }
            finally {
                this.ci.setIndex(n3);
            }
        }

        private int forward(int n) {
            int n2 = 0;
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                char c = this.ci.setIndex(i);
                if (Character.isWhitespace(c) || ++n2 <= n) continue;
                return i;
            }
            return this.endIndex;
        }

        private int backward(int n) {
            int n2 = 0;
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                char c = this.ci.setIndex(i);
                if (Character.isWhitespace(c) || ++n2 < n) continue;
                return i + 1;
            }
            return this.endIndex;
        }
    }
}

