/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniDictionaryManager;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.UniMorphoSyntaxFi;
import com.ibm.dltj.data.BreakIteratorManager;
import com.ibm.dltj.fst.CharacterMapping;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.gloss.TokenClassGloss;
import com.ibm.dltj.util.CharacterFilterSpecification;
import com.ibm.dltj.util.CharacterFilteringIterator;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;

class UniMorphoSyntax
extends UniDictionaryManager {
    MatchBuffer matches = new MatchBuffer();
    MatchBuffer break_matches = new MatchBuffer();
    int cmPolicy = 1;
    MultiNet[] multinets;
    CharacterFilteringIterator filteringIterator;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    UniMorphoSyntax() {
    }

    static UniMorphoSyntax getMorphoSyntax(ULocale uLocale) {
        if (UniLexAnalyzer.isSameLanguage(uLocale, UniLexAnalyzerConstants.FINNISH)) {
            return new UniMorphoSyntaxFi();
        }
        return new UniMorphoSyntax();
    }

    private void initializeBreakRules(UniLexAnalyzer uniLexAnalyzer) throws DLTException {
        if (this.break_rules == null) {
            this.setBreakRules(BreakIteratorManager.constructBreakIterator(uniLexAnalyzer.getBreakRulesLocale()));
        }
    }

    public void open(Dictionary[] dictionaryArray, int n, UniLexAnalyzer uniLexAnalyzer) throws DLTException {
        this.cmPolicy = n;
        this.matches.clear();
        this.setDictionaries(dictionaryArray);
        this.prepareDictionaries(uniLexAnalyzer);
        this.initializeBreakRules(uniLexAnalyzer);
    }

    public void open(int n, UniLexAnalyzer uniLexAnalyzer) throws DLTException {
        this.cmPolicy = n;
        this.matches.clear();
        this.prepareDictionaries(uniLexAnalyzer);
        this.initializeBreakRules(uniLexAnalyzer);
    }

    boolean prepareDictionary(CharacterFilterSpecification characterFilterSpecification, Dictionary dictionary) throws DLTException {
        if (!(dictionary.getNet() instanceof NetGenericDictionary)) {
            return false;
        }
        NetGenericDictionary netGenericDictionary = (NetGenericDictionary)dictionary.getNet();
        if (!(netGenericDictionary.getCharacterMap() instanceof CharacterMapping)) {
            return false;
        }
        CharacterMapping characterMapping = (CharacterMapping)((Object)netGenericDictionary.getCharacterMap());
        characterMapping.applySpecification(characterFilterSpecification);
        return true;
    }

    private void prepareDictionaries(UniLexAnalyzer uniLexAnalyzer) throws DLTException {
        int n;
        if (this.multinets == null || this.multinets.length != this.dictionaries.length) {
            this.multinets = new MultiNet[this.dictionaries.length];
        }
        for (n = 0; n < this.dictionaries.length; ++n) {
            this.multinets[n] = this.dictionaries[n].fsa;
        }
        n = 1;
        if (uniLexAnalyzer.getEquivalentCharacters(0) != null) {
            for (Dictionary dictionary : this.dictionaries) {
                n = n != 0 && this.prepareDictionary(uniLexAnalyzer, dictionary) ? 1 : 0;
            }
            for (Dictionary dictionary : this.oov_dictionaries) {
                n = n != 0 && this.prepareDictionary(uniLexAnalyzer, dictionary) ? 1 : 0;
            }
            for (Dictionary dictionary : this.mw_dictionaries_new) {
                n = n != 0 && this.prepareDictionary(uniLexAnalyzer, dictionary) ? 1 : 0;
            }
            for (Dictionary dictionary : this.mw_dictionaries_old) {
                n = n != 0 && this.prepareDictionary(uniLexAnalyzer, dictionary) ? 1 : 0;
            }
            for (Dictionary dictionary : this.tcr_dictionaries) {
                n = n != 0 && this.prepareDictionary(uniLexAnalyzer, dictionary) ? 1 : 0;
            }
            for (Dictionary dictionary : this.nta_dictionaries) {
                n = n != 0 && this.prepareDictionary(uniLexAnalyzer, dictionary) ? 1 : 0;
            }
        }
        this.filteringIterator = n != 0 ? null : new CharacterFilteringIterator(uniLexAnalyzer, null);
    }

    CharacterIterator prepareIterator(CharacterIterator characterIterator) {
        if (this.filteringIterator != null) {
            this.filteringIterator.setIterator(characterIterator);
            return this.filteringIterator;
        }
        return characterIterator;
    }

    protected boolean dictLookup(CharacterIterator characterIterator, UniLexAnalyzer.DictLookupPos dictLookupPos, int n) {
        int n2 = characterIterator.getIndex();
        boolean bl = false;
        while (dictLookupPos.dictIdx < this.multinets.length) {
            characterIterator.setIndex(n2);
            if (this.multinets[dictLookupPos.dictIdx].traverseLongest(characterIterator, this.matches, this.getCaseHandlingMethod(), n)) {
                bl = true;
                if (this.cmPolicy == 1) {
                    ++dictLookupPos.dictIdx;
                    break;
                }
            }
            ++dictLookupPos.dictIdx;
        }
        characterIterator.setIndex(n2);
        return bl;
    }

    public GlossCollection dictLookupWord(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        GlossCollection glossCollection = null;
        for (int i = 0; i < this.multinets.length; ++i) {
            characterIterator.setIndex(n3);
            GlossCollection glossCollection2 = this.multinets[i].get(characterIterator, n, this.getCaseHandlingMethod(), n2);
            if (glossCollection2 == null) continue;
            if (glossCollection == null) {
                glossCollection = new GlossCollection();
                glossCollection.addAll(glossCollection2);
                if (this.cmPolicy != 1) continue;
                return glossCollection;
            }
            glossCollection.addAll(glossCollection2);
        }
        return glossCollection;
    }

    protected GlossCollection oov_dictLookup(CharacterIterator characterIterator, int n, int n2) {
        if (this.oov_dictionaries.length <= 0) {
            return null;
        }
        GlossCollection glossCollection = null;
        int n3 = n2 - n;
        boolean bl = n3 < 5;
        for (int i = 0; i < this.oov_dictionaries.length; ++i) {
            characterIterator.setIndex(n2);
            GlossCollection glossCollection2 = (GlossCollection)this.oov_dictionaries[i].oovLookup(characterIterator, n3);
            if (glossCollection2 == null || bl && glossCollection2.isGeneric()) continue;
            if (glossCollection == null) {
                glossCollection = new GlossCollection();
                glossCollection.addAll(glossCollection2);
                if (this.cmPolicy != 1) continue;
                return glossCollection;
            }
            glossCollection.addAll(glossCollection2);
        }
        return glossCollection;
    }

    public TokenClassGloss evaluateBreakRules(CharacterIterator characterIterator) {
        return UniMorphoSyntax.evaluateBreakRules(characterIterator, this.break_matches, this.break_rules);
    }

    public static TokenClassGloss evaluateBreakRules(CharacterIterator characterIterator, MatchBuffer matchBuffer, Dictionary dictionary) {
        matchBuffer.clear();
        int n = characterIterator.getIndex();
        dictionary.lookupLongest(characterIterator, matchBuffer);
        assert (matchBuffer.mpos > 0);
        TokenClassGloss tokenClassGloss = (TokenClassGloss)matchBuffer.gloss[0].first();
        int n2 = tokenClassGloss.getMatchEnd(n, matchBuffer.index[0]);
        if (n2 <= characterIterator.getEndIndex()) {
            characterIterator.setIndex(n2);
        }
        return tokenClassGloss;
    }

    public GlossCollection getBreakRulesCollection() {
        return this.break_matches.gloss[0];
    }

    public TokenClassGloss evaluateBreakRules(CharacterIterator characterIterator, int n) {
        try {
            return (TokenClassGloss)this.break_rules.lookupWord(characterIterator, n).first();
        }
        catch (DLTException dLTException) {
            return null;
        }
    }

    public TokenClassGloss evaluateBreakRules(CharacterIterator characterIterator, int n, int n2) {
        characterIterator.setIndex(n);
        try {
            GlossCollection glossCollection = this.break_rules.lookupWord(characterIterator, n2 - n);
            if (glossCollection == null) {
                return null;
            }
            return (TokenClassGloss)glossCollection.first();
        }
        catch (DLTException dLTException) {
            return null;
        }
    }
}

