/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.algorithmichyphenation;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.HyphenationPoint;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.HyphenationGloss;
import com.ibm.dltj.gloss.HyphenationRuleGloss;
import com.ibm.dltj.util.LowercasingCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AlgorithmicHyphenationExtraction {
    Dictionary hyphenDict;
    List<HyphenationPoint> hyphenationPoints = new ArrayList<HyphenationPoint>();
    private static final char TERMINATOR = '?';
    private static final char DELIMITR = '\u00ad';
    private static final char BLANK = ' ';
    private static final char HYPHEN = '-';
    private static final char APOSTROPHE = '\'';
    private static final char UNDERSCORE = '\u00ad';
    private static final char PERIOD = '.';
    private static final char LPAREN = '(';
    private static final char QUOTE = '\"';
    private static final char GENERIC = '.';
    Dictionary exceptionalDict;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public boolean setAlgorithmicHyphenDictionary(Dictionary dictionary, String string) {
        int n;
        Integer[] integerArray = dictionary.getSummary().getFunctions(string);
        for (n = 0; n < integerArray.length && integerArray[n] != 84; ++n) {
        }
        if (n == integerArray.length) {
            return false;
        }
        this.exceptionalDict = null;
        if (string.startsWith("sv-SE")) {
            this.buildSEDictionary();
        }
        this.hyphenDict = dictionary;
        return true;
    }

    public List<HyphenationPoint> hyphenateWord(CharacterIterator characterIterator, int n, int n2) {
        LowercasingCharacterIterator lowercasingCharacterIterator = new LowercasingCharacterIterator(characterIterator);
        this.hyphenationPoints = new ArrayList<HyphenationPoint>();
        lowercasingCharacterIterator.setIndex(n);
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        stringBuffer.append(lowercasingCharacterIterator.current());
        for (int i = n + 1; i < n2; ++i) {
            stringBuffer.append(lowercasingCharacterIterator.next());
        }
        this.finalize(stringBuffer, n2 - n, 1);
        this.finalize(stringBuffer, n2 - n, 2);
        this.filter();
        return this.hyphenationPoints;
    }

    private void filter() {
        for (int i = 0; i < this.hyphenationPoints.size(); ++i) {
            if (this.hyphenationPoints.get(i).getType() < 128) continue;
            this.hyphenationPoints.remove(i);
            --i;
        }
    }

    private void finalize(StringBuffer stringBuffer, int n, int n2) {
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        int n3 = 0;
        int n4 = this.hyphenationPoints.size();
        int[] nArray = new int[n4 + 1];
        nArray[n4] = -1;
        for (int i = 0; i < n4; ++i) {
            HyphenationPoint hyphenationPoint = this.hyphenationPoints.get(i);
            stringBuffer.insert(n3 + hyphenationPoint.getPosition(), HyphenationGloss.HYPHENS[hyphenationPoint.getType()]);
            nArray[i] = n3 + hyphenationPoint.getPosition();
            ++n3;
            ++n;
        }
        n3 = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(stringBuffer.toString());
        MatchBuffer matchBuffer = new MatchBuffer(8);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n4 = 0;
        boolean bl = false;
        int n8 = 0;
        while (n8 < stringCharacterIterator.getEndIndex()) {
            stringCharacterIterator.setIndex(n8);
            matchBuffer.clear();
            if (this.exceptionalDict != null) {
                stringCharacterIterator.setIndex(n8);
                this.exceptionalDict.traverse(stringCharacterIterator, matchBuffer);
            }
            stringCharacterIterator.setIndex(n8);
            this.hyphenDict.traverse(stringCharacterIterator, matchBuffer);
            Gloss[] glossArray = this.refineMatchbuffer(stringCharacterIterator, n8, 0, stringBuffer.length(), matchBuffer, 84);
            HyphenationRuleGloss[] hyphenationRuleGlossArray = this.Sort(glossArray, n8, 0, stringBuffer.length(), n2, bl);
            if (hyphenationRuleGlossArray != null && hyphenationRuleGlossArray.length != 0) {
                List<HyphenationPoint> list = hyphenationRuleGlossArray[0].getHyphenationPoints();
                if (list == null || list.size() == 0) {
                    if (n8 == nArray[n5]) {
                        this.hyphenationPoints.remove(n4);
                        --n6;
                        ++n5;
                        ++n7;
                        int n9 = hyphenationRuleGlossArray[0].getEscapedCharacters();
                        for (int i = 1; i < n9 && i + n8 == nArray[n5]; ++i) {
                            this.hyphenationPoints.remove(n4);
                            ++n5;
                            ++n7;
                            ++n8;
                        }
                    } else {
                        n8 += hyphenationRuleGlossArray[0].getEscapedCharacters() - 1;
                        n6 += hyphenationRuleGlossArray[0].getEscapedCharacters() - 1;
                    }
                } else if (n8 == nArray[n5]) {
                    list = hyphenationRuleGlossArray[0].getHyphenationPoints(stringBuffer2, this.hyphenationPoints.get(n4).getPosition());
                    this.hyphenationPoints.set(n4, list.get(0));
                    if (n4 + 2 < this.hyphenationPoints.size() && this.isSpecialHyphens(this.hyphenationPoints.get(n4 + 1))) {
                        this.hyphenationPoints.set(n4, this.combineSpecialHyphen(this.hyphenationPoints.get(n5), this.hyphenationPoints.get(n5 + 1)));
                    }
                    ++n4;
                    ++n5;
                } else {
                    this.hyphenationPoints.addAll(n4, hyphenationRuleGlossArray[0].getHyphenationPoints(stringBuffer2, n6 - (n5 - n7)));
                    n4 += hyphenationRuleGlossArray[0].getHyphenationPoints(stringBuffer2, n6 - n5).size();
                    n8 += hyphenationRuleGlossArray[0].getEscapedCharacters() - 1;
                    n6 += hyphenationRuleGlossArray[0].getEscapedCharacters() - 1;
                }
                if (hyphenationRuleGlossArray[0].getNState() != -1) {
                    n2 = hyphenationRuleGlossArray[0].getNState();
                    bl = true;
                }
            } else if (n8 == nArray[n5]) {
                ++n4;
                ++n5;
            }
            ++n8;
            ++n6;
        }
    }

    private HyphenationPoint combineSpecialHyphen(Object object, Object object2) {
        int n = ((HyphenationPoint)object).getPosition();
        int n2 = ((HyphenationPoint)object).getType();
        StringBuffer stringBuffer = new StringBuffer(((HyphenationPoint)object).getWord());
        int n3 = ((HyphenationPoint)object2).getPosition();
        int n4 = ((HyphenationPoint)object2).getType();
        stringBuffer.insert(n3 + 1, HyphenationGloss.HYPHENS[n4]);
        HyphenationPoint hyphenationPoint = new HyphenationPoint(n, n2, stringBuffer.toString());
        return hyphenationPoint;
    }

    private boolean isSpecialHyphens(Object object) {
        return ((HyphenationPoint)object).getType() >= 220;
    }

    private Gloss[] refineMatchbuffer(CharacterIterator characterIterator, int n, int n2, int n3, MatchBuffer matchBuffer, int n4) {
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>();
        for (int i = 0; i < matchBuffer.mpos; ++i) {
            GlossCollection glossCollection = matchBuffer.gloss[i];
            for (Gloss gloss : glossCollection) {
                if (gloss.getType() != n4) continue;
                characterIterator.setIndex(matchBuffer.index[i]);
                if (!this.matchContext(characterIterator, ((HyphenationRuleGloss)gloss).getRightContext(), n2, n3, true, n, false)) continue;
                boolean bl = false;
                if (n > 0) {
                    characterIterator.setIndex(n - 1);
                } else {
                    characterIterator.setIndex(n);
                    bl = true;
                }
                if (!this.matchContext(characterIterator, ((HyphenationRuleGloss)gloss).getLeftContext(), n2, n3, false, n - 1, bl)) continue;
                arrayList.add(gloss);
            }
        }
        arrayList.trimToSize();
        return arrayList.toArray(new Gloss[0]);
    }

    private boolean matchContext(CharacterIterator characterIterator, String string, int n, int n2, boolean bl, int n3, boolean bl2) {
        int n4 = characterIterator.getIndex();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        block8: while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken();
                if (string2.equals("0xff")) {
                    boolean bl3 = stringTokenizer2.nextToken().equals("1");
                    for (int i = Integer.parseInt(stringTokenizer2.nextToken()); i > 0; --i) {
                        boolean bl4 = true;
                        for (int j = Integer.parseInt(stringTokenizer2.nextToken()); j > 0; --j) {
                            if (characterIterator.current() != stringTokenizer2.nextToken().charAt(0)) {
                                bl4 = false;
                                continue;
                            }
                            if (bl4 && j == 1) {
                                if (bl) {
                                    characterIterator.next();
                                } else {
                                    characterIterator.previous();
                                }
                                n4 = characterIterator.getIndex();
                                continue block8;
                            }
                            if (!bl && characterIterator.getIndex() == 0) {
                                bl4 = false;
                            }
                            if (bl) {
                                characterIterator.next();
                                continue;
                            }
                            characterIterator.previous();
                        }
                        characterIterator.setIndex(n4);
                    }
                    while (stringTokenizer2.hasMoreTokens()) {
                        if (characterIterator.current() != stringTokenizer2.nextToken().charAt(0)) continue;
                        if (bl) {
                            characterIterator.next();
                        } else {
                            characterIterator.previous();
                        }
                        n4 = characterIterator.getIndex();
                        continue block8;
                    }
                    if (bl3) continue block8;
                    return false;
                }
                block0 : switch (string2.charAt(0)) {
                    case '?': {
                        return bl && n4 >= n2 || !bl && (n4 < n || n3 == -1);
                    }
                    case '\u00ad': {
                        if (bl && n4 > n2 || !bl && (n4 < n || bl2)) {
                            return true;
                        }
                        switch (characterIterator.current()) {
                            case ' ': 
                            case '\"': 
                            case '\'': 
                            case '(': 
                            case '-': 
                            case '.': 
                            case '\u00ad': {
                                break block0;
                            }
                        }
                        return false;
                    }
                    case '.': {
                        if ((!bl || n4 <= n2) && (bl || n4 >= n || n4 == 0)) break;
                        return false;
                    }
                    default: {
                        if (bl && n4 > n2 || !bl && n4 < n && n4 != 0) {
                            return false;
                        }
                        if (string2.charAt(0) == characterIterator.current()) break;
                        return false;
                    }
                }
                if (!bl && characterIterator.getIndex() == 0) {
                    n4 = -1;
                    continue;
                }
                if (bl) {
                    characterIterator.next();
                } else {
                    characterIterator.previous();
                }
                n4 = characterIterator.getIndex();
            }
        }
        return true;
    }

    private HyphenationRuleGloss[] Sort(Gloss[] glossArray, int n, int n2, int n3, int n4, boolean bl) {
        HyphenationRuleGloss[] hyphenationRuleGlossArray = new HyphenationRuleGloss[glossArray.length];
        int n5 = 0;
        for (int i = 0; i < glossArray.length; ++i) {
            for (int j = i + 1; j < glossArray.length; ++j) {
                if (((HyphenationRuleGloss)glossArray[i]).getRuleno() <= ((HyphenationRuleGloss)glossArray[j]).getRuleno()) continue;
                HyphenationRuleGloss hyphenationRuleGloss = (HyphenationRuleGloss)glossArray[i];
                glossArray[i] = glossArray[j];
                glossArray[j] = hyphenationRuleGloss;
            }
            boolean bl2 = true;
            if (!bl) {
                if ((((HyphenationRuleGloss)glossArray[i]).getState() & n4) == 0) {
                    bl2 = false;
                }
            } else if (n4 < 50) {
                if (((HyphenationRuleGloss)glossArray[i]).getEstate() > 0 && ((HyphenationRuleGloss)glossArray[i]).getEstate() != n4) {
                    bl2 = false;
                }
            } else if (((HyphenationRuleGloss)glossArray[i]).getEstate() != n4) {
                bl2 = false;
            }
            if (((HyphenationRuleGloss)glossArray[i]).getLlscreen() > n - n2 || ((HyphenationRuleGloss)glossArray[i]).getBrscreen() > n3 - n || !bl2) continue;
            hyphenationRuleGlossArray[n5] = (HyphenationRuleGloss)glossArray[i];
            ++n5;
        }
        HyphenationRuleGloss[] hyphenationRuleGlossArray2 = new HyphenationRuleGloss[n5];
        System.arraycopy(hyphenationRuleGlossArray, 0, hyphenationRuleGlossArray2, 0, n5);
        return hyphenationRuleGlossArray2;
    }

    private boolean buildSEDictionary() {
        int n = HyphenationGloss.addSpecialHyphen('!');
        HyphenationRuleGloss hyphenationRuleGloss = new HyphenationRuleGloss("0xff,0,0,e,a,i,o,n,;", "", "\u00c4upp-!ack%", 0, 7, 3, 1, -1, 1, 6);
        HyphenationGloss.replaceSpecialHyphen(n, 'p');
        n = HyphenationGloss.addSpecialHyphen('!');
        HyphenationRuleGloss hyphenationRuleGloss2 = new HyphenationRuleGloss("", "", "\u00c4till-!\u00e4ggS", 0, 7, 3, 1, -1, 1, 7);
        HyphenationGloss.replaceSpecialHyphen(n, 'l');
        this.exceptionalDict = new Dictionary();
        try {
            this.exceptionalDict.addWord("uppack", new Gloss[]{hyphenationRuleGloss});
            this.exceptionalDict.addWord("till\u00e4gg", new Gloss[]{hyphenationRuleGloss2});
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        return true;
    }
}

