/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.annotate.gloss;

import com.ibm.dltj.AutoGlossSupport;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.annotate.Annotate;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.AnnotateFeature;
import com.ibm.dltj.annotate.Validate;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.StringArrayGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FeatureStructureGloss
extends MidGloss
implements Annotate,
AnnotateFeature,
Validate {
    protected String _typeName;
    protected String[] _featNames;

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public FeatureStructureGloss() {
        this._typeName = "";
        this._featNames = new String[0];
    }

    public FeatureStructureGloss(Gloss[] glossArray) throws DLTException {
        super(glossArray);
        this._typeName = "";
        this._featNames = new String[0];
    }

    private static Gloss[] addNames(StringArrayGloss stringArrayGloss, List<Gloss> list, List<Gloss> list2) {
        assert (stringArrayGloss.getStrings().length == list.size());
        Gloss[] glossArray = new Gloss[list.size() + list2.size() + 1];
        int n = 0;
        for (Gloss gloss : list2) {
            glossArray[n++] = gloss;
        }
        for (Gloss gloss : list) {
            glossArray[n++] = gloss;
        }
        glossArray[n] = stringArrayGloss;
        return glossArray;
    }

    public FeatureStructureGloss(String string, StringArrayGloss stringArrayGloss, List<Gloss> list, List<Gloss> list2) throws DLTException {
        this(string, FeatureStructureGloss.addNames(stringArrayGloss, list, list2));
        this._featNames = stringArrayGloss.getStrings();
    }

    public FeatureStructureGloss(FeatureStructureGloss featureStructureGloss) {
        this._typeName = featureStructureGloss._typeName;
        this._featNames = featureStructureGloss._featNames;
        this.element = featureStructureGloss.element;
    }

    private FeatureStructureGloss(String string, Gloss[] glossArray) throws DLTException {
        super(glossArray);
        this._typeName = string;
        this._featNames = ((StringArrayGloss)glossArray[glossArray.length - 1]).getStrings();
    }

    @Override
    public void annotateFeature(AnnotateContext annotateContext, int n, String string) throws AnnotateException {
        if (string == null) {
            throw new AnnotateException();
        }
        int n2 = annotateContext.createFS(this._typeName);
        int n3 = this.element.length - 1 - this._featNames.length;
        assert (n3 >= 0);
        for (int i = 0; i < this._featNames.length; ++i) {
            ((AnnotateFeature)((Object)this.element[n3 + i])).annotateFeature(annotateContext, n2, this._featNames[i]);
        }
        annotateContext.addChildFS(n2, string);
    }

    @Override
    public void annotate(AnnotateContext annotateContext) throws AnnotateException {
        int n = annotateContext.createFS(this._typeName);
        int n2 = this.element.length - 1 - this._featNames.length;
        assert (n2 >= 0);
        for (int i = 0; i < this._featNames.length; ++i) {
            ((AnnotateFeature)((Object)this.element[n2 + i])).annotateFeature(annotateContext, n, this._featNames[i]);
        }
        annotateContext.addFS(n);
    }

    @Override
    public int getType() {
        return 88;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FeatureStructureGloss)) {
            return false;
        }
        FeatureStructureGloss featureStructureGloss = (FeatureStructureGloss)object;
        if (!Arrays.equals(this.element, featureStructureGloss.element)) {
            return false;
        }
        return !(this._typeName == null ? featureStructureGloss._typeName != null : !this._typeName.equals(featureStructureGloss._typeName));
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.element);
        n = 37 * n + (this._typeName == null ? 0 : this._typeName.hashCode());
        return n;
    }

    public String toFeaturesString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._typeName);
        stringBuilder.append('(');
        int n = this.element.length - 1 - this._featNames.length;
        assert (n >= 0);
        for (int i = 0; i < this._featNames.length; ++i) {
            stringBuilder.append(this._featNames[i]);
            stringBuilder.append('=');
            stringBuilder.append(this.element[n + i].toString());
            stringBuilder.append(';');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.toFeaturesString());
        stringBuilder.setLength(stringBuilder.length() - 1);
        int n = this.element.length - 1 - this._featNames.length;
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.element[i].toString());
            stringBuilder.append(';');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        super.read(dataInputStream, n);
        this._typeName = AutoGlossSupport.readString(dataInputStream);
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        this._featNames = ((StringArrayGloss)this.element[this.element.length - 1]).getStrings();
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        super.write(dataOutputStream, glossMapper);
        AutoGlossSupport.writeString(dataOutputStream, this._typeName);
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        FeatureStructureGloss featureStructureGloss;
        Gloss[] glossArray = this.applyProcessorToElements(glossProcessor);
        if (glossArray == this.element) {
            featureStructureGloss = this;
        } else {
            featureStructureGloss = new FeatureStructureGloss(this._typeName, glossArray);
            featureStructureGloss.rtData = this.rtData;
        }
        return (Gloss)glossProcessor.process(featureStructureGloss);
    }

    public String getFSType() {
        return this._typeName;
    }

    public String[] getFeatureSpec() {
        return this._featNames;
    }

    public List<Gloss> getFeatureGlosses() {
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>();
        int n = this.element.length - 1 - this._featNames.length;
        assert (n >= 0);
        for (int i = 0; i < this._featNames.length; ++i) {
            arrayList.add(this.element[n + i]);
        }
        return arrayList;
    }

    public List<Gloss> getOtherGlosses() {
        ArrayList<Gloss> arrayList = new ArrayList<Gloss>();
        int n = this.element.length - 1 - this._featNames.length;
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.element[i]);
        }
        return arrayList;
    }

    @Override
    public boolean validate(AnnotateContext annotateContext) throws AnnotateException {
        for (Gloss gloss : this.element) {
            if (!(gloss instanceof Validate) || ((Validate)((Object)gloss)).validate(annotateContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Gloss mergeGloss(Object object) {
        Gloss gloss = super.mergeGloss(object);
        if (gloss.getClass() == this.getClass()) {
            ((FeatureStructureGloss)gloss)._typeName = this._typeName;
            ((FeatureStructureGloss)gloss)._featNames = this._featNames;
        }
        return gloss;
    }
}

