/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.annotate.gloss;

import com.ibm.dltj.AutoGlossSupport;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.AnnotateFeature;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IntegerFeatGloss
extends Gloss
implements AnnotateFeature {
    private int _featVal;

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public IntegerFeatGloss() {
    }

    public IntegerFeatGloss(Integer n) {
        this._featVal = n;
    }

    @Override
    public int getType() {
        return 89;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntegerFeatGloss)) {
            return false;
        }
        IntegerFeatGloss integerFeatGloss = (IntegerFeatGloss)object;
        return this._featVal == integerFeatGloss._featVal;
    }

    @Override
    public int hashCode() {
        return this._featVal;
    }

    @Override
    public String toString() {
        return String.valueOf(this._featVal);
    }

    public int getValue() {
        return this._featVal;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this._featVal = AutoGlossSupport.readInteger(dataInputStream);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        AutoGlossSupport.writeInteger(dataOutputStream, this._featVal);
    }

    @Override
    public void annotateFeature(AnnotateContext annotateContext, int n, String string) throws AnnotateException {
        annotateContext.setInteger(n, string, this._featVal);
    }
}

