/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.annotate.gloss;

import com.ibm.dltj.AutoGlossSupport;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.Validate;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaPatternGloss
extends Gloss
implements Validate {
    static final String lemmaIndicator = "[lemma]";
    Pattern pattern;
    boolean onLemma;

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public JavaPatternGloss() {
    }

    private void interpretString(String string) {
        if (string.startsWith(lemmaIndicator)) {
            string = string.substring(lemmaIndicator.length());
            this.onLemma = true;
        } else {
            this.onLemma = false;
        }
        this.pattern = Pattern.compile(string);
    }

    public JavaPatternGloss(String string) {
        this.interpretString(string);
    }

    @Override
    public int getType() {
        return 92;
    }

    @Override
    public String toString() {
        return this.onLemma ? lemmaIndicator + this.pattern.pattern() : this.pattern.pattern();
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        String string = AutoGlossSupport.readString(dataInputStream);
        this.interpretString(string);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        AutoGlossSupport.writeString(dataOutputStream, this.toString());
    }

    @Override
    public boolean validate(AnnotateContext annotateContext) throws AnnotateException {
        String string;
        if (annotateContext.getCachedDatum(this) != null) {
            return true;
        }
        String string2 = string = this.onLemma ? annotateContext.getCurrentLemma() : annotateContext.getCurrentSurfaceForm();
        if (string == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.matches()) {
            annotateContext.addCachedDatum(this, matcher);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.pattern == null ? 0 : this.pattern.pattern().hashCode()) ^ (this.onLemma ? -1 : 0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavaPatternGloss javaPatternGloss = (JavaPatternGloss)object;
        if (this.onLemma != javaPatternGloss.onLemma) {
            return false;
        }
        return !(this.pattern == null ? javaPatternGloss.pattern != null : !this.pattern.pattern().equals(javaPatternGloss.pattern.pattern()));
    }
}

