/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.annotate.gloss;

import com.ibm.dltj.AutoGlossSupport;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.AnnotateFeature;
import com.ibm.dltj.annotate.Validate;
import com.ibm.dltj.annotate.gloss.JavaPatternGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;

public class JavaRegexTransformGloss
extends Gloss
implements AnnotateFeature,
Validate {
    private Gloss patGloss;
    private String outPattern;

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public JavaRegexTransformGloss() {
        this.outPattern = "";
    }

    public JavaRegexTransformGloss(String string, String string2) {
        this(new JavaPatternGloss(string), string2);
    }

    public JavaRegexTransformGloss(JavaPatternGloss javaPatternGloss, String string) {
        this.patGloss = javaPatternGloss;
        this.outPattern = string;
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public String toString() {
        return this.patGloss + "->" + this.outPattern;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.patGloss = new MapperGloss(dataInputStream.readInt());
        this.outPattern = AutoGlossSupport.readString(dataInputStream);
    }

    @Override
    public void recalcPointers(Gloss[] glossArray) {
        this.patGloss = glossArray[((MapperGloss)this.patGloss).map];
    }

    @Override
    public Gloss applyGlossProcessor(GlossProcessor glossProcessor) throws DLTException {
        Gloss gloss = this.patGloss.applyGlossProcessor(glossProcessor);
        JavaRegexTransformGloss javaRegexTransformGloss = gloss == this.patGloss ? this : new JavaRegexTransformGloss((JavaPatternGloss)gloss, this.outPattern);
        return (Gloss)glossProcessor.process(javaRegexTransformGloss);
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(glossMapper.getGlossIndex(this.patGloss));
        AutoGlossSupport.writeString(dataOutputStream, this.outPattern);
    }

    @Override
    public void annotateFeature(AnnotateContext annotateContext, int n, String string) throws AnnotateException {
        Matcher matcher = (Matcher)annotateContext.getCachedDatum(this.patGloss);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        String string2 = this.outPattern;
        while (n2 < string2.length()) {
            char c = string2.charAt(n2);
            if (c == '\\') {
                c = string2.charAt(++n2);
                stringBuffer.append(c);
                ++n2;
                continue;
            }
            if (c == '$') {
                int n3;
                int n4;
                if ((n4 = string2.charAt(++n2) - 48) < 0 || n4 > 9) {
                    throw new IllegalArgumentException(Messages.getString("error.gloss.illegalref"));
                }
                ++n2;
                boolean bl = false;
                while (!bl && n2 < string2.length() && (n3 = string2.charAt(n2) - 48) >= 0 && n3 <= 9) {
                    int n5 = n4 * 10 + n3;
                    if (matcher.groupCount() < n5) {
                        bl = true;
                        continue;
                    }
                    n4 = n5;
                    ++n2;
                }
                if (matcher.group(n4) == null) continue;
                stringBuffer.append(matcher.group(n4));
                continue;
            }
            stringBuffer.append(c);
            ++n2;
        }
        annotateContext.setString(n, string, stringBuffer.toString());
    }

    @Override
    public boolean validate(AnnotateContext annotateContext) throws AnnotateException {
        return ((Validate)((Object)this.patGloss)).validate(annotateContext);
    }

    @Override
    public int hashCode() {
        int n = this.patGloss == null ? 0 : this.patGloss.hashCode();
        n = 31 * n + (this.outPattern == null ? 0 : this.outPattern.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavaRegexTransformGloss javaRegexTransformGloss = (JavaRegexTransformGloss)object;
        if (this.patGloss == null ? javaRegexTransformGloss.patGloss != null : !this.patGloss.equals(javaRegexTransformGloss.patGloss)) {
            return false;
        }
        return !(this.outPattern == null ? javaRegexTransformGloss.outPattern != null : !this.outPattern.equals(javaRegexTransformGloss.outPattern));
    }
}

