/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.annotate.gloss;

import com.ibm.dltj.AutoGlossSupport;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.annotate.AnnotateContext;
import com.ibm.dltj.annotate.AnnotateException;
import com.ibm.dltj.annotate.AnnotateFeature;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class StringArrayFeatGloss
extends Gloss
implements AnnotateFeature {
    private String[] _featValues;

    public static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public StringArrayFeatGloss() {
        this(new String[0]);
    }

    public StringArrayFeatGloss(String[] stringArray) {
        this._featValues = stringArray;
    }

    public StringArrayFeatGloss(List<String> list) {
        this(list.toArray(new String[list.size()]));
    }

    @Override
    public int getType() {
        return 93;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StringArrayFeatGloss)) {
            return false;
        }
        StringArrayFeatGloss stringArrayFeatGloss = (StringArrayFeatGloss)object;
        return Arrays.equals(this._featValues, stringArrayFeatGloss._featValues);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this._featValues);
    }

    @Override
    public String toString() {
        return Arrays.toString(this._featValues);
    }

    public String[] getValue() {
        return this._featValues;
    }

    @Override
    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this._featValues = new String[n];
        for (int i = 0; i < n; ++i) {
            this._featValues[i] = AutoGlossSupport.readString(dataInputStream);
        }
    }

    @Override
    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this._featValues.length);
        for (String string : this._featValues) {
            AutoGlossSupport.writeString(dataOutputStream, string);
        }
    }

    @Override
    public void annotateFeature(AnnotateContext annotateContext, int n, String string) throws AnnotateException {
        annotateContext.setStringArray(n, string, this._featValues);
    }
}

