/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.crf.FeatureValueClassifier;
import com.ibm.dltj.crf.FeatureValueMapping;
import com.ibm.dltj.crf.FeatureValueMappingDense;
import com.ibm.dltj.crf.FeatureValueMappingSparse;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import com.ibm.dltj.crf.feature.handler.FeatureHandlerFactory;
import com.ibm.dltj.crf.feature.template.FeatureTemplate;
import com.ibm.dltj.crf.feature.template.FeatureTemplateGraph;
import com.ibm.dltj.crf.feature.template.FeatureTemplateParser;
import com.ibm.dltj.fst.NetGenericDictionary;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.CRFLabelSetGloss;
import com.ibm.dltj.gloss.CRFLearningRate;
import com.ibm.dltj.gloss.CRFLearningRateGloss;
import com.ibm.dltj.gloss.CRFTransitionFeatureGloss;
import com.ibm.dltj.gloss.StringArrayGloss;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.tagger.feature.Tag;
import com.ibm.dltj.util.ArrayUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CRFDictionary {
    private static final int[] GLOSS_TYPES = new int[]{60, 86, 50, 51, 52, 53};
    private final Dictionary _dic;
    private FeatureValueMapping _mapping;
    private FeatureValueClassifier _classifier;
    private FeatureTemplate[] _templates;
    private FeatureTemplate[] _stateTemplates;
    private FeatureTemplate[] _transitionTemplates;
    private FeatureTemplateGraph[] _stateTemplatesGraph;
    private CRFLabelSet _labelSet;
    private CRFLearningRate _learningRate;
    private FeatureHandler[] _featureHandlers;
    private String[] _featurePaths;
    private boolean _editable = false;
    public static final String CRF = "CRF";
    private static final String DEFAULT_LEARNING_ALGORITHM = "L1-SGD";
    private static final String DICTIONARY_BUILDER_VERSION = "2";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private CRFDictionary(Dictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException();
        }
        this._dic = dictionary;
    }

    public static CRFDictionary newInstance(File file) throws DLTException, IOException {
        CRFDictionary cRFDictionary = new CRFDictionary(new Dictionary());
        cRFDictionary.load(file);
        return cRFDictionary;
    }

    /*
     * WARNING - void declaration
     */
    public static CRFDictionary newInstance(File file, EnumMap<PropertyName, Object> enumMap) throws DLTException, IOException {
        void var13_19;
        List<String> list;
        List<String> list2;
        String string;
        if (file == null || enumMap == null) {
            throw new IllegalArgumentException();
        }
        String string2 = (String)enumMap.get((Object)PropertyName.DIC_COPYRIGHT);
        if (string2 == null) {
            string2 = "";
        }
        DictionaryInfo dictionaryInfo = new DictionaryInfo((string = (String)enumMap.get((Object)PropertyName.DIC_VERSION)) == null ? 0x8000400L : (long)Integer.parseInt(string, 16), true, true, false, true, false, string2, false, true, false, 7000);
        dictionaryInfo.setDescription("IBM LanguageWare CRF Dictionary (" + DLT.getStrVersion() + ")");
        Dictionary dictionary = Dictionary.createDictionary(file, dictionaryInfo);
        String string3 = (String)enumMap.get((Object)PropertyName.DIC_LANGUAGE);
        if (string3 == null) {
            string3 = "";
        }
        for (int n : GLOSS_TYPES) {
            dictionary.registerType(n, string3);
        }
        Object object = new CRFDictionary(dictionary);
        super.setAttribute(ReservedWord.LEARNING_ALGORITHM, new StringGloss(DEFAULT_LEARNING_ALGORITHM));
        super.setAttribute(ReservedWord.LEARNING_RATE, new CRFLearningRateGloss());
        List<String> list3 = (List<String>)enumMap.get((Object)PropertyName.FEATURE_MAPPING);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        super.setMapping(list3);
        String string4 = (String)enumMap.get((Object)PropertyName.LABEL_CLASSNAME);
        if (string4 != null && !string4.isEmpty() && !string4.equals(Tag.class.getName())) {
            list2 = new ArrayList();
            try {
                list = Class.forName(string4);
                for (Object obj : ((Class)((Object)list)).getEnumConstants()) {
                    list2.add(obj.toString());
                }
                list2.remove("START");
                list2.remove("FINAL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            super.setAttribute(ReservedWord.LABEL_CLASS, new StringGloss(string4));
            super.setAttribute(ReservedWord.LABEL_SET, new CRFLabelSetGloss(list2));
        } else {
            list2 = (List<String>)enumMap.get((Object)PropertyName.LABEL_SET);
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            super.setAttribute(ReservedWord.LABEL_CLASS, new StringGloss(Tag.class.getName()));
            super.setAttribute(ReservedWord.LABEL_SET, new CRFLabelSetGloss(list2));
        }
        super.setFeatureMapping(new FeatureValueMappingSparse(((CRFDictionary)object).getLabelSet().size(), ((NetGenericDictionary)dictionary.getNet()).getCharacterMap()));
        list2 = (List<String>)enumMap.get((Object)PropertyName.FEATURE_TEMPLATE);
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        super.setFeatureTemplate(list2);
        list = (List)enumMap.get((Object)PropertyName.FEATURE_PATH);
        if (list == null) {
            list = Collections.emptyList();
        }
        super.setAttribute(ReservedWord.FEATURE_PATH_LIST, new StringArrayGloss(list));
        List list4 = (List)enumMap.get((Object)PropertyName.FEATURE_HANDLER);
        if (list4 == null) {
            List list5 = Collections.emptyList();
        }
        super.setAttribute(ReservedWord.FEATURE_HANDLER_LIST, new StringArrayGloss((List<String>)var13_19));
        URL uRL = (URL)enumMap.get((Object)PropertyName.FEATURE_REGEX);
        super.setFeatureValueClassifier(uRL);
        return object;
    }

    public <K> void setAttribute(K k, String string) throws DLTException {
        this.setAttribute(k, new StringGloss(string));
    }

    public <K> void setAttributeList(K k, List<String> list) throws DLTException {
        this.setAttribute(k, new StringArrayGloss(list));
    }

    private <K> void setAttribute(K k, Gloss gloss) throws DLTException {
        if (gloss == null) {
            return;
        }
        this._dic.addWord(k.toString(), this._dic.addGloss(gloss.getType(), gloss));
    }

    private void setMapping(List<String> list) throws DLTException {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            String string2;
            String string3;
            if (string.length() == 0 || string.startsWith("#")) continue;
            if (string.contains("\t")) {
                String[] stringArray = string.split("\t");
                string3 = stringArray[0];
                string2 = stringArray[1];
            } else {
                string3 = string;
                string2 = string;
            }
            this.setAttribute(string3, new StringGloss(string2));
        }
    }

    private void setFeatureTemplate(List<String> list) throws DLTException {
        if (list == null || list.isEmpty()) {
            return;
        }
        FeatureTemplateParser featureTemplateParser = new FeatureTemplateParser(this.getFeatureMapping());
        for (FeatureTemplate featureTemplate : featureTemplateParser.parse(list)) {
            FeatureTemplate.Type type = featureTemplate.getType();
            if (type == FeatureTemplate.Type.UNIGRAM) {
                this.setAttribute(ReservedWord.STATE_FEATURE_TEMPLATE_LIST, new StringGloss(featureTemplate.toString()));
                continue;
            }
            if (type != FeatureTemplate.Type.BIGRAM) continue;
            this.setAttribute(ReservedWord.TRANSITION_FEATURE_TEMPLATE_LIST, new StringGloss(featureTemplate.toString()));
        }
    }

    private void setFeatureMapping(FeatureValueMapping featureValueMapping) {
        assert (featureValueMapping != null);
        this._mapping = featureValueMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFeatureValueClassifier(URL uRL) throws IOException {
        if (uRL == null) {
            this._classifier = FeatureValueClassifier.newInstance();
            return;
        }
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
            this._classifier = FeatureValueClassifier.newInstance((DataInput)((Object)filterInputStream));
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws DLTException, IOException {
        byte[] byArray;
        long l;
        if (file == null) {
            throw new FileNotFoundException();
        }
        this._dic.setFile(file);
        this._dic.load(file);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            long l2 = randomAccessFile.length() - 8L;
            randomAccessFile.seek(l2);
            l = randomAccessFile.readLong();
            long l3 = randomAccessFile.length() - l;
            randomAccessFile.seek(l3);
            byArray = new byte[(int)(l2 - l3)];
            randomAccessFile.readFully(byArray);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        while (byteArrayInputStream.available() > 0) {
            l = dataInputStream.readLong();
            if (l == 4851017085447075174L) {
                this._mapping = new FeatureValueMappingDense(dataInputStream, ((NetGenericDictionary)this._dic.getNet()).getCharacterMap());
                this._mapping.setEditable(this._editable);
                continue;
            }
            if (l == 4851017085447075175L) {
                this._mapping = new FeatureValueMappingSparse(dataInputStream, ((NetGenericDictionary)this._dic.getNet()).getCharacterMap());
                this._mapping.setEditable(this._editable);
                continue;
            }
            if (l != 4851017004026524531L) break;
            this._classifier = FeatureValueClassifier.newInstance(dataInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Collection<Map.Entry<String, String>> collection) throws DLTException, IOException {
        this._dic.getSummary().addBuildHistoryStep(this.getClass().getSimpleName() + DICTIONARY_BUILDER_VERSION, collection);
        this._dic.save();
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._dic.getFile(), true)));
            int n = ((DataOutputStream)filterOutputStream).size();
            this._mapping.save((DataOutput)((Object)filterOutputStream));
            this._classifier.save((DataOutput)((Object)filterOutputStream));
            int n2 = ((DataOutputStream)filterOutputStream).size();
            int n3 = n2 - n + 8;
            ((DataOutputStream)filterOutputStream).writeLong(n3);
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public void save() throws DLTException, IOException {
        this.save(null);
    }

    public boolean isEditable() {
        assert (this._mapping == null || this._editable == this._mapping.isEditable());
        assert (this._labelSet == null || this._editable == this._labelSet.isEditable());
        return this._editable;
    }

    void setEditable(boolean bl) {
        this._editable = bl;
        this._mapping.setEditable(bl);
        this.getLabelSet().setEditable(bl);
    }

    public Dictionary getDictionary() {
        return this._dic;
    }

    public <K> String getAttribute(K k) {
        return this.getAttribute(k, "");
    }

    public <K> String getAttribute(K k, String string) {
        GlossCollection glossCollection = this._dic.get(k.toString());
        if (glossCollection != null) {
            for (Gloss gloss : glossCollection) {
                if (gloss.getType() != 60) continue;
                return ((StringGloss)gloss).getValue();
            }
        }
        return string;
    }

    public <K> List<String> getAttributeList(K k) {
        return this.getAttributeList(k, Collections.<String>emptyList());
    }

    public <K> List<String> getAttributeList(K k, List<String> list) {
        GlossCollection glossCollection = this._dic.get(k.toString());
        if (glossCollection != null) {
            ArrayList<String> arrayList = new ArrayList<String>(glossCollection.size());
            for (Gloss gloss : glossCollection) {
                String[] stringArray;
                if (gloss.getType() == 60) {
                    arrayList.add(((StringGloss)gloss).getValue());
                }
                if (gloss.getType() != 86) continue;
                for (String string : stringArray = ((StringArrayGloss)gloss).getStrings()) {
                    arrayList.add(string);
                }
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return list;
    }

    public CRFLabelSet getLabelSet() {
        if (this._labelSet == null) {
            GlossCollection glossCollection = this._dic.get(ReservedWord.LABEL_SET.toString());
            assert (glossCollection.size() == 1);
            this._labelSet = (CRFLabelSet)glossCollection.iterator().next();
            this._labelSet.setEditable(this._editable);
        }
        return this._labelSet;
    }

    FeatureTemplate[] getFeatureTemplate() throws DLTException {
        if (this._templates == null) {
            ArrayList<FeatureTemplate> arrayList = new ArrayList<FeatureTemplate>();
            for (FeatureTemplate featureTemplate : this.getStateFeatureTemplate()) {
                arrayList.add(featureTemplate);
            }
            for (FeatureTemplate featureTemplate : this.getTransitionFeatureTemplate()) {
                arrayList.add(featureTemplate);
            }
            this._templates = arrayList.toArray(new FeatureTemplate[arrayList.size()]);
        }
        return this._templates;
    }

    FeatureTemplate[] getStateFeatureTemplate() throws DLTException {
        if (this._stateTemplates == null) {
            List<String> list = this.getAttributeList(ReservedWord.STATE_FEATURE_TEMPLATE_LIST);
            FeatureTemplateParser featureTemplateParser = new FeatureTemplateParser(this.getFeatureMapping());
            List<FeatureTemplate> list2 = featureTemplateParser.parse(list);
            this._stateTemplates = list2.toArray(new FeatureTemplate[list2.size()]);
        }
        return this._stateTemplates;
    }

    FeatureTemplateGraph[] getStateFeatureTemplateGraph() throws DLTException {
        if (this._stateTemplatesGraph == null) {
            this._stateTemplatesGraph = FeatureTemplateGraph.buildGraph(Arrays.asList(this.getStateFeatureTemplate()));
        }
        return this._stateTemplatesGraph;
    }

    FeatureTemplate[] getTransitionFeatureTemplate() throws DLTException {
        if (this._transitionTemplates == null) {
            List<String> list = this.getAttributeList(ReservedWord.TRANSITION_FEATURE_TEMPLATE_LIST);
            FeatureTemplateParser featureTemplateParser = new FeatureTemplateParser(this.getFeatureMapping());
            List<FeatureTemplate> list2 = featureTemplateParser.parse(list);
            this._transitionTemplates = list2.toArray(new FeatureTemplate[list2.size()]);
        }
        return this._transitionTemplates;
    }

    public CRFLearningRate getLearningRate() {
        if (this._learningRate == null) {
            GlossCollection glossCollection = this._dic.get(ReservedWord.LEARNING_RATE.toString());
            assert (glossCollection.size() == 1);
            this._learningRate = (CRFLearningRate)glossCollection.iterator().next();
        }
        return this._learningRate;
    }

    public FeatureValueClassifier getFeatureValueClassifier() {
        return this._classifier;
    }

    @Deprecated
    public Pattern getNumericPattern() {
        String string = this.getAttribute(ReservedWord.PATTERN_NUMERIC, null);
        if (string != null) {
            return Pattern.compile(string);
        }
        return null;
    }

    @Deprecated
    public Pattern getSymbolPattern() {
        String string = this.getAttribute(ReservedWord.PATTERN_SYMBOL, null);
        if (string != null) {
            return Pattern.compile(string);
        }
        return null;
    }

    public FeatureHandler[] getFeatureHandlerList() throws DLTException {
        if (this._featureHandlers == null) {
            List<String> list = this.getAttributeList(ReservedWord.FEATURE_HANDLER_LIST);
            ArrayList<FeatureHandler> arrayList = new ArrayList<FeatureHandler>(list.size());
            for (String string : list) {
                FeatureHandler featureHandler = FeatureHandlerFactory.createHandler(string, this);
                arrayList.add(featureHandler);
            }
            this._featureHandlers = arrayList.toArray(new FeatureHandler[arrayList.size()]);
        }
        return this._featureHandlers;
    }

    public String[] getFeaturePathList() {
        if (this._featurePaths == null) {
            List<String> list = this.getAttributeList(ReservedWord.FEATURE_PATH_LIST);
            this._featurePaths = list.isEmpty() ? ArrayUtils.EMPTY_STRING_ARRAY : list.toArray(new String[list.size()]);
        }
        return this._featurePaths;
    }

    public FeatureValueMapping getFeatureMapping() {
        assert (this._mapping != null);
        return this._mapping;
    }

    public Class<?> getLabelClass() {
        try {
            String string = this.getAttribute(ReservedWord.LABEL_CLASS, null);
            if (string != null) {
                return Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public CRFDictionary trimToSize() throws DLTException {
        this._mapping = this._mapping.trimToSize();
        return this;
    }

    void dump(PrintWriter printWriter) throws IOException {
        assert (printWriter != null);
        DecimalFormat decimalFormat = new DecimalFormat("####0.0#########");
        CRFLabelSet cRFLabelSet = this.getLabelSet();
        int n = cRFLabelSet.size();
        Iterator<Map.Entry<String, Object>> iterator = this._dic.getNet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String string = entry.getKey();
            printWriter.print(string);
            printWriter.println("={");
            Collection collection = (Collection)entry.getValue();
            if (collection == null) continue;
            for (Gloss gloss : collection) {
                if (gloss.getType() == 60) {
                    printWriter.println("\t" + ((StringGloss)gloss).getValue());
                    continue;
                }
                if (gloss.getType() == 52) {
                    CRFTransitionFeatureGloss cRFTransitionFeatureGloss = (CRFTransitionFeatureGloss)gloss;
                    float[][] fArray = cRFTransitionFeatureGloss.w();
                    for (int i = 0; i < n; ++i) {
                        printWriter.print("\t" + cRFLabelSet.getLabel(i) + "\t{");
                        for (int j = 0; j < n; ++j) {
                            printWriter.print(decimalFormat.format(fArray[j][i]));
                            if (j + 1 == n) continue;
                            printWriter.print(", ");
                        }
                        printWriter.println("}");
                    }
                    continue;
                }
                printWriter.println("\t" + gloss);
            }
            printWriter.println("}");
            printWriter.println();
        }
        this._mapping.dump(printWriter, this.getLabelSet(), decimalFormat);
        printWriter.flush();
    }

    private static enum ReservedWord {
        LEARNING_ALGORITHM,
        LABEL_SET,
        LABEL_CLASS,
        STATE_FEATURE_TEMPLATE_LIST,
        TRANSITION_FEATURE_TEMPLATE_LIST,
        LEARNING_RATE,
        FEATURE_HANDLER_LIST,
        FEATURE_PATH_LIST,
        PATTERN_NUMERIC,
        PATTERN_SYMBOL;

    }

    public static enum PropertyName {
        DIC_LANGUAGE,
        DIC_COPYRIGHT,
        DIC_VERSION,
        LABEL_SET,
        LABEL_CLASSNAME,
        FEATURE_TEMPLATE,
        FEATURE_MAPPING,
        FEATURE_HANDLER,
        FEATURE_REGEX,
        FEATURE_PATH;

    }
}

