/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.Viterbi;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.crf.feature.template.FeatureTemplateGraph;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.CRFTransitionFeatureGloss;
import com.ibm.dltj.netgeneric.NetGenericReadOnly;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRFTagger {
    private final CRFDictionary _dic;
    private final CRFLabelSet _labelSet;
    private final NetGenericReadOnly _valueStore;
    private final Viterbi _viterbi;
    private final FeatureTemplateGraph[] _graph;
    private final int[] _stack;
    private static final Logger _logger = Logger.getLogger(CRFTagger.class.getName());

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CRFTagger(CRFDictionary cRFDictionary) throws DLTException {
        if (cRFDictionary == null) {
            throw new IllegalArgumentException();
        }
        this._dic = cRFDictionary;
        this._dic.setEditable(false);
        this._labelSet = this._dic.getLabelSet();
        assert (this._labelSet != null);
        this._valueStore = this._dic.getFeatureMapping()._valueStore.getReader();
        assert (this._valueStore != null);
        this._viterbi = new Viterbi(this._labelSet, this._dic.getFeatureMapping());
        this._viterbi.addTransitionFeature((CRFTransitionFeatureGloss)this._dic.getDictionary().get("B").first());
        this._graph = this._dic.getStateFeatureTemplateGraph();
        assert (this._graph != null);
        this._stack = new int[Math.max(this._graph.length, 32)];
    }

    public void process(List<FeatureTable> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, Messages.format("info.table.num", Integer.toString(list.size())));
        }
        long l = System.currentTimeMillis();
        for (FeatureTable featureTable : list) {
            this.process(featureTable);
        }
        long l2 = System.currentTimeMillis();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, Messages.format("info.elapsed.time", Long.toString(l2 - l)));
        }
    }

    public void process(FeatureTable featureTable) {
        int n;
        if (featureTable == null || featureTable.isEmpty()) {
            return;
        }
        int n2 = featureTable.getRowSize();
        if (!this._viterbi.isEmpty()) {
            this._viterbi.clear();
        }
        this._viterbi.ensureCapacity(n2);
        NetGenericReadOnly netGenericReadOnly = this._valueStore;
        this._stack[0] = netGenericReadOnly.first_base();
        for (int i = 0; i < n2; ++i) {
            n = 0;
            while (n < this._graph.length) {
                FeatureTemplateGraph featureTemplateGraph = this._graph[n];
                int n3 = this._stack[featureTemplateGraph._stackPos];
                int n4 = featureTemplateGraph._entry.getFeature(featureTable, i);
                int n5 = netGenericReadOnly.takeTransition(n3, n4, 0);
                if (n5 == 0) {
                    n = featureTemplateGraph._indexOnFail;
                    continue;
                }
                this._stack[featureTemplateGraph._stackPos + 1] = n5;
                if (featureTemplateGraph._nextFinal) {
                    this._viterbi.addStateFeature(n5);
                }
                ++n;
            }
            this._viterbi.forward();
        }
        int[] nArray = this._viterbi.decode();
        for (n = 0; n < n2; ++n) {
            int n6 = nArray[n];
            String string = this._labelSet.getUserLabel(n6);
            featureTable.setLabel(n, string);
        }
    }
}

