/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.ForwardBackward;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.crf.feature.SystemFeatureTable;
import com.ibm.dltj.crf.feature.template.FeatureTemplate;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.CRFLearningRate;
import com.ibm.dltj.gloss.CRFTransitionFeatureGloss;
import com.ibm.dltj.netgeneric.NetGeneric;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRFTrainer {
    private final CRFDictionary _dic;
    private final CRFLabelSet _labelSet;
    private final SystemFeatureTable _table = new SystemFeatureTable();
    private final CRFLearningRate _learningRate;
    private static final Logger _logger = Logger.getLogger(CRFTrainer.class.getName());

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CRFTrainer(CRFDictionary cRFDictionary) throws IOException, DLTException {
        if (cRFDictionary == null) {
            throw new IllegalArgumentException();
        }
        this._dic = cRFDictionary;
        this._dic.setEditable(true);
        this._labelSet = this._dic.getLabelSet();
        this._learningRate = this._dic.getLearningRate();
        assert (this._labelSet != null);
        assert (this._learningRate != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List<FeatureTable> list, int n) throws DLTException {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, Messages.format("info.table.num", Integer.toString(list.size())));
        }
        ForwardBackward forwardBackward = null;
        try {
            forwardBackward = new ForwardBackward(this._dic);
            for (int i = 0; i < n; ++i) {
                long l = System.currentTimeMillis();
                Collections.shuffle(list);
                this.updateLearningRate();
                for (FeatureTable featureTable : list) {
                    this.process(featureTable, forwardBackward);
                }
                long l2 = System.currentTimeMillis();
                if (!_logger.isLoggable(Level.INFO)) continue;
                _logger.log(Level.INFO, Messages.format("info.elapsed.time.itr", Integer.toString(i), Long.toString(l2 - l)));
            }
        }
        finally {
            if (forwardBackward != null) {
                try {
                    forwardBackward.close(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new DLTException(interruptedException);
                }
            }
        }
    }

    private void updateLearningRate() {
        this._learningRate.next();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, Messages.format("info.learning.rate", this._learningRate.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(FeatureTable featureTable, ForwardBackward forwardBackward) throws DLTException {
        assert (this._dic != null);
        if (featureTable == null || forwardBackward == null) {
            return;
        }
        this._table.setTable(featureTable);
        try {
            int n;
            for (n = 1; n < this._table.getRowSize(); ++n) {
                Object object;
                for (FeatureTemplate featureTemplate : this._dic.getStateFeatureTemplate()) {
                    object = featureTemplate.iterator(this._table, n);
                    forwardBackward.addStateFeature(n, (NetGeneric.IndexIterator)object);
                }
                for (FeatureTemplate n3 : this._dic.getTransitionFeatureTemplate()) {
                    GlossCollection glossCollection = this._dic.getDictionary().get(n3.toString());
                    if (glossCollection == null || glossCollection.isEmpty()) {
                        object = (CRFTransitionFeatureGloss)this._dic.getDictionary().addGloss(52, new CRFTransitionFeatureGloss(this._labelSet.size()));
                        this._dic.getDictionary().addWord(n3.toString(), (Gloss)object);
                    } else {
                        object = (CRFTransitionFeatureGloss)glossCollection.first();
                    }
                    forwardBackward.addTransitionFeature(n, (CRFTransitionFeatureGloss)object);
                }
            }
            if (forwardBackward.process()) {
                for (n = 1; n < this._table.getRowSize(); ++n) {
                    Object object = this._table.getLabel(n - 1);
                    CharSequence charSequence = this._table.getLabel(n);
                    if (object == null || object.length() == 0) {
                        object = "__nil__";
                    }
                    if (charSequence == null || charSequence.length() == 0) {
                        charSequence = "__nil__";
                    }
                    int n2 = this._labelSet.getId(object.toString());
                    int n3 = this._labelSet.getId(((Object)charSequence).toString());
                    forwardBackward.update(n, n2, n3);
                }
                forwardBackward.commit();
            }
        }
        finally {
            forwardBackward.clear();
        }
    }
}

