/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FilterInputStream;
import java.io.IOException;

public class FeatureValueClassifier {
    private final char[] _net;
    private final byte[] _charMap;
    private static final int FIRST_NODE = 1;
    private static final int CHAR_SIZE = 65536;
    static final long SIGNATURE = 4851017004026524531L;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    private FeatureValueClassifier(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        int n = dataInput.readInt();
        assert (n == 8);
        this._charMap = new byte[65536];
        dataInput.readFully(this._charMap);
        n = dataInput.readInt();
        assert (n == 16);
        n = dataInput.readInt();
        this._net = new char[n];
        for (int i = 0; i < this._net.length; ++i) {
            this._net[i] = dataInput.readChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FeatureValueClassifier newInstance() throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(FeatureValueClassifier.class.getResourceAsStream("numsym.rule.dat")));
            FeatureValueClassifier featureValueClassifier = new FeatureValueClassifier((DataInput)((Object)filterInputStream));
            return featureValueClassifier;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    static FeatureValueClassifier newInstance(DataInput dataInput) throws IOException {
        return new FeatureValueClassifier(dataInput);
    }

    void save(DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        dataOutput.writeLong(4851017004026524531L);
        dataOutput.writeInt(8);
        dataOutput.write(this._charMap, 0, this._charMap.length);
        dataOutput.writeInt(16);
        dataOutput.writeInt(this._net.length);
        for (int i = 0; i < this._net.length; ++i) {
            dataOutput.writeChar(this._net[i]);
        }
    }

    public int valueOf(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n; n3 < n2; ++n3) {
            int n5 = n4 + this._charMap[charSequence.charAt(n3)];
            if (n5 < 1 || n5 >= this._net.length) {
                return 0;
            }
            n4 = this._net[n5];
        }
        n3 = n4 - 1;
        return n3 < 1 || n3 >= this._net.length ? 0 : this._net[n3];
    }
}

