/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.netgeneric.BuildNode;
import com.ibm.dltj.netgeneric.BuildNodeBase;
import com.ibm.dltj.netgeneric.Initializer;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.netgeneric.NetGenericFactory;
import com.ibm.dltj.netgeneric.PayloadManipulator;
import com.ibm.dltj.util.ArrayUtils;
import com.ibm.dltj.util.IntArray;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class FeatureValueMapping
implements FeatureMapping,
Initializer {
    protected final CharacterMap _charMap;
    protected NetGeneric _featureMap;
    protected NetGeneric _valueStore;
    private boolean _editable = false;
    protected static final int PAYLOAD = 2;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected FeatureValueMapping(int n, CharacterMap characterMap) throws DLTException {
        assert (n >= 0);
        assert (characterMap != null);
        this._valueStore = NetGenericFactory.create(448061489, n + 2, this);
        this._featureMap = NetGenericFactory.create(448061489, 4, this);
        this._charMap = characterMap;
        this.initialize();
    }

    protected FeatureValueMapping(DataInput dataInput, CharacterMap characterMap) throws IOException, DLTException {
        assert (dataInput != null);
        assert (characterMap != null);
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        this._valueStore = NetGenericFactory.load(dataInput, n, n2, this);
        this._featureMap = NetGenericFactory.load(dataInput, 4, characterMap.getMaxIndex(), this);
        this._charMap = characterMap;
        this.initialize();
    }

    protected void initialize() {
        int n;
        for (n = 2; n < this._valueStore.getFirstLinkIndex(); ++n) {
            this._valueStore.setPayloadManipulator(n, PayloadManipulator.SimpleInteger);
        }
        for (n = 2; n < this._featureMap.getFirstLinkIndex(); ++n) {
            this._featureMap.setPayloadManipulator(n, PayloadManipulator.SimpleInteger);
        }
        this._charMap.attachToNet(this._featureMap);
    }

    @Override
    public void startModify() throws DLTException {
        this._charMap.startModify();
        this._featureMap.startModify();
        this._valueStore.startModify();
    }

    @Override
    public void endModify() {
        this._charMap.endModify();
        this._featureMap.endModify();
        this._valueStore.endModify();
    }

    @Override
    public void reset() {
        this._charMap.reset();
        this._featureMap.reset();
        this._valueStore.reset();
    }

    void save(DataOutput dataOutput) throws IOException, DLTException {
        dataOutput.writeInt(this._valueStore.getFirstLinkIndex());
        dataOutput.writeInt(this._valueStore.getMaxIndex());
        NetGenericFactory.save(dataOutput, this._valueStore);
        NetGenericFactory.save(dataOutput, this._featureMap);
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    void setEditable(boolean bl) {
        this._editable = bl;
    }

    NetGeneric.IndexIterator addFeature(final List<String> list) {
        return new NetGeneric.IndexIterator(){
            private int _idx = 0;

            @Override
            public int first() {
                try {
                    this._idx = 0;
                    return FeatureValueMapping.this.addFeature((CharSequence)list.get(0));
                }
                catch (DLTException dLTException) {
                    return 0;
                }
            }

            @Override
            public int next() {
                if (++this._idx == list.size()) {
                    return 0;
                }
                try {
                    return FeatureValueMapping.this.addFeature((CharSequence)list.get(this._idx));
                }
                catch (DLTException dLTException) {
                    return 0;
                }
            }
        };
    }

    @Override
    public int addFeature(CharSequence charSequence) throws DLTException {
        return this.addFeature(this._charMap.makeAddingIterator(charSequence));
    }

    @Override
    public int addFeature(NetGeneric.IndexIterator indexIterator) throws DLTException {
        int n = this._featureMap.getEntry(indexIterator);
        if (n != -1) {
            return n;
        }
        n = this._valueStore.getMaxIndex();
        this._featureMap.modifyEntry(indexIterator, new NetGeneric.ChangeEncapsulator.Setter(n));
        this._valueStore.setMaxIndex(n + 1);
        return n;
    }

    @Override
    public int getFeature(CharSequence charSequence) {
        CharacterMap characterMap = this._charMap;
        NetGeneric netGeneric = this._featureMap;
        int n = netGeneric.first_base();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = characterMap.translate(charSequence.charAt(i));
            if (!netGeneric.transitionPresent(n, c)) {
                return 1;
            }
            n = netGeneric.transitionValue(n, c);
        }
        return netGeneric.takeTransition(n, 3, 1);
    }

    @Override
    public int getFeature(NetGeneric.IndexIterator indexIterator) {
        NetGeneric netGeneric = this._featureMap;
        int n = netGeneric.first_base();
        int n2 = indexIterator.first();
        while (n2 != 3) {
            if (!netGeneric.transitionPresent(n, n2)) {
                return 1;
            }
            n = netGeneric.transitionValue(n, n2);
            n2 = indexIterator.next();
        }
        return netGeneric.takeTransition(n, 3, 1);
    }

    abstract void addValue(NetGeneric.IndexIterator var1, double[] var2) throws DLTException;

    protected void addValue(NetGeneric.IndexIterator indexIterator, final int[] nArray) throws DLTException {
        if (this._valueStore.getEntry(indexIterator) != -1) {
            this._valueStore.modifyEntry(indexIterator, new NetGeneric.ChangeEncapsulator.Setter(-1));
        }
        this._valueStore.attachFSA(indexIterator, new BuildNodeBase(){

            @Override
            public BuildNode getChild() throws DLTException {
                if (nArray[this.depth] == 0) {
                    return null;
                }
                return 2.makeAssignedNode(nArray[this.depth]);
            }

            @Override
            public int getIndex() {
                return this.depth + 2;
            }

            @Override
            public boolean nextTransition() {
                do {
                    ++this.depth;
                } while (this.depth < nArray.length && nArray[this.depth] == 0);
                return this.depth < nArray.length;
            }

            @Override
            public String toString() {
                return Arrays.toString(nArray);
            }
        });
    }

    void getValue(NetGeneric.IndexIterator indexIterator, float[] fArray) {
        int n = this._valueStore.getEntry(indexIterator);
        if (n == -1) {
            return;
        }
        this.getValue(n, fArray);
    }

    abstract void getValue(int var1, float[] var2);

    @Override
    public String[] inverseMap() {
        String[] stringArray = new String[this._valueStore.getMaxIndex()];
        this.inverseMap(this._featureMap.first_base(), "", stringArray);
        return stringArray;
    }

    private void inverseMap(int n, String string, String[] stringArray) {
        NetGeneric netGeneric = this._featureMap;
        if (netGeneric.transitionPresent(n, 3)) {
            stringArray[netGeneric.transitionValue((int)n, (int)3)] = string;
        }
        for (int i = netGeneric.getFirstLinkIndex(); i < netGeneric.getMaxIndex(); ++i) {
            if (!netGeneric.transitionPresent(n, i)) continue;
            this.inverseMap(netGeneric.transitionValue(n, i), string + this._charMap.invert(i), stringArray);
        }
    }

    FeatureValueMapping trimToSize() throws DLTException {
        String[] stringArray = this.inverseMap();
        NetGeneric netGeneric = this._valueStore;
        NetGeneric netGeneric2 = this._featureMap;
        this._valueStore = NetGenericFactory.create(448061489, netGeneric.getFirstLinkIndex(), this);
        this._featureMap = NetGenericFactory.create(448061489, netGeneric2.getFirstLinkIndex(), this);
        this.initialize();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.trimToSize(netGeneric, netGeneric.first_base(), arrayList, stringArray);
        return this;
    }

    private void trimToSize(NetGeneric netGeneric, int n, List<String> list, String[] stringArray) throws DLTException {
        int[] nArray = new int[netGeneric.getFirstLinkIndex() - 2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = netGeneric.takeTransition(n, i + 2, 0);
        }
        if (!ArrayUtils.isEmpty(nArray)) {
            NetGeneric.IndexIterator indexIterator = this.addFeature(list);
            this.addValue(indexIterator, nArray);
        }
        for (int n2 : netGeneric.gatherNodeLinks(n)) {
            list.add(stringArray[n2]);
            this.trimToSize(netGeneric, netGeneric.transitionValue(n, n2), list, stringArray);
            list.remove(list.size() - 1);
        }
    }

    void dump(PrintWriter printWriter, CRFLabelSet cRFLabelSet, NumberFormat numberFormat) throws IOException {
        String[] stringArray = this.inverseMap();
        this.dump(printWriter, this._valueStore.first_base(), "", stringArray, cRFLabelSet, numberFormat);
        printWriter.println();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this._featureMap.printStatistics(new PrintStream(byteArrayOutputStream));
        printWriter.print("feature map: ");
        printWriter.print(new String(byteArrayOutputStream.toByteArray(), "utf-8"));
        byteArrayOutputStream.reset();
        this._valueStore.printStatistics(new PrintStream(byteArrayOutputStream));
        printWriter.print("value store: ");
        printWriter.print(new String(byteArrayOutputStream.toByteArray(), "utf-8"));
    }

    private void dump(PrintWriter printWriter, int n, String string, String[] stringArray, CRFLabelSet cRFLabelSet, NumberFormat numberFormat) {
        NetGeneric netGeneric = this._valueStore;
        float[] fArray = new float[cRFLabelSet.size()];
        this.getValue(n, fArray);
        if (!ArrayUtils.isEmpty(fArray)) {
            printWriter.print(string);
            printWriter.print("->{");
            for (int i = 0; i < fArray.length; ++i) {
                if ((double)fArray[i] == 0.0) continue;
                printWriter.print(cRFLabelSet.getLabel(i));
                printWriter.print('=');
                printWriter.print(numberFormat.format(fArray[i]));
                printWriter.print(", ");
            }
            printWriter.println('}');
        }
        for (int n2 : netGeneric.gatherNodeLinks(n)) {
            this.dump(printWriter, netGeneric.transitionValue(n, n2), string + '/' + stringArray[n2], stringArray, cRFLabelSet, numberFormat);
        }
    }

    IntArray toArray(NetGeneric.IndexIterator indexIterator) {
        IntArray intArray = new IntArray();
        int n = indexIterator.first();
        while (true) {
            intArray.add(n);
            if (n == 0) break;
            n = indexIterator.next();
        }
        intArray.trimToSize();
        return intArray;
    }
}

