/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.FeatureValueMapping;
import com.ibm.dltj.fst.CharacterMap;
import com.ibm.dltj.netgeneric.NetGeneric;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class FeatureValueMappingSparse
extends FeatureValueMapping {
    static final long SIGNATURE = 4851017085447075175L;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    FeatureValueMappingSparse(int n, CharacterMap characterMap) throws DLTException {
        super(n * 2, characterMap);
    }

    FeatureValueMappingSparse(DataInput dataInput, CharacterMap characterMap) throws IOException, DLTException {
        super(dataInput, characterMap);
    }

    @Override
    final void addValue(NetGeneric.IndexIterator indexIterator, double[] dArray) throws DLTException {
        int[] nArray = new int[this._valueStore.getFirstLinkIndex() - 2];
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            nArray[n++] = Float.floatToIntBits((float)dArray[i]) >>> 8;
            nArray[n++] = i;
        }
        this.addValue(indexIterator, nArray);
    }

    @Override
    final void getValue(int n, float[] fArray) {
        int n2 = 2;
        int n3 = Math.min(2 + fArray.length * 2, this._valueStore.getMaxIndex());
        while (n2 < n3) {
            int n4;
            int n5;
            if ((n5 = this._valueStore.takeTransition(n, n2++, 0)) == 0) {
                return;
            }
            int n6 = n4 = this._valueStore.takeTransition(n, n2++, 0);
            fArray[n6] = fArray[n6] + Float.intBitsToFloat(n5 << 8);
        }
    }

    @Override
    void save(DataOutput dataOutput) throws IOException, DLTException {
        dataOutput.writeLong(4851017085447075175L);
        super.save(dataOutput);
    }
}

