/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.FeatureValueMapping;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.CRFLearningRate;
import com.ibm.dltj.gloss.CRFStateFeatureGloss;
import com.ibm.dltj.gloss.CRFTransitionFeatureGloss;
import com.ibm.dltj.netgeneric.NetGeneric;
import com.ibm.dltj.util.ArrayUtils;
import com.ibm.dltj.util.ExpUtils;
import com.ibm.dltj.util.IntArray;
import com.ibm.dltj.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class ForwardBackward {
    private double[][] _alpha = ArrayUtils.EMPTY_DOUBLE_DARRAY;
    private double[][] _beta = ArrayUtils.EMPTY_DOUBLE_DARRAY;
    private double _Z;
    private final ArrayList<ArrayList<CRFStateFeatureGloss>> _theta = new ArrayList();
    private final ArrayList<CRFTransitionFeatureGloss> _psi = new ArrayList();
    private final CRFLearningRate _learningRate;
    private final CRFLabelSet _labelSet;
    private final FeatureValueMapping _mapping;
    private final Map<IntArray, CRFStateFeatureGloss> _store = new HashMap<IntArray, CRFStateFeatureGloss>();
    private double[][] _pTheta = ArrayUtils.EMPTY_DOUBLE_DARRAY;
    private double[][][] _pPsi = ArrayUtils.EMPTY_DOUBLE_TARRAY;
    private final ExecutorService _executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
    private static final Logger _logger = Logger.getLogger(ForwardBackward.class.getName());

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public ForwardBackward(CRFDictionary cRFDictionary) throws DLTException {
        if (cRFDictionary == null) {
            throw new IllegalArgumentException();
        }
        this._learningRate = cRFDictionary.getLearningRate();
        this._labelSet = cRFDictionary.getLabelSet();
        this._mapping = cRFDictionary.getFeatureMapping();
    }

    public void clear() {
        Object object;
        int n;
        int n2 = Math.min(this._alpha.length, this.length());
        for (n = 0; n < n2; ++n) {
            if (this._alpha[n] == null) continue;
            Arrays.fill(this._alpha[n], 0.0);
        }
        n2 = Math.min(this._beta.length, this.length());
        for (n = 0; n < n2; ++n) {
            if (this._beta[n] == null) continue;
            Arrays.fill(this._beta[n], 0.0);
        }
        this._Z = 0.0;
        n2 = Math.min(this._pTheta.length, this.length());
        for (n = 0; n < n2; ++n) {
            if (this._pTheta[n] == null) continue;
            Arrays.fill(this._pTheta[n], 0.0);
        }
        n2 = Math.min(this._pPsi.length, this.length());
        for (n = 0; n < n2; ++n) {
            object = this._pPsi[n];
            if (object == null) continue;
            for (double[] dArray : object) {
                if (dArray == null) continue;
                Arrays.fill(dArray, 0.0);
            }
        }
        this._psi.clear();
        n2 = Math.min(this._theta.size(), this.length());
        for (n = 0; n < n2; ++n) {
            object = this._theta.get(n);
            if (object == null) continue;
            object.clear();
        }
    }

    public void close(long l) throws InterruptedException, DLTException {
        if (this._executor != null) {
            this._executor.shutdown();
            this._executor.awaitTermination(l, TimeUnit.MILLISECONDS);
        }
        double[] dArray = new double[this._labelSet.size()];
        for (Map.Entry<IntArray, CRFStateFeatureGloss> entry : this._store.entrySet()) {
            IntArray intArray = entry.getKey();
            CRFStateFeatureGloss cRFStateFeatureGloss = entry.getValue();
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = cRFStateFeatureGloss.w(i);
            }
            NetGeneric.IndexIterator.Array array = new NetGeneric.IndexIterator.Array(intArray.toArray());
            this._mapping.addValue((NetGeneric.IndexIterator)array, dArray);
            Arrays.fill(dArray, 0.0);
        }
    }

    public void addStateFeature(int n, NetGeneric.IndexIterator indexIterator) throws DLTException {
        IntArray intArray;
        CRFStateFeatureGloss cRFStateFeatureGloss;
        if (n < 0 || indexIterator == null) {
            throw new IllegalArgumentException();
        }
        while (n >= this._theta.size()) {
            this._theta.add(null);
        }
        ArrayList<CRFStateFeatureGloss> arrayList = this._theta.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this._theta.set(n, arrayList);
        }
        if ((cRFStateFeatureGloss = this._store.get(intArray = this._mapping.toArray(indexIterator))) == null) {
            float[] fArray = new float[this._labelSet.size()];
            this._mapping.getValue(indexIterator, fArray);
            cRFStateFeatureGloss = new CRFStateFeatureGloss(fArray);
            this._store.put(intArray, cRFStateFeatureGloss);
        }
        arrayList.add(cRFStateFeatureGloss);
    }

    public void addTransitionFeature(int n, CRFTransitionFeatureGloss cRFTransitionFeatureGloss) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (cRFTransitionFeatureGloss == null) {
            return;
        }
        while (n >= this._psi.size()) {
            this._psi.add(null);
        }
        this._psi.set(n, cRFTransitionFeatureGloss);
    }

    public boolean process() throws DLTException {
        if (this.weight()) {
            return this.probability();
        }
        return false;
    }

    private int length() {
        return this._theta.size();
    }

    private double theta(int n, int n2) {
        if (n < 0 || n >= this._theta.size()) {
            return 0.0;
        }
        ArrayList<CRFStateFeatureGloss> arrayList = this._theta.get(n);
        if (arrayList == null || arrayList.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (CRFStateFeatureGloss cRFStateFeatureGloss : arrayList) {
            d += cRFStateFeatureGloss.w(n2);
        }
        return d;
    }

    private double psi(int n, int n2, int n3) {
        if (n < 0 || n >= this._psi.size()) {
            return 0.0;
        }
        CRFTransitionFeatureGloss cRFTransitionFeatureGloss = this._psi.get(n);
        if (cRFTransitionFeatureGloss == null) {
            return 0.0;
        }
        return cRFTransitionFeatureGloss.w(n2, n3);
    }

    private boolean weight() throws DLTException {
        Future<Double> future = null;
        Future<Double> future2 = null;
        try {
            future = this._executor.submit(new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return ForwardBackward.this.forward();
                }
            });
            future2 = this._executor.submit(new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return ForwardBackward.this.backward();
                }
            });
            double d = future.get();
            double d2 = future2.get();
            this._Z = Math.max(d, d2);
            if (this._Z < 0.0 || 1.0 - Math.min(d, d2) / Math.max(d, d2) > 0.1) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, Messages.format("info.fb.Z: ", Double.toString(d), Double.toString(d2)));
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            throw new DLTException(executionException.getCause());
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            if (future2 != null) {
                future2.cancel(true);
            }
        }
        return true;
    }

    double forward() {
        int n;
        this._alpha = ArrayUtils.ensureCapacity(this._alpha, this.length());
        for (n = 0; n < this.length(); ++n) {
            if (this._alpha[n] != null && this._alpha[n].length >= this._labelSet.size()) continue;
            this._alpha[n] = new double[this._labelSet.size()];
        }
        n = this._labelSet.getStartId();
        for (int i = 0; i < this._labelSet.size(); ++i) {
            this._alpha[1][i] = this.psi(1, n, i) + this.theta(1, i);
        }
        double[] dArray = new double[this._labelSet.size()];
        for (int i = 2; i < this.length(); ++i) {
            double[] dArray2 = this._alpha[i - 1];
            double[] dArray3 = this._alpha[i];
            for (int j = 0; j < this._labelSet.size(); ++j) {
                double d = this.theta(i, j);
                for (int k = 0; k < this._labelSet.size(); ++k) {
                    double d2 = this.psi(i, k, j);
                    dArray[k] = dArray2[k] + d2 + d;
                }
                dArray3[j] = MathUtils.logsumexp(dArray, this._learningRate.threshold());
            }
        }
        double d = Math.max(this._alpha[this.length() - 1][this._labelSet.getFinalId()], this._learningRate.threshold());
        return d;
    }

    double backward() {
        int n;
        this._beta = ArrayUtils.ensureCapacity(this._beta, this.length());
        for (n = 0; n < this.length(); ++n) {
            if (this._beta[n] != null && this._beta[n].length >= this._labelSet.size()) continue;
            this._beta[n] = new double[this._labelSet.size()];
        }
        n = this._labelSet.getFinalId();
        for (int i = 0; i < this._labelSet.size(); ++i) {
            this._beta[this.length() - 2][i] = this.psi(this.length() - 1, i, n) + this.theta(this.length() - 1, n);
        }
        double[] dArray = new double[this._labelSet.size()];
        double[] dArray2 = new double[this._labelSet.size()];
        for (int i = this.length() - 3; i >= 0; --i) {
            int n2;
            double[] dArray3 = this._beta[i];
            double[] dArray4 = this._beta[i + 1];
            for (n2 = 0; n2 < this._labelSet.size(); ++n2) {
                dArray2[n2] = this.theta(i + 1, n2);
            }
            for (n2 = 0; n2 < this._labelSet.size(); ++n2) {
                for (int j = 0; j < this._labelSet.size(); ++j) {
                    double d = this.psi(i + 1, n2, j);
                    dArray[j] = d + dArray2[j] + dArray4[j];
                }
                dArray3[n2] = MathUtils.logsumexp(dArray, this._learningRate.threshold());
            }
        }
        double d = Math.max(this._beta[0][this._labelSet.getStartId()], this._learningRate.threshold());
        return d;
    }

    private boolean probability() throws DLTException {
        int n;
        block14: {
            if (this._pTheta.length < this.length()) {
                this._pTheta = ArrayUtils.ensureCapacity(this._pTheta, this.length());
            }
            if (this._pPsi.length < this.length()) {
                this._pPsi = (double[][][])ArrayUtils.ensureCapacity(this._pPsi, this.length());
            }
            for (n = 1; n < this.length(); ++n) {
                if (this._pTheta[n] == null || this._pTheta[n].length < this._labelSet.size()) {
                    this._pTheta[n] = new double[this._labelSet.size()];
                }
                if (this._pPsi[n] != null && this._pPsi[n].length >= this._labelSet.size()) continue;
                this._pPsi[n] = new double[this._labelSet.size()][this._labelSet.size()];
            }
            n = 1;
            ArrayList<Future<Boolean>> arrayList = new ArrayList<Future<Boolean>>(this.length());
            try {
                Future<Boolean> future = this._executor.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return ForwardBackward.this.probability1();
                    }
                });
                arrayList.add(future);
                Future<Boolean> future2 = this._executor.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return ForwardBackward.this.probabilityN();
                    }
                });
                arrayList.add(future2);
                int n2 = 2;
                while (n2 < this.length() - 1) {
                    final int n3 = n2++;
                    Future<Boolean> future3 = this._executor.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return ForwardBackward.this.probability(n3);
                        }
                    });
                    arrayList.add(future3);
                }
                for (Future future4 : arrayList) {
                    n &= ((Boolean)future4.get()).booleanValue();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                throw new DLTException(executionException.getCause());
            }
            finally {
                if (arrayList.isEmpty()) break block14;
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
        return n != 0;
    }

    boolean probability1() {
        double[] dArray = this._pTheta[1];
        double[][] dArray2 = this._pPsi[1];
        ExpUtils expUtils = new ExpUtils();
        int n = this._labelSet.getStartId();
        for (int i = 0; i < this._labelSet.size(); ++i) {
            double d = this.psi(1, n, i);
            double d2 = this.theta(1, i);
            double d3 = d + d2 + this._beta[1][i];
            double d4 = expUtils.exp(d3 - this._Z);
            int n2 = i;
            dArray[n2] = dArray[n2] + d4;
            dArray2[n][i] = d4;
        }
        return ForwardBackward.verify(dArray);
    }

    boolean probabilityN() {
        int n = this.length() - 1;
        double[] dArray = this._pTheta[n];
        double[][] dArray2 = this._pPsi[n];
        ExpUtils expUtils = new ExpUtils();
        int n2 = this._labelSet.getFinalId();
        double d = this.theta(n, n2);
        for (int i = 0; i < this._labelSet.size(); ++i) {
            double d2 = this.psi(n, i, n2);
            double d3 = this._alpha[n - 1][i] + d2 + d;
            double d4 = expUtils.exp(d3 - this._Z);
            int n3 = n2;
            dArray[n3] = dArray[n3] + d4;
            dArray2[i][n2] = d4;
        }
        return ForwardBackward.verify(dArray);
    }

    boolean probability(int n) {
        if (n < 1 || n >= this.length()) {
            throw new IllegalArgumentException();
        }
        double[] dArray = this._pTheta[n];
        double[][] dArray2 = this._pPsi[n];
        ExpUtils expUtils = new ExpUtils();
        for (int i = 0; i < this._labelSet.size(); ++i) {
            double d = this.theta(n, i);
            for (int j = 0; j < this._labelSet.size(); ++j) {
                double d2 = this.psi(n, j, i);
                double d3 = this._alpha[n - 1][j] + d2 + d + this._beta[n][i];
                double d4 = expUtils.exp(d3 - this._Z);
                int n2 = i;
                dArray[n2] = dArray[n2] + d4;
                dArray2[j][i] = d4;
            }
        }
        return ForwardBackward.verify(dArray);
    }

    private static boolean verify(double[] dArray) {
        double d = ArrayUtils.sum(dArray);
        if (Math.abs(1.0 - d) > 1.0E-4) {
            System.out.println(d);
            return false;
        }
        return true;
    }

    public void update(int n, int n2, int n3) {
        if (n < 1 || n >= this.length()) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= this._labelSet.size()) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 >= this._labelSet.size()) {
            throw new IllegalArgumentException();
        }
        this.updatePsi(n, n2, n3);
        this.updateTheta(n, n3);
    }

    private void updatePsi(int n, int n2, int n3) {
        if (this._psi.size() <= n) {
            return;
        }
        CRFTransitionFeatureGloss cRFTransitionFeatureGloss = this._psi.get(n);
        if (cRFTransitionFeatureGloss == null) {
            return;
        }
        double[][] dArray = this._pPsi[n];
        if (dArray == null || dArray.length == 0) {
            return;
        }
        cRFTransitionFeatureGloss.ensureCapacity(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                if (i == n2 && j == n3) {
                    cRFTransitionFeatureGloss.g(i, j, cRFTransitionFeatureGloss.g(i, j) + (1.0 - dArray[i][j]), this._learningRate.threshold());
                    continue;
                }
                cRFTransitionFeatureGloss.g(i, j, cRFTransitionFeatureGloss.g(i, j) + (0.0 - dArray[i][j]), this._learningRate.threshold());
            }
        }
    }

    private void updateTheta(int n, int n2) {
        if (this._theta.size() <= n) {
            return;
        }
        ArrayList<CRFStateFeatureGloss> arrayList = this._theta.get(n);
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        double[] dArray = this._pTheta[n];
        if (dArray == null || dArray.length == 0) {
            return;
        }
        for (CRFStateFeatureGloss cRFStateFeatureGloss : arrayList) {
            cRFStateFeatureGloss.ensureCapacity(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                if (i == n2) {
                    cRFStateFeatureGloss.g(i, cRFStateFeatureGloss.g(i) + (1.0 - dArray[i]), this._learningRate.threshold());
                    continue;
                }
                cRFStateFeatureGloss.g(i, cRFStateFeatureGloss.g(i) + (0.0 - dArray[i]), this._learningRate.threshold());
            }
        }
    }

    public void commit() {
        this.commitPsi();
        this.commitTheta();
    }

    private void commitPsi() {
        for (int i = 0; i < this._psi.size(); ++i) {
            CRFTransitionFeatureGloss cRFTransitionFeatureGloss = this._psi.get(i);
            if (cRFTransitionFeatureGloss == null) continue;
            for (int j = 0; j < this._labelSet.size(); ++j) {
                for (int k = 0; k < this._labelSet.size(); ++k) {
                    double d = this._learningRate.eta() * cRFTransitionFeatureGloss.g(j, k);
                    if (Math.abs(d) < this._learningRate.threshold()) continue;
                    double d2 = cRFTransitionFeatureGloss.w(j, k) + d;
                    if (d2 > 0.0) {
                        cRFTransitionFeatureGloss.w(j, k, (float)Math.max(0.0, d2 - (this._learningRate.u() + cRFTransitionFeatureGloss.q(j, k))), this._learningRate.threshold());
                    } else if (d2 < 0.0) {
                        cRFTransitionFeatureGloss.w(j, k, (float)Math.min(0.0, d2 + (this._learningRate.u() - cRFTransitionFeatureGloss.q(j, k))), this._learningRate.threshold());
                    }
                    cRFTransitionFeatureGloss.q(j, k, (float)(cRFTransitionFeatureGloss.q(j, k) + (cRFTransitionFeatureGloss.w(j, k) - d2)), this._learningRate.threshold());
                }
            }
            cRFTransitionFeatureGloss.clear();
        }
    }

    private void commitTheta() {
        for (int i = 0; i < this._theta.size(); ++i) {
            ArrayList<CRFStateFeatureGloss> arrayList = this._theta.get(i);
            if (arrayList == null || arrayList.isEmpty()) continue;
            for (CRFStateFeatureGloss cRFStateFeatureGloss : arrayList) {
                for (int j = 0; j < this._labelSet.size(); ++j) {
                    double d = this._learningRate.eta() * cRFStateFeatureGloss.g(j);
                    if (Math.abs(d) < this._learningRate.threshold()) continue;
                    double d2 = cRFStateFeatureGloss.w(j) + d;
                    if (d2 > 0.0) {
                        cRFStateFeatureGloss.w(j, Math.max(0.0, d2 - (this._learningRate.u() + cRFStateFeatureGloss.q(j))), this._learningRate.threshold());
                    } else if (d2 < 0.0) {
                        cRFStateFeatureGloss.w(j, Math.min(0.0, d2 + (this._learningRate.u() - cRFStateFeatureGloss.q(j))), this._learningRate.threshold());
                    }
                    cRFStateFeatureGloss.q(j, cRFStateFeatureGloss.q(j) + (cRFStateFeatureGloss.w(j) - d2), this._learningRate.threshold());
                }
                cRFStateFeatureGloss.clear();
            }
        }
    }
}

