/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf;

import com.ibm.dltj.crf.FeatureValueMapping;
import com.ibm.dltj.gloss.CRFLabelSet;
import com.ibm.dltj.gloss.CRFTransitionFeatureGloss;

final class Viterbi {
    private int _size = 0;
    private final float[][] _alpha;
    private final float[] _theta;
    private float[][] _psi;
    private int[] _prev = new int[0];
    private final CRFLabelSet _labelSet;
    private final FeatureValueMapping _mapping;
    private int _maxAt;
    private int[] _path;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public Viterbi(CRFLabelSet cRFLabelSet, FeatureValueMapping featureValueMapping) {
        this(cRFLabelSet, featureValueMapping, 32);
    }

    public Viterbi(CRFLabelSet cRFLabelSet, FeatureValueMapping featureValueMapping, int n) {
        if (cRFLabelSet == null) {
            throw new IllegalArgumentException();
        }
        if (featureValueMapping == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this._labelSet = cRFLabelSet;
        this._mapping = featureValueMapping;
        int n2 = this._labelSet.size();
        this._alpha = new float[2][n2];
        this._theta = new float[n2];
        this._path = new int[n];
    }

    public void clear() {
        if (this._size == 0) {
            return;
        }
        this._size = 0;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this._prev.length < n * this._labelSet.size()) {
            this._prev = new int[n * this._labelSet.size()];
        }
        if (this._path.length < n) {
            this._path = new int[n];
        }
    }

    public void addStateFeature(int n) {
        this._mapping.getValue(n, this._theta);
    }

    public void addTransitionFeature(CRFTransitionFeatureGloss cRFTransitionFeatureGloss) {
        assert (cRFTransitionFeatureGloss != null);
        this._psi = cRFTransitionFeatureGloss.w();
    }

    public void forward() {
        int n;
        int n2 = this._size - 1;
        int n3 = this._size++;
        float[] fArray = this._alpha[n2 + 1 & 1];
        float[] fArray2 = this._alpha[n3 + 1 & 1];
        float[] fArray3 = this._theta;
        int n4 = this._labelSet.size();
        if (n3 == 0) {
            float[] fArray4 = this._psi[this._labelSet.getStartId()];
            float f = Float.MIN_VALUE;
            for (int i = 0; i < n4; ++i) {
                float f2 = fArray2[i] = fArray4[i + 2] + fArray3[i];
                fArray3[i] = 0.0f;
                if (!(f < f2)) continue;
                f = f2;
                this._maxAt = i;
            }
            return;
        }
        float f = fArray[this._maxAt];
        float[] fArray5 = this._psi[this._maxAt];
        float f3 = f + fArray5[0];
        for (n = 0; n < n4; ++n) {
            fArray2[n] = f + fArray5[n + 2];
            this._prev[n3 * n4 + n] = this._maxAt;
        }
        for (n = 0; n < n4; ++n) {
            float f4 = fArray[n];
            float[] fArray6 = this._psi[n];
            if (n == this._maxAt || !(f3 < f4 + fArray6[1])) continue;
            for (int i = 0; i < n4; ++i) {
                float f5 = f4 + fArray6[i + 2];
                if (!(fArray2[i] < f5)) continue;
                fArray2[i] = f5;
                this._prev[n3 * n4 + i] = n;
            }
        }
        float f6 = Float.MIN_VALUE;
        for (int i = 0; i < n4; ++i) {
            int n5 = i;
            float f7 = fArray2[n5] + fArray3[i];
            fArray2[n5] = f7;
            float f8 = f7;
            fArray3[i] = 0.0f;
            if (!(f6 < f8)) continue;
            f6 = f8;
            this._maxAt = i;
        }
    }

    public int[] decode() {
        if (this._size > 0) {
            int n;
            float[] fArray = this._alpha[this._size & 1];
            int n2 = this._labelSet.getFinalId();
            int n3 = this._labelSet.size();
            float f = Float.MIN_VALUE;
            for (n = 0; n < n3; ++n) {
                int n4 = n;
                float f2 = fArray[n4] = fArray[n4] + this._psi[n][n2 + 1];
                float f3 = f2;
                if (!(f < f3)) continue;
                f = f3;
                this._maxAt = n;
            }
            n = this._maxAt;
            for (int i = this._size - 1; i >= 0; --i) {
                this._path[i] = n;
                n = this._prev[i * n3 + n];
            }
        }
        return this._path;
    }
}

