/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.FeatureMapping;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import com.ibm.dltj.util.IntArray;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class CSVFeatureTable
implements FeatureTable {
    private final IntArray _id = new IntArray();
    private final ArrayList<CharSequence> _labels = new ArrayList();
    protected final FeatureMapping _mapping;
    protected final int _colSize;
    protected final FeatureHandler[] _handler;
    protected static final String COMMA = ",";
    protected static final String TAB = "\t";
    private final String NIL = "__nil%d__";
    private final int[] _nil = new int[8];

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    protected CSVFeatureTable(int n, FeatureMapping featureMapping) throws DLTException {
        assert (n >= 0);
        this._colSize = n;
        this._handler = new FeatureHandler[n];
        this._mapping = featureMapping;
        for (int i = 0; i < this._nil.length; ++i) {
            this._nil[i] = this.addFeature(String.format("__nil%d__", i));
        }
    }

    public static CSVFeatureTable newInstance(CRFDictionary cRFDictionary) throws DLTException {
        assert (cRFDictionary != null);
        return new CSVFeatureTable(cRFDictionary.getFeaturePathList().length - 1, cRFDictionary.getFeatureMapping());
    }

    @Override
    public void clear() {
        this._id.clear();
        this._labels.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._id.isEmpty();
    }

    @Override
    public int getRowSize() {
        return (this._id.size() + (this._colSize - 1)) / this._colSize;
    }

    @Override
    public int getColumnSize() {
        return this._colSize;
    }

    @Override
    public void setHandler(FeatureHandler[] featureHandlerArray) {
        if (featureHandlerArray == null) {
            return;
        }
        System.arraycopy(featureHandlerArray, 0, this._handler, 0, Math.min(featureHandlerArray.length, this._handler.length));
    }

    @Override
    public int getFeature(int n, int n2) {
        assert (n2 >= 0 && n2 < this._colSize);
        int n3 = n * this._colSize + n2;
        if (n < 0) {
            return this._nil[-n];
        }
        if (n3 >= this._id.size()) {
            return this._nil[n - this.getRowSize() + 1];
        }
        return this._id.get(n3);
    }

    @Override
    public void setFeature(int n, int n2, CharSequence charSequence) throws DLTException {
        FeatureHandler featureHandler = this._handler[n2];
        int n3 = this.addFeature(featureHandler == null ? charSequence : featureHandler.getFeature(charSequence));
        this.setFeature(n, n2, n3);
    }

    @Override
    public void setFeature(int n, int n2, int n3) {
        assert (n >= 0);
        assert (n2 >= 0 && n2 < this._colSize);
        int n4 = n * this._colSize + n2;
        while (n4 >= this._id.size()) {
            this._id.addMultiple(this._colSize, 1);
        }
        this._id.set(n4, n3);
    }

    @Override
    public CharSequence getLabel(int n) {
        if (n < 0) {
            return String.format("__nil%d__", -n);
        }
        if (n >= this._labels.size()) {
            return String.format("__nil%d__", n - this._labels.size() + 1);
        }
        return this._labels.get(n);
    }

    @Override
    public void setLabel(int n, CharSequence charSequence) {
        while (n >= this._labels.size()) {
            this._labels.add(null);
        }
        this._labels.set(n, charSequence);
    }

    private final int addFeature(CharSequence charSequence) throws DLTException {
        assert (charSequence != null);
        if (this._mapping.isEditable()) {
            return this._mapping.addFeature(charSequence);
        }
        return this._mapping.getFeature(charSequence);
    }

    public void toCSV(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        this.toCSV(printWriter);
        printWriter.flush();
    }

    public void toCSV(PrintWriter printWriter) {
        this.save(printWriter, COMMA, true);
    }

    public void toTSV(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        this.toTSV(printWriter);
        printWriter.flush();
    }

    public void toTSV(PrintWriter printWriter) {
        this.save(printWriter, TAB, false);
    }

    protected void save(PrintWriter printWriter, String string, boolean bl) {
        String[] stringArray = this._mapping.inverseMap();
        int n = this.getRowSize();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this._colSize; ++j) {
                int n2 = i * this._colSize + j;
                String string2 = stringArray[this._id.get(n2)];
                if (string2 != null && string2.length() > 0) {
                    if (bl) {
                        printWriter.print("\"");
                        for (int k = 0; k < string2.length(); ++k) {
                            char c = string2.charAt(k);
                            printWriter.print(c == '\"' ? "\"\"" : Character.valueOf(c));
                        }
                        printWriter.print("\"");
                    } else {
                        printWriter.print(string2);
                    }
                }
                printWriter.print(string);
            }
            CharSequence charSequence = this._labels.get(i);
            if (charSequence != null) {
                printWriter.print("\"");
                printWriter.print(charSequence);
                printWriter.print("\"");
            }
            printWriter.print("\r\n");
        }
    }
}

