/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.crf.feature;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.crf.CRFDictionary;
import com.ibm.dltj.crf.feature.CSVFeatureTable;
import com.ibm.dltj.crf.feature.FeatureTable;
import com.ibm.dltj.crf.feature.handler.FeatureHandler;
import com.ibm.dltj.gloss.CRFLabelSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVFeatureTableParser {
    private final CRFDictionary _dic;
    private int _lineCount = 0;
    private static final String CSV = "(?:^|,)(?:\"((?:[^\"]|\"\")*)\"|([^,\"]*))";
    private static final String TSV = "(?:^|\t)(?:\"((?:[^\"]|\"\")*)\"|([^\t\"]*))";
    private static final String EMPTY = "[,]+";
    private static final int BOM = 65279;
    private static final Logger _logger = Logger.getLogger(CSVFeatureTableParser.class.getName());

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2013.\n\n";
    }

    public CSVFeatureTableParser(CRFDictionary cRFDictionary) {
        assert (cRFDictionary != null);
        this._dic = cRFDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureTable> parse(File file, Charset charset) throws IOException, DLTException {
        Object object;
        String string;
        if (file == null || charset == null) {
            throw new IllegalArgumentException();
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, Messages.format("info.csv.parse", file.getCanonicalPath()));
        }
        Pattern pattern = Pattern.compile((string = file.getName()).endsWith(".csv") ? CSV : TSV);
        Matcher matcher = Pattern.compile(EMPTY).matcher("");
        ArrayList<FeatureTable> arrayList = new ArrayList<FeatureTable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).length() == 0 || matcher.reset((CharSequence)object).matches()) {
                    if (arrayList2.isEmpty()) continue;
                    arrayList.add(this.parse(arrayList2, pattern));
                    arrayList2.clear();
                    continue;
                }
                arrayList2.add((String)object);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(this.parse(arrayList2, pattern));
            arrayList2.clear();
        }
        if (_logger.isLoggable(Level.INFO)) {
            object = new HashSet();
            for (FeatureTable featureTable : arrayList) {
                for (int i = 0; i < featureTable.getRowSize(); ++i) {
                    CharSequence charSequence = featureTable.getLabel(i);
                    object.add(((Object)charSequence).toString());
                }
            }
            Object[] objectArray = object.toArray(new String[object.size()]);
            Arrays.sort(objectArray);
            _logger.log(Level.INFO, Messages.format("info.csv.tagset", Arrays.toString(objectArray)));
        }
        return arrayList;
    }

    public FeatureTable parse(List<String> list, Pattern pattern) throws DLTException {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        CSVFeatureTable cSVFeatureTable = CSVFeatureTable.newInstance(this._dic);
        FeatureHandler[] featureHandlerArray = this._dic.getFeatureHandlerList();
        cSVFeatureTable.setHandler(featureHandlerArray);
        CRFLabelSet cRFLabelSet = this._dic.getLabelSet();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.charAt(0) != '\ufeff') continue;
            list.set(i, string.substring(1));
        }
        Matcher matcher = pattern.matcher("");
        int n = 0;
        String string = list.get(0);
        matcher.reset(string);
        while (matcher.find()) {
            if (matcher.groupCount() < 2 || matcher.group(1) == null) {
                throw new DLTException(Messages.format("invalid.csv", Integer.toString(this._lineCount + 1), Integer.toString(n + 1), string));
            }
            ++n;
        }
        if (n > cSVFeatureTable.getColumnSize() + 1) {
            throw new DLTException(Messages.format("invalid.csv.colnum", Integer.toString(cSVFeatureTable.getColumnSize()), Integer.toString(this._lineCount + 1), Integer.toString(this._lineCount + list.size() + 1)));
        }
        for (int i = 0; i < list.size(); ++i) {
            int n2 = 0;
            String string2 = list.get(i);
            matcher.reset(string2);
            while (matcher.find()) {
                if (matcher.groupCount() < 2) {
                    throw new DLTException(Messages.format("invalid.csv", Integer.toString(this._lineCount + i + 1), Integer.toString(n2 + 1), string2));
                }
                String string3 = matcher.group(1);
                if (string3 == null) {
                    throw new DLTException(Messages.format("invalid.csv", Integer.toString(this._lineCount + i + 1), Integer.toString(n2 + 1), string2));
                }
                if (string3.contains("\"\"")) {
                    string3 = string3.replaceAll("\"\"", "\"");
                }
                if (n2 + 1 == n && string3.equals("'")) {
                    string3 = "''";
                }
                if (n2 < cSVFeatureTable.getColumnSize()) {
                    cSVFeatureTable.setFeature(i, n2, string3);
                } else if (n2 == cSVFeatureTable.getColumnSize()) {
                    if (!cRFLabelSet.hasId(string3)) {
                        throw new DLTException(Messages.format("invalid.csv.tag", Integer.toString(this._lineCount + i + 1), Integer.toString(n2 + 1), string2));
                    }
                    cSVFeatureTable.setLabel(i, string3);
                }
                ++n2;
            }
            if (n2 == n) continue;
            throw new DLTException(Messages.format("invalid.csv", Integer.toString(this._lineCount + i + 1), Integer.toString(n2 + 1), string2));
        }
        this._lineCount += list.size() + 1;
        return cSVFeatureTable;
    }
}

